/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.cast;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.BooleanFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;

public class CastCharToBooleanFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "cast(At)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        return new CastCharToBooleanFunction(args.getQuick(0));
    }

    public static class CastCharToBooleanFunction
    extends BooleanFunction
    implements UnaryFunction {
        private final Function arg;

        public CastCharToBooleanFunction(Function arg) {
            this.arg = arg;
        }

        @Override
        public Function getArg() {
            return this.arg;
        }

        @Override
        public boolean getBool(Record rec) {
            return (this.arg.getChar(rec) | 0x20) == 116;
        }
    }
}

