/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.cast;

import io.questdb.cairo.TableUtils;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.SymbolTable;
import io.questdb.cairo.sql.SymbolTableSource;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.SymbolFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.std.Chars;
import io.questdb.std.IntIntHashMap;
import io.questdb.std.ObjList;
import io.questdb.std.str.StringSink;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractToSymbolCastFunction
extends SymbolFunction
implements UnaryFunction {
    protected final Function arg;
    protected final StringSink sink = new StringSink();
    protected final IntIntHashMap symbolTableShortcut = new IntIntHashMap();
    protected final ObjList<String> symbols = new ObjList();
    protected int next = 1;

    public AbstractToSymbolCastFunction(Function arg) {
        this.arg = arg;
        this.symbols.add(null);
    }

    @Override
    public Function getArg() {
        return this.arg;
    }

    protected int getInt0(int value) {
        int keyIndex = this.symbolTableShortcut.keyIndex(value);
        if (keyIndex < 0) {
            return this.symbolTableShortcut.valueAt(keyIndex) - 1;
        }
        this.symbolTableShortcut.putAt(keyIndex, value, this.next);
        this.sink.clear();
        this.sink.put(value);
        this.symbols.add(Chars.toString(this.sink));
        return this.next++ - 1;
    }

    @Nullable
    protected String getSymbol0(int value) {
        int keyIndex = this.symbolTableShortcut.keyIndex(value);
        if (keyIndex < 0) {
            return this.symbols.getQuick(this.symbolTableShortcut.valueAt(keyIndex));
        }
        this.symbolTableShortcut.putAt(keyIndex, value, this.next++);
        this.sink.clear();
        this.sink.put(value);
        String str = Chars.toString(this.sink);
        this.symbols.add(Chars.toString(this.sink));
        return str;
    }

    @Override
    public void init(SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) throws SqlException {
        this.arg.init(symbolTableSource, executionContext);
        this.symbolTableShortcut.clear();
        this.symbols.clear();
        this.symbols.add(null);
        this.next = 1;
    }

    @Override
    public boolean isSymbolTableStatic() {
        return false;
    }

    @Override
    public CharSequence getSymbolB(Record rec) {
        return this.getSymbol(rec);
    }

    @Override
    public CharSequence valueOf(int symbolKey) {
        return this.symbols.getQuick(TableUtils.toIndexKey(symbolKey));
    }

    @Override
    public CharSequence valueBOf(int key) {
        return this.valueOf(key);
    }

    protected abstract AbstractToSymbolCastFunction newFunc();

    @Override
    @Nullable
    public SymbolTable newSymbolTable() {
        AbstractToSymbolCastFunction copy = this.newFunc();
        copy.symbolTableShortcut.putAll(this.symbolTableShortcut);
        copy.symbols.clear();
        copy.symbols.addAll(this.symbols);
        copy.next = this.next;
        return copy;
    }
}

