/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.bool;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.BinaryFunction;
import io.questdb.griffin.engine.functions.BooleanFunction;
import io.questdb.griffin.engine.functions.constants.BooleanConstant;
import io.questdb.std.IntList;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;

public class OrFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "or(TT)";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        Function leftFunc = args.getQuick(0);
        Function rightFunc = args.getQuick(1);
        if (leftFunc.isConstant()) {
            try {
                if (leftFunc.getBool(null)) {
                    Misc.free(rightFunc);
                    BooleanConstant booleanConstant = BooleanConstant.TRUE;
                    return booleanConstant;
                }
                Function function = rightFunc;
                return function;
            }
            finally {
                leftFunc.close();
            }
        }
        if (rightFunc.isConstant()) {
            try {
                if (rightFunc.getBool(null)) {
                    Misc.free(leftFunc);
                    BooleanConstant booleanConstant = BooleanConstant.TRUE;
                    return booleanConstant;
                }
                Function function = leftFunc;
                return function;
            }
            finally {
                rightFunc.close();
            }
        }
        return new MyBooleanFunction(leftFunc, rightFunc);
    }

    private static class MyBooleanFunction
    extends BooleanFunction
    implements BinaryFunction {
        final Function left;
        final Function right;

        public MyBooleanFunction(Function left, Function right) {
            this.left = left;
            this.right = right;
        }

        @Override
        public boolean getBool(Record rec) {
            return this.left.getBool(rec) || this.right.getBool(rec);
        }

        @Override
        public Function getLeft() {
            return this.left;
        }

        @Override
        public Function getRight() {
            return this.right;
        }
    }
}

