/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.bool;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.BooleanFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.griffin.engine.functions.constants.BooleanConstant;
import io.questdb.std.CharSequenceHashSet;
import io.questdb.std.Chars;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;

public class InStrFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "in(Sv)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        CharSequenceHashSet set = new CharSequenceHashSet();
        int n = args.size();
        if (n == 1) {
            return BooleanConstant.FALSE;
        }
        block4: for (int i = 1; i < n; ++i) {
            Function func = args.getQuick(i);
            switch (ColumnType.tagOf(func.getType())) {
                case 11: 
                case 12: 
                case 28: {
                    CharSequence value = func.getStr(null);
                    if (value == null) {
                        throw SqlException.$(argPositions.getQuick(i), "NULL is not allowed");
                    }
                    set.add(Chars.toString(value));
                    continue block4;
                }
                case 4: {
                    set.add(String.valueOf(func.getChar(null)));
                    continue block4;
                }
                default: {
                    throw SqlException.$(argPositions.getQuick(i), "STRING constant expected");
                }
            }
        }
        Function var = args.getQuick(0);
        if (var.isConstant()) {
            return BooleanConstant.of(set.contains(var.getStr(null)));
        }
        return new Func(var, set);
    }

    private static class Func
    extends BooleanFunction
    implements UnaryFunction {
        private final Function arg;
        private final CharSequenceHashSet set;

        public Func(Function arg, CharSequenceHashSet set) {
            this.arg = arg;
            this.set = set;
        }

        @Override
        public Function getArg() {
            return this.arg;
        }

        @Override
        public boolean getBool(Record rec) {
            return this.set.contains(this.arg.getStr(rec));
        }
    }
}

