/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.bind;

import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.ScalarFunction;
import io.questdb.griffin.engine.functions.Long256Function;
import io.questdb.std.Long256;
import io.questdb.std.Long256Impl;
import io.questdb.std.Mutable;
import io.questdb.std.Numbers;
import io.questdb.std.str.CharSink;

class Long256BindVariable
extends Long256Function
implements ScalarFunction,
Mutable {
    final Long256Impl value = new Long256Impl();

    Long256BindVariable() {
    }

    @Override
    public void getLong256(Record rec, CharSink sink) {
        long a = this.value.getLong0();
        long b = this.value.getLong1();
        long c = this.value.getLong2();
        long d = this.value.getLong3();
        Numbers.appendLong256(a, b, c, d, sink);
    }

    @Override
    public Long256 getLong256A(Record rec) {
        return this.value;
    }

    @Override
    public Long256 getLong256B(Record rec) {
        return this.value;
    }

    public void setValue(long l0, long l1, long l2, long l3) {
        this.value.setAll(l0, l1, l2, l3);
    }

    public void setValue(Long256 value) {
        this.value.copyFrom(value);
    }

    @Override
    public void clear() {
        this.value.copyFrom(Long256Impl.NULL_LONG256);
    }

    @Override
    public boolean isRuntimeConstant() {
        return true;
    }
}

