/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.bind;

import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.ScalarFunction;
import io.questdb.cairo.sql.StaticSymbolTable;
import io.questdb.cairo.sql.SymbolTableSource;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.SymbolFunction;

public class CompiledFilterSymbolBindVariable
extends SymbolFunction
implements ScalarFunction {
    private final Function symbolFunction;
    private final int columnIndex;
    private StaticSymbolTable symbolTable;

    public CompiledFilterSymbolBindVariable(Function symbolFunction, int columnIndex) {
        assert (symbolFunction.getType() == 11 || symbolFunction.getType() == 12);
        this.symbolFunction = symbolFunction;
        this.columnIndex = columnIndex;
    }

    @Override
    public void init(SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) throws SqlException {
        this.symbolTable = (StaticSymbolTable)symbolTableSource.getSymbolTable(this.columnIndex);
        this.symbolFunction.init(symbolTableSource, executionContext);
    }

    @Override
    public int getInt(Record rec) {
        CharSequence symbolStr = this.symbolFunction.getStr(null);
        return this.symbolTable.keyOf(symbolStr);
    }

    @Override
    public CharSequence getSymbol(Record rec) {
        return this.symbolFunction.getStr(null);
    }

    @Override
    public CharSequence getSymbolB(Record rec) {
        return this.symbolFunction.getStrB(null);
    }

    @Override
    public boolean isSymbolTableStatic() {
        return true;
    }

    @Override
    public CharSequence valueOf(int symbolKey) {
        return this.symbolTable.valueOf(symbolKey);
    }

    @Override
    public CharSequence valueBOf(int symbolKey) {
        return this.symbolTable.valueBOf(symbolKey);
    }

    @Override
    public boolean isRuntimeConstant() {
        return true;
    }
}

