/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin;

import io.questdb.MessageBus;
import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.CairoSecurityContext;
import io.questdb.cairo.ColumnTypes;
import io.questdb.cairo.RecordSink;
import io.questdb.cairo.sql.BindVariableService;
import io.questdb.cairo.sql.SqlExecutionCircuitBreaker;
import io.questdb.cairo.sql.VirtualRecord;
import io.questdb.griffin.QueryFutureUpdateListener;
import io.questdb.griffin.engine.analytic.AnalyticContext;
import io.questdb.griffin.engine.functions.rnd.SharedRandom;
import io.questdb.std.Rnd;
import java.io.Closeable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface SqlExecutionContext
extends Closeable {
    public QueryFutureUpdateListener getQueryFutureUpdateListener();

    public BindVariableService getBindVariableService();

    public CairoSecurityContext getCairoSecurityContext();

    @NotNull
    default public MessageBus getMessageBus() {
        return this.getCairoEngine().getMessageBus();
    }

    public boolean isTimestampRequired();

    public void popTimestampRequiredFlag();

    public void pushTimestampRequiredFlag(boolean var1);

    public int getWorkerCount();

    default public int getSharedWorkerCount() {
        return this.getWorkerCount();
    }

    public Rnd getRandom();

    default public Rnd getAsyncRandom() {
        return SharedRandom.getAsyncRandom(this.getCairoEngine().getConfiguration());
    }

    public void setRandom(Rnd var1);

    @NotNull
    public CairoEngine getCairoEngine();

    public long getRequestFd();

    @NotNull
    public SqlExecutionCircuitBreaker getCircuitBreaker();

    public void storeTelemetry(short var1, short var2);

    public AnalyticContext getAnalyticContext();

    public void configureAnalyticContext(@Nullable VirtualRecord var1, @Nullable RecordSink var2, @Nullable ColumnTypes var3, boolean var4, boolean var5);

    public void initNow();

    public long getNow();

    public int getJitMode();

    public void setJitMode(int var1);

    @Override
    default public void close() {
    }

    public void setCloneSymbolTables(boolean var1);

    public boolean getCloneSymbolTables();
}

