/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin;

import io.questdb.cairo.AbstractDataFrameCursorFactory;
import io.questdb.cairo.ArrayColumnTypes;
import io.questdb.cairo.BaseRecordMetadata;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.ColumnTypes;
import io.questdb.cairo.EntityColumnFilter;
import io.questdb.cairo.FullBwdDataFrameCursorFactory;
import io.questdb.cairo.FullFwdDataFrameCursorFactory;
import io.questdb.cairo.GenericRecordMetadata;
import io.questdb.cairo.IntervalBwdDataFrameCursorFactory;
import io.questdb.cairo.IntervalFwdDataFrameCursorFactory;
import io.questdb.cairo.ListColumnFilter;
import io.questdb.cairo.RecordSink;
import io.questdb.cairo.RecordSinkFactory;
import io.questdb.cairo.SymbolMapReader;
import io.questdb.cairo.TableColumnMetadata;
import io.questdb.cairo.TableReader;
import io.questdb.cairo.TableReaderMetadata;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.map.RecordValueSink;
import io.questdb.cairo.map.RecordValueSinkFactory;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.PageFrameCursor;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.cairo.sql.RowCursorFactory;
import io.questdb.cairo.sql.ScalarFunction;
import io.questdb.cairo.sql.SingleSymbolFilter;
import io.questdb.cairo.sql.VirtualRecord;
import io.questdb.cairo.sql.async.PageFrameReduceTask;
import io.questdb.cairo.vm.Vm;
import io.questdb.cairo.vm.api.MemoryCARW;
import io.questdb.griffin.EmptyRecordMetadata;
import io.questdb.griffin.FunctionParser;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.SqlKeywords;
import io.questdb.griffin.WhereClauseParser;
import io.questdb.griffin.engine.EmptyTableRecordCursorFactory;
import io.questdb.griffin.engine.LimitOverflowException;
import io.questdb.griffin.engine.LimitRecordCursorFactory;
import io.questdb.griffin.engine.RecordComparator;
import io.questdb.griffin.engine.analytic.AnalyticFunction;
import io.questdb.griffin.engine.analytic.CachedAnalyticRecordCursorFactory;
import io.questdb.griffin.engine.functions.GroupByFunction;
import io.questdb.griffin.engine.functions.SymbolFunction;
import io.questdb.griffin.engine.functions.bind.IndexedParameterLinkFunction;
import io.questdb.griffin.engine.functions.bind.NamedParameterLinkFunction;
import io.questdb.griffin.engine.functions.cast.CastByteToCharFunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastByteToStrFunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastDateToStrFunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastDateToTimestampFunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastDoubleToStrFunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastFloatToStrFunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastGeoHashToGeoHashFunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastIntToStrFunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastLong256ToStrFunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastLongToStrFunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastShortToStrFunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastStrToGeoHashFunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastSymbolToStrFunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastTimestampToStrFunctionFactory;
import io.questdb.griffin.engine.functions.columns.BinColumn;
import io.questdb.griffin.engine.functions.columns.BooleanColumn;
import io.questdb.griffin.engine.functions.columns.ByteColumn;
import io.questdb.griffin.engine.functions.columns.CharColumn;
import io.questdb.griffin.engine.functions.columns.DateColumn;
import io.questdb.griffin.engine.functions.columns.DoubleColumn;
import io.questdb.griffin.engine.functions.columns.FloatColumn;
import io.questdb.griffin.engine.functions.columns.GeoByteColumn;
import io.questdb.griffin.engine.functions.columns.GeoIntColumn;
import io.questdb.griffin.engine.functions.columns.GeoLongColumn;
import io.questdb.griffin.engine.functions.columns.GeoShortColumn;
import io.questdb.griffin.engine.functions.columns.IntColumn;
import io.questdb.griffin.engine.functions.columns.Long256Column;
import io.questdb.griffin.engine.functions.columns.LongColumn;
import io.questdb.griffin.engine.functions.columns.ShortColumn;
import io.questdb.griffin.engine.functions.columns.StrColumn;
import io.questdb.griffin.engine.functions.columns.SymbolColumn;
import io.questdb.griffin.engine.functions.columns.TimestampColumn;
import io.questdb.griffin.engine.functions.constants.ConstantFunction;
import io.questdb.griffin.engine.functions.constants.LongConstant;
import io.questdb.griffin.engine.functions.constants.NullConstant;
import io.questdb.griffin.engine.functions.constants.StrConstant;
import io.questdb.griffin.engine.functions.constants.SymbolConstant;
import io.questdb.griffin.engine.groupby.AbstractSampleByRecordCursorFactory;
import io.questdb.griffin.engine.groupby.CountRecordCursorFactory;
import io.questdb.griffin.engine.groupby.DistinctKeyRecordCursorFactory;
import io.questdb.griffin.engine.groupby.DistinctRecordCursorFactory;
import io.questdb.griffin.engine.groupby.DistinctTimeSeriesRecordCursorFactory;
import io.questdb.griffin.engine.groupby.GroupByNotKeyedRecordCursorFactory;
import io.questdb.griffin.engine.groupby.GroupByRecordCursorFactory;
import io.questdb.griffin.engine.groupby.GroupByUtils;
import io.questdb.griffin.engine.groupby.SampleByFillNoneNotKeyedRecordCursorFactory;
import io.questdb.griffin.engine.groupby.SampleByFillNoneRecordCursorFactory;
import io.questdb.griffin.engine.groupby.SampleByFillNullNotKeyedRecordCursorFactory;
import io.questdb.griffin.engine.groupby.SampleByFillNullRecordCursorFactory;
import io.questdb.griffin.engine.groupby.SampleByFillPrevNotKeyedRecordCursorFactory;
import io.questdb.griffin.engine.groupby.SampleByFillPrevRecordCursorFactory;
import io.questdb.griffin.engine.groupby.SampleByFillValueNotKeyedRecordCursorFactory;
import io.questdb.griffin.engine.groupby.SampleByFillValueRecordCursorFactory;
import io.questdb.griffin.engine.groupby.SampleByFirstLastRecordCursorFactory;
import io.questdb.griffin.engine.groupby.SampleByInterpolateRecordCursorFactory;
import io.questdb.griffin.engine.groupby.TimestampSampler;
import io.questdb.griffin.engine.groupby.TimestampSamplerFactory;
import io.questdb.griffin.engine.groupby.vect.AvgDoubleVectorAggregateFunction;
import io.questdb.griffin.engine.groupby.vect.AvgIntVectorAggregateFunction;
import io.questdb.griffin.engine.groupby.vect.AvgLongVectorAggregateFunction;
import io.questdb.griffin.engine.groupby.vect.CountVectorAggregateFunction;
import io.questdb.griffin.engine.groupby.vect.GroupByNotKeyedVectorRecordCursorFactory;
import io.questdb.griffin.engine.groupby.vect.KSumDoubleVectorAggregateFunction;
import io.questdb.griffin.engine.groupby.vect.MaxDateVectorAggregateFunction;
import io.questdb.griffin.engine.groupby.vect.MaxDoubleVectorAggregateFunction;
import io.questdb.griffin.engine.groupby.vect.MaxIntVectorAggregateFunction;
import io.questdb.griffin.engine.groupby.vect.MaxLongVectorAggregateFunction;
import io.questdb.griffin.engine.groupby.vect.MaxTimestampVectorAggregateFunction;
import io.questdb.griffin.engine.groupby.vect.MinDateVectorAggregateFunction;
import io.questdb.griffin.engine.groupby.vect.MinDoubleVectorAggregateFunction;
import io.questdb.griffin.engine.groupby.vect.MinIntVectorAggregateFunction;
import io.questdb.griffin.engine.groupby.vect.MinLongVectorAggregateFunction;
import io.questdb.griffin.engine.groupby.vect.MinTimestampVectorAggregateFunction;
import io.questdb.griffin.engine.groupby.vect.NSumDoubleVectorAggregateFunction;
import io.questdb.griffin.engine.groupby.vect.SumDateVectorAggregateFunction;
import io.questdb.griffin.engine.groupby.vect.SumDoubleVectorAggregateFunction;
import io.questdb.griffin.engine.groupby.vect.SumIntVectorAggregateFunction;
import io.questdb.griffin.engine.groupby.vect.SumLong256VectorAggregateFunction;
import io.questdb.griffin.engine.groupby.vect.SumLongVectorAggregateFunction;
import io.questdb.griffin.engine.groupby.vect.SumTimestampVectorAggregateFunction;
import io.questdb.griffin.engine.groupby.vect.VectorAggregateFunction;
import io.questdb.griffin.engine.groupby.vect.VectorAggregateFunctionConstructor;
import io.questdb.griffin.engine.join.AsOfJoinLightRecordCursorFactory;
import io.questdb.griffin.engine.join.AsOfJoinNoKeyRecordCursorFactory;
import io.questdb.griffin.engine.join.AsOfJoinRecordCursorFactory;
import io.questdb.griffin.engine.join.CrossJoinRecordCursorFactory;
import io.questdb.griffin.engine.join.HashJoinLightRecordCursorFactory;
import io.questdb.griffin.engine.join.HashJoinRecordCursorFactory;
import io.questdb.griffin.engine.join.HashOuterJoinLightRecordCursorFactory;
import io.questdb.griffin.engine.join.HashOuterJoinRecordCursorFactory;
import io.questdb.griffin.engine.join.JoinRecordMetadata;
import io.questdb.griffin.engine.join.LtJoinLightRecordCursorFactory;
import io.questdb.griffin.engine.join.LtJoinNoKeyRecordCursorFactory;
import io.questdb.griffin.engine.join.LtJoinRecordCursorFactory;
import io.questdb.griffin.engine.join.RecordAsAFieldRecordCursorFactory;
import io.questdb.griffin.engine.join.SpliceJoinLightRecordCursorFactory;
import io.questdb.griffin.engine.orderby.LimitedSizeSortedLightRecordCursorFactory;
import io.questdb.griffin.engine.orderby.RecordComparatorCompiler;
import io.questdb.griffin.engine.orderby.SortedLightRecordCursorFactory;
import io.questdb.griffin.engine.orderby.SortedRecordCursorFactory;
import io.questdb.griffin.engine.table.AsyncFilteredRecordCursorFactory;
import io.questdb.griffin.engine.table.AsyncJitFilteredRecordCursorFactory;
import io.questdb.griffin.engine.table.BwdDataFrameRowCursorFactory;
import io.questdb.griffin.engine.table.DataFrameRecordCursorFactory;
import io.questdb.griffin.engine.table.DataFrameRowCursorFactory;
import io.questdb.griffin.engine.table.DeferredSingleSymbolFilterDataFrameRecordCursorFactory;
import io.questdb.griffin.engine.table.DeferredSymbolIndexFilteredRowCursorFactory;
import io.questdb.griffin.engine.table.DeferredSymbolIndexRowCursorFactory;
import io.questdb.griffin.engine.table.FilterOnExcludedValuesRecordCursorFactory;
import io.questdb.griffin.engine.table.FilterOnSubQueryRecordCursorFactory;
import io.questdb.griffin.engine.table.FilterOnValuesRecordCursorFactory;
import io.questdb.griffin.engine.table.FilteredRecordCursorFactory;
import io.questdb.griffin.engine.table.FunctionBasedRowCursorFactory;
import io.questdb.griffin.engine.table.LatestByAllFilteredRecordCursorFactory;
import io.questdb.griffin.engine.table.LatestByAllIndexedRecordCursorFactory;
import io.questdb.griffin.engine.table.LatestByDeferredListValuesFilteredRecordCursorFactory;
import io.questdb.griffin.engine.table.LatestByLightRecordCursorFactory;
import io.questdb.griffin.engine.table.LatestByRecordCursorFactory;
import io.questdb.griffin.engine.table.LatestBySubQueryRecordCursorFactory;
import io.questdb.griffin.engine.table.LatestByValueDeferredFilteredRecordCursorFactory;
import io.questdb.griffin.engine.table.LatestByValueDeferredIndexedFilteredRecordCursorFactory;
import io.questdb.griffin.engine.table.LatestByValueDeferredIndexedRowCursorFactory;
import io.questdb.griffin.engine.table.LatestByValueFilteredRecordCursorFactory;
import io.questdb.griffin.engine.table.LatestByValueIndexedFilteredRecordCursorFactory;
import io.questdb.griffin.engine.table.LatestByValueIndexedRowCursorFactory;
import io.questdb.griffin.engine.table.LatestByValuesIndexedFilteredRecordCursorFactory;
import io.questdb.griffin.engine.table.SelectedRecordCursorFactory;
import io.questdb.griffin.engine.table.SortedSymbolIndexRecordCursorFactory;
import io.questdb.griffin.engine.table.SymbolIndexFilteredRowCursorFactory;
import io.questdb.griffin.engine.table.SymbolIndexRowCursorFactory;
import io.questdb.griffin.engine.table.VirtualRecordCursorFactory;
import io.questdb.griffin.engine.union.ExceptRecordCursorFactory;
import io.questdb.griffin.engine.union.IntersectRecordCursorFactory;
import io.questdb.griffin.engine.union.SetRecordCursorFactoryConstructor;
import io.questdb.griffin.engine.union.UnionAllRecordCursorFactory;
import io.questdb.griffin.engine.union.UnionRecordCursorFactory;
import io.questdb.griffin.model.AnalyticColumn;
import io.questdb.griffin.model.ExpressionNode;
import io.questdb.griffin.model.IntrinsicModel;
import io.questdb.griffin.model.JoinContext;
import io.questdb.griffin.model.QueryColumn;
import io.questdb.griffin.model.QueryModel;
import io.questdb.griffin.model.RuntimeIntrinsicIntervalModel;
import io.questdb.jit.CompiledFilter;
import io.questdb.jit.CompiledFilterIRSerializer;
import io.questdb.jit.JitUtil;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.BytecodeAssembler;
import io.questdb.std.Chars;
import io.questdb.std.FlyweightMessageContainer;
import io.questdb.std.GenericLexer;
import io.questdb.std.IntHashSet;
import io.questdb.std.IntList;
import io.questdb.std.IntObjHashMap;
import io.questdb.std.LongList;
import io.questdb.std.LowerCaseCharSequenceIntHashMap;
import io.questdb.std.Misc;
import io.questdb.std.Mutable;
import io.questdb.std.Numbers;
import io.questdb.std.ObjList;
import io.questdb.std.ObjObjHashMap;
import io.questdb.std.ObjectPool;
import io.questdb.std.WeakClosableObjectPool;
import java.io.Closeable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlCodeGenerator
implements Mutable,
Closeable {
    public static final int GKK_VANILLA_INT = 0;
    public static final int GKK_HOUR_INT = 1;
    private static final Log LOG = LogFactory.getLog(SqlCodeGenerator.class);
    private static final IntHashSet limitTypes = new IntHashSet();
    private static final FullFatJoinGenerator CREATE_FULL_FAT_LT_JOIN = SqlCodeGenerator::createFullFatLtJoin;
    private static final FullFatJoinGenerator CREATE_FULL_FAT_AS_OF_JOIN = SqlCodeGenerator::createFullFatAsOfJoin;
    private static final boolean[] joinsRequiringTimestamp = new boolean[8];
    private static final IntObjHashMap<VectorAggregateFunctionConstructor> sumConstructors = new IntObjHashMap();
    private static final IntObjHashMap<VectorAggregateFunctionConstructor> ksumConstructors = new IntObjHashMap();
    private static final IntObjHashMap<VectorAggregateFunctionConstructor> nsumConstructors = new IntObjHashMap();
    private static final IntObjHashMap<VectorAggregateFunctionConstructor> avgConstructors = new IntObjHashMap();
    private static final IntObjHashMap<VectorAggregateFunctionConstructor> minConstructors = new IntObjHashMap();
    private static final IntObjHashMap<VectorAggregateFunctionConstructor> maxConstructors = new IntObjHashMap();
    private static final VectorAggregateFunctionConstructor COUNT_CONSTRUCTOR = (keyKind, columnIndex, workerCount) -> new CountVectorAggregateFunction(keyKind);
    private static final SetRecordCursorFactoryConstructor SET_UNION_CONSTRUCTOR = UnionRecordCursorFactory::new;
    private static final SetRecordCursorFactoryConstructor SET_INTERSECT_CONSTRUCTOR = IntersectRecordCursorFactory::new;
    private static final SetRecordCursorFactoryConstructor SET_EXCEPT_CONSTRUCTOR = ExceptRecordCursorFactory::new;
    private final WhereClauseParser whereClauseParser = new WhereClauseParser();
    private final CompiledFilterIRSerializer jitIRSerializer = new CompiledFilterIRSerializer();
    private final MemoryCARW jitIRMem;
    private final boolean enableJitDebug;
    private final FunctionParser functionParser;
    private final CairoEngine engine;
    private final BytecodeAssembler asm = new BytecodeAssembler();
    private final ListColumnFilter listColumnFilterA = new ListColumnFilter();
    private final ListColumnFilter listColumnFilterB = new ListColumnFilter();
    private final CairoConfiguration configuration;
    private final RecordComparatorCompiler recordComparatorCompiler;
    private final IntHashSet intHashSet = new IntHashSet();
    private final ArrayColumnTypes keyTypes = new ArrayColumnTypes();
    private final ArrayColumnTypes valueTypes = new ArrayColumnTypes();
    private final EntityColumnFilter entityColumnFilter = new EntityColumnFilter();
    private final ObjList<VectorAggregateFunction> tempVaf = new ObjList();
    private final GenericRecordMetadata tempMetadata = new GenericRecordMetadata();
    private final ArrayColumnTypes arrayColumnTypes = new ArrayColumnTypes();
    private final IntList tempKeyIndexesInBase = new IntList();
    private final IntList tempSymbolSkewIndexes = new IntList();
    private final IntList tempKeyIndex = new IntList();
    private final IntList tempAggIndex = new IntList();
    private final ObjList<VectorAggregateFunctionConstructor> tempVecConstructors = new ObjList();
    private final IntList tempVecConstructorArgIndexes = new IntList();
    private final IntList tempKeyKinds = new IntList();
    private final ObjObjHashMap<IntList, ObjList<AnalyticFunction>> groupedAnalytic = new ObjObjHashMap();
    private final IntList recordFunctionPositions = new IntList();
    private final IntList groupByFunctionPositions = new IntList();
    private final LongList prefixes = new LongList();
    private final ObjectPool<ExpressionNode> expressionNodePool;
    private final WeakClosableObjectPool<PageFrameReduceTask> reduceTaskPool;
    private final ObjList<TableColumnMetadata> deferredAnalyticMetadata = new ObjList();
    private final ObjectPool<IntList> intListPool = new ObjectPool<IntList>(IntList::new, 4);
    private boolean enableJitNullChecks = true;
    private boolean fullFatJoins = false;

    public SqlCodeGenerator(CairoEngine engine, CairoConfiguration configuration, FunctionParser functionParser, ObjectPool<ExpressionNode> expressionNodePool) {
        this.engine = engine;
        this.configuration = configuration;
        this.functionParser = functionParser;
        this.recordComparatorCompiler = new RecordComparatorCompiler(this.asm);
        this.enableJitDebug = configuration.isSqlJitDebugEnabled();
        this.jitIRMem = Vm.getCARWInstance(configuration.getSqlJitIRMemoryPageSize(), configuration.getSqlJitIRMemoryMaxPages(), 22);
        this.jitIRMem.putByte((byte)0);
        this.jitIRMem.truncate();
        this.expressionNodePool = expressionNodePool;
        this.reduceTaskPool = new WeakClosableObjectPool<PageFrameReduceTask>(() -> new PageFrameReduceTask(configuration), configuration.getPageFrameReduceTaskPoolCapacity());
    }

    @Override
    public void clear() {
        this.whereClauseParser.clear();
        this.intListPool.clear();
    }

    @Override
    public void close() {
        Misc.free(this.jitIRMem);
        Misc.free(this.reduceTaskPool);
    }

    @NotNull
    public Function compileBooleanFilter(ExpressionNode expr, RecordMetadata metadata, SqlExecutionContext executionContext) throws SqlException {
        Function filter = this.functionParser.parseFunction(expr, metadata, executionContext);
        if (ColumnType.isBoolean(filter.getType())) {
            return filter;
        }
        Misc.free(filter);
        throw SqlException.$(expr.position, "boolean expression expected");
    }

    public RecordCursorFactory generate(QueryModel model, SqlExecutionContext executionContext) throws SqlException {
        return this.generateQuery(model, executionContext, true);
    }

    private static RecordCursorFactory createFullFatAsOfJoin(CairoConfiguration configuration, RecordMetadata metadata, RecordCursorFactory masterFactory, RecordCursorFactory slaveFactory, ColumnTypes mapKeyTypes, ColumnTypes mapValueTypes, ColumnTypes slaveColumnTypes, RecordSink masterKeySink, RecordSink slaveKeySink, int columnSplit, RecordValueSink slaveValueSink, IntList columnIndex) {
        return new AsOfJoinRecordCursorFactory(configuration, metadata, masterFactory, slaveFactory, mapKeyTypes, mapValueTypes, slaveColumnTypes, masterKeySink, slaveKeySink, columnSplit, slaveValueSink, columnIndex);
    }

    private static RecordCursorFactory createFullFatLtJoin(CairoConfiguration configuration, RecordMetadata metadata, RecordCursorFactory masterFactory, RecordCursorFactory slaveFactory, ColumnTypes mapKeyTypes, ColumnTypes mapValueTypes, ColumnTypes slaveColumnTypes, RecordSink masterKeySink, RecordSink slaveKeySink, int columnSplit, RecordValueSink slaveValueSink, IntList columnIndex) {
        return new LtJoinRecordCursorFactory(configuration, metadata, masterFactory, slaveFactory, mapKeyTypes, mapValueTypes, slaveColumnTypes, masterKeySink, slaveKeySink, columnSplit, slaveValueSink, columnIndex);
    }

    private static int getOrderByDirectionOrDefault(QueryModel model, int index) {
        IntList direction = model.getOrderByDirectionAdvice();
        if (index >= direction.size()) {
            return 0;
        }
        return model.getOrderByDirectionAdvice().getQuick(index);
    }

    private static boolean allGroupsFirstLastWithSingleSymbolFilter(QueryModel model, RecordMetadata metadata) {
        ObjList<QueryColumn> columns = model.getColumns();
        int n = columns.size();
        for (int i = 0; i < n; ++i) {
            QueryColumn column = columns.getQuick(i);
            ExpressionNode node = column.getAst();
            if (node.type == 4) continue;
            ExpressionNode columnAst = column.getAst();
            CharSequence token = columnAst.token;
            if (!SqlKeywords.isFirstKeyword(token) && !SqlKeywords.isLastKeyword(token)) {
                return false;
            }
            if (columnAst.rhs.type == 4 && metadata.getColumnIndex(columnAst.rhs.token) >= 0) continue;
            return false;
        }
        return true;
    }

    private VectorAggregateFunctionConstructor assembleFunctionReference(RecordMetadata metadata, ExpressionNode ast) {
        if (ast.type == 8 && ast.paramCount == 1 && SqlKeywords.isSumKeyword(ast.token) && ast.rhs.type == 4) {
            int columnIndex = metadata.getColumnIndex(ast.rhs.token);
            this.tempVecConstructorArgIndexes.add(columnIndex);
            return sumConstructors.get(metadata.getColumnType(columnIndex));
        }
        if (ast.type == 8 && ast.paramCount == 0 && SqlKeywords.isCountKeyword(ast.token)) {
            this.tempVecConstructorArgIndexes.add(-1);
            return COUNT_CONSTRUCTOR;
        }
        if (this.isSingleColumnFunction(ast, "ksum")) {
            int columnIndex = metadata.getColumnIndex(ast.rhs.token);
            this.tempVecConstructorArgIndexes.add(columnIndex);
            return ksumConstructors.get(metadata.getColumnType(columnIndex));
        }
        if (this.isSingleColumnFunction(ast, "nsum")) {
            int columnIndex = metadata.getColumnIndex(ast.rhs.token);
            this.tempVecConstructorArgIndexes.add(columnIndex);
            return nsumConstructors.get(metadata.getColumnType(columnIndex));
        }
        if (this.isSingleColumnFunction(ast, "avg")) {
            int columnIndex = metadata.getColumnIndex(ast.rhs.token);
            this.tempVecConstructorArgIndexes.add(columnIndex);
            return avgConstructors.get(metadata.getColumnType(columnIndex));
        }
        if (this.isSingleColumnFunction(ast, "min")) {
            int columnIndex = metadata.getColumnIndex(ast.rhs.token);
            this.tempVecConstructorArgIndexes.add(columnIndex);
            return minConstructors.get(metadata.getColumnType(columnIndex));
        }
        if (this.isSingleColumnFunction(ast, "max")) {
            int columnIndex = metadata.getColumnIndex(ast.rhs.token);
            this.tempVecConstructorArgIndexes.add(columnIndex);
            return maxConstructors.get(metadata.getColumnType(columnIndex));
        }
        return null;
    }

    private boolean assembleKeysAndFunctionReferences(ObjList<QueryColumn> columns, RecordMetadata metadata, boolean checkLiterals) {
        this.tempVaf.clear();
        this.tempMetadata.clear();
        this.tempSymbolSkewIndexes.clear();
        this.tempVecConstructors.clear();
        this.tempVecConstructorArgIndexes.clear();
        this.tempAggIndex.clear();
        int n = columns.size();
        for (int i = 0; i < n; ++i) {
            QueryColumn qc = columns.getQuick(i);
            ExpressionNode ast = qc.getAst();
            if (ast.type == 4) {
                if (!checkLiterals) continue;
                int columnIndex = metadata.getColumnIndex(ast.token);
                int type = metadata.getColumnType(columnIndex);
                if (ColumnType.isInt(type)) {
                    this.tempKeyIndexesInBase.add(columnIndex);
                    this.tempKeyIndex.add(i);
                    this.arrayColumnTypes.add(5);
                    this.tempKeyKinds.add(0);
                    continue;
                }
                if (ColumnType.isSymbol(type)) {
                    this.tempKeyIndexesInBase.add(columnIndex);
                    this.tempKeyIndex.add(i);
                    this.tempSymbolSkewIndexes.extendAndSet(i, columnIndex);
                    this.arrayColumnTypes.add(12);
                    this.tempKeyKinds.add(0);
                    continue;
                }
                return false;
            }
            VectorAggregateFunctionConstructor constructor = this.assembleFunctionReference(metadata, ast);
            if (constructor != null) {
                this.tempVecConstructors.add(constructor);
                this.tempAggIndex.add(i);
                continue;
            }
            return false;
        }
        return true;
    }

    private boolean canBeOptimized(QueryModel model, SqlExecutionContext context, Function loFunc, Function hiFunc) {
        if (model.getLimitLo() == null && model.getLimitHi() == null) {
            return false;
        }
        if (loFunc != null && loFunc.isConstant() && hiFunc != null && hiFunc.isConstant()) {
            try {
                loFunc.init(null, context);
                hiFunc.init(null, context);
                return loFunc.getLong(null) < 0L || hiFunc.getLong(null) >= 0L;
            }
            catch (SqlException ex) {
                LOG.error().$("Failed to initialize lo or hi functions [").$("error=").$(ex.getMessage()).I$();
            }
        }
        return true;
    }

    private boolean checkIfSetCastIsRequired(RecordMetadata metadataA, RecordMetadata metadataB, boolean symbolDisallowed) {
        int columnCount = metadataA.getColumnCount();
        assert (columnCount == metadataB.getColumnCount());
        for (int i = 0; i < columnCount; ++i) {
            int typeB;
            int typeA = metadataA.getColumnType(i);
            if (typeA == (typeB = metadataB.getColumnType(i)) && (typeA != 12 || !symbolDisallowed)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private Function compileFilter(IntrinsicModel intrinsicModel, RecordMetadata readerMeta, SqlExecutionContext executionContext) throws SqlException {
        if (intrinsicModel.filter != null) {
            return this.compileBooleanFilter(intrinsicModel.filter, readerMeta, executionContext);
        }
        return null;
    }

    @Nullable
    private ObjList<Function> compileWorkerFilterConditionally(boolean condition, int workerCount, ExpressionNode filterExpr, RecordMetadata metadata, SqlExecutionContext executionContext) throws SqlException {
        if (condition) {
            ObjList<Function> workerFilters = new ObjList<Function>();
            for (int i = 0; i < workerCount; ++i) {
                workerFilters.extendAndSet(i, this.compileBooleanFilter(filterExpr, metadata, executionContext));
            }
            return workerFilters;
        }
        return null;
    }

    private RecordCursorFactory createAsOfJoin(RecordMetadata metadata, RecordCursorFactory master, RecordSink masterKeySink, RecordCursorFactory slave, RecordSink slaveKeySink, int columnSplit) {
        this.valueTypes.clear();
        this.valueTypes.add(6);
        this.valueTypes.add(6);
        return new AsOfJoinLightRecordCursorFactory(this.configuration, metadata, master, slave, this.keyTypes, this.valueTypes, masterKeySink, slaveKeySink, columnSplit);
    }

    @NotNull
    private RecordCursorFactory createFullFatJoin(RecordCursorFactory master, RecordMetadata masterMetadata, CharSequence masterAlias, RecordCursorFactory slave, RecordMetadata slaveMetadata, CharSequence slaveAlias, int joinPosition, FullFatJoinGenerator generator) throws SqlException {
        this.intHashSet.clear();
        int n = this.listColumnFilterA.getColumnCount();
        for (int i = 0; i < n; ++i) {
            this.intHashSet.add(this.listColumnFilterA.getColumnIndexFactored(i));
        }
        int m = slaveMetadata.getColumnCount();
        for (int k = 0; k < m; ++k) {
            if (!this.intHashSet.excludes(k) || !ColumnType.isVariableLength(slaveMetadata.getColumnType(k))) continue;
            throw SqlException.position(joinPosition).put("right side column '").put(slaveMetadata.getColumnName(k)).put("' is of unsupported type");
        }
        RecordSink masterSink = RecordSinkFactory.getInstance(this.asm, masterMetadata, this.listColumnFilterB, true);
        JoinRecordMetadata metadata = new JoinRecordMetadata(this.configuration, masterMetadata.getColumnCount() + slaveMetadata.getColumnCount());
        try {
            metadata.copyColumnMetadataFrom(masterAlias, masterMetadata);
            IntList columnIndex = new IntList(slaveMetadata.getColumnCount());
            this.listColumnFilterB.clear();
            this.valueTypes.clear();
            ArrayColumnTypes slaveTypes = new ArrayColumnTypes();
            if (slaveMetadata instanceof BaseRecordMetadata) {
                int i;
                int n2 = slaveMetadata.getColumnCount();
                for (i = 0; i < n2; ++i) {
                    if (!this.intHashSet.excludes(i)) continue;
                    TableColumnMetadata m2 = ((BaseRecordMetadata)slaveMetadata).getColumnQuick(i);
                    metadata.add(slaveAlias, m2);
                    this.listColumnFilterB.add(i + 1);
                    columnIndex.add(i);
                    this.valueTypes.add(m2.getType());
                    slaveTypes.add(m2.getType());
                }
                n2 = this.listColumnFilterA.getColumnCount();
                for (i = 0; i < n2; ++i) {
                    int index = this.listColumnFilterA.getColumnIndexFactored(i);
                    TableColumnMetadata m3 = ((BaseRecordMetadata)slaveMetadata).getColumnQuick(index);
                    if (ColumnType.isSymbol(m3.getType())) {
                        metadata.add(slaveAlias, m3.getName(), m3.getHash(), 11, false, 0, false, null);
                        slaveTypes.add(11);
                    } else {
                        metadata.add(slaveAlias, m3);
                        slaveTypes.add(m3.getType());
                    }
                    columnIndex.add(index);
                }
            } else {
                int i;
                int n3 = slaveMetadata.getColumnCount();
                for (i = 0; i < n3; ++i) {
                    if (!this.intHashSet.excludes(i)) continue;
                    int type = slaveMetadata.getColumnType(i);
                    metadata.add(slaveAlias, slaveMetadata.getColumnName(i), slaveMetadata.getColumnHash(i), type, slaveMetadata.isColumnIndexed(i), slaveMetadata.getIndexValueBlockCapacity(i), slaveMetadata.isSymbolTableStatic(i), slaveMetadata.getMetadata(i));
                    this.listColumnFilterB.add(i + 1);
                    columnIndex.add(i);
                    this.valueTypes.add(type);
                    slaveTypes.add(type);
                }
                n3 = this.listColumnFilterA.getColumnCount();
                for (i = 0; i < n3; ++i) {
                    int index = this.listColumnFilterA.getColumnIndexFactored(i);
                    int type = slaveMetadata.getColumnType(index);
                    if (ColumnType.isSymbol(type)) {
                        type = 11;
                    }
                    metadata.add(slaveAlias, slaveMetadata.getColumnName(index), slaveMetadata.getColumnHash(index), type, slaveMetadata.isColumnIndexed(i), slaveMetadata.getIndexValueBlockCapacity(i), slaveMetadata.isSymbolTableStatic(i), slaveMetadata.getMetadata(i));
                    columnIndex.add(index);
                    slaveTypes.add(type);
                }
            }
            if (masterMetadata.getTimestampIndex() != -1) {
                metadata.setTimestampIndex(masterMetadata.getTimestampIndex());
            }
            return generator.create(this.configuration, metadata, master, slave, this.keyTypes, this.valueTypes, slaveTypes, masterSink, RecordSinkFactory.getInstance(this.asm, slaveMetadata, this.listColumnFilterA, true), masterMetadata.getColumnCount(), RecordValueSinkFactory.getInstance(this.asm, slaveMetadata, this.listColumnFilterB), columnIndex);
        }
        catch (Throwable e) {
            Misc.free(metadata);
            throw e;
        }
    }

    private RecordCursorFactory createHashJoin(RecordMetadata metadata, RecordCursorFactory master, RecordCursorFactory slave, int joinType) {
        RecordMetadata masterMetadata = master.getMetadata();
        RecordMetadata slaveMetadata = slave.getMetadata();
        RecordSink masterKeySink = RecordSinkFactory.getInstance(this.asm, masterMetadata, this.listColumnFilterB, true);
        RecordSink slaveKeySink = RecordSinkFactory.getInstance(this.asm, slaveMetadata, this.listColumnFilterA, true);
        this.valueTypes.clear();
        this.valueTypes.add(6);
        this.valueTypes.add(6);
        if (slave.recordCursorSupportsRandomAccess() && !this.fullFatJoins) {
            if (joinType == 1) {
                return new HashJoinLightRecordCursorFactory(this.configuration, metadata, master, slave, this.keyTypes, this.valueTypes, masterKeySink, slaveKeySink, masterMetadata.getColumnCount());
            }
            return new HashOuterJoinLightRecordCursorFactory(this.configuration, metadata, master, slave, this.keyTypes, this.valueTypes, masterKeySink, slaveKeySink, masterMetadata.getColumnCount());
        }
        this.entityColumnFilter.of(slaveMetadata.getColumnCount());
        RecordSink slaveSink = RecordSinkFactory.getInstance(this.asm, slaveMetadata, this.entityColumnFilter, false);
        if (joinType == 1) {
            return new HashJoinRecordCursorFactory(this.configuration, metadata, master, slave, this.keyTypes, this.valueTypes, masterKeySink, slaveKeySink, slaveSink, masterMetadata.getColumnCount());
        }
        return new HashOuterJoinRecordCursorFactory(this.configuration, metadata, master, slave, this.keyTypes, this.valueTypes, masterKeySink, slaveKeySink, slaveSink, masterMetadata.getColumnCount());
    }

    @NotNull
    private JoinRecordMetadata createJoinMetadata(CharSequence masterAlias, RecordMetadata masterMetadata, CharSequence slaveAlias, RecordMetadata slaveMetadata) {
        return this.createJoinMetadata(masterAlias, masterMetadata, slaveAlias, slaveMetadata, masterMetadata.getTimestampIndex());
    }

    @NotNull
    private JoinRecordMetadata createJoinMetadata(CharSequence masterAlias, RecordMetadata masterMetadata, CharSequence slaveAlias, RecordMetadata slaveMetadata, int timestampIndex) {
        JoinRecordMetadata metadata = new JoinRecordMetadata(this.configuration, masterMetadata.getColumnCount() + slaveMetadata.getColumnCount());
        metadata.copyColumnMetadataFrom(masterAlias, masterMetadata);
        metadata.copyColumnMetadataFrom(slaveAlias, slaveMetadata);
        if (timestampIndex != -1) {
            metadata.setTimestampIndex(timestampIndex);
        }
        return metadata;
    }

    private RecordCursorFactory createLtJoin(RecordMetadata metadata, RecordCursorFactory master, RecordSink masterKeySink, RecordCursorFactory slave, RecordSink slaveKeySink, int columnSplit) {
        this.valueTypes.clear();
        this.valueTypes.add(6);
        this.valueTypes.add(6);
        return new LtJoinLightRecordCursorFactory(this.configuration, metadata, master, slave, this.keyTypes, this.valueTypes, masterKeySink, slaveKeySink, columnSplit);
    }

    private RecordCursorFactory createSpliceJoin(RecordMetadata metadata, RecordCursorFactory master, RecordSink masterKeySink, RecordCursorFactory slave, RecordSink slaveKeySink, int columnSplit) {
        this.valueTypes.clear();
        this.valueTypes.add(6);
        this.valueTypes.add(6);
        this.valueTypes.add(6);
        this.valueTypes.add(6);
        return new SpliceJoinLightRecordCursorFactory(this.configuration, metadata, master, slave, this.keyTypes, this.valueTypes, masterKeySink, slaveKeySink, columnSplit);
    }

    private ObjList<Function> generateCastFunctions(RecordMetadata castToMetadata, RecordMetadata castFromMetadata, int modelPosition) throws SqlException {
        int columnCount = castToMetadata.getColumnCount();
        ObjList<Function> castFunctions = new ObjList<Function>();
        block103: for (int i = 0; i < columnCount; ++i) {
            int toType = castToMetadata.getColumnType(i);
            int fromType = castFromMetadata.getColumnType(i);
            short toTag = ColumnType.tagOf(toType);
            short fromTag = ColumnType.tagOf(fromType);
            if (fromTag == 28) {
                castFunctions.add(NullConstant.NULL);
                continue;
            }
            switch (toTag) {
                case 1: {
                    castFunctions.add(new BooleanColumn(i));
                    continue block103;
                }
                case 2: {
                    castFunctions.add(new ByteColumn(i));
                    continue block103;
                }
                case 3: {
                    switch (fromTag) {
                        case 2: {
                            castFunctions.add(new ByteColumn(i));
                            break;
                        }
                        case 4: {
                            castFunctions.add(new CharColumn(i));
                            break;
                        }
                        case 3: {
                            castFunctions.add(new ShortColumn(i));
                        }
                    }
                    continue block103;
                }
                case 4: {
                    switch (fromTag) {
                        case 2: {
                            castFunctions.add(new CastByteToCharFunctionFactory.CastByteToCharFunction(new ByteColumn(i)));
                            continue block103;
                        }
                        case 4: {
                            castFunctions.add(new CharColumn(i));
                            continue block103;
                        }
                    }
                    continue block103;
                }
                case 5: {
                    switch (fromTag) {
                        case 2: {
                            castFunctions.add(new ByteColumn(i));
                            break;
                        }
                        case 3: {
                            castFunctions.add(new ShortColumn(i));
                            break;
                        }
                        case 4: {
                            castFunctions.add(new CharColumn(i));
                            break;
                        }
                        case 5: {
                            castFunctions.add(new IntColumn(i));
                        }
                    }
                    continue block103;
                }
                case 6: {
                    switch (fromTag) {
                        case 2: {
                            castFunctions.add(new ByteColumn(i));
                            continue block103;
                        }
                        case 3: {
                            castFunctions.add(new ShortColumn(i));
                            continue block103;
                        }
                        case 4: {
                            castFunctions.add(new CharColumn(i));
                            continue block103;
                        }
                        case 5: {
                            castFunctions.add(new IntColumn(i));
                            continue block103;
                        }
                        case 6: {
                            castFunctions.add(new LongColumn(i));
                            continue block103;
                        }
                    }
                    throw SqlException.unsupportedCast(modelPosition, castFromMetadata.getColumnName(i), fromType, toType);
                }
                case 7: {
                    if (fromTag == 7) {
                        castFunctions.add(new DateColumn(i));
                        continue block103;
                    }
                    throw SqlException.unsupportedCast(modelPosition, castFromMetadata.getColumnName(i), fromType, toType);
                }
                case 8: {
                    switch (fromTag) {
                        case 7: {
                            castFunctions.add(new CastDateToTimestampFunctionFactory.CastDateToTimestampFunction(new DateColumn(i)));
                            continue block103;
                        }
                        case 8: {
                            castFunctions.add(new TimestampColumn(i));
                            continue block103;
                        }
                    }
                    throw SqlException.unsupportedCast(modelPosition, castFromMetadata.getColumnName(i), fromType, toType);
                }
                case 9: {
                    switch (fromTag) {
                        case 2: {
                            castFunctions.add(new ByteColumn(i));
                            continue block103;
                        }
                        case 3: {
                            castFunctions.add(new ShortColumn(i));
                            continue block103;
                        }
                        case 5: {
                            castFunctions.add(new IntColumn(i));
                            continue block103;
                        }
                        case 6: {
                            castFunctions.add(new LongColumn(i));
                            continue block103;
                        }
                        case 9: {
                            castFunctions.add(new FloatColumn(i));
                            continue block103;
                        }
                    }
                    throw SqlException.unsupportedCast(modelPosition, castFromMetadata.getColumnName(i), fromType, toType);
                }
                case 10: {
                    switch (fromTag) {
                        case 2: {
                            castFunctions.add(new ByteColumn(i));
                            continue block103;
                        }
                        case 3: {
                            castFunctions.add(new ShortColumn(i));
                            continue block103;
                        }
                        case 5: {
                            castFunctions.add(new IntColumn(i));
                            continue block103;
                        }
                        case 6: {
                            castFunctions.add(new LongColumn(i));
                            continue block103;
                        }
                        case 9: {
                            castFunctions.add(new FloatColumn(i));
                            continue block103;
                        }
                        case 10: {
                            castFunctions.add(new DoubleColumn(i));
                            continue block103;
                        }
                    }
                    throw SqlException.unsupportedCast(modelPosition, castFromMetadata.getColumnName(i), fromType, toType);
                }
                case 11: {
                    switch (fromTag) {
                        case 1: {
                            castFunctions.add(new BooleanColumn(i));
                            continue block103;
                        }
                        case 2: {
                            castFunctions.add(new CastByteToStrFunctionFactory.CastByteToStrFunction(new ByteColumn(i)));
                            continue block103;
                        }
                        case 3: {
                            castFunctions.add(new CastShortToStrFunctionFactory.CastShortToStrFunction(new ShortColumn(i)));
                            continue block103;
                        }
                        case 4: {
                            castFunctions.add(new CharColumn(i));
                            continue block103;
                        }
                        case 5: {
                            castFunctions.add(new CastIntToStrFunctionFactory.CastIntToStrFunction(new IntColumn(i)));
                            continue block103;
                        }
                        case 6: {
                            castFunctions.add(new CastLongToStrFunctionFactory.CastLongToStrFunction(new LongColumn(i)));
                            continue block103;
                        }
                        case 7: {
                            castFunctions.add(new CastDateToStrFunctionFactory.CastDateToStrFunction(new DateColumn(i)));
                            continue block103;
                        }
                        case 8: {
                            castFunctions.add(new CastTimestampToStrFunctionFactory.CastTimestampToStrFunction(new TimestampColumn(i)));
                            continue block103;
                        }
                        case 9: {
                            castFunctions.add(new CastFloatToStrFunctionFactory.CastFloatToStrFunction(new FloatColumn(i), this.configuration.getFloatToStrCastScale()));
                            continue block103;
                        }
                        case 10: {
                            castFunctions.add(new CastDoubleToStrFunctionFactory.CastDoubleToStrFunction(new DoubleColumn(i), this.configuration.getDoubleToStrCastScale()));
                            continue block103;
                        }
                        case 11: {
                            castFunctions.add(new StrColumn(i));
                            continue block103;
                        }
                        case 12: {
                            castFunctions.add(new CastSymbolToStrFunctionFactory.CastSymbolToStrFunction(new SymbolColumn(i, castFromMetadata.isSymbolTableStatic(i))));
                            continue block103;
                        }
                        case 13: {
                            castFunctions.add(new CastLong256ToStrFunctionFactory.CastLong256ToStrFunction(new Long256Column(i)));
                            continue block103;
                        }
                        case 14: {
                            castFunctions.add(CastGeoHashToGeoHashFunctionFactory.getGeoByteToStrCastFunction(new GeoByteColumn(i, toTag), ColumnType.getGeoHashBits(fromType)));
                            continue block103;
                        }
                        case 15: {
                            castFunctions.add(CastGeoHashToGeoHashFunctionFactory.getGeoShortToStrCastFunction(new GeoShortColumn(i, toTag), ColumnType.getGeoHashBits(castFromMetadata.getColumnType(i))));
                            continue block103;
                        }
                        case 16: {
                            castFunctions.add(CastGeoHashToGeoHashFunctionFactory.getGeoIntToStrCastFunction(new GeoIntColumn(i, toTag), ColumnType.getGeoHashBits(castFromMetadata.getColumnType(i))));
                            continue block103;
                        }
                        case 17: {
                            castFunctions.add(CastGeoHashToGeoHashFunctionFactory.getGeoLongToStrCastFunction(new GeoLongColumn(i, toTag), ColumnType.getGeoHashBits(castFromMetadata.getColumnType(i))));
                            continue block103;
                        }
                        case 18: {
                            throw SqlException.unsupportedCast(modelPosition, castFromMetadata.getColumnName(i), fromType, toType);
                        }
                    }
                    continue block103;
                }
                case 12: {
                    castFunctions.add(new CastSymbolToStrFunctionFactory.CastSymbolToStrFunction(new SymbolColumn(i, castFromMetadata.isSymbolTableStatic(i))));
                    continue block103;
                }
                case 13: {
                    castFunctions.add(new Long256Column(i));
                    continue block103;
                }
                case 14: {
                    switch (fromTag) {
                        case 11: {
                            castFunctions.add(CastStrToGeoHashFunctionFactory.newInstance(0, toType, new StrColumn(i)));
                            continue block103;
                        }
                        case 14: {
                            castFunctions.add(new GeoByteColumn(i, fromType));
                            continue block103;
                        }
                        case 15: {
                            castFunctions.add(CastGeoHashToGeoHashFunctionFactory.newInstance(0, new GeoShortColumn(i, fromType), toType, fromType));
                            continue block103;
                        }
                        case 16: {
                            castFunctions.add(CastGeoHashToGeoHashFunctionFactory.newInstance(0, new GeoIntColumn(i, fromType), toType, fromType));
                            continue block103;
                        }
                        case 17: {
                            castFunctions.add(CastGeoHashToGeoHashFunctionFactory.newInstance(0, new GeoLongColumn(i, fromType), toType, fromType));
                            continue block103;
                        }
                    }
                    throw SqlException.unsupportedCast(modelPosition, castFromMetadata.getColumnName(i), fromType, toType);
                }
                case 15: {
                    switch (fromTag) {
                        case 11: {
                            castFunctions.add(CastStrToGeoHashFunctionFactory.newInstance(0, toType, new StrColumn(i)));
                            continue block103;
                        }
                        case 15: {
                            castFunctions.add(new GeoShortColumn(i, toType));
                            continue block103;
                        }
                        case 16: {
                            castFunctions.add(CastGeoHashToGeoHashFunctionFactory.newInstance(0, new GeoIntColumn(i, fromType), toType, fromType));
                            continue block103;
                        }
                        case 17: {
                            castFunctions.add(CastGeoHashToGeoHashFunctionFactory.newInstance(0, new GeoLongColumn(i, fromType), toType, fromType));
                            continue block103;
                        }
                    }
                    throw SqlException.unsupportedCast(modelPosition, castFromMetadata.getColumnName(i), fromType, toType);
                }
                case 16: {
                    switch (fromTag) {
                        case 11: {
                            castFunctions.add(CastStrToGeoHashFunctionFactory.newInstance(0, toType, new StrColumn(i)));
                            continue block103;
                        }
                        case 16: {
                            castFunctions.add(new GeoIntColumn(i, fromType));
                            continue block103;
                        }
                        case 17: {
                            castFunctions.add(CastGeoHashToGeoHashFunctionFactory.newInstance(0, new GeoLongColumn(i, fromType), toType, fromType));
                            continue block103;
                        }
                    }
                    throw SqlException.unsupportedCast(modelPosition, castFromMetadata.getColumnName(i), fromType, toType);
                }
                case 17: {
                    switch (fromTag) {
                        case 11: {
                            castFunctions.add(CastStrToGeoHashFunctionFactory.newInstance(0, toType, new StrColumn(i)));
                            continue block103;
                        }
                        case 17: {
                            castFunctions.add(new GeoLongColumn(i, fromType));
                            continue block103;
                        }
                    }
                    throw SqlException.unsupportedCast(modelPosition, castFromMetadata.getColumnName(i), fromType, toType);
                }
                case 18: {
                    castFunctions.add(new BinColumn(i));
                }
            }
        }
        return castFunctions;
    }

    private RecordCursorFactory generateFilter(RecordCursorFactory factory, QueryModel model, SqlExecutionContext executionContext) throws SqlException {
        ExpressionNode filter = model.getWhereClause();
        return filter == null ? factory : this.generateFilter0(factory, model, executionContext, filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private RecordCursorFactory generateFilter0(RecordCursorFactory factory, QueryModel model, SqlExecutionContext executionContext, ExpressionNode filterExpr) throws SqlException {
        Function filter;
        model.setWhereClause(null);
        try {
            filter = this.compileBooleanFilter(filterExpr, factory.getMetadata(), executionContext);
        }
        catch (Throwable e) {
            Misc.free(factory);
            throw e;
        }
        if (filter.isConstant()) {
            try {
                if (filter.getBool(null)) {
                    RecordCursorFactory e = factory;
                    return e;
                }
                RecordMetadata metadata = factory.getMetadata();
                assert (metadata instanceof GenericRecordMetadata);
                Misc.free(factory);
                EmptyTableRecordCursorFactory emptyTableRecordCursorFactory = new EmptyTableRecordCursorFactory(metadata);
                return emptyTableRecordCursorFactory;
            }
            finally {
                filter.close();
            }
        }
        boolean enableParallelFilter = this.configuration.isSqlParallelFilterEnabled();
        boolean preTouchColumns = this.configuration.isSqlParallelFilterPreTouchEnabled();
        if (enableParallelFilter && factory.supportPageFrameCursor()) {
            Function limitLoFunction;
            boolean canCompile;
            boolean useJit = executionContext.getJitMode() != 2;
            boolean bl = canCompile = factory.supportPageFrameCursor() && JitUtil.isJitSupported();
            if (useJit && canCompile) {
                CompiledFilter jitFilter = null;
                try {
                    int jitOptions;
                    ObjList<Function> bindVarFunctions = new ObjList<Function>();
                    try (PageFrameCursor cursor = factory.getPageFrameCursor(executionContext, 2);){
                        boolean forceScalar = executionContext.getJitMode() == 1;
                        this.jitIRSerializer.of(this.jitIRMem, executionContext, factory.getMetadata(), cursor, bindVarFunctions);
                        jitOptions = this.jitIRSerializer.serialize(filterExpr, forceScalar, this.enableJitDebug, this.enableJitNullChecks);
                    }
                    jitFilter = new CompiledFilter();
                    jitFilter.compile(this.jitIRMem, jitOptions);
                    Function limitLoFunction2 = this.getLimitLoFunctionOnly(model, executionContext);
                    int limitLoPos = model.getLimitAdviceLo() != null ? model.getLimitAdviceLo().position : 0;
                    LOG.info().$("JIT enabled for (sub)query [tableName=").utf8(model.getName()).$(", fd=").$(executionContext.getRequestFd()).$(']').$();
                    AsyncJitFilteredRecordCursorFactory asyncJitFilteredRecordCursorFactory = new AsyncJitFilteredRecordCursorFactory(this.configuration, executionContext.getMessageBus(), factory, bindVarFunctions, filter, this.compileWorkerFilterConditionally(!filter.isReadThreadSafe(), executionContext.getSharedWorkerCount(), filterExpr, factory.getMetadata(), executionContext), jitFilter, this.reduceTaskPool, limitLoFunction2, limitLoPos, preTouchColumns);
                    return asyncJitFilteredRecordCursorFactory;
                }
                catch (SqlException | LimitOverflowException ex) {
                    Misc.free(jitFilter);
                    LOG.debug().$("JIT cannot be applied to (sub)query [tableName=").utf8(model.getName()).$(", ex=").$(((FlyweightMessageContainer)((Object)ex)).getFlyweightMessage()).$(", fd=").$(executionContext.getRequestFd()).$(']').$();
                }
                finally {
                    this.jitIRSerializer.clear();
                    this.jitIRMem.truncate();
                }
            }
            try {
                limitLoFunction = this.getLimitLoFunctionOnly(model, executionContext);
            }
            catch (Throwable e) {
                Misc.free(filter);
                Misc.free(factory);
                throw e;
            }
            int limitLoPos = model.getLimitAdviceLo() != null ? model.getLimitAdviceLo().position : 0;
            return new AsyncFilteredRecordCursorFactory(this.configuration, executionContext.getMessageBus(), factory, filter, this.reduceTaskPool, this.compileWorkerFilterConditionally(!filter.isReadThreadSafe(), executionContext.getSharedWorkerCount(), filterExpr, factory.getMetadata(), executionContext), limitLoFunction, limitLoPos, preTouchColumns);
        }
        return new FilteredRecordCursorFactory(factory, filter);
    }

    private RecordCursorFactory generateFunctionQuery(QueryModel model, SqlExecutionContext executionContext) throws SqlException {
        Function function = model.getTableNameFunction();
        if (function != null) {
            model.setTableNameFunction(null);
            return function.getRecordCursorFactory();
        }
        return TableUtils.createCursorFunction(this.functionParser, model, executionContext).getRecordCursorFactory();
    }

    /*
     * Unable to fully structure code
     */
    private RecordCursorFactory generateJoins(QueryModel model, SqlExecutionContext executionContext) throws SqlException {
        joinModels = model.getJoinModels();
        ordered = model.getOrderedJoinModels();
        master = null;
        masterAlias = null;
        try {
            n = ordered.size();
            if (!SqlCodeGenerator.$assertionsDisabled && n <= 1) {
                throw new AssertionError();
            }
            for (i = 0; i < n; ++i) {
                block24: {
                    index = ordered.getQuick(i);
                    slaveModel = joinModels.getQuick(index);
                    if (i > 0) {
                        executionContext.pushTimestampRequiredFlag(SqlCodeGenerator.joinsRequiringTimestamp[slaveModel.getJoinType()]);
                    } else {
                        nextJointType = joinModels.getQuick(ordered.getQuick(1)).getJoinType();
                        executionContext.pushTimestampRequiredFlag(SqlCodeGenerator.joinsRequiringTimestamp[nextJointType]);
                    }
                    slave = null;
                    releaseSlave = true;
                    try {
                        slave = this.generateQuery(slaveModel, executionContext, index > 0);
                        if (master == null) {
                            master = slave;
                            releaseSlave = false;
                            masterAlias = slaveModel.getName();
                            break block24;
                        }
                        joinType = slaveModel.getJoinType();
                        masterMetadata = master.getMetadata();
                        slaveMetadata = slave.getMetadata();
                        switch (joinType) {
                            case 3: {
                                master = new CrossJoinRecordCursorFactory(this.createJoinMetadata(masterAlias, masterMetadata, slaveModel.getName(), slaveMetadata), master, slave, masterMetadata.getColumnCount());
                                masterAlias = null;
                                ** break;
lbl34:
                                // 1 sources

                                break;
                            }
                            case 4: {
                                this.validateBothTimestamps(slaveModel, masterMetadata, slaveMetadata);
                                this.processJoinContext(index == 1, slaveModel.getContext(), masterMetadata, slaveMetadata);
                                master = slave.recordCursorSupportsRandomAccess() && !this.fullFatJoins ? (this.listColumnFilterA.size() > 0 && this.listColumnFilterB.size() > 0 ? this.createAsOfJoin(this.createJoinMetadata(masterAlias, masterMetadata, slaveModel.getName(), slaveMetadata), master, RecordSinkFactory.getInstance(this.asm, masterMetadata, this.listColumnFilterB, true), slave, RecordSinkFactory.getInstance(this.asm, slaveMetadata, this.listColumnFilterA, true), masterMetadata.getColumnCount()) : new AsOfJoinNoKeyRecordCursorFactory(this.createJoinMetadata(masterAlias, masterMetadata, slaveModel.getName(), slaveMetadata), master, slave, masterMetadata.getColumnCount())) : this.createFullFatJoin(master, masterMetadata, masterAlias, slave, slaveMetadata, slaveModel.getName(), slaveModel.getJoinKeywordPosition(), SqlCodeGenerator.CREATE_FULL_FAT_AS_OF_JOIN);
                                masterAlias = null;
                                releaseSlave = false;
                                this.validateBothTimestampOrders(master, slave, slaveModel.getJoinKeywordPosition());
                                ** break;
lbl43:
                                // 1 sources

                                break;
                            }
                            case 6: {
                                this.validateBothTimestamps(slaveModel, masterMetadata, slaveMetadata);
                                this.processJoinContext(index == 1, slaveModel.getContext(), masterMetadata, slaveMetadata);
                                master = slave.recordCursorSupportsRandomAccess() && !this.fullFatJoins ? (this.listColumnFilterA.size() > 0 && this.listColumnFilterB.size() > 0 ? this.createLtJoin(this.createJoinMetadata(masterAlias, masterMetadata, slaveModel.getName(), slaveMetadata), master, RecordSinkFactory.getInstance(this.asm, masterMetadata, this.listColumnFilterB, true), slave, RecordSinkFactory.getInstance(this.asm, slaveMetadata, this.listColumnFilterA, true), masterMetadata.getColumnCount()) : new LtJoinNoKeyRecordCursorFactory(this.createJoinMetadata(masterAlias, masterMetadata, slaveModel.getName(), slaveMetadata), master, slave, masterMetadata.getColumnCount())) : this.createFullFatJoin(master, masterMetadata, masterAlias, slave, slaveMetadata, slaveModel.getName(), slaveModel.getJoinKeywordPosition(), SqlCodeGenerator.CREATE_FULL_FAT_LT_JOIN);
                                masterAlias = null;
                                releaseSlave = false;
                                this.validateBothTimestampOrders(master, slave, slaveModel.getJoinKeywordPosition());
                                ** break;
lbl52:
                                // 1 sources

                                break;
                            }
                            case 5: {
                                this.validateBothTimestamps(slaveModel, masterMetadata, slaveMetadata);
                                this.processJoinContext(index == 1, slaveModel.getContext(), masterMetadata, slaveMetadata);
                                if (slave.recordCursorSupportsRandomAccess() && master.recordCursorSupportsRandomAccess() && !this.fullFatJoins) {
                                    master = this.createSpliceJoin(this.createJoinMetadata(masterAlias, masterMetadata, slaveModel.getName(), slaveMetadata, -1), master, RecordSinkFactory.getInstance(this.asm, masterMetadata, this.listColumnFilterB, true), slave, RecordSinkFactory.getInstance(this.asm, slaveMetadata, this.listColumnFilterA, true), masterMetadata.getColumnCount());
                                    releaseSlave = false;
                                    this.validateBothTimestampOrders(master, slave, slaveModel.getJoinKeywordPosition());
                                    ** break;
lbl61:
                                    // 1 sources

                                } else if (!SqlCodeGenerator.$assertionsDisabled) {
                                    throw new AssertionError();
                                }
                                break;
                            }
                            default: {
                                this.processJoinContext(index == 1, slaveModel.getContext(), masterMetadata, slaveMetadata);
                                master = this.createHashJoin(this.createJoinMetadata(masterAlias, masterMetadata, slaveModel.getName(), slaveMetadata), master, slave, joinType);
                                masterAlias = null;
                                break;
                            }
                        }
                    }
                    catch (Throwable th) {
                        master = Misc.free(master);
                        if (releaseSlave) {
                            Misc.free(slave);
                        }
                        throw th;
                    }
                    finally {
                        executionContext.popTimestampRequiredFlag();
                    }
                }
                filterExpr = slaveModel.getPostJoinWhereClause();
                if (filterExpr == null) continue;
                if (this.configuration.isSqlParallelFilterEnabled() && master.supportPageFrameCursor()) {
                    filter = this.compileBooleanFilter(filterExpr, master.getMetadata(), executionContext);
                    master = new AsyncFilteredRecordCursorFactory(this.configuration, executionContext.getMessageBus(), master, filter, this.reduceTaskPool, this.compileWorkerFilterConditionally(filter.isReadThreadSafe() == false, executionContext.getSharedWorkerCount(), filterExpr, master.getMetadata(), executionContext), null, 0, false);
                    continue;
                }
                master = new FilteredRecordCursorFactory(master, this.functionParser.parseFunction(filterExpr, master.getMetadata(), executionContext));
            }
            constFilter = model.getConstWhereClause();
            if (constFilter != null && !(function = this.functionParser.parseFunction(constFilter, null, executionContext)).getBool(null)) {
                metadata = (JoinRecordMetadata)master.getMetadata();
                metadata.incrementRefCount();
                factory = new EmptyTableRecordCursorFactory(metadata);
                Misc.free(master);
                return factory;
            }
            return master;
        }
        catch (Throwable e) {
            Misc.free(master);
            throw e;
        }
    }

    @NotNull
    private RecordCursorFactory generateLatestBy(RecordCursorFactory factory, QueryModel model) throws SqlException {
        String timestampColumn;
        int timestampIndex;
        ObjList<ExpressionNode> latestBy = model.getLatestBy();
        if (latestBy.size() == 0) {
            return factory;
        }
        try {
            timestampIndex = this.getTimestampIndex(model, factory);
            if (timestampIndex == -1) {
                throw SqlException.$(model.getModelPosition(), "latest by query does not provide dedicated TIMESTAMP column");
            }
        }
        catch (Throwable e) {
            Misc.free(factory);
            throw e;
        }
        RecordMetadata metadata = factory.getMetadata();
        this.prepareLatestByColumnIndexes(latestBy, metadata);
        if (!factory.recordCursorSupportsRandomAccess()) {
            return new LatestByRecordCursorFactory(this.configuration, factory, RecordSinkFactory.getInstance(this.asm, metadata, this.listColumnFilterA, false), this.keyTypes, timestampIndex);
        }
        boolean orderedByTimestampAsc = false;
        QueryModel nested = model.getNestedModel();
        assert (nested != null);
        LowerCaseCharSequenceIntHashMap orderBy = nested.getOrderHash();
        if (orderBy.get(timestampColumn = metadata.getColumnName(timestampIndex)) == 0) {
            orderedByTimestampAsc = true;
        } else if (timestampIndex == metadata.getTimestampIndex() && orderBy.size() == 0) {
            orderedByTimestampAsc = true;
        }
        return new LatestByLightRecordCursorFactory(this.configuration, factory, RecordSinkFactory.getInstance(this.asm, metadata, this.listColumnFilterA, false), this.keyTypes, timestampIndex, orderedByTimestampAsc);
    }

    @NotNull
    private RecordCursorFactory generateLatestByTableQuery(QueryModel model, TableReader reader, RecordMetadata metadata, String tableName, IntrinsicModel intrinsicModel, Function filter, SqlExecutionContext executionContext, int timestampIndex, @NotNull IntList columnIndexes, @NotNull IntList columnSizes, @NotNull LongList prefixes) throws SqlException {
        AbstractDataFrameCursorFactory dataFrameCursorFactory = intrinsicModel.hasIntervalFilters() ? new IntervalBwdDataFrameCursorFactory(tableName, model.getTableId(), model.getTableVersion(), intrinsicModel.buildIntervalModel(), timestampIndex) : new FullBwdDataFrameCursorFactory(tableName, model.getTableId(), model.getTableVersion());
        assert (model.getLatestBy() != null && model.getLatestBy().size() > 0);
        ObjList<ExpressionNode> latestBy = new ObjList<ExpressionNode>(model.getLatestBy().size());
        latestBy.addAll(model.getLatestBy());
        ExpressionNode latestByNode = (ExpressionNode)latestBy.get(0);
        int latestByIndex = metadata.getColumnIndexQuiet(latestByNode.token);
        boolean indexed = metadata.isColumnIndexed(latestByIndex);
        model.setWhereClause(null);
        model.getLatestBy().clear();
        if (latestBy.size() > 1 || !ColumnType.isSymbol(metadata.getColumnType(latestByIndex))) {
            return new LatestByAllFilteredRecordCursorFactory(metadata, this.configuration, dataFrameCursorFactory, RecordSinkFactory.getInstance(this.asm, metadata, this.listColumnFilterA, false), this.keyTypes, filter, columnIndexes);
        }
        if (intrinsicModel.keyColumn != null) {
            int symbolKey;
            assert (latestByIndex == metadata.getColumnIndexQuiet(intrinsicModel.keyColumn));
            if (intrinsicModel.keySubQuery != null) {
                Record.CharSequenceFunction func;
                RecordCursorFactory rcf;
                try {
                    rcf = this.generate(intrinsicModel.keySubQuery, executionContext);
                    func = this.validateSubQueryColumnAndGetGetter(intrinsicModel, rcf.getMetadata());
                }
                catch (Throwable e) {
                    Misc.free(dataFrameCursorFactory);
                    throw e;
                }
                return new LatestBySubQueryRecordCursorFactory(this.configuration, metadata, dataFrameCursorFactory, latestByIndex, rcf, filter, indexed, func, columnIndexes);
            }
            int nKeyValues = intrinsicModel.keyValueFuncs.size();
            if (indexed) {
                assert (nKeyValues > 0);
                SymbolMapReader symbolMapReader = reader.getSymbolMapReader(columnIndexes.getQuick(latestByIndex));
                if (nKeyValues == 1) {
                    int symbol;
                    Function symbolValueFunc = intrinsicModel.keyValueFuncs.get(0);
                    int n = symbol = symbolValueFunc.isRuntimeConstant() ? -2 : symbolMapReader.keyOf(symbolValueFunc.getStr(null));
                    if (filter == null) {
                        RowCursorFactory rcf = symbol == -2 ? new LatestByValueDeferredIndexedRowCursorFactory(columnIndexes.getQuick(latestByIndex), symbolValueFunc, false) : new LatestByValueIndexedRowCursorFactory(columnIndexes.getQuick(latestByIndex), symbol, false);
                        return new DataFrameRecordCursorFactory(this.configuration, metadata, dataFrameCursorFactory, rcf, false, null, false, columnIndexes, columnSizes, true);
                    }
                    if (symbol == -2) {
                        return new LatestByValueDeferredIndexedFilteredRecordCursorFactory(metadata, dataFrameCursorFactory, latestByIndex, symbolValueFunc, filter, columnIndexes);
                    }
                    return new LatestByValueIndexedFilteredRecordCursorFactory(metadata, dataFrameCursorFactory, latestByIndex, symbol, filter, columnIndexes);
                }
                return new LatestByValuesIndexedFilteredRecordCursorFactory(this.configuration, metadata, dataFrameCursorFactory, latestByIndex, intrinsicModel.keyValueFuncs, symbolMapReader, filter, columnIndexes);
            }
            assert (nKeyValues > 0);
            SymbolMapReader symbolMapReader = reader.getSymbolMapReader(columnIndexes.getQuick(latestByIndex));
            if (nKeyValues > 1) {
                return new LatestByDeferredListValuesFilteredRecordCursorFactory(this.configuration, metadata, dataFrameCursorFactory, latestByIndex, intrinsicModel.keyValueFuncs, filter, columnIndexes);
            }
            Function symbolKeyFunc = intrinsicModel.keyValueFuncs.get(0);
            int n = symbolKey = symbolKeyFunc.isRuntimeConstant() ? -2 : symbolMapReader.keyOf(symbolKeyFunc.getStr(null));
            if (symbolKey == -2) {
                return new LatestByValueDeferredFilteredRecordCursorFactory(metadata, dataFrameCursorFactory, latestByIndex, symbolKeyFunc, filter, columnIndexes);
            }
            return new LatestByValueFilteredRecordCursorFactory(metadata, dataFrameCursorFactory, latestByIndex, symbolKey, filter, columnIndexes);
        }
        assert (intrinsicModel.keyValueFuncs.size() == 0);
        if (indexed && filter == null) {
            return new LatestByAllIndexedRecordCursorFactory(metadata, this.configuration, dataFrameCursorFactory, latestByIndex, columnIndexes, prefixes);
        }
        return new LatestByDeferredListValuesFilteredRecordCursorFactory(this.configuration, metadata, dataFrameCursorFactory, latestByIndex, filter, columnIndexes);
    }

    private RecordCursorFactory generateLimit(RecordCursorFactory factory, QueryModel model, SqlExecutionContext executionContext) throws SqlException {
        if (factory.followedLimitAdvice()) {
            return factory;
        }
        ExpressionNode limitLo = model.getLimitLo();
        ExpressionNode limitHi = model.getLimitHi();
        if (limitLo == null && limitHi == null || factory.implementsLimit() && model.isLimitImplemented()) {
            return factory;
        }
        try {
            Function loFunc = this.getLoFunction(model, executionContext);
            Function hiFunc = this.getHiFunction(model, executionContext);
            return new LimitRecordCursorFactory(factory, loFunc, hiFunc);
        }
        catch (Throwable e) {
            Misc.free(factory);
            throw e;
        }
    }

    private RecordCursorFactory generateNoSelect(QueryModel model, SqlExecutionContext executionContext) throws SqlException {
        ExpressionNode tableName = model.getTableName();
        if (tableName != null) {
            if (tableName.type == 8) {
                return this.generateFunctionQuery(model, executionContext);
            }
            return this.generateTableQuery(model, executionContext);
        }
        return this.generateSubQuery(model, executionContext);
    }

    private RecordCursorFactory generateOrderBy(RecordCursorFactory recordCursorFactory, QueryModel model, SqlExecutionContext executionContext) throws SqlException {
        if (recordCursorFactory.followedOrderByAdvice()) {
            return recordCursorFactory;
        }
        try {
            LowerCaseCharSequenceIntHashMap orderBy = model.getOrderHash();
            ObjList columnNames = orderBy.keys();
            int orderByColumnCount = columnNames.size();
            if (orderByColumnCount > 0) {
                int index;
                CharSequence column;
                RecordMetadata metadata = recordCursorFactory.getMetadata();
                int timestampIndex = metadata.getTimestampIndex();
                this.listColumnFilterA.clear();
                this.intHashSet.clear();
                for (int i = 0; i < orderByColumnCount; ++i) {
                    column = (CharSequence)columnNames.getQuick(i);
                    index = metadata.getColumnIndexQuiet(column);
                    if (ColumnType.isBinary(metadata.getColumnType(index))) {
                        ObjList<ExpressionNode> nodes = model.getOrderBy();
                        int position = 0;
                        int y = nodes.size();
                        for (int j = 0; j < y; ++j) {
                            if (!Chars.equals(column, nodes.getQuick((int)i).token)) continue;
                            position = nodes.getQuick((int)i).position;
                            break;
                        }
                        throw SqlException.$(position, "unsupported column type: ").put(ColumnType.nameOf(metadata.getColumnType(index)));
                    }
                    if (!this.intHashSet.add(index)) continue;
                    if (orderBy.get(column) == 1) {
                        this.listColumnFilterA.add(-index - 1);
                        continue;
                    }
                    this.listColumnFilterA.add(index + 1);
                }
                if (timestampIndex != -1 && (index = metadata.getColumnIndexQuiet(column = (CharSequence)columnNames.getQuick(0))) == timestampIndex && orderByColumnCount == 1) {
                    if (orderBy.get(column) == 0) {
                        return recordCursorFactory;
                    }
                    if (orderBy.get(column) == 1 && recordCursorFactory.hasDescendingOrder()) {
                        return recordCursorFactory;
                    }
                }
                GenericRecordMetadata orderedMetadata = GenericRecordMetadata.copyOfSansTimestamp(metadata);
                Function loFunc = this.getLoFunction(model, executionContext);
                Function hiFunc = this.getHiFunction(model, executionContext);
                if (recordCursorFactory.recordCursorSupportsRandomAccess()) {
                    if (this.canBeOptimized(model, executionContext, loFunc, hiFunc)) {
                        model.setLimitImplemented(true);
                        return new LimitedSizeSortedLightRecordCursorFactory(this.configuration, orderedMetadata, recordCursorFactory, this.recordComparatorCompiler.compile(metadata, this.listColumnFilterA), loFunc, hiFunc);
                    }
                    return new SortedLightRecordCursorFactory(this.configuration, orderedMetadata, recordCursorFactory, this.recordComparatorCompiler.compile(metadata, this.listColumnFilterA));
                }
                this.entityColumnFilter.of(orderedMetadata.getColumnCount());
                return new SortedRecordCursorFactory(this.configuration, orderedMetadata, recordCursorFactory, RecordSinkFactory.getInstance(this.asm, orderedMetadata, this.entityColumnFilter, false), this.recordComparatorCompiler.compile(metadata, this.listColumnFilterA));
            }
            return recordCursorFactory;
        }
        catch (CairoException | SqlException e) {
            recordCursorFactory.close();
            throw e;
        }
    }

    private RecordCursorFactory generateQuery(QueryModel model, SqlExecutionContext executionContext, boolean processJoins) throws SqlException {
        RecordCursorFactory factory = this.generateQuery0(model, executionContext, processJoins);
        if (model.getUnionModel() != null) {
            return this.generateSetFactory(model, factory, executionContext);
        }
        return factory;
    }

    private RecordCursorFactory generateQuery0(QueryModel model, SqlExecutionContext executionContext, boolean processJoins) throws SqlException {
        return this.generateLimit(this.generateOrderBy(this.generateLatestBy(this.generateFilter(this.generateSelect(model, executionContext, processJoins), model, executionContext), model), model, executionContext), model, executionContext);
    }

    @NotNull
    private RecordCursorFactory generateSampleBy(QueryModel model, SqlExecutionContext executionContext, ExpressionNode sampleByNode, ExpressionNode sampleByUnits) throws SqlException {
        executionContext.pushTimestampRequiredFlag(true);
        try {
            AbstractSampleByRecordCursorFactory abstractSampleByRecordCursorFactory;
            SingleSymbolFilter symbolFilter;
            boolean allGroupsFirstLast;
            ObjList<GroupByFunction> groupByFunctions;
            int columnCount;
            TimestampSampler timestampSampler;
            int timestampIndex;
            int offsetFuncPos;
            Function offsetFunc;
            int timezoneNameFuncPos;
            Function timezoneNameFunc;
            ExpressionNode timezoneName = model.getSampleByTimezoneName();
            ExpressionNode offset = model.getSampleByOffset();
            if (timezoneName != null) {
                timezoneNameFunc = this.functionParser.parseFunction(timezoneName, EmptyRecordMetadata.INSTANCE, executionContext);
                timezoneNameFuncPos = timezoneName.position;
            } else {
                timezoneNameFunc = StrConstant.NULL;
                timezoneNameFuncPos = 0;
            }
            if (ColumnType.isUndefined(timezoneNameFunc.getType())) {
                timezoneNameFunc.assignType(11, executionContext.getBindVariableService());
            } else if (!timezoneNameFunc.isConstant() && !timezoneNameFunc.isRuntimeConstant() || !ColumnType.isAssignableFrom(timezoneNameFunc.getType(), 11)) {
                throw SqlException.$(timezoneNameFuncPos, "timezone must be a constant expression of STRING or CHAR type");
            }
            if (offset != null) {
                offsetFunc = this.functionParser.parseFunction(offset, EmptyRecordMetadata.INSTANCE, executionContext);
                offsetFuncPos = offset.position;
            } else {
                offsetFunc = StrConstant.NULL;
                offsetFuncPos = 0;
            }
            if (ColumnType.isUndefined(offsetFunc.getType())) {
                offsetFunc.assignType(11, executionContext.getBindVariableService());
            } else if (!offsetFunc.isConstant() && !offsetFunc.isRuntimeConstant() || !ColumnType.isAssignableFrom(offsetFunc.getType(), 11)) {
                throw SqlException.$(offsetFuncPos, "offset must be a constant expression of STRING or CHAR type");
            }
            RecordCursorFactory factory = this.generateSubQuery(model, executionContext);
            try {
                timestampIndex = this.getTimestampIndex(model, factory);
                if (timestampIndex == -1 || factory.hasDescendingOrder()) {
                    throw SqlException.$(model.getModelPosition(), "base query does not provide ASC order over dedicated TIMESTAMP column");
                }
            }
            catch (Throwable e) {
                Misc.free(factory);
                throw e;
            }
            RecordMetadata metadata = factory.getMetadata();
            ObjList<ExpressionNode> sampleByFill = model.getSampleByFill();
            int fillCount = sampleByFill.size();
            try {
                if (sampleByUnits == null) {
                    timestampSampler = TimestampSamplerFactory.getInstance(sampleByNode.token, sampleByNode.position);
                } else {
                    Function sampleByPeriod = this.functionParser.parseFunction(sampleByNode, EmptyRecordMetadata.INSTANCE, executionContext);
                    if (!sampleByPeriod.isConstant() || sampleByPeriod.getType() != 6 && sampleByPeriod.getType() != 5) {
                        Misc.free(sampleByPeriod);
                        throw SqlException.$(sampleByNode.position, "sample by period must be a constant expression of INT or LONG type");
                    }
                    long period = sampleByPeriod.getLong(null);
                    sampleByPeriod.close();
                    timestampSampler = TimestampSamplerFactory.getInstance(period, sampleByUnits.token, sampleByUnits.position);
                }
                this.keyTypes.clear();
                this.valueTypes.clear();
                this.listColumnFilterA.clear();
                if (fillCount == 1 && Chars.equalsLowerCaseAscii(sampleByFill.getQuick((int)0).token, "linear")) {
                    int columnCount2 = metadata.getColumnCount();
                    ObjList<GroupByFunction> groupByFunctions2 = new ObjList<GroupByFunction>(columnCount2);
                    ObjList<Function> recordFunctions = new ObjList<Function>(columnCount2);
                    this.valueTypes.add(2);
                    GroupByUtils.prepareGroupByFunctions(model, metadata, this.functionParser, executionContext, groupByFunctions2, this.groupByFunctionPositions, this.valueTypes);
                    GenericRecordMetadata groupByMetadata = new GenericRecordMetadata();
                    GroupByUtils.prepareGroupByRecordFunctions(model, metadata, this.listColumnFilterA, groupByFunctions2, this.groupByFunctionPositions, recordFunctions, this.recordFunctionPositions, groupByMetadata, this.keyTypes, this.valueTypes.getColumnCount(), false, timestampIndex);
                    SampleByInterpolateRecordCursorFactory sampleByInterpolateRecordCursorFactory = new SampleByInterpolateRecordCursorFactory(this.configuration, factory, groupByMetadata, groupByFunctions2, recordFunctions, timestampSampler, model, this.listColumnFilterA, this.asm, this.keyTypes, this.valueTypes, this.entityColumnFilter, this.groupByFunctionPositions, timestampIndex);
                    return sampleByInterpolateRecordCursorFactory;
                }
                columnCount = model.getColumns().size();
                groupByFunctions = new ObjList<GroupByFunction>(columnCount);
                this.valueTypes.add(8);
            }
            catch (Throwable e) {
                Misc.free(factory);
                throw e;
            }
            GroupByUtils.prepareGroupByFunctions(model, metadata, this.functionParser, executionContext, groupByFunctions, this.groupByFunctionPositions, this.valueTypes);
            ObjList<Function> recordFunctions = new ObjList<Function>(columnCount);
            GenericRecordMetadata groupByMetadata = new GenericRecordMetadata();
            GroupByUtils.prepareGroupByRecordFunctions(model, metadata, this.listColumnFilterA, groupByFunctions, this.groupByFunctionPositions, recordFunctions, this.recordFunctionPositions, groupByMetadata, this.keyTypes, this.valueTypes.getColumnCount(), false, timestampIndex);
            boolean isFillNone = fillCount == 0 || fillCount == 1 && Chars.equalsLowerCaseAscii(sampleByFill.getQuick((int)0).token, "none");
            boolean bl = allGroupsFirstLast = isFillNone && SqlCodeGenerator.allGroupsFirstLastWithSingleSymbolFilter(model, metadata);
            if (allGroupsFirstLast && (symbolFilter = factory.convertToSampleByIndexDataFrameCursorFactory()) != null) {
                SampleByFirstLastRecordCursorFactory sampleByFirstLastRecordCursorFactory = new SampleByFirstLastRecordCursorFactory(factory, timestampSampler, groupByMetadata, model.getColumns(), metadata, timezoneNameFunc, timezoneNameFuncPos, offsetFunc, offsetFuncPos, timestampIndex, symbolFilter, this.configuration.getSampleByIndexSearchPageSize());
                return sampleByFirstLastRecordCursorFactory;
            }
            if (fillCount == 1 && Chars.equalsLowerCaseAscii(sampleByFill.getQuick((int)0).token, "prev")) {
                if (this.keyTypes.getColumnCount() == 0) {
                    abstractSampleByRecordCursorFactory = new SampleByFillPrevNotKeyedRecordCursorFactory(factory, timestampSampler, groupByMetadata, groupByFunctions, recordFunctions, timestampIndex, this.valueTypes.getColumnCount(), timezoneNameFunc, timezoneNameFuncPos, offsetFunc, offsetFuncPos);
                    return abstractSampleByRecordCursorFactory;
                }
                abstractSampleByRecordCursorFactory = new SampleByFillPrevRecordCursorFactory(this.configuration, factory, timestampSampler, this.listColumnFilterA, this.asm, this.keyTypes, this.valueTypes, groupByMetadata, groupByFunctions, recordFunctions, timestampIndex, timezoneNameFunc, timezoneNameFuncPos, offsetFunc, offsetFuncPos);
                return abstractSampleByRecordCursorFactory;
            }
            if (isFillNone) {
                if (this.keyTypes.getColumnCount() == 0) {
                    abstractSampleByRecordCursorFactory = new SampleByFillNoneNotKeyedRecordCursorFactory(factory, timestampSampler, groupByMetadata, groupByFunctions, recordFunctions, this.valueTypes.getColumnCount(), timestampIndex, timezoneNameFunc, timezoneNameFuncPos, offsetFunc, offsetFuncPos);
                    return abstractSampleByRecordCursorFactory;
                }
                abstractSampleByRecordCursorFactory = new SampleByFillNoneRecordCursorFactory(this.configuration, factory, groupByMetadata, groupByFunctions, recordFunctions, timestampSampler, this.listColumnFilterA, this.asm, this.keyTypes, this.valueTypes, timestampIndex, timezoneNameFunc, timezoneNameFuncPos, offsetFunc, offsetFuncPos);
                return abstractSampleByRecordCursorFactory;
            }
            if (fillCount == 1 && SqlKeywords.isNullKeyword(sampleByFill.getQuick((int)0).token)) {
                if (this.keyTypes.getColumnCount() == 0) {
                    abstractSampleByRecordCursorFactory = new SampleByFillNullNotKeyedRecordCursorFactory(factory, timestampSampler, groupByMetadata, groupByFunctions, recordFunctions, this.recordFunctionPositions, this.valueTypes.getColumnCount(), timestampIndex, timezoneNameFunc, timezoneNameFuncPos, offsetFunc, offsetFuncPos);
                    return abstractSampleByRecordCursorFactory;
                }
                abstractSampleByRecordCursorFactory = new SampleByFillNullRecordCursorFactory(this.configuration, factory, timestampSampler, this.listColumnFilterA, this.asm, this.keyTypes, this.valueTypes, groupByMetadata, groupByFunctions, recordFunctions, this.recordFunctionPositions, timestampIndex, timezoneNameFunc, timezoneNameFuncPos, offsetFunc, offsetFuncPos);
                return abstractSampleByRecordCursorFactory;
            }
            assert (fillCount > 0);
            if (this.keyTypes.getColumnCount() == 0) {
                abstractSampleByRecordCursorFactory = new SampleByFillValueNotKeyedRecordCursorFactory(factory, timestampSampler, sampleByFill, groupByMetadata, groupByFunctions, recordFunctions, this.recordFunctionPositions, this.valueTypes.getColumnCount(), timestampIndex, timezoneNameFunc, timezoneNameFuncPos, offsetFunc, offsetFuncPos);
                return abstractSampleByRecordCursorFactory;
            }
            abstractSampleByRecordCursorFactory = new SampleByFillValueRecordCursorFactory(this.configuration, factory, timestampSampler, this.listColumnFilterA, this.asm, sampleByFill, this.keyTypes, this.valueTypes, groupByMetadata, groupByFunctions, recordFunctions, this.recordFunctionPositions, timestampIndex, timezoneNameFunc, timezoneNameFuncPos, offsetFunc, offsetFuncPos);
            return abstractSampleByRecordCursorFactory;
        }
        finally {
            executionContext.popTimestampRequiredFlag();
        }
    }

    private RecordCursorFactory generateSelect(QueryModel model, SqlExecutionContext executionContext, boolean processJoins) throws SqlException {
        switch (model.getSelectModelType()) {
            case 1: {
                return this.generateSelectChoose(model, executionContext);
            }
            case 4: {
                return this.generateSelectGroupBy(model, executionContext);
            }
            case 2: {
                return this.generateSelectVirtual(model, executionContext);
            }
            case 3: {
                return this.generateSelectAnalytic(model, executionContext);
            }
            case 5: {
                return this.generateSelectDistinct(model, executionContext);
            }
            case 6: {
                return this.generateSelectCursor(model, executionContext);
            }
        }
        if (model.getJoinModels().size() > 1 && processJoins) {
            return this.generateJoins(model, executionContext);
        }
        return this.generateNoSelect(model, executionContext);
    }

    private RecordCursorFactory generateSelectAnalytic(QueryModel model, SqlExecutionContext executionContext) throws SqlException {
        int i;
        Object m;
        RecordCursorFactory base = this.generateSubQuery(model, executionContext);
        RecordMetadata baseMetadata = base.getMetadata();
        ObjList<QueryColumn> columns = model.getColumns();
        int columnCount = columns.size();
        this.groupedAnalytic.clear();
        ObjList<AnalyticFunction> naturalOrderFunctions = null;
        this.valueTypes.clear();
        ArrayColumnTypes chainTypes = this.valueTypes;
        GenericRecordMetadata chainMetadata = new GenericRecordMetadata();
        GenericRecordMetadata factoryMetadata = new GenericRecordMetadata();
        this.listColumnFilterA.clear();
        this.listColumnFilterB.clear();
        this.intHashSet.clear();
        IntList columnIndexes = new IntList();
        for (int i2 = 0; i2 < columnCount; ++i2) {
            QueryColumn qc = columns.getQuick(i2);
            if (qc instanceof AnalyticColumn) continue;
            int columnIndex = baseMetadata.getColumnIndexQuiet(qc.getAst().token);
            m = BaseRecordMetadata.copyOf(baseMetadata, columnIndex);
            chainMetadata.add(i2, (TableColumnMetadata)m);
            factoryMetadata.add(i2, (TableColumnMetadata)m);
            chainTypes.add(i2, ((TableColumnMetadata)m).getType());
            this.listColumnFilterA.extendAndSet(i2, i2 + 1);
            this.listColumnFilterB.extendAndSet(i2, columnIndex);
            this.intHashSet.add(columnIndex);
            columnIndexes.extendAndSet(i2, columnIndex);
        }
        int addAt = columnCount;
        int n = baseMetadata.getColumnCount();
        for (i = 0; i < n; ++i) {
            if (!this.intHashSet.excludes(i)) continue;
            m = BaseRecordMetadata.copyOf(baseMetadata, i);
            chainMetadata.add(addAt, (TableColumnMetadata)m);
            chainTypes.add(addAt, ((TableColumnMetadata)m).getType());
            this.listColumnFilterA.extendAndSet(addAt, addAt + 1);
            this.listColumnFilterB.extendAndSet(addAt, i);
            columnIndexes.extendAndSet(addAt, i);
            ++addAt;
        }
        this.deferredAnalyticMetadata.clear();
        for (i = 0; i < columnCount; ++i) {
            boolean dismissOrder;
            RecordSink partitionBySink;
            VirtualRecord partitionByRecord;
            QueryColumn qc = columns.getQuick(i);
            if (!(qc instanceof AnalyticColumn)) continue;
            AnalyticColumn ac = (AnalyticColumn)qc;
            ExpressionNode expressionNode = qc.getAst();
            if (expressionNode.paramCount > 1) {
                Misc.free(base);
                throw SqlException.$(expressionNode.position, "too many arguments");
            }
            ObjList<Function> partitionBy = null;
            int psz = ac.getPartitionBy().size();
            if (psz > 0) {
                partitionBy = new ObjList<Function>(psz);
                for (int j = 0; j < psz; ++j) {
                    partitionBy.add(this.functionParser.parseFunction(ac.getPartitionBy().getQuick(j), chainMetadata, executionContext));
                }
            }
            if (partitionBy != null) {
                partitionByRecord = new VirtualRecord(partitionBy);
                this.keyTypes.clear();
                int partitionByCount = partitionBy.size();
                for (int j = 0; j < partitionByCount; ++j) {
                    this.keyTypes.add(((Function)partitionBy.getQuick(j)).getType());
                }
                this.entityColumnFilter.of(partitionByCount);
                partitionBySink = RecordSinkFactory.getInstance(this.asm, this.keyTypes, this.entityColumnFilter, false);
            } else {
                partitionByRecord = null;
                partitionBySink = null;
            }
            int osz = ac.getOrderBy().size();
            executionContext.configureAnalyticContext(partitionByRecord, partitionBySink, this.keyTypes, osz > 0, base.recordCursorSupportsRandomAccess());
            Function f = this.functionParser.parseFunction(expressionNode, baseMetadata, executionContext);
            if (!(f instanceof AnalyticFunction)) {
                Misc.free(base);
                throw SqlException.$(expressionNode.position, "non-analytic function called in analytic context");
            }
            AnalyticFunction analyticFunction = (AnalyticFunction)f;
            LowerCaseCharSequenceIntHashMap orderHash = model.getOrderHash();
            if (osz > 0 && orderHash.size() > 0) {
                dismissOrder = true;
                for (int j = 0; j < osz; ++j) {
                    ExpressionNode node = ac.getOrderBy().getQuick(j);
                    int direction = ac.getOrderByDirection().getQuick(j);
                    if (orderHash.get(node.token) == direction) continue;
                    dismissOrder = false;
                    break;
                }
            } else {
                dismissOrder = false;
            }
            if (osz > 0 && !dismissOrder) {
                IntList order = this.toOrderIndices(chainMetadata, ac.getOrderBy(), ac.getOrderByDirection());
                ObjList<AnalyticFunction> funcs = this.groupedAnalytic.get(order);
                if (funcs == null) {
                    funcs = new ObjList();
                    this.groupedAnalytic.put(order, funcs);
                }
                funcs.add(analyticFunction);
            } else {
                if (naturalOrderFunctions == null) {
                    naturalOrderFunctions = new ObjList<AnalyticFunction>();
                }
                naturalOrderFunctions.add(analyticFunction);
            }
            analyticFunction.setColumnIndex(i);
            this.deferredAnalyticMetadata.extendAndSet(i, new TableColumnMetadata(Chars.toString(qc.getAlias()), 0L, analyticFunction.getType(), false, 0, false, null));
            this.listColumnFilterA.extendAndSet(i, -i - 1);
        }
        n = this.deferredAnalyticMetadata.size();
        for (i = 0; i < n; ++i) {
            m = this.deferredAnalyticMetadata.getQuick(i);
            if (m == null) continue;
            chainTypes.add(i, ((TableColumnMetadata)m).getType());
            factoryMetadata.add(i, (TableColumnMetadata)m);
        }
        ObjList<RecordComparator> analyticComparators = new ObjList<RecordComparator>(this.groupedAnalytic.size());
        ObjList<ObjList<AnalyticFunction>> functionGroups = new ObjList<ObjList<AnalyticFunction>>(this.groupedAnalytic.size());
        for (ObjObjHashMap.Entry entry : this.groupedAnalytic) {
            analyticComparators.add(this.recordComparatorCompiler.compile(chainTypes, (IntList)entry.key));
            functionGroups.add((ObjList<AnalyticFunction>)entry.value);
        }
        RecordSink recordSink = RecordSinkFactory.getInstance(this.asm, chainTypes, this.listColumnFilterA, false, this.listColumnFilterB);
        return new CachedAnalyticRecordCursorFactory(this.configuration, base, recordSink, factoryMetadata, chainTypes, analyticComparators, functionGroups, naturalOrderFunctions, columnIndexes);
    }

    private RecordCursorFactory generateSelectChoose(QueryModel model, SqlExecutionContext executionContext) throws SqlException {
        int timestampIndex;
        boolean entity;
        int index;
        RecordCursorFactory factory = this.generateSubQuery(model, executionContext);
        RecordMetadata metadata = factory.getMetadata();
        ObjList<QueryColumn> columns = model.getColumns();
        int selectColumnCount = columns.size();
        ExpressionNode timestamp = model.getTimestamp();
        if (model.isUpdate()) {
            boolean columnTypeMismatch = false;
            ObjList<CharSequence> updateColumnNames = model.getUpdateTableColumnNames();
            IntList updateColumnTypes = model.getUpdateTableColumnTypes();
            int n = columns.size();
            for (int i = 0; i < n; ++i) {
                QueryColumn queryColumn = columns.getQuick(i);
                CharSequence columnName = queryColumn.getAlias();
                index = metadata.getColumnIndexQuiet(queryColumn.getAst().token);
                assert (index > -1) : "wtf? " + queryColumn.getAst().token;
                int updateColumnIndex = updateColumnNames.indexOf(columnName);
                int updateColumnType = updateColumnTypes.get(updateColumnIndex);
                if (updateColumnType == metadata.getColumnType(index)) continue;
                columnTypeMismatch = true;
                break;
            }
            if (columnTypeMismatch) {
                return this.generateSelectVirtualWithSubquery(model, executionContext, factory);
            }
        }
        if (timestamp == null && metadata.getColumnCount() == selectColumnCount) {
            entity = true;
            for (int i = 0; i < selectColumnCount; ++i) {
                QueryColumn qc = columns.getQuick(i);
                if (Chars.equals((CharSequence)metadata.getColumnName(i), qc.getAst().token) && (qc.getAlias() == null || Chars.equals(qc.getAlias(), qc.getAst().token))) continue;
                entity = false;
                break;
            }
        } else {
            entity = false;
        }
        if (entity) {
            return factory;
        }
        try {
            timestampIndex = this.getTimestampIndex(model, factory);
            if (executionContext.isTimestampRequired() && (timestampIndex == -1 || factory.hasDescendingOrder())) {
                throw SqlException.$(model.getModelPosition(), "ASC order over TIMESTAMP column is required but not provided");
            }
        }
        catch (Throwable e) {
            Misc.free(factory);
            throw e;
        }
        IntList columnCrossIndex = new IntList(selectColumnCount);
        GenericRecordMetadata selectMetadata = new GenericRecordMetadata();
        boolean timestampSet = false;
        for (int i = 0; i < selectColumnCount; ++i) {
            QueryColumn queryColumn = columns.getQuick(i);
            index = metadata.getColumnIndexQuiet(queryColumn.getAst().token);
            assert (index > -1) : "wtf? " + queryColumn.getAst().token;
            columnCrossIndex.add(index);
            if (queryColumn.getAlias() == null) {
                selectMetadata.add(BaseRecordMetadata.copyOf(metadata, index));
            } else {
                selectMetadata.add(new TableColumnMetadata(Chars.toString(queryColumn.getAlias()), metadata.getColumnHash(index), metadata.getColumnType(index), metadata.isColumnIndexed(index), metadata.getIndexValueBlockCapacity(index), metadata.isSymbolTableStatic(index), metadata.getMetadata(index)));
            }
            if (index != timestampIndex) continue;
            selectMetadata.setTimestampIndex(i);
            timestampSet = true;
        }
        if (!timestampSet && executionContext.isTimestampRequired()) {
            selectMetadata.add(BaseRecordMetadata.copyOf(metadata, timestampIndex));
            selectMetadata.setTimestampIndex(selectMetadata.getColumnCount() - 1);
            columnCrossIndex.add(timestampIndex);
        }
        return new SelectedRecordCursorFactory(selectMetadata, columnCrossIndex, factory);
    }

    private RecordCursorFactory generateSelectCursor(QueryModel model, SqlExecutionContext executionContext) throws SqlException {
        return new RecordAsAFieldRecordCursorFactory(this.generate(model.getNestedModel(), executionContext), model.getColumns().getQuick(0).getAlias());
    }

    private RecordCursorFactory generateSelectDistinct(QueryModel model, SqlExecutionContext executionContext) throws SqlException {
        ExpressionNode tableNameEn;
        QueryModel twoDeepNested;
        if (model.getColumns().size() == 1 && model.getNestedModel() != null && model.getNestedModel().getSelectModelType() == 1 && (twoDeepNested = model.getNestedModel().getNestedModel()) != null && twoDeepNested.getLatestBy().size() == 0 && (tableNameEn = twoDeepNested.getTableName()) != null && twoDeepNested.getWhereClause() == null) {
            CharSequence tableName = tableNameEn.token;
            try (TableReader reader = this.engine.getReader(executionContext.getCairoSecurityContext(), tableName);){
                CharSequence columnName = model.getBottomUpColumnNames().get(0);
                TableReaderMetadata readerMetadata = reader.getMetadata();
                int columnIndex = readerMetadata.getColumnIndex(columnName);
                int columnType = readerMetadata.getColumnType(columnIndex);
                GenericRecordMetadata distinctColumnMetadata = new GenericRecordMetadata();
                distinctColumnMetadata.add(BaseRecordMetadata.copyOf(readerMetadata, columnIndex));
                if (ColumnType.isSymbol(columnType) || columnType == 5) {
                    RecordCursorFactory factory = this.generateSubQuery(model.getNestedModel(), executionContext);
                    if (factory.supportPageFrameCursor()) {
                        DistinctKeyRecordCursorFactory distinctKeyRecordCursorFactory = new DistinctKeyRecordCursorFactory(this.engine.getConfiguration(), factory, distinctColumnMetadata, this.arrayColumnTypes, this.tempVaf, executionContext.getSharedWorkerCount(), this.tempSymbolSkewIndexes);
                        return distinctKeyRecordCursorFactory;
                    }
                    Misc.free(factory);
                    throw CairoException.critical(0).put("Optimization error, incorrect path chosen, please contact support.");
                }
            }
        }
        RecordCursorFactory factory = this.generateSubQuery(model, executionContext);
        try {
            if (factory.recordCursorSupportsRandomAccess() && factory.getMetadata().getTimestampIndex() != -1) {
                return new DistinctTimeSeriesRecordCursorFactory(this.configuration, factory, this.entityColumnFilter, this.asm);
            }
            return new DistinctRecordCursorFactory(this.configuration, factory, this.entityColumnFilter, this.asm);
        }
        catch (Throwable e) {
            factory.close();
            throw e;
        }
    }

    private RecordCursorFactory generateSelectGroupBy(QueryModel model, SqlExecutionContext executionContext) throws SqlException {
        ExpressionNode sampleByNode = model.getSampleBy();
        if (sampleByNode != null) {
            return this.generateSampleBy(model, executionContext, sampleByNode, model.getSampleByUnit());
        }
        RecordCursorFactory factory = null;
        try {
            ExpressionNode columnExpr;
            ObjList<QueryColumn> columns = model.getColumns();
            if (columns.size() == 1) {
                CharSequence columnName = columns.getQuick(0).getName();
                columnExpr = columns.getQuick(0).getAst();
                if (columnExpr.type == 8 && columnExpr.paramCount == 0 && SqlKeywords.isCountKeyword(columnExpr.token)) {
                    GenericRecordMetadata metadata = SqlKeywords.isCountKeyword(columnName) ? CountRecordCursorFactory.DEFAULT_COUNT_METADATA : new GenericRecordMetadata().add(new TableColumnMetadata(Chars.toString(columnName), 0L, 6));
                    return new CountRecordCursorFactory(metadata, this.generateSubQuery(model, executionContext));
                }
            }
            this.tempKeyIndexesInBase.clear();
            this.tempKeyIndex.clear();
            this.arrayColumnTypes.clear();
            this.tempKeyKinds.clear();
            boolean pageFramingSupported = false;
            boolean specialCaseKeys = false;
            QueryModel nested = model.getNestedModel();
            assert (nested != null);
            if (nested.getSelectModelType() == 2) {
                columnExpr = nested.getColumns().getQuick(0).getAst();
                if (columnExpr.type == 8 && SqlKeywords.isHourKeyword(columnExpr.token) && columnExpr.paramCount == 1 && columnExpr.rhs.type == 4) {
                    specialCaseKeys = true;
                    QueryModel.backupWhereClause(this.expressionNodePool, model);
                    factory = this.generateSubQuery(nested, executionContext);
                    pageFramingSupported = factory.supportPageFrameCursor();
                    if (pageFramingSupported) {
                        this.tempKeyIndexesInBase.add(factory.getMetadata().getColumnIndex(columnExpr.rhs.token));
                        CharSequence functionColumnName = columns.getQuick(0).getName();
                        int n = columns.size();
                        for (int i = 0; i < n; ++i) {
                            columnExpr = columns.getQuick(i).getAst();
                            if (columnExpr.type != 4) continue;
                            if (Chars.equals(columnExpr.token, functionColumnName)) {
                                this.tempKeyIndex.add(i);
                                this.tempKeyKinds.add(1);
                                this.arrayColumnTypes.add(5);
                                continue;
                            }
                            pageFramingSupported = false;
                            break;
                        }
                    } else {
                        factory = Misc.free(factory);
                    }
                }
            }
            if (factory == null) {
                if (specialCaseKeys) {
                    QueryModel.restoreWhereClause(model);
                }
                factory = this.generateSubQuery(model, executionContext);
                pageFramingSupported = factory.supportPageFrameCursor();
            }
            RecordMetadata metadata = factory.getMetadata();
            if (pageFramingSupported && this.assembleKeysAndFunctionReferences(columns, metadata, !specialCaseKeys)) {
                int indexInBase;
                int i;
                GenericRecordMetadata meta = new GenericRecordMetadata();
                int n = this.tempKeyIndex.size();
                for (i = 0; i < n; ++i) {
                    int indexInThis = this.tempKeyIndex.getQuick(i);
                    indexInBase = this.tempKeyIndexesInBase.getQuick(i);
                    int type = this.arrayColumnTypes.getColumnType(i);
                    if (ColumnType.isSymbol(type)) {
                        meta.add(indexInThis, new TableColumnMetadata(Chars.toString(columns.getQuick(indexInThis).getName()), 0L, type, false, 0, metadata.isSymbolTableStatic(indexInBase), null));
                        continue;
                    }
                    meta.add(indexInThis, new TableColumnMetadata(Chars.toString(columns.getQuick(indexInThis).getName()), 0L, type, null));
                }
                n = this.tempVecConstructors.size();
                for (i = 0; i < n; ++i) {
                    VectorAggregateFunctionConstructor constructor = this.tempVecConstructors.getQuick(i);
                    indexInBase = this.tempVecConstructorArgIndexes.getQuick(i);
                    int indexInThis = this.tempAggIndex.getQuick(i);
                    VectorAggregateFunction vaf = constructor.create(this.tempKeyKinds.size() == 0 ? 0 : this.tempKeyKinds.getQuick(0), indexInBase, executionContext.getSharedWorkerCount());
                    this.tempVaf.add(vaf);
                    meta.add(indexInThis, new TableColumnMetadata(Chars.toString(columns.getQuick(indexInThis).getName()), 0L, vaf.getType(), null));
                }
                if (this.tempKeyIndexesInBase.size() == 0) {
                    return new GroupByNotKeyedVectorRecordCursorFactory(this.configuration, factory, meta, this.tempVaf);
                }
                if (this.tempKeyIndexesInBase.size() == 1) {
                    n = this.tempVaf.size();
                    for (i = 0; i < n; ++i) {
                        this.tempVaf.getQuick(i).pushValueTypes(this.arrayColumnTypes);
                    }
                    try {
                        GroupByUtils.validateGroupByColumns(model, 1);
                    }
                    catch (Throwable e) {
                        Misc.freeObjList(this.tempVaf);
                        throw e;
                    }
                    return new io.questdb.griffin.engine.groupby.vect.GroupByRecordCursorFactory(this.configuration, factory, meta, this.arrayColumnTypes, executionContext.getSharedWorkerCount(), this.tempVaf, this.tempKeyIndexesInBase.getQuick(0), this.tempKeyIndex.getQuick(0), this.tempSymbolSkewIndexes);
                }
                Misc.freeObjList(this.tempVaf);
            }
            if (specialCaseKeys) {
                Misc.free(factory);
                QueryModel.restoreWhereClause(model);
                factory = this.generateSubQuery(model, executionContext);
                metadata = factory.getMetadata();
            }
            int timestampIndex = this.getTimestampIndex(model, factory);
            this.keyTypes.clear();
            this.valueTypes.clear();
            this.listColumnFilterA.clear();
            int columnCount = model.getColumns().size();
            ObjList<GroupByFunction> groupByFunctions = new ObjList<GroupByFunction>(columnCount);
            try {
                GroupByUtils.prepareGroupByFunctions(model, metadata, this.functionParser, executionContext, groupByFunctions, this.groupByFunctionPositions, this.valueTypes);
            }
            catch (Throwable e) {
                Misc.freeObjList(groupByFunctions);
                throw e;
            }
            ObjList<Function> recordFunctions = new ObjList<Function>(columnCount);
            GenericRecordMetadata groupByMetadata = new GenericRecordMetadata();
            try {
                GroupByUtils.prepareGroupByRecordFunctions(model, metadata, this.listColumnFilterA, groupByFunctions, this.groupByFunctionPositions, recordFunctions, this.recordFunctionPositions, groupByMetadata, this.keyTypes, this.valueTypes.getColumnCount(), true, timestampIndex);
            }
            catch (Throwable e) {
                Misc.freeObjList(recordFunctions);
                throw e;
            }
            if (this.keyTypes.getColumnCount() == 0) {
                return new GroupByNotKeyedRecordCursorFactory(factory, groupByMetadata, groupByFunctions, recordFunctions, this.valueTypes.getColumnCount());
            }
            return new GroupByRecordCursorFactory(this.configuration, factory, this.listColumnFilterA, this.asm, this.keyTypes, this.valueTypes, groupByMetadata, groupByFunctions, recordFunctions);
        }
        catch (Throwable e) {
            Misc.free(factory);
            throw e;
        }
    }

    private RecordCursorFactory generateSelectVirtual(QueryModel model, SqlExecutionContext executionContext) throws SqlException {
        RecordCursorFactory factory = this.generateSubQuery(model, executionContext);
        return this.generateSelectVirtualWithSubquery(model, executionContext, factory);
    }

    @NotNull
    private VirtualRecordCursorFactory generateSelectVirtualWithSubquery(QueryModel model, SqlExecutionContext executionContext, RecordCursorFactory factory) throws SqlException {
        try {
            ObjList<QueryColumn> columns = model.getColumns();
            int columnCount = columns.size();
            RecordMetadata metadata = factory.getMetadata();
            ObjList<Function> functions = new ObjList<Function>(columnCount);
            GenericRecordMetadata virtualMetadata = new GenericRecordMetadata();
            int timestampIndex = metadata.getTimestampIndex();
            String timestampColumn = timestampIndex > -1 ? metadata.getColumnName(timestampIndex) : null;
            for (int i = 0; i < columnCount; ++i) {
                QueryColumn column = columns.getQuick(i);
                ExpressionNode node = column.getAst();
                if (node.type == 4 && Chars.equalsNc(node.token, timestampColumn)) {
                    virtualMetadata.setTimestampIndex(i);
                }
                Function function = this.functionParser.parseFunction(column.getAst(), metadata, executionContext);
                int targetColumnType = -1;
                if (model.isUpdate()) {
                    int columnIndex = model.getUpdateTableColumnNames().indexOf(column.getAlias());
                    targetColumnType = model.getUpdateTableColumnTypes().get(columnIndex);
                }
                if (function.isUndefined()) {
                    if (!model.isUpdate()) {
                        function.assignType(11, executionContext.getBindVariableService());
                    } else {
                        function.assignType(targetColumnType, executionContext.getBindVariableService());
                    }
                }
                int columnType = function.getType();
                if (targetColumnType != -1 && targetColumnType != columnType) {
                    if (ColumnType.isBuiltInWideningCast(function.getType(), targetColumnType)) {
                        columnType = targetColumnType;
                    } else {
                        Function castFunction = this.functionParser.createImplicitCast(column.getAst().position, function, targetColumnType);
                        if (castFunction != null) {
                            function = castFunction;
                            columnType = targetColumnType;
                        }
                    }
                }
                functions.add(function);
                if (columnType == 12) {
                    if (function instanceof SymbolFunction) {
                        virtualMetadata.add(new TableColumnMetadata(Chars.toString(column.getAlias()), this.configuration.getRandom().nextLong(), function.getType(), false, 0, ((SymbolFunction)function).isSymbolTableStatic(), function.getMetadata()));
                        continue;
                    }
                    if (!(function instanceof NullConstant)) continue;
                    virtualMetadata.add(new TableColumnMetadata(Chars.toString(column.getAlias()), this.configuration.getRandom().nextLong(), 12, false, 0, false, function.getMetadata()));
                    functions.setQuick(functions.size() - 1, SymbolConstant.NULL);
                    continue;
                }
                virtualMetadata.add(new TableColumnMetadata(Chars.toString(column.getAlias()), this.configuration.getRandom().nextLong(), columnType, function.getMetadata()));
            }
            if (executionContext.isTimestampRequired() && timestampColumn != null && virtualMetadata.getTimestampIndex() == -1) {
                ScalarFunction timestampFunction = FunctionParser.createColumn(0, timestampColumn, metadata);
                functions.add(timestampFunction);
                int n = model.getBottomUpColumns().size();
                for (int i = 0; i < n; ++i) {
                    QueryColumn qc = model.getBottomUpColumns().getQuick(i);
                    if (qc.getAst().type != 4 || !Chars.equals((CharSequence)timestampColumn, qc.getAst().token)) continue;
                    virtualMetadata.setTimestampIndex(virtualMetadata.getColumnCount());
                    virtualMetadata.add(new TableColumnMetadata(Chars.toString(qc.getAlias()), 0L, timestampFunction.getType(), timestampFunction.getMetadata()));
                    break;
                }
            }
            return new VirtualRecordCursorFactory(virtualMetadata, functions, factory);
        }
        catch (CairoException | SqlException e) {
            factory.close();
            throw e;
        }
    }

    private RecordCursorFactory generateSetFactory(QueryModel model, RecordCursorFactory factoryA, SqlExecutionContext executionContext) throws SqlException {
        RecordCursorFactory factoryB = this.generateQuery0(model.getUnionModel(), executionContext, true);
        ObjList<Function> castFunctionsA = null;
        ObjList<Function> castFunctionsB = null;
        try {
            RecordMetadata metadataA = factoryA.getMetadata();
            RecordMetadata metadataB = factoryB.getMetadata();
            int positionA = model.getModelPosition();
            int positionB = model.getUnionModel().getModelPosition();
            switch (model.getSetOperationType()) {
                case 1: {
                    RecordMetadata setMetadata;
                    boolean castIsRequired = this.checkIfSetCastIsRequired(metadataA, metadataB, true);
                    RecordMetadata recordMetadata = setMetadata = castIsRequired ? this.widenSetMetadata(metadataA, metadataB) : GenericRecordMetadata.removeTimestamp(metadataA);
                    if (castIsRequired) {
                        castFunctionsA = this.generateCastFunctions(setMetadata, metadataA, positionA);
                        castFunctionsB = this.generateCastFunctions(setMetadata, metadataB, positionB);
                    }
                    return this.generateUnionFactory(model, executionContext, factoryA, factoryB, castFunctionsA, castFunctionsB, setMetadata, SET_UNION_CONSTRUCTOR);
                }
                case 0: {
                    RecordMetadata setMetadata;
                    boolean castIsRequired = this.checkIfSetCastIsRequired(metadataA, metadataB, true);
                    RecordMetadata recordMetadata = setMetadata = castIsRequired ? this.widenSetMetadata(metadataA, metadataB) : GenericRecordMetadata.removeTimestamp(metadataA);
                    if (castIsRequired) {
                        castFunctionsA = this.generateCastFunctions(setMetadata, metadataA, positionA);
                        castFunctionsB = this.generateCastFunctions(setMetadata, metadataB, positionB);
                    }
                    return this.generateUnionAllFactory(model, executionContext, factoryA, factoryB, castFunctionsA, castFunctionsB, setMetadata);
                }
                case 2: {
                    RecordMetadata setMetadata;
                    boolean castIsRequired = this.checkIfSetCastIsRequired(metadataA, metadataB, false);
                    RecordMetadata recordMetadata = setMetadata = castIsRequired ? this.widenSetMetadata(metadataA, metadataB) : metadataA;
                    if (castIsRequired) {
                        castFunctionsA = this.generateCastFunctions(setMetadata, metadataA, positionA);
                        castFunctionsB = this.generateCastFunctions(setMetadata, metadataB, positionB);
                    }
                    return this.generateUnionFactory(model, executionContext, factoryA, factoryB, castFunctionsA, castFunctionsB, setMetadata, SET_EXCEPT_CONSTRUCTOR);
                }
                case 3: {
                    RecordMetadata setMetadata;
                    boolean castIsRequired = this.checkIfSetCastIsRequired(metadataA, metadataB, false);
                    RecordMetadata recordMetadata = setMetadata = castIsRequired ? this.widenSetMetadata(metadataA, metadataB) : metadataA;
                    if (castIsRequired) {
                        castFunctionsA = this.generateCastFunctions(setMetadata, metadataA, positionA);
                        castFunctionsB = this.generateCastFunctions(setMetadata, metadataB, positionB);
                    }
                    return this.generateUnionFactory(model, executionContext, factoryA, factoryB, castFunctionsA, castFunctionsB, setMetadata, SET_INTERSECT_CONSTRUCTOR);
                }
            }
            assert (false);
            return null;
        }
        catch (Throwable e) {
            Misc.free(factoryA);
            Misc.free(factoryB);
            Misc.freeObjList(castFunctionsA);
            Misc.freeObjList(castFunctionsB);
            throw e;
        }
    }

    private RecordCursorFactory generateSubQuery(QueryModel model, SqlExecutionContext executionContext) throws SqlException {
        assert (model.getNestedModel() != null);
        return this.generateQuery(model.getNestedModel(), executionContext, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RecordCursorFactory generateTableQuery(QueryModel model, SqlExecutionContext executionContext) throws SqlException {
        boolean supportsRandomAccess;
        ObjList<ExpressionNode> latestBy = model.getLatestBy();
        GenericLexer.FloatingSequence tab = (GenericLexer.FloatingSequence)model.getTableName().token;
        if (Chars.startsWith((CharSequence)tab, "*!*")) {
            tab.setLo(tab.getLo() + "*!*".length());
            supportsRandomAccess = false;
        } else {
            supportsRandomAccess = true;
        }
        try (TableReader reader = this.engine.getReader(executionContext.getCairoSecurityContext(), tab, model.getTableId(), model.getTableVersion());){
            boolean framingSupported;
            TableReaderMetadata readerMeta = reader.getMetadata();
            ObjList<QueryColumn> topDownColumns = model.getTopDownColumns();
            int topDownColumnCount = topDownColumns.size();
            IntList columnIndexes = new IntList();
            IntList columnSizes = new IntList();
            int readerTimestampIndex = this.getTimestampIndex(model, readerMeta);
            if (latestBy.size() > 0 && readerTimestampIndex != readerMeta.getTimestampIndex()) {
                throw SqlException.$(model.getTimestamp().position, "latest by over a table requires designated TIMESTAMP");
            }
            boolean requiresTimestamp = joinsRequiringTimestamp[model.getJoinType()];
            GenericRecordMetadata myMeta = new GenericRecordMetadata();
            try {
                if (requiresTimestamp) {
                    executionContext.pushTimestampRequiredFlag(true);
                }
                boolean contextTimestampRequired = executionContext.isTimestampRequired();
                if (topDownColumnCount > 0 || contextTimestampRequired || model.isUpdate()) {
                    framingSupported = true;
                    for (int i = 0; i < topDownColumnCount; ++i) {
                        int columnIndex = readerMeta.getColumnIndexQuiet(topDownColumns.getQuick(i).getName());
                        int type = readerMeta.getColumnType(columnIndex);
                        int typeSize = ColumnType.sizeOf(type);
                        columnIndexes.add(columnIndex);
                        columnSizes.add(Numbers.msb(typeSize));
                        myMeta.add(new TableColumnMetadata(Chars.toString(topDownColumns.getQuick(i).getName()), readerMeta.getColumnHash(columnIndex), type, readerMeta.isColumnIndexed(columnIndex), readerMeta.getIndexValueBlockCapacity(columnIndex), readerMeta.isSymbolTableStatic(columnIndex), readerMeta.getMetadata(columnIndex)));
                        if (columnIndex != readerTimestampIndex) continue;
                        myMeta.setTimestampIndex(myMeta.getColumnCount() - 1);
                    }
                    if (readerTimestampIndex != -1 && myMeta.getTimestampIndex() == -1 && contextTimestampRequired) {
                        myMeta.add(new TableColumnMetadata(readerMeta.getColumnName(readerTimestampIndex), readerMeta.getColumnHash(readerTimestampIndex), readerMeta.getColumnType(readerTimestampIndex), readerMeta.getMetadata(readerTimestampIndex)));
                        myMeta.setTimestampIndex(myMeta.getColumnCount() - 1);
                        columnIndexes.add(readerTimestampIndex);
                        columnSizes.add(Numbers.msb(8));
                    }
                } else {
                    framingSupported = false;
                }
            }
            finally {
                if (requiresTimestamp) {
                    executionContext.popTimestampRequiredFlag();
                }
            }
            int latestByColumnCount = this.prepareLatestByColumnIndexes(latestBy, myMeta);
            String tableName = reader.getTableName();
            ExpressionNode withinExtracted = this.whereClauseParser.extractWithin(model, model.getWhereClause(), readerMeta, this.functionParser, executionContext, this.prefixes);
            model.setWhereClause(withinExtracted);
            if (withinExtracted != null) {
                RowCursorFactory rowFactory;
                boolean isOrderByTimestampDesc;
                ObjList<ExpressionNode> orderByAdvice;
                int orderByAdviceSize;
                int indexDirection;
                boolean orderByKeyColumn;
                boolean intervalHitsOnlyOnePartition;
                AbstractDataFrameCursorFactory dfcFactory;
                int latestByIndex;
                CharSequence preferredKeyColumn = null;
                if (latestByColumnCount == 1 && ColumnType.isSymbol(myMeta.getColumnType(latestByIndex = this.listColumnFilterA.getColumnIndexFactored(0)))) {
                    preferredKeyColumn = latestBy.getQuick((int)0).token;
                }
                IntrinsicModel intrinsicModel = this.whereClauseParser.extract(model, withinExtracted, readerMeta, preferredKeyColumn, readerTimestampIndex, this.functionParser, myMeta, executionContext, latestByColumnCount > 1);
                model.setWhereClause(null);
                if (intrinsicModel.intrinsicValue == 2) {
                    EmptyTableRecordCursorFactory emptyTableRecordCursorFactory = new EmptyTableRecordCursorFactory(myMeta);
                    return emptyTableRecordCursorFactory;
                }
                if (latestByColumnCount > 0) {
                    Function f = this.compileFilter(intrinsicModel, myMeta, executionContext);
                    if (f != null && f.isConstant() && !f.getBool(null)) {
                        model.getLatestBy().clear();
                        Misc.free(f);
                        EmptyTableRecordCursorFactory emptyTableRecordCursorFactory = new EmptyTableRecordCursorFactory(myMeta);
                        return emptyTableRecordCursorFactory;
                    }
                    this.prepareLatestByColumnIndexes(latestBy, myMeta);
                    RecordCursorFactory recordCursorFactory = this.generateLatestByTableQuery(model, reader, myMeta, tableName, intrinsicModel, f, executionContext, readerTimestampIndex, columnIndexes, columnSizes, this.prefixes);
                    return recordCursorFactory;
                }
                if (intrinsicModel.hasIntervalFilters()) {
                    RuntimeIntrinsicIntervalModel intervalModel = intrinsicModel.buildIntervalModel();
                    dfcFactory = new IntervalFwdDataFrameCursorFactory(tableName, model.getTableId(), model.getTableVersion(), intervalModel, readerTimestampIndex);
                    intervalHitsOnlyOnePartition = intervalModel.allIntervalsHitOnePartition(reader.getPartitionedBy());
                } else {
                    dfcFactory = new FullFwdDataFrameCursorFactory(tableName, model.getTableId(), model.getTableVersion());
                    intervalHitsOnlyOnePartition = false;
                }
                if (intrinsicModel.keyColumn != null) {
                    Function f;
                    ObjList<ExpressionNode> orderByAdvice2;
                    int orderByAdviceSize22;
                    int keyColumnIndex = reader.getMetadata().getColumnIndexQuiet(intrinsicModel.keyColumn);
                    int nKeyValues = intrinsicModel.keyValueFuncs.size();
                    int nKeyExcludedValues = intrinsicModel.keyExcludedValueFuncs.size();
                    if (intrinsicModel.keySubQuery != null) {
                        RecordCursorFactory rcf = this.generate(intrinsicModel.keySubQuery, executionContext);
                        Record.CharSequenceFunction func = this.validateSubQueryColumnAndGetGetter(intrinsicModel, rcf.getMetadata());
                        Function f2 = this.compileFilter(intrinsicModel, myMeta, executionContext);
                        if (f2 != null && f2.isConstant() && !f2.getBool(null)) {
                            Misc.free(dfcFactory);
                            EmptyTableRecordCursorFactory emptyTableRecordCursorFactory = new EmptyTableRecordCursorFactory(myMeta);
                            return emptyTableRecordCursorFactory;
                        }
                        FilterOnSubQueryRecordCursorFactory filterOnSubQueryRecordCursorFactory = new FilterOnSubQueryRecordCursorFactory(myMeta, dfcFactory, rcf, keyColumnIndex, f2, func, columnIndexes);
                        return filterOnSubQueryRecordCursorFactory;
                    }
                    assert (nKeyValues > 0 || nKeyExcludedValues > 0);
                    orderByKeyColumn = false;
                    indexDirection = 1;
                    if (intervalHitsOnlyOnePartition && (orderByAdviceSize22 = (orderByAdvice2 = model.getOrderByAdvice()).size()) > 0 && orderByAdviceSize22 < 3 && Chars.equals(orderByAdvice2.getQuick((int)0).token, intrinsicModel.keyColumn)) {
                        myMeta.setTimestampIndex(-1);
                        if (orderByAdviceSize22 == 1) {
                            orderByKeyColumn = true;
                        } else if (Chars.equals(orderByAdvice2.getQuick((int)1).token, model.getTimestamp().token)) {
                            orderByKeyColumn = true;
                            if (SqlCodeGenerator.getOrderByDirectionOrDefault(model, 1) == 1) {
                                indexDirection = 2;
                            }
                        }
                    }
                    if (intrinsicModel.keyExcludedValueFuncs.size() == 0) {
                        f = this.compileFilter(intrinsicModel, myMeta, executionContext);
                        if (f != null && f.isConstant()) {
                            try {
                                if (!f.getBool(null)) {
                                    Misc.free(dfcFactory);
                                    EmptyTableRecordCursorFactory orderByAdviceSize22 = new EmptyTableRecordCursorFactory(myMeta);
                                    return orderByAdviceSize22;
                                }
                            }
                            finally {
                                f = Misc.free(f);
                            }
                        }
                        if (nKeyValues == 1) {
                            int symbolKey;
                            Function symbolFunc = intrinsicModel.keyValueFuncs.get(0);
                            SymbolMapReader symbolMapReader = reader.getSymbolMapReader(keyColumnIndex);
                            int n = symbolKey = symbolFunc.isRuntimeConstant() ? -2 : symbolMapReader.keyOf(symbolFunc.getStr(null));
                            FunctionBasedRowCursorFactory rcf = symbolKey == -2 ? (f == null ? new DeferredSymbolIndexRowCursorFactory(keyColumnIndex, symbolFunc, true, indexDirection) : new DeferredSymbolIndexFilteredRowCursorFactory(keyColumnIndex, symbolFunc, f, true, indexDirection, columnIndexes)) : (f == null ? new SymbolIndexRowCursorFactory(keyColumnIndex, symbolKey, true, indexDirection, null) : new SymbolIndexFilteredRowCursorFactory(keyColumnIndex, symbolKey, f, true, indexDirection, columnIndexes, null));
                            if (f == null) {
                                DeferredSingleSymbolFilterDataFrameRecordCursorFactory deferredSingleSymbolFilterDataFrameRecordCursorFactory = new DeferredSingleSymbolFilterDataFrameRecordCursorFactory(this.configuration, keyColumnIndex, symbolFunc, (RowCursorFactory)rcf, myMeta, dfcFactory, orderByKeyColumn, columnIndexes, columnSizes, supportsRandomAccess);
                                return deferredSingleSymbolFilterDataFrameRecordCursorFactory;
                            }
                            DataFrameRecordCursorFactory dataFrameRecordCursorFactory = new DataFrameRecordCursorFactory(this.configuration, myMeta, dfcFactory, rcf, orderByKeyColumn, f, false, columnIndexes, columnSizes, supportsRandomAccess);
                            return dataFrameRecordCursorFactory;
                        }
                        if (orderByKeyColumn) {
                            myMeta.setTimestampIndex(-1);
                        }
                        FilterOnValuesRecordCursorFactory filterOnValuesRecordCursorFactory = new FilterOnValuesRecordCursorFactory(myMeta, dfcFactory, intrinsicModel.keyValueFuncs, keyColumnIndex, reader, f, model.getOrderByAdviceMnemonic(), orderByKeyColumn, SqlCodeGenerator.getOrderByDirectionOrDefault(model, 0), indexDirection, columnIndexes);
                        return filterOnValuesRecordCursorFactory;
                    }
                    if (intrinsicModel.keyExcludedValueFuncs.size() > 0 && reader.getSymbolMapReader(keyColumnIndex).getSymbolCount() < this.configuration.getMaxSymbolNotEqualsCount()) {
                        f = this.compileFilter(intrinsicModel, myMeta, executionContext);
                        if (f != null && f.isConstant()) {
                            try {
                                if (!f.getBool(null)) {
                                    Misc.free(dfcFactory);
                                    EmptyTableRecordCursorFactory emptyTableRecordCursorFactory = new EmptyTableRecordCursorFactory(myMeta);
                                    return emptyTableRecordCursorFactory;
                                }
                            }
                            finally {
                                f = Misc.free(f);
                            }
                        }
                        FilterOnExcludedValuesRecordCursorFactory filterOnExcludedValuesRecordCursorFactory = new FilterOnExcludedValuesRecordCursorFactory(myMeta, dfcFactory, intrinsicModel.keyExcludedValueFuncs, keyColumnIndex, f, model.getOrderByAdviceMnemonic(), orderByKeyColumn, indexDirection, columnIndexes, this.configuration.getMaxSymbolNotEqualsCount());
                        return filterOnExcludedValuesRecordCursorFactory;
                    }
                }
                if (intervalHitsOnlyOnePartition && intrinsicModel.filter == null && (orderByAdviceSize = (orderByAdvice = model.getOrderByAdvice()).size()) > 0 && orderByAdviceSize < 3 && intrinsicModel.hasIntervalFilters()) {
                    int columnIndex = myMeta.getColumnIndexQuiet(model.getOrderByAdvice().getQuick((int)0).token);
                    assert (columnIndex > -1);
                    if (myMeta.isColumnIndexed(columnIndex)) {
                        orderByKeyColumn = false;
                        indexDirection = 1;
                        if (orderByAdviceSize == 1) {
                            orderByKeyColumn = true;
                        } else if (Chars.equals(orderByAdvice.getQuick((int)1).token, model.getTimestamp().token)) {
                            orderByKeyColumn = true;
                            if (SqlCodeGenerator.getOrderByDirectionOrDefault(model, 1) == 1) {
                                indexDirection = 2;
                            }
                        }
                        if (orderByKeyColumn) {
                            myMeta.setTimestampIndex(-1);
                            SortedSymbolIndexRecordCursorFactory sortedSymbolIndexRecordCursorFactory = new SortedSymbolIndexRecordCursorFactory(myMeta, dfcFactory, columnIndex, SqlCodeGenerator.getOrderByDirectionOrDefault(model, 0) == 0, indexDirection, columnIndexes);
                            return sortedSymbolIndexRecordCursorFactory;
                        }
                    }
                }
                if ((isOrderByTimestampDesc = this.isOrderDescendingByDesignatedTimestampOnly(model)) && !intrinsicModel.hasIntervalFilters()) {
                    Misc.free(dfcFactory);
                    dfcFactory = new FullBwdDataFrameCursorFactory(tableName, model.getTableId(), model.getTableVersion());
                    rowFactory = new BwdDataFrameRowCursorFactory();
                } else {
                    rowFactory = new DataFrameRowCursorFactory();
                }
                model.setWhereClause(intrinsicModel.filter);
                DataFrameRecordCursorFactory dataFrameRecordCursorFactory = new DataFrameRecordCursorFactory(this.configuration, myMeta, dfcFactory, rowFactory, false, null, framingSupported, columnIndexes, columnSizes, supportsRandomAccess);
                return dataFrameRecordCursorFactory;
            }
            if (latestByColumnCount == 0) {
                RowCursorFactory rowCursorFactory;
                AbstractDataFrameCursorFactory cursorFactory;
                if (this.isOrderDescendingByDesignatedTimestampOnly(model)) {
                    cursorFactory = new FullBwdDataFrameCursorFactory(tableName, model.getTableId(), model.getTableVersion());
                    rowCursorFactory = new BwdDataFrameRowCursorFactory();
                } else {
                    cursorFactory = new FullFwdDataFrameCursorFactory(tableName, model.getTableId(), model.getTableVersion());
                    rowCursorFactory = new DataFrameRowCursorFactory();
                }
                DataFrameRecordCursorFactory dataFrameRecordCursorFactory = new DataFrameRecordCursorFactory(this.configuration, myMeta, cursorFactory, rowCursorFactory, false, null, framingSupported, columnIndexes, columnSizes, supportsRandomAccess);
                return dataFrameRecordCursorFactory;
            }
            model.getLatestBy().clear();
            if (latestByColumnCount == 1) {
                int latestByColumnIndex = this.listColumnFilterA.getColumnIndexFactored(0);
                if (myMeta.isColumnIndexed(latestByColumnIndex)) {
                    LatestByAllIndexedRecordCursorFactory latestByAllIndexedRecordCursorFactory = new LatestByAllIndexedRecordCursorFactory(myMeta, this.configuration, new FullBwdDataFrameCursorFactory(tableName, model.getTableId(), model.getTableVersion()), this.listColumnFilterA.getColumnIndexFactored(0), columnIndexes, this.prefixes);
                    return latestByAllIndexedRecordCursorFactory;
                }
                if (ColumnType.isSymbol(myMeta.getColumnType(latestByColumnIndex)) && myMeta.isSymbolTableStatic(latestByColumnIndex)) {
                    LatestByDeferredListValuesFilteredRecordCursorFactory latestByDeferredListValuesFilteredRecordCursorFactory = new LatestByDeferredListValuesFilteredRecordCursorFactory(this.configuration, myMeta, new FullBwdDataFrameCursorFactory(tableName, model.getTableId(), model.getTableVersion()), latestByColumnIndex, null, columnIndexes);
                    return latestByDeferredListValuesFilteredRecordCursorFactory;
                }
            }
            LatestByAllFilteredRecordCursorFactory latestByAllFilteredRecordCursorFactory = new LatestByAllFilteredRecordCursorFactory(myMeta, this.configuration, new FullBwdDataFrameCursorFactory(tableName, model.getTableId(), model.getTableVersion()), RecordSinkFactory.getInstance(this.asm, myMeta, this.listColumnFilterA, false), this.keyTypes, null, columnIndexes);
            return latestByAllFilteredRecordCursorFactory;
        }
    }

    private RecordCursorFactory generateUnionAllFactory(QueryModel model, SqlExecutionContext executionContext, RecordCursorFactory factoryA, RecordCursorFactory factoryB, ObjList<Function> castFunctionsA, ObjList<Function> castFunctionsB, RecordMetadata setMetadata) throws SqlException {
        UnionAllRecordCursorFactory setFactory = new UnionAllRecordCursorFactory(setMetadata, factoryA, factoryB, castFunctionsA, castFunctionsB);
        if (model.getUnionModel().getUnionModel() != null) {
            return this.generateSetFactory(model.getUnionModel(), setFactory, executionContext);
        }
        return setFactory;
    }

    private RecordCursorFactory generateUnionFactory(QueryModel model, SqlExecutionContext executionContext, RecordCursorFactory factoryA, RecordCursorFactory factoryB, ObjList<Function> castFunctionsA, ObjList<Function> castFunctionsB, RecordMetadata setMetadata, SetRecordCursorFactoryConstructor constructor) throws SqlException {
        this.entityColumnFilter.of(factoryA.getMetadata().getColumnCount());
        RecordSink recordSink = RecordSinkFactory.getInstance(this.asm, setMetadata, this.entityColumnFilter, true);
        this.valueTypes.clear();
        RecordCursorFactory unionFactory = constructor.create(this.configuration, setMetadata, factoryA, factoryB, castFunctionsA, castFunctionsB, recordSink, this.valueTypes);
        if (model.getUnionModel().getUnionModel() != null) {
            return this.generateSetFactory(model.getUnionModel(), unionFactory, executionContext);
        }
        return unionFactory;
    }

    @Nullable
    private Function getHiFunction(QueryModel model, SqlExecutionContext executionContext) throws SqlException {
        return this.toLimitFunction(executionContext, model.getLimitHi(), null);
    }

    @Nullable
    private Function getLimitLoFunctionOnly(QueryModel model, SqlExecutionContext executionContext) throws SqlException {
        if (model.getLimitAdviceLo() != null && model.getLimitAdviceHi() == null) {
            return this.toLimitFunction(executionContext, model.getLimitAdviceLo(), LongConstant.ZERO);
        }
        return null;
    }

    @NotNull
    private Function getLoFunction(QueryModel model, SqlExecutionContext executionContext) throws SqlException {
        return this.toLimitFunction(executionContext, model.getLimitLo(), LongConstant.ZERO);
    }

    private int getTimestampIndex(QueryModel model, RecordCursorFactory factory) throws SqlException {
        return this.getTimestampIndex(model, factory.getMetadata());
    }

    private int getTimestampIndex(QueryModel model, RecordMetadata metadata) throws SqlException {
        ExpressionNode timestamp = model.getTimestamp();
        if (timestamp != null) {
            int timestampIndex = metadata.getColumnIndexQuiet(timestamp.token);
            if (timestampIndex == -1) {
                throw SqlException.invalidColumn(timestamp.position, timestamp.token);
            }
            if (!ColumnType.isTimestamp(metadata.getColumnType(timestampIndex))) {
                throw SqlException.$(timestamp.position, "not a TIMESTAMP");
            }
            return timestampIndex;
        }
        return metadata.getTimestampIndex();
    }

    private boolean isOrderDescendingByDesignatedTimestampOnly(QueryModel model) {
        return model.getOrderByAdvice().size() == 1 && model.getTimestamp() != null && Chars.equalsIgnoreCase(model.getOrderByAdvice().getQuick((int)0).token, model.getTimestamp().token) && SqlCodeGenerator.getOrderByDirectionOrDefault(model, 0) == 1;
    }

    private boolean isSingleColumnFunction(ExpressionNode ast, CharSequence name) {
        return ast.type == 8 && ast.paramCount == 1 && Chars.equalsIgnoreCase(ast.token, name) && ast.rhs.type == 4;
    }

    private void lookupColumnIndexes(ListColumnFilter filter, ObjList<ExpressionNode> columnNames, RecordMetadata metadata) throws SqlException {
        filter.clear();
        int n = columnNames.size();
        for (int i = 0; i < n; ++i) {
            CharSequence columnName = columnNames.getQuick((int)i).token;
            int columnIndex = metadata.getColumnIndexQuiet(columnName);
            if (columnIndex <= -1) {
                int dot = Chars.indexOf(columnName, '.');
                if (dot > -1 && (columnIndex = metadata.getColumnIndexQuiet(columnName, dot + 1, columnName.length())) > -1) {
                    filter.add(columnIndex + 1);
                    return;
                }
                throw SqlException.invalidColumn(columnNames.getQuick((int)i).position, columnName);
            }
            filter.add(columnIndex + 1);
        }
    }

    private void lookupColumnIndexesUsingVanillaNames(ListColumnFilter filter, ObjList<CharSequence> columnNames, RecordMetadata metadata) {
        filter.clear();
        int n = columnNames.size();
        for (int i = 0; i < n; ++i) {
            filter.add(metadata.getColumnIndex(columnNames.getQuick(i)) + 1);
        }
    }

    private int prepareLatestByColumnIndexes(ObjList<ExpressionNode> latestBy, RecordMetadata myMeta) throws SqlException {
        this.keyTypes.clear();
        this.listColumnFilterA.clear();
        int latestByColumnCount = latestBy.size();
        if (latestByColumnCount > 0) {
            block3: for (int i = 0; i < latestByColumnCount; ++i) {
                ExpressionNode latestByNode = latestBy.getQuick(i);
                int index = myMeta.getColumnIndexQuiet(latestByNode.token);
                if (index == -1) {
                    throw SqlException.invalidColumn(latestByNode.position, latestByNode.token);
                }
                int columnType = myMeta.getColumnType(index);
                switch (ColumnType.tagOf(columnType)) {
                    case 1: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 11: 
                    case 12: 
                    case 13: {
                        this.keyTypes.add(columnType);
                        this.listColumnFilterA.add(index + 1);
                        continue block3;
                    }
                    default: {
                        throw SqlException.position(latestByNode.position).put(latestByNode.token).put(" (").put(ColumnType.nameOf(columnType)).put("): invalid type, only [BOOLEAN, SHORT, INT, LONG, LONG256, CHAR, STRING, SYMBOL] are supported in LATEST BY");
                    }
                }
            }
        }
        return latestByColumnCount;
    }

    private void processJoinContext(boolean vanillaMaster, JoinContext jc, RecordMetadata masterMetadata, RecordMetadata slaveMetadata) throws SqlException {
        this.lookupColumnIndexesUsingVanillaNames(this.listColumnFilterA, jc.aNames, slaveMetadata);
        if (vanillaMaster) {
            this.lookupColumnIndexesUsingVanillaNames(this.listColumnFilterB, jc.bNames, masterMetadata);
        } else {
            this.lookupColumnIndexes(this.listColumnFilterB, jc.bNodes, masterMetadata);
        }
        this.keyTypes.clear();
        int m = this.listColumnFilterA.getColumnCount();
        for (int k = 0; k < m; ++k) {
            int columnTypeA = slaveMetadata.getColumnType(this.listColumnFilterA.getColumnIndexFactored(k));
            int columnTypeB = masterMetadata.getColumnType(this.listColumnFilterB.getColumnIndexFactored(k));
            if (!(columnTypeB == columnTypeA || ColumnType.isSymbolOrString(columnTypeB) && ColumnType.isSymbolOrString(columnTypeA))) {
                throw SqlException.$(jc.aNodes.getQuick((int)k).position, "join column type mismatch");
            }
            this.keyTypes.add(columnTypeB == 12 ? 11 : columnTypeB);
        }
    }

    void setEnableJitNullChecks(boolean value) {
        this.enableJitNullChecks = value;
    }

    void setFullFatJoins(boolean fullFatJoins) {
        this.fullFatJoins = fullFatJoins;
    }

    private Function toLimitFunction(SqlExecutionContext executionContext, ExpressionNode limit, ConstantFunction defaultValue) throws SqlException {
        if (limit == null) {
            return defaultValue;
        }
        Function func = this.functionParser.parseFunction(limit, EmptyRecordMetadata.INSTANCE, executionContext);
        int type = func.getType();
        if (limitTypes.excludes(type)) {
            if (type == 0) {
                if (func instanceof IndexedParameterLinkFunction) {
                    executionContext.getBindVariableService().setLong(((IndexedParameterLinkFunction)func).getVariableIndex(), defaultValue.getLong(null));
                    return func;
                }
                if (func instanceof NamedParameterLinkFunction) {
                    executionContext.getBindVariableService().setLong(((NamedParameterLinkFunction)func).getVariableName(), defaultValue.getLong(null));
                    return func;
                }
            }
            throw SqlException.$(limit.position, "invalid type: ").put(ColumnType.nameOf(type));
        }
        return func;
    }

    private IntList toOrderIndices(RecordMetadata m, ObjList<ExpressionNode> orderBy, IntList orderByDirection) throws SqlException {
        IntList indices = this.intListPool.next();
        int n = orderBy.size();
        for (int i = 0; i < n; ++i) {
            ExpressionNode tok = orderBy.getQuick(i);
            int index = m.getColumnIndexQuiet(tok.token);
            if (index == -1) {
                throw SqlException.invalidColumn(tok.position, tok.token);
            }
            ++index;
            if (orderByDirection.getQuick(i) == 1) {
                index = -index;
            }
            indices.add(index);
        }
        return indices;
    }

    private void validateBothTimestampOrders(RecordCursorFactory masterFactory, RecordCursorFactory slaveFactory, int position) throws SqlException {
        if (masterFactory.hasDescendingOrder()) {
            throw SqlException.$(position, "left side of time series join has DESC timestamp order");
        }
        if (slaveFactory.hasDescendingOrder()) {
            throw SqlException.$(position, "right side of time series join has DESC timestamp order");
        }
    }

    private void validateBothTimestamps(QueryModel slaveModel, RecordMetadata masterMetadata, RecordMetadata slaveMetadata) throws SqlException {
        if (masterMetadata.getTimestampIndex() == -1) {
            throw SqlException.$(slaveModel.getJoinKeywordPosition(), "left side of time series join has no timestamp");
        }
        if (slaveMetadata.getTimestampIndex() == -1) {
            throw SqlException.$(slaveModel.getJoinKeywordPosition(), "right side of time series join has no timestamp");
        }
    }

    private Record.CharSequenceFunction validateSubQueryColumnAndGetGetter(IntrinsicModel intrinsicModel, RecordMetadata metadata) throws SqlException {
        int columnType = metadata.getColumnType(0);
        if (!ColumnType.isSymbolOrString(columnType)) {
            assert (intrinsicModel.keySubQuery.getColumns() != null);
            assert (intrinsicModel.keySubQuery.getColumns().size() > 0);
            throw SqlException.position(intrinsicModel.keySubQuery.getColumns().getQuick((int)0).getAst().position).put("unsupported column type: ").put(metadata.getColumnName(0)).put(": ").put(ColumnType.nameOf(columnType));
        }
        return ColumnType.isString(columnType) ? Record.GET_STR : Record.GET_SYM;
    }

    private RecordMetadata widenSetMetadata(RecordMetadata typesA, RecordMetadata typesB) {
        int columnCount = typesA.getColumnCount();
        assert (columnCount == typesB.getColumnCount());
        GenericRecordMetadata metadata = new GenericRecordMetadata();
        for (int i = 0; i < columnCount; ++i) {
            int typeB;
            int typeA = typesA.getColumnType(i);
            if (typeA == (typeB = typesB.getColumnType(i)) && typeA != 12) {
                metadata.add(BaseRecordMetadata.copyOf(typesA, i));
                continue;
            }
            if (ColumnType.isToSameOrWider(typeB, typeA) && typeA != 12 && typeA != 4) {
                metadata.add(BaseRecordMetadata.copyOf(typesA, i));
                continue;
            }
            if (ColumnType.isToSameOrWider(typeA, typeB) && typeB != 12) {
                metadata.add(new TableColumnMetadata(typesA.getColumnName(i), typesA.getColumnHash(i), typeB));
                continue;
            }
            metadata.add(new TableColumnMetadata(typesA.getColumnName(i), typesA.getColumnHash(i), 11));
        }
        return metadata;
    }

    static {
        SqlCodeGenerator.joinsRequiringTimestamp[1] = false;
        SqlCodeGenerator.joinsRequiringTimestamp[2] = false;
        SqlCodeGenerator.joinsRequiringTimestamp[3] = false;
        SqlCodeGenerator.joinsRequiringTimestamp[4] = true;
        SqlCodeGenerator.joinsRequiringTimestamp[5] = true;
        SqlCodeGenerator.joinsRequiringTimestamp[6] = true;
        SqlCodeGenerator.joinsRequiringTimestamp[7] = false;
        limitTypes.add(6);
        limitTypes.add(2);
        limitTypes.add(3);
        limitTypes.add(5);
        limitTypes.add(6);
        limitTypes.add(2);
        limitTypes.add(3);
        limitTypes.add(5);
        sumConstructors.put(10, SumDoubleVectorAggregateFunction::new);
        sumConstructors.put(5, SumIntVectorAggregateFunction::new);
        sumConstructors.put(6, SumLongVectorAggregateFunction::new);
        sumConstructors.put(13, SumLong256VectorAggregateFunction::new);
        sumConstructors.put(7, SumDateVectorAggregateFunction::new);
        sumConstructors.put(8, SumTimestampVectorAggregateFunction::new);
        ksumConstructors.put(10, KSumDoubleVectorAggregateFunction::new);
        nsumConstructors.put(10, NSumDoubleVectorAggregateFunction::new);
        avgConstructors.put(10, AvgDoubleVectorAggregateFunction::new);
        avgConstructors.put(6, AvgLongVectorAggregateFunction::new);
        avgConstructors.put(8, AvgLongVectorAggregateFunction::new);
        avgConstructors.put(7, AvgLongVectorAggregateFunction::new);
        avgConstructors.put(5, AvgIntVectorAggregateFunction::new);
        minConstructors.put(10, MinDoubleVectorAggregateFunction::new);
        minConstructors.put(6, MinLongVectorAggregateFunction::new);
        minConstructors.put(7, MinDateVectorAggregateFunction::new);
        minConstructors.put(8, MinTimestampVectorAggregateFunction::new);
        minConstructors.put(5, MinIntVectorAggregateFunction::new);
        maxConstructors.put(10, MaxDoubleVectorAggregateFunction::new);
        maxConstructors.put(6, MaxLongVectorAggregateFunction::new);
        maxConstructors.put(7, MaxDateVectorAggregateFunction::new);
        maxConstructors.put(8, MaxTimestampVectorAggregateFunction::new);
        maxConstructors.put(5, MaxIntVectorAggregateFunction::new);
    }

    @FunctionalInterface
    public static interface FullFatJoinGenerator {
        public RecordCursorFactory create(CairoConfiguration var1, RecordMetadata var2, RecordCursorFactory var3, RecordCursorFactory var4, ColumnTypes var5, ColumnTypes var6, ColumnTypes var7, RecordSink var8, RecordSink var9, int var10, RecordValueSink var11, IntList var12);
    }
}

