/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin;

import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.FunctionFactoryCache;
import io.questdb.griffin.SqlException;
import io.questdb.std.Misc;
import io.questdb.std.str.StringSink;

public class FunctionFactoryDescriptor {
    private static final int ARRAY_MASK = Integer.MIN_VALUE;
    private static final int CONST_MASK = 0x40000000;
    private static final int TYPE_MASK = 0x3FFFFFFF;
    private final FunctionFactory factory;
    private final long[] argTypes;
    private final int sigArgCount;
    private final int openBraceIndex;

    public FunctionFactoryDescriptor(FunctionFactory factory) throws SqlException {
        this.factory = factory;
        String sig = factory.getSignature();
        this.openBraceIndex = FunctionFactoryDescriptor.validateSignatureAndGetNameSeparator(sig);
        int typeCount = 0;
        int i = this.openBraceIndex + 1;
        int n = sig.length() - 1;
        while (i < n) {
            char cc = sig.charAt(i);
            if (FunctionFactoryDescriptor.getArgType(cc) == -1) {
                throw SqlException.position(0).put("illegal argument type: ").put('`').put(cc).put('`');
            }
            if (++i < n && sig.charAt(i) == '[') {
                if (++i >= n || sig.charAt(i) != ']') {
                    throw SqlException.position(0).put("invalid array declaration");
                }
                ++i;
            }
            ++typeCount;
        }
        long[] types = new long[typeCount % 2 == 0 ? typeCount / 2 : typeCount / 2 + 1];
        int i2 = this.openBraceIndex + 1;
        int n2 = sig.length() - 1;
        int typeIndex = 0;
        while (i2 < n2) {
            char c = sig.charAt(i2);
            int type = FunctionFactoryDescriptor.getArgType(c);
            int arrayIndex = typeIndex / 2;
            int arrayValueOffset = typeIndex % 2 * 32;
            if (++i2 < n2 && sig.charAt(i2) == '[') {
                type |= Integer.MIN_VALUE;
                i2 += 2;
            }
            if ((c | 0x20) == c) {
                type |= 0x40000000;
            }
            int n3 = arrayIndex;
            types[n3] = types[n3] | FunctionFactoryDescriptor.toUnsignedLong(type) << 32 - arrayValueOffset;
            ++typeIndex;
        }
        this.argTypes = types;
        this.sigArgCount = typeCount;
    }

    private static long toUnsignedLong(int type) {
        return (long)type & 0xFFFFFFFFL;
    }

    public static int getArgType(char c) {
        int sigArgType;
        switch (c | 0x20) {
            case 100: {
                sigArgType = 10;
                break;
            }
            case 98: {
                sigArgType = 2;
                break;
            }
            case 101: {
                sigArgType = 3;
                break;
            }
            case 97: {
                sigArgType = 4;
                break;
            }
            case 102: {
                sigArgType = 9;
                break;
            }
            case 105: {
                sigArgType = 5;
                break;
            }
            case 108: {
                sigArgType = 6;
                break;
            }
            case 115: {
                sigArgType = 11;
                break;
            }
            case 116: {
                sigArgType = 1;
                break;
            }
            case 107: {
                sigArgType = 12;
                break;
            }
            case 109: {
                sigArgType = 7;
                break;
            }
            case 110: {
                sigArgType = 8;
                break;
            }
            case 117: {
                sigArgType = 18;
                break;
            }
            case 118: {
                sigArgType = 21;
                break;
            }
            case 99: {
                sigArgType = 20;
                break;
            }
            case 114: {
                sigArgType = 22;
                break;
            }
            case 104: {
                sigArgType = 13;
                break;
            }
            case 103: {
                sigArgType = 23;
                break;
            }
            case 111: {
                sigArgType = 28;
                break;
            }
            case 112: {
                sigArgType = 25;
                break;
            }
            case 113: {
                sigArgType = 26;
                break;
            }
            case 119: {
                sigArgType = 27;
                break;
            }
            case 106: {
                sigArgType = 24;
                break;
            }
            default: {
                sigArgType = -1;
            }
        }
        return sigArgType;
    }

    public static boolean isArray(int mask) {
        return (mask & Integer.MIN_VALUE) != 0;
    }

    public static boolean isConstant(int mask) {
        return (mask & 0x40000000) != 0;
    }

    public static short toType(int mask) {
        return (short)(mask & 0x3FFFFFFF);
    }

    public static int validateSignatureAndGetNameSeparator(String sig) throws SqlException {
        if (sig == null) {
            throw SqlException.$(0, "NULL signature");
        }
        int openBraceIndex = sig.indexOf(40);
        if (openBraceIndex == -1) {
            throw SqlException.$(0, "open brace expected");
        }
        if (openBraceIndex == 0) {
            throw SqlException.$(0, "empty function name");
        }
        if (sig.charAt(sig.length() - 1) != ')') {
            throw SqlException.$(0, "close brace expected");
        }
        char c = sig.charAt(0);
        if (c >= '0' && c <= '9') {
            throw SqlException.$(0, "name must not start with digit");
        }
        for (int i = 0; i < openBraceIndex; ++i) {
            char cc = sig.charAt(i);
            if (!FunctionFactoryCache.invalidFunctionNameChars.contains(cc)) continue;
            throw SqlException.position(0).put("invalid character: ").put(cc);
        }
        if (FunctionFactoryCache.invalidFunctionNames.keyIndex(sig, 0, openBraceIndex) < 0) {
            throw SqlException.position(0).put("invalid function name character: ").put(sig);
        }
        return openBraceIndex;
    }

    public static String replaceSignatureNameAndSwapArgs(String name, String signature) throws SqlException {
        int openBraceIndex = FunctionFactoryDescriptor.validateSignatureAndGetNameSeparator(signature);
        StringSink signatureBuilder = Misc.getThreadLocalBuilder();
        signatureBuilder.put(name);
        signatureBuilder.put('(');
        for (int i = signature.length() - 2; i > openBraceIndex; --i) {
            char curr = signature.charAt(i);
            if (curr == '[') {
                signatureBuilder.put("[]");
                continue;
            }
            if (curr == ']') continue;
            signatureBuilder.put(curr);
        }
        signatureBuilder.put(')');
        return signatureBuilder.toString();
    }

    public static String replaceSignatureName(String name, String signature) throws SqlException {
        int openBraceIndex = FunctionFactoryDescriptor.validateSignatureAndGetNameSeparator(signature);
        StringSink signatureBuilder = Misc.getThreadLocalBuilder();
        signatureBuilder.put(name);
        signatureBuilder.put(signature, openBraceIndex, signature.length());
        return signatureBuilder.toString();
    }

    public int getArgTypeMask(int index) {
        int arrayIndex = index / 2;
        long mask = this.argTypes[arrayIndex];
        return (int)(mask >>> 32 - index % 2 * 32);
    }

    public FunctionFactory getFactory() {
        return this.factory;
    }

    public String getName() {
        return this.factory.getSignature().substring(0, this.openBraceIndex);
    }

    public int getSigArgCount() {
        return this.sigArgCount;
    }
}

