/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin;

import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.sql.InsertOperation;
import io.questdb.cairo.sql.OperationFuture;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cutlass.text.TextLoader;
import io.questdb.griffin.CompiledQuery;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.ops.AbstractOperation;
import io.questdb.griffin.engine.ops.AlterOperation;
import io.questdb.griffin.engine.ops.DoneOperationFuture;
import io.questdb.griffin.engine.ops.OperationDispatcher;
import io.questdb.griffin.engine.ops.UpdateOperation;
import io.questdb.mp.SCSequence;
import io.questdb.std.Chars;
import org.jetbrains.annotations.Nullable;

public class CompiledQueryImpl
implements CompiledQuery {
    private RecordCursorFactory recordCursorFactory;
    private InsertOperation insertOperation;
    private UpdateOperation updateOperation;
    private AlterOperation alterOperation;
    private TextLoader textLoader;
    private short type;
    private SqlExecutionContext sqlExecutionContext;
    private final DoneOperationFuture doneFuture = new DoneOperationFuture();
    private final OperationDispatcher<UpdateOperation> updateOperationDispatcher;
    private final OperationDispatcher<AlterOperation> alterOperationDispatcher;
    private long affectedRowsCount;
    private CharSequence statementName;

    public CompiledQueryImpl(CairoEngine engine) {
        this.updateOperationDispatcher = new OperationDispatcher(engine, "sync 'UPDATE' execution");
        this.alterOperationDispatcher = new OperationDispatcher(engine, "Alter table execute");
    }

    @Override
    public RecordCursorFactory getRecordCursorFactory() {
        return this.recordCursorFactory;
    }

    @Override
    public InsertOperation getInsertOperation() {
        return this.insertOperation;
    }

    @Override
    public TextLoader getTextLoader() {
        return this.textLoader;
    }

    @Override
    public AlterOperation getAlterOperation() {
        return this.alterOperation;
    }

    @Override
    public short getType() {
        return this.type;
    }

    @Override
    public UpdateOperation getUpdateOperation() {
        return this.updateOperation;
    }

    public CompiledQuery ofUpdate(UpdateOperation updateOperation) {
        this.updateOperation = updateOperation;
        this.type = (short)14;
        return this;
    }

    @Override
    public OperationFuture execute(SCSequence eventSubSeq) throws SqlException {
        switch (this.type) {
            case 2: {
                return this.insertOperation.execute(this.sqlExecutionContext);
            }
            case 14: {
                throw SqlException.$(0, "UPDATE execution is not supported via careless invocation. UpdateOperation is allocating.");
            }
            case 4: {
                return this.alterOperationDispatcher.execute(this.alterOperation, this.sqlExecutionContext, eventSubSeq);
            }
        }
        return this.doneFuture.of(0L);
    }

    @Override
    public <T extends AbstractOperation> OperationDispatcher<T> getDispatcher() {
        switch (this.type) {
            case 4: {
                return this.alterOperationDispatcher;
            }
            case 14: {
                return this.updateOperationDispatcher;
            }
        }
        return null;
    }

    @Override
    public <T extends AbstractOperation> T getOperation() {
        switch (this.type) {
            case 2: {
                return (T)((AbstractOperation)((Object)this.insertOperation));
            }
            case 14: {
                return (T)this.updateOperation;
            }
            case 4: {
                return (T)this.alterOperation;
            }
        }
        return null;
    }

    @Override
    public long getAffectedRowsCount() {
        return this.affectedRowsCount;
    }

    @Override
    public CharSequence getStatementName() {
        return this.statementName;
    }

    public CompiledQuery of(short type) {
        return this.of(type, null);
    }

    public CompiledQuery ofLock() {
        this.type = (short)15;
        return this;
    }

    public CompiledQuery ofUnlock() {
        this.type = (short)16;
        return this;
    }

    @Override
    public CompiledQueryImpl withContext(SqlExecutionContext sqlExecutionContext) {
        this.sqlExecutionContext = sqlExecutionContext;
        return this;
    }

    CompiledQuery of(RecordCursorFactory recordCursorFactory) {
        return this.of((short)1, recordCursorFactory);
    }

    private CompiledQuery of(short type, RecordCursorFactory factory) {
        this.type = type;
        this.recordCursorFactory = factory;
        this.affectedRowsCount = -1L;
        return this;
    }

    CompiledQuery ofAlter(AlterOperation statement) {
        this.of((short)4);
        this.alterOperation = statement;
        return this;
    }

    CompiledQuery ofBackupTable() {
        return this.of((short)13);
    }

    CompiledQuery ofCopyLocal(@Nullable RecordCursorFactory factory) {
        this.type = (short)8;
        this.recordCursorFactory = factory;
        this.affectedRowsCount = -1L;
        return this;
    }

    CompiledQuery ofCopyRemote(TextLoader textLoader) {
        this.textLoader = textLoader;
        return this.of((short)11);
    }

    CompiledQuery ofCreateTable() {
        return this.of((short)9);
    }

    CompiledQuery ofCreateTableAsSelect(long affectedRowsCount) {
        this.of((short)21);
        this.affectedRowsCount = affectedRowsCount;
        return this;
    }

    CompiledQuery ofDrop() {
        return this.of((short)7);
    }

    CompiledQuery ofInsert(InsertOperation insertOperation) {
        this.insertOperation = insertOperation;
        return this.of((short)2);
    }

    CompiledQuery ofInsertAsSelect(long affectedRowsCount) {
        this.of((short)10);
        this.affectedRowsCount = affectedRowsCount;
        return this;
    }

    CompiledQuery ofRenameTable() {
        return this.of((short)12);
    }

    CompiledQuery ofRepair() {
        return this.of((short)5);
    }

    CompiledQuery ofSet() {
        return this.of((short)6);
    }

    CompiledQuery ofBegin() {
        return this.of((short)18);
    }

    CompiledQuery ofCommit() {
        return this.of((short)19);
    }

    CompiledQuery ofRollback() {
        return this.of((short)20);
    }

    CompiledQuery ofTruncate() {
        return this.of((short)3);
    }

    CompiledQuery ofVacuum() {
        return this.of((short)17);
    }

    CompiledQuery ofSnapshotPrepare() {
        return this.of((short)22);
    }

    CompiledQuery ofSnapshotComplete() {
        return this.of((short)23);
    }

    CompiledQuery ofDeallocate(CharSequence statementName) {
        this.statementName = Chars.toString(statementName);
        return this.of((short)24);
    }
}

