/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.pgwire;

import io.questdb.Metrics;
import io.questdb.cairo.CairoEngine;
import io.questdb.cutlass.pgwire.BadProtocolException;
import io.questdb.cutlass.pgwire.PGConnectionContext;
import io.questdb.cutlass.pgwire.PGWireConfiguration;
import io.questdb.cutlass.pgwire.TypesAndSelect;
import io.questdb.cutlass.pgwire.TypesAndUpdate;
import io.questdb.griffin.DatabaseSnapshotAgent;
import io.questdb.griffin.FunctionFactoryCache;
import io.questdb.griffin.SqlCompiler;
import io.questdb.network.PeerDisconnectedException;
import io.questdb.network.PeerIsSlowToReadException;
import io.questdb.network.PeerIsSlowToWriteException;
import io.questdb.std.AssociativeCache;
import io.questdb.std.Misc;
import io.questdb.std.WeakSelfReturningObjectPool;
import java.io.Closeable;

public class PGJobContext
implements Closeable {
    private final SqlCompiler compiler;
    private final AssociativeCache<TypesAndSelect> typesAndSelectCache;
    private final WeakSelfReturningObjectPool<TypesAndSelect> typesAndSelectPool;
    private final AssociativeCache<TypesAndUpdate> typesAndUpdateCache;
    private final WeakSelfReturningObjectPool<TypesAndUpdate> typesAndUpdatePool;

    public PGJobContext(PGWireConfiguration configuration, CairoEngine engine, FunctionFactoryCache functionFactoryCache, DatabaseSnapshotAgent snapshotAgent) {
        this.compiler = new SqlCompiler(engine, functionFactoryCache, snapshotAgent);
        Metrics metrics = engine.getMetrics();
        boolean enableSelectCache = configuration.isSelectCacheEnabled();
        int blockCount = enableSelectCache ? configuration.getSelectCacheBlockCount() : 1;
        int rowCount = enableSelectCache ? configuration.getSelectCacheRowCount() : 1;
        this.typesAndSelectCache = new AssociativeCache(blockCount, rowCount, metrics.pgWire().cachedSelectsGauge());
        this.typesAndSelectPool = new WeakSelfReturningObjectPool<TypesAndSelect>(TypesAndSelect::new, blockCount * rowCount);
        boolean enabledUpdateCache = configuration.isUpdateCacheEnabled();
        int updateBlockCount = enabledUpdateCache ? configuration.getUpdateCacheBlockCount() : 1;
        int updateRowCount = enabledUpdateCache ? configuration.getUpdateCacheRowCount() : 1;
        this.typesAndUpdateCache = new AssociativeCache(updateBlockCount, updateRowCount, metrics.pgWire().cachedUpdatesGauge());
        this.typesAndUpdatePool = new WeakSelfReturningObjectPool<TypesAndUpdate>(parent -> new TypesAndUpdate(parent, engine), updateBlockCount * updateRowCount);
    }

    @Override
    public void close() {
        Misc.free(this.compiler);
        Misc.free(this.typesAndSelectCache);
        Misc.free(this.typesAndUpdateCache);
    }

    public void handleClientOperation(PGConnectionContext context, int operation) throws PeerIsSlowToWriteException, PeerIsSlowToReadException, PeerDisconnectedException, BadProtocolException {
        context.handleClientOperation(this.compiler, this.typesAndSelectCache, this.typesAndSelectPool, this.typesAndUpdateCache, this.typesAndUpdatePool, operation);
    }

    public void flushQueryCache() {
        this.typesAndSelectCache.clear();
        this.typesAndUpdateCache.clear();
    }
}

