/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.pgwire;

import io.questdb.cairo.CairoSecurityContext;
import io.questdb.cairo.security.AllowAllCairoSecurityContext;
import io.questdb.cairo.security.CairoSecurityContextImpl;
import io.questdb.cutlass.pgwire.AuthenticationException;
import io.questdb.cutlass.pgwire.BadProtocolException;
import io.questdb.cutlass.pgwire.PGAuthenticator;
import io.questdb.cutlass.pgwire.PGConnectionContext;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.Chars;
import io.questdb.std.str.DirectByteCharSequence;

public class PGBasicAuthenticator
implements PGAuthenticator {
    private static final Log LOG = LogFactory.getLog(PGBasicAuthenticator.class);
    private final String username;
    private final String password;
    private final DirectByteCharSequence dbcs = new DirectByteCharSequence();
    private final CairoSecurityContext securityContext;

    public PGBasicAuthenticator(String username, String password, boolean readOnlyContext) {
        this.username = username;
        this.password = password;
        this.securityContext = readOnlyContext ? new CairoSecurityContextImpl(false) : AllowAllCairoSecurityContext.INSTANCE;
    }

    @Override
    public CairoSecurityContext authenticate(CharSequence username, long msg, long msgLimit) throws BadProtocolException, AuthenticationException {
        if (Chars.equals((CharSequence)this.username, username)) {
            long hi = PGConnectionContext.getStringLength(msg, msgLimit, "bad password length");
            this.dbcs.of(msg, hi);
            if (Chars.equals((CharSequence)this.password, this.dbcs)) {
                return this.securityContext;
            }
            LOG.error().$("invalid password [user=").$(username).$(']').$();
        } else {
            LOG.error().$("invalid user [").$(username).$(']').$();
        }
        throw AuthenticationException.INSTANCE;
    }
}

