/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.line.tcp;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.CommitFailedException;
import io.questdb.cairo.TableReader;
import io.questdb.cairo.TableReaderMetadata;
import io.questdb.cairo.TableWriter;
import io.questdb.cairo.TableWriterMetadata;
import io.questdb.cairo.TxReader;
import io.questdb.cairo.security.AllowAllCairoSecurityContext;
import io.questdb.cairo.sql.SymbolLookup;
import io.questdb.cutlass.line.tcp.DefaultColumnTypes;
import io.questdb.cutlass.line.tcp.LineTcpReceiverConfiguration;
import io.questdb.cutlass.line.tcp.LineTcpUtils;
import io.questdb.cutlass.line.tcp.NetworkIOJob;
import io.questdb.cutlass.line.tcp.SymbolCache;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.BoolList;
import io.questdb.std.CharSequenceIntHashMap;
import io.questdb.std.FilesFacade;
import io.questdb.std.IntList;
import io.questdb.std.LowerCaseCharSequenceHashSet;
import io.questdb.std.Misc;
import io.questdb.std.Numbers;
import io.questdb.std.ObjList;
import io.questdb.std.datetime.millitime.MillisecondClock;
import io.questdb.std.str.DirectByteCharSequence;
import io.questdb.std.str.Path;
import io.questdb.std.str.StringSink;
import java.io.Closeable;

public class TableUpdateDetails
implements Closeable {
    private static final Log LOG = LogFactory.getLog(TableUpdateDetails.class);
    private static final SymbolLookup NOT_FOUND_LOOKUP = value -> -2;
    private final DefaultColumnTypes defaultColumnTypes;
    private final String tableNameUtf16;
    private final ThreadLocalDetails[] localDetailsArray;
    private final int timestampIndex;
    private final CairoEngine engine;
    private final MillisecondClock millisecondClock;
    private final long writerTickRowsCountMod;
    private int writerThreadId;
    private long eventsProcessedSinceReshuffle = 0L;
    private TableWriter writer;
    private boolean assignedToJob = false;
    private long lastMeasurementMillis = Long.MAX_VALUE;
    private long nextCommitTime;
    private int networkIOOwnerCount = 0;
    private volatile boolean writerInError;

    TableUpdateDetails(LineTcpReceiverConfiguration configuration, CairoEngine engine, TableWriter writer, int writerThreadId, NetworkIOJob[] netIoJobs, DefaultColumnTypes defaultColumnTypes) {
        this.writerThreadId = writerThreadId;
        this.engine = engine;
        this.defaultColumnTypes = defaultColumnTypes;
        int n = netIoJobs.length;
        this.localDetailsArray = new ThreadLocalDetails[n];
        for (int i = 0; i < n; ++i) {
            this.localDetailsArray[i] = new ThreadLocalDetails(configuration, netIoJobs[i].getUnusedSymbolCaches(), writer.getMetadata().getColumnCount());
        }
        CairoConfiguration cairoConfiguration = engine.getConfiguration();
        TableWriterMetadata metadata = writer.getMetadata();
        this.millisecondClock = cairoConfiguration.getMillisecondClock();
        this.writerTickRowsCountMod = cairoConfiguration.getWriterTickRowsCountMod();
        this.writer = writer;
        this.timestampIndex = metadata.getTimestampIndex();
        this.tableNameUtf16 = writer.getTableName();
        writer.updateCommitInterval(configuration.getCommitIntervalFraction(), configuration.getCommitIntervalDefault());
        this.nextCommitTime = this.millisecondClock.getTicks() + writer.getCommitInterval();
    }

    public void addReference(int workerId) {
        ++this.networkIOOwnerCount;
        LOG.info().$("network IO thread using table [workerId=").$(workerId).$(", tableName=").$(this.tableNameUtf16).$(", nNetworkIoWorkers=").$(this.networkIOOwnerCount).$(']').$();
    }

    public boolean isWriterInError() {
        return this.writerInError;
    }

    public void setWriterInError() {
        this.writerInError = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        TableUpdateDetails tableUpdateDetails = this;
        synchronized (tableUpdateDetails) {
            this.closeNoLock();
        }
    }

    public void closeLocals() {
        for (int n = 0; n < this.localDetailsArray.length; ++n) {
            LOG.info().$("closing table parsers [tableName=").$(this.tableNameUtf16).$(']').$();
            this.localDetailsArray[n] = Misc.free(this.localDetailsArray[n]);
        }
    }

    public void closeNoLock() {
        if (this.writerThreadId != Integer.MIN_VALUE) {
            LOG.info().$("closing table writer [tableName=").$(this.tableNameUtf16).$(']').$();
            this.closeLocals();
            if (null != this.writer) {
                try {
                    if (!this.writerInError) {
                        this.writer.commit();
                    }
                }
                catch (Throwable ex) {
                    LOG.error().$("cannot commit writer transaction, rolling back before releasing it [table=").$(this.tableNameUtf16).$(",ex=").$(ex).I$();
                }
                finally {
                    this.writer = Misc.free(this.writer);
                }
            }
            this.writerThreadId = Integer.MIN_VALUE;
        }
    }

    public long getEventsProcessedSinceReshuffle() {
        return this.eventsProcessedSinceReshuffle;
    }

    public long getLastMeasurementMillis() {
        return this.lastMeasurementMillis;
    }

    public int getNetworkIOOwnerCount() {
        return this.networkIOOwnerCount;
    }

    public String getTableNameUtf16() {
        return this.tableNameUtf16;
    }

    public int getWriterThreadId() {
        return this.writerThreadId;
    }

    public void incrementEventsProcessedSinceReshuffle() {
        ++this.eventsProcessedSinceReshuffle;
    }

    public boolean isAssignedToJob() {
        return this.assignedToJob;
    }

    public void setAssignedToJob(boolean assignedToJob) {
        this.assignedToJob = assignedToJob;
    }

    public void removeReference(int workerId) {
        --this.networkIOOwnerCount;
        this.localDetailsArray[workerId].clear();
        LOG.info().$("network IO thread released table [workerId=").$(workerId).$(", tableName=").$(this.tableNameUtf16).$(", nNetworkIoWorkers=").$(this.networkIOOwnerCount).I$();
    }

    public void tick() {
        if (this.writer != null) {
            this.writer.tick();
        }
    }

    private void commit(boolean withLag) throws CommitFailedException {
        if (this.writer.getUncommittedRowCount() > 0L) {
            try {
                LOG.debug().$("time-based commit " + (withLag ? "with lag " : "") + "[rows=").$(this.writer.getUncommittedRowCount()).$(", table=").$(this.tableNameUtf16).I$();
                if (withLag) {
                    this.writer.commitWithLag();
                } else {
                    this.writer.commit();
                }
            }
            catch (Throwable ex) {
                this.setWriterInError();
                LOG.error().$("could not commit [table=").$(this.tableNameUtf16).$(", e=").$(ex).I$();
                try {
                    this.writer.rollback();
                }
                catch (Throwable th) {
                    LOG.error().$("could not perform emergency rollback [table=").$(this.tableNameUtf16).$(", e=").$(th).I$();
                }
                throw CommitFailedException.instance(ex);
            }
        }
    }

    long commitIfIntervalElapsed(long wallClockMillis) throws CommitFailedException {
        if (wallClockMillis < this.nextCommitTime) {
            return this.nextCommitTime;
        }
        if (this.writer != null) {
            long commitInterval = this.writer.getCommitInterval();
            this.commit(wallClockMillis - this.lastMeasurementMillis < commitInterval);
            this.nextCommitTime += commitInterval;
        }
        return this.nextCommitTime;
    }

    void commitIfMaxUncommittedRowsCountReached() throws CommitFailedException {
        long rowsSinceCommit = this.writer.getUncommittedRowCount();
        if (rowsSinceCommit < (long)this.writer.getMetadata().getMaxUncommittedRows()) {
            if ((rowsSinceCommit & this.writerTickRowsCountMod) == 0L) {
                this.writer.tick();
            }
            return;
        }
        LOG.debug().$("max-uncommitted-rows commit with lag [").$(this.tableNameUtf16).I$();
        this.nextCommitTime = this.millisecondClock.getTicks() + this.writer.getCommitInterval();
        try {
            this.writer.commitWithLag();
        }
        catch (Throwable th) {
            LOG.error().$("could not commit line protocol measurement [tableName=").$(this.writer.getTableName()).$(", message=").$(th.getMessage()).$(th).I$();
            this.writer.rollback();
            throw CommitFailedException.instance(th);
        }
        this.writer.tick();
    }

    ThreadLocalDetails getThreadLocalDetails(int workerId) {
        this.lastMeasurementMillis = this.millisecondClock.getTicks();
        return this.localDetailsArray[workerId];
    }

    int getTimestampIndex() {
        return this.timestampIndex;
    }

    TableWriter getWriter() {
        return this.writer;
    }

    void releaseWriter(boolean commit) {
        if (this.writer != null) {
            try {
                if (commit) {
                    LOG.debug().$("release commit [table=").$(this.tableNameUtf16).I$();
                    this.writer.commit();
                }
            }
            catch (Throwable ex) {
                LOG.error().$("writer commit fails, force closing it [table=").$(this.tableNameUtf16).$(",ex=").$(ex).I$();
            }
            finally {
                this.writer = Misc.free(this.writer);
            }
        }
    }

    public class ThreadLocalDetails
    implements Closeable {
        static final int COLUMN_NOT_FOUND = -1;
        static final int DUPLICATED_COLUMN = -2;
        private final Path path = new Path();
        private final CharSequenceIntHashMap columnIndexByNameUtf8 = new CharSequenceIntHashMap();
        private final CharSequenceIntHashMap columnTypeByNameUtf8 = new CharSequenceIntHashMap();
        private final ObjList<SymbolCache> symbolCacheByColumnIndex = new ObjList();
        private final ObjList<SymbolCache> unusedSymbolCaches;
        private final IntList columnTypeMeta = new IntList();
        private final IntList columnTypes = new IntList();
        private final StringSink tempSink = new StringSink();
        private final BoolList processedCols = new BoolList();
        private final LowerCaseCharSequenceHashSet addedColsUtf16 = new LowerCaseCharSequenceHashSet();
        private final LineTcpReceiverConfiguration configuration;
        private int columnCount;
        private String colName;
        private TxReader txReader;
        private boolean clean = true;
        private String symbolNameTemp;

        ThreadLocalDetails(LineTcpReceiverConfiguration configuration, ObjList<SymbolCache> unusedSymbolCaches, int columnCount) {
            this.configuration = configuration;
            this.unusedSymbolCaches = unusedSymbolCaches;
            this.columnCount = columnCount;
            this.columnTypeMeta.add(0);
        }

        @Override
        public void close() {
            Misc.freeObjList(this.symbolCacheByColumnIndex);
            Misc.free(this.path);
            this.txReader = Misc.free(this.txReader);
        }

        private SymbolCache addSymbolCache(int colWriterIndex) {
            try (TableReader reader = TableUpdateDetails.this.engine.getReader(AllowAllCairoSecurityContext.INSTANCE, TableUpdateDetails.this.tableNameUtf16);){
                SymbolCache symCache;
                int symIndex = this.resolveSymbolIndexAndName(reader.getMetadata(), colWriterIndex);
                if (this.symbolNameTemp == null || symIndex < 0) {
                    throw CairoException.critical(0).put(reader.getMetadata().getColumnName(colWriterIndex)).put(" cannot find symbol column name by writer index ").put(colWriterIndex);
                }
                this.path.of(TableUpdateDetails.this.engine.getConfiguration().getRoot()).concat(TableUpdateDetails.this.tableNameUtf16);
                int lastUnusedSymbolCacheIndex = this.unusedSymbolCaches.size() - 1;
                if (lastUnusedSymbolCacheIndex > -1) {
                    symCache = this.unusedSymbolCaches.get(lastUnusedSymbolCacheIndex);
                    this.unusedSymbolCaches.remove(lastUnusedSymbolCacheIndex);
                } else {
                    symCache = new SymbolCache(this.configuration);
                }
                FilesFacade filesFacade = TableUpdateDetails.this.engine.getConfiguration().getFilesFacade();
                if (this.clean) {
                    if (this.txReader == null) {
                        this.txReader = new TxReader(filesFacade);
                    }
                    int pathLen = this.path.length();
                    this.txReader.ofRO(this.path.concat("_txn").$(), reader.getPartitionedBy());
                    this.path.trimTo(pathLen);
                    this.clean = false;
                }
                long columnNameTxn = reader.getColumnVersionReader().getDefaultColumnNameTxn(colWriterIndex);
                assert (symIndex <= colWriterIndex);
                symCache.of(TableUpdateDetails.this.engine.getConfiguration(), this.path, this.symbolNameTemp, symIndex, this.txReader, columnNameTxn);
                this.symbolCacheByColumnIndex.extendAndSet(colWriterIndex, symCache);
                SymbolCache symbolCache = symCache;
                return symbolCache;
            }
        }

        void clear() {
            this.columnIndexByNameUtf8.clear();
            this.columnTypeByNameUtf8.clear();
            int sz = this.symbolCacheByColumnIndex.size();
            for (int n = 0; n < sz; ++n) {
                SymbolCache symCache = this.symbolCacheByColumnIndex.getQuick(n);
                if (null == symCache) continue;
                symCache.close();
                this.unusedSymbolCaches.add(symCache);
            }
            this.symbolCacheByColumnIndex.clear();
            this.columnTypes.clear();
            this.columnTypeMeta.clear();
            this.columnTypeMeta.add(0);
            if (this.txReader != null) {
                this.txReader.clear();
            }
            this.clean = true;
        }

        String getColName() {
            assert (this.colName != null);
            return this.colName;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        int getColumnIndex(DirectByteCharSequence colNameUtf8, boolean hasNonAsciiChars) {
            int colWriterIndex = this.columnIndexByNameUtf8.get(colNameUtf8);
            if (colWriterIndex < 0) {
                CharSequence colNameUtf16 = LineTcpUtils.utf8ToUtf16(colNameUtf8, this.tempSink, hasNonAsciiChars);
                int index = this.addedColsUtf16.keyIndex(colNameUtf16);
                if (index <= -1) return -2;
                colWriterIndex = this.getColumnWriterIndexFromReader(colNameUtf16);
                if (colWriterIndex > -1) {
                    this.columnIndexByNameUtf8.put(LineTcpUtils.utf8BytesToString(colNameUtf8, this.tempSink), colWriterIndex);
                } else {
                    this.colName = colNameUtf16.toString();
                    this.addedColsUtf16.addAt(index, this.colName);
                    return -1;
                }
            }
            if (!this.processedCols.extendAndReplace(colWriterIndex, true)) return colWriterIndex;
            return -2;
        }

        private int getColumnWriterIndexFromReader(CharSequence colNameUtf16) {
            try (TableReader reader = TableUpdateDetails.this.engine.getReader(AllowAllCairoSecurityContext.INSTANCE, TableUpdateDetails.this.tableNameUtf16);){
                TableReaderMetadata metadata = reader.getMetadata();
                int colIndex = metadata.getColumnIndexQuiet(colNameUtf16);
                if (colIndex < 0) {
                    int n = colIndex;
                    return n;
                }
                int writerColIndex = metadata.getWriterIndex(colIndex);
                this.updateColumnTypeCache(colIndex, writerColIndex, metadata);
                int n = writerColIndex;
                return n;
            }
        }

        int getColumnType(int colIndex) {
            return this.columnTypes.getQuick(colIndex);
        }

        int getColumnType(String colName, byte entityType) {
            int colType = this.columnTypeByNameUtf8.get(colName);
            if (colType < 0) {
                colType = ((TableUpdateDetails)TableUpdateDetails.this).defaultColumnTypes.DEFAULT_COLUMN_TYPES[entityType];
                this.columnTypeByNameUtf8.put(colName, colType);
            }
            return colType;
        }

        private int resolveSymbolIndexAndName(TableReaderMetadata metadata, int colWriterIndex) {
            this.symbolNameTemp = null;
            int symIndex = -1;
            int n = metadata.getColumnCount();
            for (int i = 0; i < n; ++i) {
                if (metadata.getWriterIndex(i) == colWriterIndex) {
                    if (!ColumnType.isSymbol(metadata.getColumnType(i))) {
                        return -1;
                    }
                    ++symIndex;
                    this.symbolNameTemp = metadata.getColumnName(i);
                    break;
                }
                if (!ColumnType.isSymbol(metadata.getColumnType(i))) continue;
                ++symIndex;
            }
            return symIndex;
        }

        int getColumnTypeMeta(int colIndex) {
            return this.columnTypeMeta.getQuick(colIndex + 1);
        }

        SymbolLookup getSymbolLookup(int columnIndex) {
            if (columnIndex > -1) {
                SymbolCache symCache = this.symbolCacheByColumnIndex.getQuiet(columnIndex);
                if (symCache != null) {
                    return symCache;
                }
                return this.addSymbolCache(columnIndex);
            }
            return NOT_FOUND_LOOKUP;
        }

        void resetProcessedColumnsTracking() {
            this.processedCols.setAll(this.columnCount, false);
            this.addedColsUtf16.clear();
        }

        private void updateColumnTypeCache(int colIndex, int writerColIndex, TableReaderMetadata metadata) {
            this.columnCount = metadata.getColumnCount();
            int colType = metadata.getColumnType(colIndex);
            int geoHashBits = ColumnType.getGeoHashBits(colType);
            this.columnTypes.extendAndSet(writerColIndex, colType);
            this.columnTypeMeta.extendAndSet(writerColIndex + 1, geoHashBits == 0 ? 0 : Numbers.encodeLowHighShorts((short)geoHashBits, ColumnType.tagOf(colType)));
        }
    }
}

