/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.line.tcp;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.TableStructure;
import io.questdb.cairo.TableUtils;
import io.questdb.cutlass.line.tcp.DefaultColumnTypes;
import io.questdb.cutlass.line.tcp.LineTcpParser;
import io.questdb.cutlass.line.tcp.LineTcpUtils;
import io.questdb.std.Chars;
import io.questdb.std.LowerCaseCharSequenceHashSet;
import io.questdb.std.ObjList;
import io.questdb.std.ThreadLocal;
import io.questdb.std.str.DirectByteCharSequence;
import io.questdb.std.str.StringSink;

class TableStructureAdapter
implements TableStructure {
    private static final String DEFAULT_TIMESTAMP_FIELD = "timestamp";
    private final ThreadLocal<StringSink> tempSink = new ThreadLocal<StringSink>(StringSink::new);
    private final LowerCaseCharSequenceHashSet entityNamesUtf16 = new LowerCaseCharSequenceHashSet();
    private final ObjList<LineTcpParser.ProtoEntity> entities = new ObjList();
    private final CairoConfiguration cairoConfiguration;
    private final DefaultColumnTypes defaultColumnTypes;
    private final int defaultPartitionBy;
    private CharSequence tableName;
    private int timestampIndex = -1;

    public TableStructureAdapter(CairoConfiguration configuration, DefaultColumnTypes defaultColumnTypes, int defaultPartitionBy) {
        this.cairoConfiguration = configuration;
        this.defaultColumnTypes = defaultColumnTypes;
        this.defaultPartitionBy = defaultPartitionBy;
    }

    @Override
    public int getColumnCount() {
        int size = this.entities.size();
        return this.timestampIndex == -1 ? size + 1 : size;
    }

    @Override
    public CharSequence getColumnName(int columnIndex) {
        assert (columnIndex < this.getColumnCount());
        if (columnIndex == this.getTimestampIndex()) {
            return DEFAULT_TIMESTAMP_FIELD;
        }
        String colName = this.entities.get(columnIndex).getName().toString();
        if (TableUtils.isValidColumnName(colName, this.cairoConfiguration.getMaxFileNameLength())) {
            return colName;
        }
        throw CairoException.nonCritical().put("column name contains invalid characters [colName=").put(colName).put(']');
    }

    @Override
    public int getColumnType(int columnIndex) {
        if (columnIndex == this.getTimestampIndex()) {
            return 8;
        }
        return this.defaultColumnTypes.DEFAULT_COLUMN_TYPES[this.entities.get(columnIndex).getType()];
    }

    @Override
    public long getColumnHash(int columnIndex) {
        return this.cairoConfiguration.getRandom().nextLong();
    }

    @Override
    public int getIndexBlockCapacity(int columnIndex) {
        return 0;
    }

    @Override
    public boolean isIndexed(int columnIndex) {
        return false;
    }

    @Override
    public boolean isSequential(int columnIndex) {
        return false;
    }

    @Override
    public int getPartitionBy() {
        return this.defaultPartitionBy;
    }

    @Override
    public boolean getSymbolCacheFlag(int columnIndex) {
        return this.cairoConfiguration.getDefaultSymbolCacheFlag();
    }

    @Override
    public int getSymbolCapacity(int columnIndex) {
        return this.cairoConfiguration.getDefaultSymbolCapacity();
    }

    @Override
    public CharSequence getTableName() {
        return this.tableName;
    }

    @Override
    public int getTimestampIndex() {
        return this.timestampIndex == -1 ? this.entities.size() : this.timestampIndex;
    }

    @Override
    public int getMaxUncommittedRows() {
        return this.cairoConfiguration.getMaxUncommittedRows();
    }

    @Override
    public long getCommitLag() {
        return this.cairoConfiguration.getCommitLag();
    }

    @Override
    public boolean isWallEnabled() {
        return this.cairoConfiguration.getWallEnabledDefault();
    }

    TableStructureAdapter of(CharSequence tableName, LineTcpParser parser) {
        this.tableName = tableName;
        this.entityNamesUtf16.clear();
        this.entities.clear();
        boolean hasNonAsciiChars = parser.hasNonAsciiChars();
        for (int i = 0; i < parser.getEntityCount(); ++i) {
            LineTcpParser.ProtoEntity entity = parser.getEntity(i);
            DirectByteCharSequence colNameUtf8 = entity.getName();
            CharSequence colNameUtf16 = LineTcpUtils.utf8ToUtf16(colNameUtf8, this.tempSink.get(), hasNonAsciiChars);
            int index = this.entityNamesUtf16.keyIndex(colNameUtf16);
            if (index <= -1) continue;
            this.entityNamesUtf16.addAt(index, colNameUtf16.toString());
            if (Chars.equals(colNameUtf16, DEFAULT_TIMESTAMP_FIELD)) {
                this.timestampIndex = this.entities.size();
            }
            this.entities.add(entity);
        }
        return this;
    }
}

