/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.line.tcp;

import io.questdb.Metrics;
import io.questdb.cutlass.line.tcp.LineTcpMeasurementEvent;
import io.questdb.cutlass.line.tcp.LineTcpMeasurementScheduler;
import io.questdb.cutlass.line.tcp.TableUpdateDetails;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.mp.Job;
import io.questdb.mp.RingQueue;
import io.questdb.mp.Sequence;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;
import io.questdb.std.Os;
import io.questdb.std.datetime.millitime.MillisecondClock;
import io.questdb.std.str.Path;
import java.io.Closeable;

class LineTcpWriterJob
implements Job,
Closeable {
    private static final Log LOG = LogFactory.getLog(LineTcpWriterJob.class);
    private final int workerId;
    private final RingQueue<LineTcpMeasurementEvent> queue;
    private final Sequence sequence;
    private final Path path = new Path();
    private final ObjList<TableUpdateDetails> assignedTables = new ObjList();
    private final MillisecondClock millisecondClock;
    private final long commitIntervalDefault;
    private final LineTcpMeasurementScheduler scheduler;
    private long nextCommitTime;
    private final Metrics metrics;

    LineTcpWriterJob(int workerId, RingQueue<LineTcpMeasurementEvent> queue, Sequence sequence, MillisecondClock millisecondClock, long commitIntervalDefault, LineTcpMeasurementScheduler scheduler, Metrics metrics) {
        this.workerId = workerId;
        this.queue = queue;
        this.sequence = sequence;
        this.millisecondClock = millisecondClock;
        this.commitIntervalDefault = commitIntervalDefault;
        this.nextCommitTime = millisecondClock.getTicks();
        this.scheduler = scheduler;
        this.metrics = metrics;
    }

    @Override
    public void close() {
        LOG.info().$("line protocol writer closing [threadId=").$(this.workerId).$(']').$();
        for (int n = 0; n < this.queue.getCycle() && this.run(this.workerId); ++n) {
        }
        Misc.free(this.path);
        Misc.freeObjList(this.assignedTables);
        this.assignedTables.clear();
    }

    @Override
    public boolean run(int workerId) {
        assert (this.workerId == workerId);
        boolean busy = this.drainQueue();
        if (!busy) {
            this.commitTables();
            this.tickWriters();
        }
        return busy;
    }

    private void commitTables() {
        long wallClockMillis = this.millisecondClock.getTicks();
        if (wallClockMillis > this.nextCommitTime) {
            long minTableNextCommitTime = Long.MAX_VALUE;
            int sz = this.assignedTables.size();
            for (int n = 0; n < sz; ++n) {
                try {
                    long tableNextCommitTime = this.assignedTables.getQuick(n).commitIfIntervalElapsed(wallClockMillis);
                    if (tableNextCommitTime >= minTableNextCommitTime) continue;
                    minTableNextCommitTime = tableNextCommitTime;
                    continue;
                }
                catch (Throwable ex) {
                    LOG.critical().$("commit failed [table=").$(this.assignedTables.getQuick(n).getTableNameUtf16()).$(",ex=").$(ex).I$();
                    this.metrics.healthCheck().incrementUnhandledErrors();
                }
            }
            this.nextCommitTime = minTableNextCommitTime != Long.MAX_VALUE ? minTableNextCommitTime : wallClockMillis + this.commitIntervalDefault;
        }
    }

    private boolean drainQueue() {
        boolean busy = false;
        while (true) {
            long cursor;
            if ((cursor = this.sequence.next()) < 0L) {
                if (cursor == -1L) {
                    return busy;
                }
                Os.pause();
                continue;
            }
            busy = true;
            LineTcpMeasurementEvent event = this.queue.get(cursor);
            try {
                boolean closeWriter;
                TableUpdateDetails tab;
                block13: {
                    tab = event.getTableUpdateDetails();
                    closeWriter = false;
                    if (event.getWriterWorkerId() == this.workerId) {
                        try {
                            if (tab.isWriterInError()) {
                                closeWriter = true;
                                break block13;
                            }
                            if (!tab.isAssignedToJob()) {
                                this.assignedTables.add(tab);
                                tab.setAssignedToJob(true);
                                this.nextCommitTime = this.millisecondClock.getTicks();
                                LOG.info().$("assigned table to writer thread [tableName=").$(tab.getTableNameUtf16()).$(", threadId=").$(this.workerId).I$();
                            }
                            event.append();
                        }
                        catch (Throwable ex) {
                            tab.setWriterInError();
                            LOG.critical().$("closing writer because of error [table=").$(tab.getTableNameUtf16()).$(",ex=").$(ex).I$();
                            this.metrics.healthCheck().incrementUnhandledErrors();
                            closeWriter = true;
                            event.createWriterReleaseEvent(tab, false);
                        }
                    } else if (event.getWriterWorkerId() == -3) {
                        closeWriter = true;
                    }
                }
                if (closeWriter && tab.getWriter() != null) {
                    this.scheduler.processWriterReleaseEvent(event, this.workerId);
                    this.assignedTables.remove(tab);
                    tab.setAssignedToJob(false);
                    this.nextCommitTime = this.millisecondClock.getTicks();
                }
            }
            catch (Throwable ex) {
                LOG.error().$("failed to process ILP event because of exception [ex=").$(ex).I$();
            }
            this.sequence.done(cursor);
        }
    }

    private void tickWriters() {
        int sz = this.assignedTables.size();
        for (int n = 0; n < sz; ++n) {
            this.assignedTables.getQuick(n).tick();
        }
    }
}

