/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.line.tcp;

import io.questdb.cairo.CairoException;
import io.questdb.std.Chars;
import io.questdb.std.str.DirectByteCharSequence;
import io.questdb.std.str.MutableCharSink;

final class LineTcpUtils {
    LineTcpUtils() {
    }

    public static void utf8ToUtf16Unchecked(DirectByteCharSequence utf8CharSeq, MutableCharSink tempSink) {
        tempSink.clear();
        if (!Chars.utf8Decode(utf8CharSeq.getLo(), utf8CharSeq.getHi(), tempSink)) {
            throw CairoException.nonCritical().put("invalid UTF8 in value for ").put(utf8CharSeq);
        }
    }

    static CharSequence utf8ToUtf16(DirectByteCharSequence utf8CharSeq, MutableCharSink tempSink, boolean hasNonAsciiChars) {
        if (hasNonAsciiChars) {
            LineTcpUtils.utf8ToUtf16Unchecked(utf8CharSeq, tempSink);
            return tempSink;
        }
        return utf8CharSeq;
    }

    static CharSequence utf8BytesToString(DirectByteCharSequence utf8CharSeq, MutableCharSink tempSink) {
        tempSink.clear();
        int n = utf8CharSeq.length();
        for (int i = 0; i < n; ++i) {
            tempSink.put(utf8CharSeq.charAt(i));
        }
        return tempSink.toString();
    }
}

