/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.line.tcp;

import io.questdb.griffin.SqlKeywords;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.Numbers;
import io.questdb.std.NumericException;
import io.questdb.std.ObjList;
import io.questdb.std.Unsafe;
import io.questdb.std.str.DirectByteCharSequence;

public class LineTcpParser {
    public static final long NULL_TIMESTAMP = Long.MIN_VALUE;
    public static final byte ENTITY_TYPE_NULL = 0;
    public static final byte ENTITY_TYPE_TAG = 1;
    public static final byte ENTITY_TYPE_FLOAT = 2;
    public static final byte ENTITY_TYPE_INTEGER = 3;
    public static final byte ENTITY_TYPE_STRING = 4;
    public static final byte ENTITY_TYPE_SYMBOL = 5;
    public static final byte ENTITY_TYPE_BOOLEAN = 6;
    public static final byte ENTITY_TYPE_LONG256 = 7;
    public static final byte ENTITY_TYPE_CACHED_TAG = 8;
    public static final byte ENTITY_TYPE_GEOBYTE = 9;
    public static final byte ENTITY_TYPE_GEOSHORT = 10;
    public static final byte ENTITY_TYPE_GEOINT = 11;
    public static final byte ENTITY_TYPE_GEOLONG = 12;
    public static final byte ENTITY_TYPE_TIMESTAMP = 13;
    public static final int N_ENTITY_TYPES = 14;
    public static final byte ENTITY_TYPE_LONG = 14;
    public static final byte ENTITY_TYPE_DOUBLE = 15;
    public static final byte ENTITY_TYPE_SHORT = 16;
    public static final byte ENTITY_TYPE_BYTE = 17;
    public static final byte ENTITY_TYPE_DATE = 18;
    public static final byte ENTITY_TYPE_CHAR = 19;
    public static final int N_MAPPED_ENTITY_TYPES = 20;
    static final byte ENTITY_TYPE_NONE = -1;
    private static final Log LOG = LogFactory.getLog(LineTcpParser.class);
    private final DirectByteCharSequence measurementName = new DirectByteCharSequence();
    private final DirectByteCharSequence charSeq = new DirectByteCharSequence();
    private final ObjList<ProtoEntity> entityCache = new ObjList();
    private final EntityHandler entityEndOfLineHandler = this::expectEndOfLine;
    private final boolean stringAsTagSupported;
    private final boolean symbolAsFieldSupported;
    private long bufAt;
    private long entityLo;
    private boolean tagsComplete;
    private boolean tagStartsWithQuote;
    private int nEscapedChars;
    private boolean isQuotedFieldValue;
    private int nEntities;
    private ProtoEntity currentEntity;
    private ErrorCode errorCode;
    private EntityHandler entityHandler;
    private long timestamp;
    private final EntityHandler entityTimestampHandler = this::expectTimestamp;
    private int nQuoteCharacters;
    private final EntityHandler entityTableHandler = this::expectTableName;
    private boolean scape;
    private final EntityHandler entityValueHandler = this::expectEntityValue;
    private boolean nextValueCanBeOpenQuote;
    private final EntityHandler entityNameHandler = this::expectEntityName;
    private boolean hasNonAscii;

    public LineTcpParser(boolean stringAsTagSupported, boolean symbolAsFieldSupported) {
        this.stringAsTagSupported = stringAsTagSupported;
        this.symbolAsFieldSupported = symbolAsFieldSupported;
    }

    public long getBufferAddress() {
        return this.bufAt;
    }

    public ProtoEntity getEntity(int n) {
        assert (n < this.nEntities);
        return this.entityCache.get(n);
    }

    public int getEntityCount() {
        return this.nEntities;
    }

    public ErrorCode getErrorCode() {
        return this.errorCode;
    }

    public DirectByteCharSequence getMeasurementName() {
        return this.measurementName;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public boolean hasNonAsciiChars() {
        return this.hasNonAscii;
    }

    public boolean hasTimestamp() {
        return this.timestamp != Long.MIN_VALUE;
    }

    public LineTcpParser of(long bufLo) {
        this.bufAt = bufLo - 1L;
        this.startNextMeasurement();
        return this;
    }

    public ParseResult parseMeasurement(long bufHi) {
        assert (this.bufAt != 0L && bufHi >= this.bufAt);
        if (this.nQuoteCharacters == 1 && this.tagsComplete && this.entityHandler == this.entityValueHandler) {
            if (!this.prepareQuotedEntity(this.entityLo, bufHi)) {
                if (this.errorCode == ErrorCode.INVALID_FIELD_VALUE_STR_UNDERFLOW) {
                    return ParseResult.BUFFER_UNDERFLOW;
                }
                return ParseResult.ERROR;
            }
            this.nQuoteCharacters = 0;
            ++this.bufAt;
        }
        while (this.bufAt < bufHi) {
            byte b = Unsafe.getUnsafe().getByte(this.bufAt);
            this.hasNonAscii |= b < 0;
            boolean endOfLine = false;
            boolean appendByte = false;
            switch (b) {
                case 10: 
                case 13: {
                    endOfLine = true;
                    b = 10;
                }
                case 32: 
                case 44: 
                case 61: {
                    this.isQuotedFieldValue = false;
                    if (!this.entityHandler.completeEntity(b, bufHi)) {
                        if (this.errorCode == ErrorCode.EMPTY_LINE) {
                            this.entityLo = ++this.bufAt;
                            break;
                        }
                        if (this.errorCode == ErrorCode.INVALID_FIELD_VALUE_STR_UNDERFLOW) {
                            return ParseResult.BUFFER_UNDERFLOW;
                        }
                        return ParseResult.ERROR;
                    }
                    if (endOfLine) {
                        if (this.nEntities > 0) {
                            this.entityHandler = this.entityEndOfLineHandler;
                            return ParseResult.MEASUREMENT_COMPLETE;
                        }
                        this.errorCode = ErrorCode.NO_FIELDS;
                        return ParseResult.ERROR;
                    }
                    ++this.bufAt;
                    if (this.isQuotedFieldValue) break;
                    this.nEscapedChars = 0;
                    this.entityLo = this.bufAt;
                    break;
                }
                case 92: {
                    if (this.bufAt + 1L >= bufHi) {
                        return ParseResult.BUFFER_UNDERFLOW;
                    }
                    ++this.nEscapedChars;
                    ++this.bufAt;
                    b = Unsafe.getUnsafe().getByte(this.bufAt);
                    if (b == 92 && this.entityHandler != this.entityValueHandler) {
                        return this.getError();
                    }
                    this.hasNonAscii |= b < 0;
                    appendByte = true;
                    break;
                }
                case 34: {
                    if (this.nextValueCanBeOpenQuote && ++this.nQuoteCharacters == 1) {
                        ++this.bufAt;
                        if (!this.prepareQuotedEntity(this.bufAt - 1L, bufHi)) {
                            if (this.errorCode == ErrorCode.INVALID_FIELD_VALUE_STR_UNDERFLOW) {
                                return ParseResult.BUFFER_UNDERFLOW;
                            }
                            return ParseResult.ERROR;
                        }
                        this.errorCode = ErrorCode.NONE;
                        this.nQuoteCharacters = 0;
                        ++this.bufAt;
                        break;
                    }
                    if (this.isQuotedFieldValue) {
                        return this.getError();
                    }
                    if (this.entityLo == this.bufAt) {
                        this.tagStartsWithQuote = true;
                    }
                }
                default: {
                    appendByte = true;
                    this.nextValueCanBeOpenQuote = false;
                    break;
                }
                case 0: {
                    LOG.info().$("could not parse [byte=\\0]").$();
                    return this.getError();
                }
                case 47: {
                    if (this.entityHandler != this.entityValueHandler) {
                        LOG.info().$("could not parse [byte=/]").$();
                        return this.getError();
                    }
                    appendByte = true;
                    this.nextValueCanBeOpenQuote = false;
                }
            }
            if (!appendByte) continue;
            if (this.nEscapedChars > 0) {
                Unsafe.getUnsafe().putByte(this.bufAt - (long)this.nEscapedChars, b);
            }
            ++this.bufAt;
        }
        return ParseResult.BUFFER_UNDERFLOW;
    }

    public void shl(long shl) {
        this.bufAt -= shl;
        this.entityLo -= shl;
        this.measurementName.shl(shl);
        this.charSeq.shl(shl);
        for (int i = 0; i < this.nEntities; ++i) {
            this.entityCache.getQuick(i).shl(shl);
        }
    }

    public ParseResult skipMeasurement(long bufHi) {
        assert (this.bufAt != 0L && bufHi >= this.bufAt);
        while (this.bufAt < bufHi) {
            byte b = Unsafe.getUnsafe().getByte(this.bufAt);
            if (b == 10 || b == 13) {
                return ParseResult.MEASUREMENT_COMPLETE;
            }
            ++this.bufAt;
        }
        return ParseResult.BUFFER_UNDERFLOW;
    }

    public void startNextMeasurement() {
        ++this.bufAt;
        this.nEscapedChars = 0;
        this.isQuotedFieldValue = false;
        this.entityLo = this.bufAt;
        this.tagsComplete = false;
        this.tagStartsWithQuote = false;
        this.nEntities = 0;
        this.currentEntity = null;
        this.entityHandler = this.entityTableHandler;
        this.timestamp = Long.MIN_VALUE;
        this.errorCode = ErrorCode.NONE;
        this.nQuoteCharacters = 0;
        this.scape = false;
        this.nextValueCanBeOpenQuote = false;
        this.hasNonAscii = false;
    }

    private boolean expectEndOfLine(byte endOfEntityByte, long bufHi) {
        assert (endOfEntityByte == 10);
        return true;
    }

    private boolean expectEntityName(byte endOfEntityByte, long bufHi) {
        boolean emptyEntity;
        if (endOfEntityByte == 61) {
            if (this.bufAt - this.entityLo - (long)this.nEscapedChars == 0L) {
                this.errorCode = this.tagsComplete ? ErrorCode.INCOMPLETE_FIELD : ErrorCode.INCOMPLETE_TAG;
                return false;
            }
            if (this.entityCache.size() <= this.nEntities) {
                this.currentEntity = new ProtoEntity();
                this.entityCache.add(this.currentEntity);
            } else {
                this.currentEntity = this.entityCache.get(this.nEntities);
                this.currentEntity.clear();
            }
            ++this.nEntities;
            this.currentEntity.setName();
            this.entityHandler = this.entityValueHandler;
            if (this.tagsComplete) {
                if (this.bufAt + 3L < bufHi) {
                    long candidateQuoteIdx = this.bufAt + 1L;
                    byte b = Unsafe.getUnsafe().getByte(candidateQuoteIdx);
                    if (b == 34) {
                        this.nEscapedChars = 0;
                        ++this.nQuoteCharacters;
                        this.bufAt += 2L;
                        return this.prepareQuotedEntity(candidateQuoteIdx, bufHi);
                    }
                    this.nextValueCanBeOpenQuote = false;
                } else {
                    this.nextValueCanBeOpenQuote = true;
                }
            }
            return true;
        }
        boolean bl = emptyEntity = this.bufAt == this.entityLo;
        if (emptyEntity) {
            if (endOfEntityByte == 32) {
                if (this.tagsComplete) {
                    this.entityHandler = this.entityTimestampHandler;
                } else {
                    this.tagsComplete = true;
                }
                return true;
            }
            if (endOfEntityByte == 10) {
                return true;
            }
        } else if (this.tagsComplete && (endOfEntityByte == 10 || endOfEntityByte == 13) && this.currentEntity != null && this.currentEntity.getType() == 1) {
            return this.expectTimestamp(endOfEntityByte, bufHi);
        }
        this.errorCode = this.tagsComplete ? ErrorCode.INCOMPLETE_FIELD : ErrorCode.INCOMPLETE_TAG;
        return false;
    }

    private boolean expectEntityValue(byte endOfEntityByte, long bufHi) {
        boolean endOfSet;
        boolean bl = endOfSet = endOfEntityByte == 32;
        if (endOfSet || endOfEntityByte == 44 || endOfEntityByte == 10) {
            if (this.currentEntity.setValue()) {
                if (endOfSet) {
                    if (this.tagsComplete) {
                        this.entityHandler = this.entityTimestampHandler;
                    } else {
                        this.entityHandler = this.entityNameHandler;
                        this.tagsComplete = true;
                    }
                } else {
                    this.entityHandler = this.entityNameHandler;
                }
                return true;
            }
            this.errorCode = this.tagsComplete ? ErrorCode.INVALID_FIELD_VALUE : ErrorCode.INVALID_TAG_VALUE;
            return false;
        }
        this.errorCode = ErrorCode.INVALID_FIELD_SEPARATOR;
        return false;
    }

    private boolean expectTableName(byte endOfEntityByte, long bufHi) {
        boolean bl = this.tagsComplete = endOfEntityByte == 32;
        if (endOfEntityByte == 44 || this.tagsComplete) {
            long hi = this.bufAt - (long)this.nEscapedChars;
            this.measurementName.of(this.entityLo, hi);
            this.entityHandler = this.entityNameHandler;
            return true;
        }
        this.errorCode = this.entityLo == this.bufAt ? ErrorCode.EMPTY_LINE : ErrorCode.NO_FIELDS;
        return false;
    }

    private boolean expectTimestamp(byte endOfEntityByte, long bufHi) {
        try {
            if (endOfEntityByte == 10) {
                if (this.entityLo < this.bufAt - (long)this.nEscapedChars) {
                    this.timestamp = Numbers.parseLong(this.charSeq.of(this.entityLo, this.bufAt - (long)this.nEscapedChars));
                }
                this.entityHandler = null;
                return true;
            }
            this.errorCode = ErrorCode.INVALID_FIELD_SEPARATOR;
            return false;
        }
        catch (NumericException ex) {
            this.errorCode = ErrorCode.INVALID_TIMESTAMP;
            return false;
        }
    }

    private ParseResult getError() {
        if (this.entityHandler == this.entityNameHandler) {
            this.errorCode = ErrorCode.INVALID_COLUMN_NAME;
        } else if (this.entityHandler == this.entityTableHandler) {
            this.errorCode = ErrorCode.INVALID_TABLE_NAME;
        } else if (this.entityHandler == this.entityValueHandler) {
            this.errorCode = ErrorCode.INVALID_FIELD_VALUE;
        }
        return ParseResult.ERROR;
    }

    private boolean prepareQuotedEntity(long openQuoteIdx, long bufHi) {
        this.entityLo = openQuoteIdx;
        while (this.bufAt < bufHi) {
            byte b = Unsafe.getUnsafe().getByte(this.bufAt);
            boolean copyByte = true;
            this.hasNonAscii |= b < 0;
            switch (b) {
                case 92: {
                    if (!this.scape) {
                        ++this.nEscapedChars;
                        copyByte = false;
                    }
                    this.scape = !this.scape;
                    break;
                }
                case 34: {
                    if (!this.scape) {
                        this.isQuotedFieldValue = true;
                        --this.nQuoteCharacters;
                        if (this.nEscapedChars > 0) {
                            Unsafe.getUnsafe().putByte(this.bufAt - (long)this.nEscapedChars, b);
                        }
                        return true;
                    }
                    this.scape = false;
                    break;
                }
                case 10: {
                    if (!this.scape) {
                        this.errorCode = ErrorCode.INVALID_FIELD_VALUE;
                        return false;
                    }
                    this.scape = false;
                    break;
                }
                default: {
                    this.scape = false;
                }
            }
            this.nextValueCanBeOpenQuote = false;
            if (copyByte && this.nEscapedChars > 0) {
                Unsafe.getUnsafe().putByte(this.bufAt - (long)this.nEscapedChars, b);
            }
            ++this.bufAt;
        }
        this.errorCode = ErrorCode.INVALID_FIELD_VALUE_STR_UNDERFLOW;
        return false;
    }

    public class ProtoEntity {
        private final DirectByteCharSequence name = new DirectByteCharSequence();
        private final DirectByteCharSequence value = new DirectByteCharSequence();
        private byte type = (byte)-1;
        private long longValue;
        private boolean booleanValue;
        private double floatValue;

        public boolean getBooleanValue() {
            return this.booleanValue;
        }

        public double getFloatValue() {
            return this.floatValue;
        }

        public long getLongValue() {
            return this.longValue;
        }

        public DirectByteCharSequence getName() {
            return this.name;
        }

        public byte getType() {
            return this.type;
        }

        public DirectByteCharSequence getValue() {
            return this.value;
        }

        public void shl(long shl) {
            this.name.shl(shl);
            this.value.shl(shl);
        }

        private void clear() {
            this.type = (byte)-1;
        }

        private boolean parse(byte last, int valueLen) {
            switch (last) {
                case 105: {
                    if (valueLen > 1 && this.value.charAt(1) != 'x') {
                        return this.parseLong((byte)3);
                    }
                    if (valueLen > 3 && this.value.charAt(0) == '0' && (this.value.charAt(1) | 0x20) == 120) {
                        this.value.decHi();
                        this.type = (byte)7;
                        return true;
                    }
                    this.type = (byte)5;
                    return true;
                }
                case 116: {
                    if (valueLen > 1) {
                        return this.parseLong((byte)13);
                    }
                }
                case 69: 
                case 70: 
                case 84: 
                case 101: 
                case 102: {
                    if (valueLen == 1) {
                        if (last != 101) {
                            this.booleanValue = (last | 0x20) == 116;
                            this.type = (byte)6;
                        } else {
                            this.type = (byte)5;
                        }
                    } else {
                        LineTcpParser.this.charSeq.of(this.value.getLo(), this.value.getHi());
                        if (SqlKeywords.isTrueKeyword(LineTcpParser.this.charSeq)) {
                            this.booleanValue = true;
                            this.type = (byte)6;
                        } else if (SqlKeywords.isFalseKeyword(LineTcpParser.this.charSeq)) {
                            this.booleanValue = false;
                            this.type = (byte)6;
                        } else {
                            this.type = (byte)5;
                        }
                    }
                    return true;
                }
                case 34: {
                    byte b = this.value.byteAt(0);
                    if (valueLen > 1 && b == 34) {
                        this.value.squeeze();
                        this.type = (byte)4;
                        return true;
                    }
                    this.type = (byte)5;
                    return true;
                }
            }
            try {
                this.floatValue = Numbers.parseDouble(this.value.getLo(), this.value.length());
                this.type = (byte)2;
            }
            catch (NumericException ex) {
                this.type = (byte)5;
            }
            return true;
        }

        private boolean parseLong(byte entityType) {
            try {
                LineTcpParser.this.charSeq.of(this.value.getLo(), this.value.getHi() - 1L);
                this.longValue = Numbers.parseLong(LineTcpParser.this.charSeq);
                this.value.decHi();
                this.type = entityType;
            }
            catch (NumericException notANumber) {
                this.type = (byte)5;
            }
            return true;
        }

        private void setName() {
            this.name.of(LineTcpParser.this.entityLo, LineTcpParser.this.bufAt - (long)LineTcpParser.this.nEscapedChars);
        }

        private boolean setValue() {
            assert (this.type == -1);
            long bufHi = LineTcpParser.this.bufAt - (long)LineTcpParser.this.nEscapedChars;
            int valueLen = (int)(bufHi - LineTcpParser.this.entityLo);
            this.value.of(LineTcpParser.this.entityLo, bufHi);
            if (LineTcpParser.this.tagsComplete) {
                if (valueLen > 0) {
                    byte lastByte = this.value.byteAt(valueLen - 1);
                    return this.parse(lastByte, valueLen) && (LineTcpParser.this.symbolAsFieldSupported || this.type != 5);
                }
                this.type = 0;
                return true;
            }
            this.type = 1;
            return !LineTcpParser.this.tagStartsWithQuote || valueLen < 2 || this.value.byteAt(valueLen - 1) != 34 || LineTcpParser.this.stringAsTagSupported;
        }
    }

    @FunctionalInterface
    private static interface EntityHandler {
        public boolean completeEntity(byte var1, long var2);
    }

    public static enum ErrorCode {
        EMPTY_LINE,
        NO_FIELDS,
        INCOMPLETE_TAG,
        INCOMPLETE_FIELD,
        INVALID_FIELD_SEPARATOR,
        INVALID_TIMESTAMP,
        INVALID_TAG_VALUE,
        INVALID_FIELD_VALUE,
        INVALID_FIELD_VALUE_STR_UNDERFLOW,
        INVALID_TABLE_NAME,
        INVALID_COLUMN_NAME,
        NONE;

    }

    public static enum ParseResult {
        MEASUREMENT_COMPLETE,
        BUFFER_UNDERFLOW,
        ERROR;

    }
}

