/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.line.tcp;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.CairoSecurityContext;
import io.questdb.cairo.EntryUnavailableException;
import io.questdb.cairo.vm.Vm;
import io.questdb.cairo.vm.api.MemoryMARW;
import io.questdb.cutlass.line.tcp.DefaultColumnTypes;
import io.questdb.cutlass.line.tcp.LineTcpConnectionContext;
import io.questdb.cutlass.line.tcp.LineTcpMeasurementEvent;
import io.questdb.cutlass.line.tcp.LineTcpNetworkIOJob;
import io.questdb.cutlass.line.tcp.LineTcpParser;
import io.questdb.cutlass.line.tcp.LineTcpReceiver;
import io.questdb.cutlass.line.tcp.LineTcpReceiverConfiguration;
import io.questdb.cutlass.line.tcp.LineTcpWriterJob;
import io.questdb.cutlass.line.tcp.NetworkIOJob;
import io.questdb.cutlass.line.tcp.TableStructureAdapter;
import io.questdb.cutlass.line.tcp.TableUpdateDetails;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.mp.MPSequence;
import io.questdb.mp.RingQueue;
import io.questdb.mp.SCSequence;
import io.questdb.mp.WorkerPool;
import io.questdb.network.IODispatcher;
import io.questdb.std.CharSequenceObjHashMap;
import io.questdb.std.Chars;
import io.questdb.std.LowerCaseCharSequenceObjHashMap;
import io.questdb.std.Misc;
import io.questdb.std.Numbers;
import io.questdb.std.ObjList;
import io.questdb.std.Os;
import io.questdb.std.SimpleReadWriteLock;
import io.questdb.std.datetime.millitime.MillisecondClock;
import io.questdb.std.str.DirectByteCharSequence;
import io.questdb.std.str.Path;
import io.questdb.std.str.StringSink;
import io.questdb.tasks.TelemetryTask;
import java.io.Closeable;
import java.util.Arrays;
import java.util.concurrent.locks.ReadWriteLock;
import org.jetbrains.annotations.NotNull;

class LineTcpMeasurementScheduler
implements Closeable {
    private static final Log LOG = LogFactory.getLog(LineTcpMeasurementScheduler.class);
    private final DefaultColumnTypes defaultColumnTypes;
    private final CairoEngine engine;
    private final CairoSecurityContext securityContext;
    private final RingQueue<LineTcpMeasurementEvent>[] queue;
    private final ReadWriteLock tableUpdateDetailsLock = new SimpleReadWriteLock();
    private final LowerCaseCharSequenceObjHashMap<TableUpdateDetails> tableUpdateDetailsUtf16;
    private final LowerCaseCharSequenceObjHashMap<TableUpdateDetails> idleTableUpdateDetailsUtf16;
    private final long[] loadByWriterThread;
    private final long writerIdleTimeout;
    private final NetworkIOJob[] netIoJobs;
    private final StringSink[] tableNameSinks;
    private final TableStructureAdapter tableStructureAdapter;
    private final Path path = new Path();
    private final MemoryMARW ddlMem = Vm.getMARWInstance();
    private final LineTcpReceiverConfiguration configuration;
    private final MPSequence[] pubSeq;
    private final boolean autoCreateNewTables;
    private final boolean autoCreateNewColumns;
    private LineTcpReceiver.SchedulerListener listener;

    LineTcpMeasurementScheduler(LineTcpReceiverConfiguration lineConfiguration, CairoEngine engine, WorkerPool ioWorkerPool, IODispatcher<LineTcpConnectionContext> dispatcher, WorkerPool writerWorkerPool) {
        this.engine = engine;
        this.securityContext = lineConfiguration.getCairoSecurityContext();
        CairoConfiguration cairoConfiguration = engine.getConfiguration();
        this.configuration = lineConfiguration;
        MillisecondClock milliClock = cairoConfiguration.getMillisecondClock();
        this.defaultColumnTypes = new DefaultColumnTypes(lineConfiguration);
        int n = ioWorkerPool.getWorkerCount();
        this.netIoJobs = new NetworkIOJob[n];
        this.tableNameSinks = new StringSink[n];
        for (int i = 0; i < n; ++i) {
            NetworkIOJob netIoJob;
            this.tableNameSinks[i] = new StringSink();
            this.netIoJobs[i] = netIoJob = this.createNetworkIOJob(dispatcher, i);
            ioWorkerPool.assign(i, netIoJob);
            ioWorkerPool.assign(i, netIoJob::close);
        }
        this.tableUpdateDetailsUtf16 = new LowerCaseCharSequenceObjHashMap();
        this.idleTableUpdateDetailsUtf16 = new LowerCaseCharSequenceObjHashMap();
        this.loadByWriterThread = new long[writerWorkerPool.getWorkerCount()];
        this.autoCreateNewTables = lineConfiguration.getAutoCreateNewTables();
        this.autoCreateNewColumns = lineConfiguration.getAutoCreateNewColumns();
        int maxMeasurementSize = lineConfiguration.getMaxMeasurementSize();
        int queueSize = lineConfiguration.getWriterQueueCapacity();
        long commitIntervalDefault = this.configuration.getCommitIntervalDefault();
        int nWriterThreads = writerWorkerPool.getWorkerCount();
        this.pubSeq = new MPSequence[nWriterThreads];
        this.queue = new RingQueue[nWriterThreads];
        for (int i = 0; i < nWriterThreads; ++i) {
            MPSequence ps;
            this.pubSeq[i] = ps = new MPSequence(queueSize);
            RingQueue<LineTcpMeasurementEvent> q = new RingQueue<LineTcpMeasurementEvent>((address, addressSize) -> new LineTcpMeasurementEvent(address, addressSize, lineConfiguration.getMicrosecondClock(), lineConfiguration.getTimestampAdapter(), this.defaultColumnTypes, lineConfiguration.isStringToCharCastAllowed(), lineConfiguration.isSymbolAsFieldSupported(), lineConfiguration.getMaxFileNameLength(), lineConfiguration.getAutoCreateNewColumns()), LineTcpMeasurementScheduler.getEventSlotSize(maxMeasurementSize), queueSize, 1);
            this.queue[i] = q;
            SCSequence subSeq = new SCSequence();
            ps.then(subSeq).then(ps);
            LineTcpWriterJob lineTcpWriterJob = new LineTcpWriterJob(i, q, subSeq, milliClock, commitIntervalDefault, this, engine.getMetrics());
            writerWorkerPool.assign(i, lineTcpWriterJob);
            writerWorkerPool.assign(i, lineTcpWriterJob);
        }
        this.tableStructureAdapter = new TableStructureAdapter(cairoConfiguration, this.defaultColumnTypes, this.configuration.getDefaultPartitionBy());
        this.writerIdleTimeout = lineConfiguration.getWriterIdleTimeout();
    }

    @Override
    public void close() {
        this.tableUpdateDetailsLock.writeLock().lock();
        try {
            this.closeLocals(this.tableUpdateDetailsUtf16);
            this.closeLocals(this.idleTableUpdateDetailsUtf16);
        }
        finally {
            this.tableUpdateDetailsLock.writeLock().unlock();
        }
        Misc.free(this.path);
        Misc.free(this.ddlMem);
        int n = this.queue.length;
        for (int i = 0; i < n; ++i) {
            Misc.free(this.queue[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doMaintenance(CharSequenceObjHashMap<TableUpdateDetails> tableUpdateDetailsUtf8, int readerWorkerId, long millis) {
        int sz = tableUpdateDetailsUtf8.size();
        for (int n = 0; n < sz; ++n) {
            CharSequence tableNameUtf8 = tableUpdateDetailsUtf8.keys().get(n);
            TableUpdateDetails tab = tableUpdateDetailsUtf8.get(tableNameUtf8);
            if (millis - tab.getLastMeasurementMillis() < this.writerIdleTimeout) continue;
            this.tableUpdateDetailsLock.writeLock().lock();
            try {
                if (tab.getNetworkIOOwnerCount() == 1) {
                    int writerWorkerId = tab.getWriterThreadId();
                    long seq = this.getNextPublisherEventSequence(writerWorkerId);
                    if (seq > -1L) {
                        LineTcpMeasurementEvent event = this.queue[writerWorkerId].get(seq);
                        event.createWriterReleaseEvent(tab, true);
                        tableUpdateDetailsUtf8.remove(tableNameUtf8);
                        String tableNameUtf16 = tab.getTableNameUtf16();
                        this.tableUpdateDetailsUtf16.remove(tableNameUtf16);
                        this.idleTableUpdateDetailsUtf16.put(tableNameUtf16, tab);
                        tab.removeReference(readerWorkerId);
                        this.pubSeq[writerWorkerId].done(seq);
                        if (this.listener != null) {
                            this.listener.onEvent(tableNameUtf16, 1);
                        }
                        LOG.info().$("active table going idle [tableName=").$(tableNameUtf16).I$();
                    }
                    boolean bl = true;
                    return bl;
                }
                tableUpdateDetailsUtf8.remove(tableNameUtf8);
                tab.removeReference(readerWorkerId);
                boolean bl = sz > 1;
                return bl;
            }
            finally {
                this.tableUpdateDetailsLock.writeLock().unlock();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processWriterReleaseEvent(LineTcpMeasurementEvent event, int workerId) {
        this.tableUpdateDetailsLock.readLock().lock();
        try {
            TableUpdateDetails tab = event.getTableUpdateDetails();
            if (tab.getWriterThreadId() != workerId) {
                return;
            }
            if (!event.getTableUpdateDetails().isWriterInError() && this.tableUpdateDetailsUtf16.keyIndex(tab.getTableNameUtf16()) < 0) {
                return;
            }
            LOG.info().$("releasing writer, its been idle since ").$ts(tab.getLastMeasurementMillis() * 1000L).$("[tableName=").$(tab.getTableNameUtf16()).I$();
            event.releaseWriter();
        }
        finally {
            this.tableUpdateDetailsLock.readLock().unlock();
        }
    }

    private static long getEventSlotSize(int maxMeasurementSize) {
        return Numbers.ceilPow2((long)(maxMeasurementSize / 4) * 13L);
    }

    private void closeLocals(LowerCaseCharSequenceObjHashMap<TableUpdateDetails> tudUtf16) {
        ObjList tableNames = tudUtf16.keys();
        int sz = tableNames.size();
        for (int n = 0; n < sz; ++n) {
            tudUtf16.get((CharSequence)tableNames.get(n)).closeLocals();
        }
        tudUtf16.clear();
    }

    protected NetworkIOJob createNetworkIOJob(IODispatcher<LineTcpConnectionContext> dispatcher, int workerId) {
        return new LineTcpNetworkIOJob(this.configuration, this, dispatcher, workerId);
    }

    long getNextPublisherEventSequence(int writerWorkerId) {
        long seq;
        assert (this.isOpen());
        while ((seq = this.pubSeq[writerWorkerId].next()) == -2L) {
            Os.pause();
        }
        return seq;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TableUpdateDetails getTableUpdateDetailsFromSharedArea(@NotNull NetworkIOJob netIoJob, @NotNull LineTcpParser parser) {
        DirectByteCharSequence tableNameUtf8 = parser.getMeasurementName();
        StringSink tableNameUtf16 = this.tableNameSinks[netIoJob.getWorkerId()];
        tableNameUtf16.clear();
        Chars.utf8Decode(tableNameUtf8.getLo(), tableNameUtf8.getHi(), tableNameUtf16);
        this.tableUpdateDetailsLock.writeLock().lock();
        try {
            TableUpdateDetails tab;
            int tudKeyIndex = this.tableUpdateDetailsUtf16.keyIndex(tableNameUtf16);
            if (tudKeyIndex < 0) {
                tab = this.tableUpdateDetailsUtf16.valueAt(tudKeyIndex);
            } else {
                int idleTudKeyIndex;
                int status = this.engine.getStatus(this.securityContext, this.path, tableNameUtf16, 0, tableNameUtf16.length());
                if (status != 0) {
                    if (!this.autoCreateNewTables) {
                        throw CairoException.nonCritical().put("table does not exist, creating new tables is disabled [table=").put(tableNameUtf16).put(']');
                    }
                    if (!this.autoCreateNewColumns) {
                        throw CairoException.nonCritical().put("table does not exist, cannot create table, creating new columns is disabled [table=").put(tableNameUtf16).put(']');
                    }
                    TableStructureAdapter tsa = this.tableStructureAdapter.of(tableNameUtf16, parser);
                    int n = tsa.getColumnCount();
                    for (int i = 0; i < n; ++i) {
                        if (tsa.getColumnType(i) != 0) continue;
                        throw CairoException.nonCritical().put("unknown column type [columnName=").put(tsa.getColumnName(i)).put(']');
                    }
                    LOG.info().$("creating table [tableName=").$(tableNameUtf16).$(']').$();
                    this.engine.createTable(this.securityContext, this.ddlMem, this.path, tsa);
                }
                if ((idleTudKeyIndex = this.idleTableUpdateDetailsUtf16.keyIndex(tableNameUtf16)) < 0) {
                    tab = this.idleTableUpdateDetailsUtf16.valueAt(idleTudKeyIndex);
                    LOG.info().$("idle table going active [tableName=").$(tab.getTableNameUtf16()).I$();
                    if (tab.getWriter() == null) {
                        tab.closeNoLock();
                        tab = this.unsafeAssignTableToWriterThread(tudKeyIndex, tab.getTableNameUtf16());
                    } else {
                        this.idleTableUpdateDetailsUtf16.removeAt(idleTudKeyIndex);
                        this.tableUpdateDetailsUtf16.putAt(tudKeyIndex, tab.getTableNameUtf16(), tab);
                    }
                } else {
                    TelemetryTask.doStoreTelemetry(this.engine, (short)102, (short)5);
                    tab = this.unsafeAssignTableToWriterThread(tudKeyIndex, tableNameUtf16);
                }
            }
            tableNameUtf16.clear();
            tableNameUtf16.put(tableNameUtf8);
            netIoJob.addTableUpdateDetails(tableNameUtf16.toString(), tab);
            TableUpdateDetails tableUpdateDetails = tab;
            return tableUpdateDetails;
        }
        finally {
            this.tableUpdateDetailsLock.writeLock().unlock();
        }
    }

    private boolean isOpen() {
        return null != this.pubSeq;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean scheduleEvent(NetworkIOJob netIoJob, LineTcpParser parser) {
        TableUpdateDetails tab;
        try {
            tab = netIoJob.getLocalTableDetails(parser.getMeasurementName());
            if (tab == null) {
                tab = this.getTableUpdateDetailsFromSharedArea(netIoJob, parser);
            }
        }
        catch (EntryUnavailableException ex) {
            LOG.info().$("could not get table writer [tableName=").$(parser.getMeasurementName()).$(", ex=`").$(ex.getFlyweightMessage()).$("`]").$();
            return true;
        }
        catch (CairoException ex) {
            LOG.error().$("could not create table [tableName=").$(parser.getMeasurementName()).$(", errno=").$(ex.getErrno()).I$();
            throw ex;
        }
        int writerThreadId = tab.getWriterThreadId();
        long seq = this.getNextPublisherEventSequence(writerThreadId);
        if (seq > -1L) {
            try {
                if (tab.isWriterInError()) {
                    throw CairoException.critical(0).put("writer is in error, aborting ILP pipeline");
                }
                this.queue[writerThreadId].get(seq).createMeasurementEvent(tab, parser, netIoJob.getWorkerId());
            }
            finally {
                this.pubSeq[writerThreadId].done(seq);
            }
            tab.incrementEventsProcessedSinceReshuffle();
            return false;
        }
        return true;
    }

    void setListener(LineTcpReceiver.SchedulerListener listener) {
        this.listener = listener;
    }

    @NotNull
    private TableUpdateDetails unsafeAssignTableToWriterThread(int tudKeyIndex, CharSequence tableNameUtf16) {
        this.unsafeCalcThreadLoad();
        long leastLoad = Long.MAX_VALUE;
        int threadId = 0;
        int n = this.loadByWriterThread.length;
        for (int i = 0; i < n; ++i) {
            if (this.loadByWriterThread[i] >= leastLoad) continue;
            leastLoad = this.loadByWriterThread[i];
            threadId = i;
        }
        TableUpdateDetails tableUpdateDetails = new TableUpdateDetails(this.configuration, this.engine, this.engine.getWriter(this.securityContext, tableNameUtf16, "tcpIlp"), threadId, this.netIoJobs, this.defaultColumnTypes);
        this.tableUpdateDetailsUtf16.putAt(tudKeyIndex, tableUpdateDetails.getTableNameUtf16(), tableUpdateDetails);
        LOG.info().$("assigned ").$(tableNameUtf16).$(" to thread ").$(threadId).$();
        return tableUpdateDetails;
    }

    private void unsafeCalcThreadLoad() {
        Arrays.fill(this.loadByWriterThread, 0L);
        ObjList tableNames = this.tableUpdateDetailsUtf16.keys();
        int sz = tableNames.size();
        for (int n = 0; n < sz; ++n) {
            CharSequence tableName = (CharSequence)tableNames.getQuick(n);
            TableUpdateDetails stats = this.tableUpdateDetailsUtf16.get(tableName);
            if (stats != null) {
                int n2 = stats.getWriterThreadId();
                this.loadByWriterThread[n2] = this.loadByWriterThread[n2] + stats.getEventsProcessedSinceReshuffle();
                continue;
            }
            LOG.error().$("could not find statistic for table [name=").$(tableName).I$();
        }
    }
}

