/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.line.tcp;

import io.questdb.cairo.CairoException;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.CommitFailedException;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.TableWriter;
import io.questdb.cutlass.line.LineProtoTimestampAdapter;
import io.questdb.cutlass.line.tcp.DefaultColumnTypes;
import io.questdb.cutlass.line.tcp.LineTcpEventBuffer;
import io.questdb.cutlass.line.tcp.LineTcpParser;
import io.questdb.cutlass.line.tcp.TableUpdateDetails;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.Misc;
import io.questdb.std.datetime.microtime.MicrosecondClock;
import io.questdb.std.str.DirectByteCharSequence;
import java.io.Closeable;

class LineTcpMeasurementEvent
implements Closeable {
    private static final Log LOG = LogFactory.getLog(LineTcpMeasurementEvent.class);
    private final MicrosecondClock clock;
    private final LineProtoTimestampAdapter timestampAdapter;
    private final LineTcpEventBuffer buffer;
    private final DefaultColumnTypes defaultColumnTypes;
    private final boolean stringToCharCastAllowed;
    private final boolean symbolAsFieldSupported;
    private final int maxColumnNameLength;
    private final boolean autoCreateNewColumns;
    private int writerWorkerId;
    private TableUpdateDetails tableUpdateDetails;
    private boolean commitOnWriterClose;

    LineTcpMeasurementEvent(long bufLo, long bufSize, MicrosecondClock clock, LineProtoTimestampAdapter timestampAdapter, DefaultColumnTypes defaultColumnTypes, boolean stringToCharCastAllowed, boolean symbolAsFieldSupported, int maxColumnNameLength, boolean autoCreateNewColumns) {
        this.maxColumnNameLength = maxColumnNameLength;
        this.autoCreateNewColumns = autoCreateNewColumns;
        this.buffer = new LineTcpEventBuffer(bufLo, bufSize);
        this.clock = clock;
        this.timestampAdapter = timestampAdapter;
        this.defaultColumnTypes = defaultColumnTypes;
        this.stringToCharCastAllowed = stringToCharCastAllowed;
        this.symbolAsFieldSupported = symbolAsFieldSupported;
    }

    @Override
    public void close() {
        this.tableUpdateDetails = Misc.free(this.tableUpdateDetails);
    }

    public TableUpdateDetails getTableUpdateDetails() {
        return this.tableUpdateDetails;
    }

    public int getWriterWorkerId() {
        return this.writerWorkerId;
    }

    public void releaseWriter() {
        this.tableUpdateDetails.releaseWriter(this.commitOnWriterClose);
    }

    void append() throws CommitFailedException {
        block25: {
            TableWriter.Row row = null;
            try {
                TableWriter writer = this.tableUpdateDetails.getWriter();
                long offset = this.buffer.getAddress();
                long timestamp = this.buffer.readLong(offset);
                offset += 8L;
                if (timestamp == Long.MIN_VALUE) {
                    timestamp = this.clock.getTicks();
                }
                row = writer.newRow(timestamp);
                int nEntities = this.buffer.readInt(offset);
                offset += 4L;
                block20: for (int nEntity = 0; nEntity < nEntities; ++nEntity) {
                    byte entityType;
                    int colIndex = this.buffer.readInt(offset);
                    offset += 4L;
                    if (colIndex > -1) {
                        entityType = this.buffer.readByte(offset);
                        ++offset;
                    } else {
                        CharSequence columnName = this.buffer.readUtf16Chars(offset, -colIndex);
                        entityType = this.buffer.readByte(offset += (long)(-colIndex) * 2L);
                        ++offset;
                        colIndex = writer.getMetadata().getColumnIndexQuiet(columnName);
                        if (colIndex < 0) {
                            row.cancel();
                            row = null;
                            int colType = this.defaultColumnTypes.MAPPED_COLUMN_TYPES[entityType];
                            writer.addColumn(columnName, colType);
                            offset = 12L + this.buffer.getAddress();
                            nEntity = -1;
                            row = writer.newRow(timestamp);
                            continue;
                        }
                    }
                    switch (entityType) {
                        case 1: {
                            CharSequence cs = this.buffer.readUtf16Chars(offset);
                            row.putSym(colIndex, cs);
                            offset += (long)cs.length() * 2L + 4L;
                            continue block20;
                        }
                        case 8: {
                            row.putSymIndex(colIndex, this.buffer.readInt(offset));
                            offset += 4L;
                            continue block20;
                        }
                        case 12: 
                        case 14: {
                            row.putLong(colIndex, this.buffer.readLong(offset));
                            offset += 8L;
                            continue block20;
                        }
                        case 3: 
                        case 11: {
                            row.putInt(colIndex, this.buffer.readInt(offset));
                            offset += 4L;
                            continue block20;
                        }
                        case 10: 
                        case 16: {
                            row.putShort(colIndex, this.buffer.readShort(offset));
                            offset += 2L;
                            continue block20;
                        }
                        case 9: 
                        case 17: {
                            row.putByte(colIndex, this.buffer.readByte(offset));
                            ++offset;
                            continue block20;
                        }
                        case 18: {
                            row.putDate(colIndex, this.buffer.readLong(offset));
                            offset += 8L;
                            continue block20;
                        }
                        case 15: {
                            row.putDouble(colIndex, this.buffer.readDouble(offset));
                            offset += 8L;
                            continue block20;
                        }
                        case 2: {
                            row.putFloat(colIndex, this.buffer.readFloat(offset));
                            offset += 4L;
                            continue block20;
                        }
                        case 6: {
                            row.putBool(colIndex, this.buffer.readByte(offset) == 1);
                            ++offset;
                            continue block20;
                        }
                        case 4: {
                            CharSequence cs = this.buffer.readUtf16Chars(offset);
                            row.putStr(colIndex, cs);
                            offset += (long)cs.length() * 2L + 4L;
                            continue block20;
                        }
                        case 19: {
                            row.putChar(colIndex, this.buffer.readChar(offset));
                            offset += 2L;
                            continue block20;
                        }
                        case 7: {
                            CharSequence cs = this.buffer.readUtf16Chars(offset);
                            row.putLong256(colIndex, cs);
                            offset += (long)cs.length() * 2L + 4L;
                            continue block20;
                        }
                        case 13: {
                            row.putTimestamp(colIndex, this.buffer.readLong(offset));
                            offset += 8L;
                            continue block20;
                        }
                        case 0: {
                            continue block20;
                        }
                        default: {
                            throw new UnsupportedOperationException("entityType " + entityType + " is not implemented!");
                        }
                    }
                }
                row.append();
                this.tableUpdateDetails.commitIfMaxUncommittedRowsCountReached();
            }
            catch (CommitFailedException commitFailedException) {
                throw commitFailedException;
            }
            catch (Throwable th) {
                LOG.error().$("could not write line protocol measurement [tableName=").$(this.tableUpdateDetails.getTableNameUtf16()).$(", message=").$(th.getMessage()).$(th).I$();
                if (row == null) break block25;
                row.cancel();
            }
        }
    }

    private CairoException boundsError(long entityValue, int columnWriterIndex, int colType) {
        return CairoException.critical(0).put("line protocol integer is out of ").put(ColumnType.nameOf(colType)).put(" bounds [columnWriterIndex=").put(columnWriterIndex).put(", value=").put(entityValue).put(']');
    }

    private CairoException castError(String ilpType, int columnWriterIndex, int colType) {
        return CairoException.critical(0).put("cast error for line protocol ").put(ilpType).put(" [columnWriterIndex=").put(columnWriterIndex).put(", columnType=").put(ColumnType.nameOf(colType)).put(']');
    }

    void createMeasurementEvent(TableUpdateDetails tableUpdateDetails, LineTcpParser parser, int workerId) {
        this.writerWorkerId = -2;
        TableUpdateDetails.ThreadLocalDetails localDetails = tableUpdateDetails.getThreadLocalDetails(workerId);
        localDetails.resetProcessedColumnsTracking();
        this.tableUpdateDetails = tableUpdateDetails;
        long timestamp = parser.getTimestamp();
        if (timestamp != Long.MIN_VALUE) {
            timestamp = this.timestampAdapter.getMicros(timestamp);
        }
        long offset = 12L + this.buffer.getAddress();
        int entitiesWritten = 0;
        int n = parser.getEntityCount();
        block38: for (int nEntity = 0; nEntity < n; ++nEntity) {
            int colType;
            LineTcpParser.ProtoEntity entity = parser.getEntity(nEntity);
            byte entityType = entity.getType();
            int columnWriterIndex = localDetails.getColumnIndex(entity.getName(), parser.hasNonAsciiChars());
            if (columnWriterIndex > -1) {
                if (columnWriterIndex == tableUpdateDetails.getTimestampIndex()) {
                    timestamp = this.timestampAdapter.getMicros(entity.getLongValue());
                    continue;
                }
                offset = this.buffer.addColumnIndex(offset, columnWriterIndex);
                colType = localDetails.getColumnType(columnWriterIndex);
            } else {
                if (columnWriterIndex != -1) continue;
                String columnName = localDetails.getColName();
                if (this.autoCreateNewColumns && TableUtils.isValidColumnName(columnName, this.maxColumnNameLength)) {
                    offset = this.buffer.addColumnName(offset, columnName);
                    colType = localDetails.getColumnType(columnName, entityType);
                } else {
                    if (!this.autoCreateNewColumns) {
                        throw this.newColumnsNotAllowed(columnName);
                    }
                    throw this.invalidColNameError(columnName);
                }
            }
            ++entitiesWritten;
            switch (entityType) {
                case 1: {
                    if (ColumnType.tagOf(colType) == 12) {
                        offset = this.buffer.addSymbol(offset, entity.getValue(), parser.hasNonAsciiChars(), localDetails.getSymbolLookup(columnWriterIndex));
                        continue block38;
                    }
                    throw this.castError("tag", columnWriterIndex, colType);
                }
                case 3: {
                    switch (ColumnType.tagOf(colType)) {
                        case 6: {
                            offset = this.buffer.addLong(offset, entity.getLongValue());
                            continue block38;
                        }
                        case 5: {
                            long entityValue = entity.getLongValue();
                            if (entityValue >= Integer.MIN_VALUE && entityValue <= Integer.MAX_VALUE) {
                                offset = this.buffer.addInt(offset, (int)entityValue);
                                continue block38;
                            }
                            if (entityValue == Long.MIN_VALUE) {
                                offset = this.buffer.addInt(offset, Integer.MIN_VALUE);
                                continue block38;
                            }
                            throw this.boundsError(entityValue, columnWriterIndex, 5);
                        }
                        case 3: {
                            long entityValue = entity.getLongValue();
                            if (entityValue >= -32768L && entityValue <= 32767L) {
                                offset = this.buffer.addShort(offset, (short)entityValue);
                                continue block38;
                            }
                            if (entityValue == Long.MIN_VALUE) {
                                offset = this.buffer.addShort(offset, (short)0);
                                continue block38;
                            }
                            throw this.boundsError(entityValue, columnWriterIndex, 3);
                        }
                        case 2: {
                            long entityValue = entity.getLongValue();
                            if (entityValue >= -128L && entityValue <= 127L) {
                                offset = this.buffer.addByte(offset, (byte)entityValue);
                                continue block38;
                            }
                            if (entityValue == Long.MIN_VALUE) {
                                offset = this.buffer.addByte(offset, (byte)0);
                                continue block38;
                            }
                            throw this.boundsError(entityValue, columnWriterIndex, 2);
                        }
                        case 8: {
                            offset = this.buffer.addTimestamp(offset, entity.getLongValue());
                            continue block38;
                        }
                        case 7: {
                            offset = this.buffer.addDate(offset, entity.getLongValue());
                            continue block38;
                        }
                        case 10: {
                            offset = this.buffer.addDouble(offset, entity.getLongValue());
                            continue block38;
                        }
                        case 9: {
                            offset = this.buffer.addFloat(offset, entity.getLongValue());
                            continue block38;
                        }
                    }
                    if (this.symbolAsFieldSupported && colType == 12) {
                        offset = this.buffer.addSymbol(offset, entity.getValue(), parser.hasNonAsciiChars(), localDetails.getSymbolLookup(columnWriterIndex));
                        continue block38;
                    }
                    throw this.castError("integer", columnWriterIndex, colType);
                }
                case 2: {
                    switch (ColumnType.tagOf(colType)) {
                        case 10: {
                            offset = this.buffer.addDouble(offset, entity.getFloatValue());
                            continue block38;
                        }
                        case 9: {
                            offset = this.buffer.addFloat(offset, (float)entity.getFloatValue());
                            continue block38;
                        }
                    }
                    if (this.symbolAsFieldSupported && colType == 12) {
                        offset = this.buffer.addSymbol(offset, entity.getValue(), parser.hasNonAsciiChars(), localDetails.getSymbolLookup(columnWriterIndex));
                        continue block38;
                    }
                    throw this.castError("float", columnWriterIndex, colType);
                }
                case 4: {
                    int colTypeMeta = localDetails.getColumnTypeMeta(columnWriterIndex);
                    DirectByteCharSequence entityValue = entity.getValue();
                    if (colTypeMeta == 0) {
                        switch (ColumnType.tagOf(colType)) {
                            case 11: {
                                offset = this.buffer.addString(offset, entityValue, parser.hasNonAsciiChars());
                                continue block38;
                            }
                            case 4: {
                                if (this.stringToCharCastAllowed || entityValue.length() == 1) {
                                    offset = this.buffer.addChar(offset, entityValue.charAt(0));
                                    continue block38;
                                }
                                throw this.castError("string", columnWriterIndex, colType);
                            }
                        }
                        if (this.symbolAsFieldSupported && colType == 12) {
                            offset = this.buffer.addSymbol(offset, entityValue, parser.hasNonAsciiChars(), localDetails.getSymbolLookup(columnWriterIndex));
                            continue block38;
                        }
                        throw this.castError("string", columnWriterIndex, colType);
                    }
                    offset = this.buffer.addGeoHash(offset, entityValue, colTypeMeta);
                    continue block38;
                }
                case 7: {
                    if (ColumnType.tagOf(colType) == 13) {
                        offset = this.buffer.addLong256(offset, entity.getValue(), parser.hasNonAsciiChars());
                        continue block38;
                    }
                    if (this.symbolAsFieldSupported && colType == 12) {
                        offset = this.buffer.addSymbol(offset, entity.getValue(), parser.hasNonAsciiChars(), localDetails.getSymbolLookup(columnWriterIndex));
                        continue block38;
                    }
                    throw this.castError("long256", columnWriterIndex, colType);
                }
                case 6: {
                    byte entityValue = (byte)(entity.getBooleanValue() ? 1 : 0);
                    switch (ColumnType.tagOf(colType)) {
                        case 1: {
                            offset = this.buffer.addBoolean(offset, entityValue);
                            continue block38;
                        }
                        case 2: {
                            offset = this.buffer.addByte(offset, entityValue);
                            continue block38;
                        }
                        case 3: {
                            offset = this.buffer.addShort(offset, entityValue);
                            continue block38;
                        }
                        case 5: {
                            offset = this.buffer.addInt(offset, entityValue);
                            continue block38;
                        }
                        case 6: {
                            offset = this.buffer.addLong(offset, entityValue);
                            continue block38;
                        }
                        case 9: {
                            offset = this.buffer.addFloat(offset, entityValue);
                            continue block38;
                        }
                        case 10: {
                            offset = this.buffer.addDouble(offset, entityValue);
                            continue block38;
                        }
                    }
                    if (this.symbolAsFieldSupported && colType == 12) {
                        offset = this.buffer.addSymbol(offset, entity.getValue(), parser.hasNonAsciiChars(), localDetails.getSymbolLookup(columnWriterIndex));
                        continue block38;
                    }
                    throw this.castError("boolean", columnWriterIndex, colType);
                }
                case 13: {
                    if (ColumnType.tagOf(colType) == 8) {
                        offset = this.buffer.addTimestamp(offset, entity.getLongValue());
                        continue block38;
                    }
                    if (this.symbolAsFieldSupported && colType == 12) {
                        offset = this.buffer.addSymbol(offset, entity.getValue(), parser.hasNonAsciiChars(), localDetails.getSymbolLookup(columnWriterIndex));
                        continue block38;
                    }
                    throw this.castError("timestamp", columnWriterIndex, colType);
                }
                case 5: {
                    if (ColumnType.tagOf(colType) == 12) {
                        offset = this.buffer.addSymbol(offset, entity.getValue(), parser.hasNonAsciiChars(), localDetails.getSymbolLookup(columnWriterIndex));
                        continue block38;
                    }
                    throw this.castError("symbol", columnWriterIndex, colType);
                }
                case 0: {
                    offset = this.buffer.addNull(offset);
                    continue block38;
                }
            }
        }
        this.buffer.addDesignatedTimestamp(this.buffer.getAddress(), timestamp);
        this.buffer.addNumOfColumns(this.buffer.getAddress() + 8L, entitiesWritten);
        this.writerWorkerId = tableUpdateDetails.getWriterThreadId();
    }

    private CairoException newColumnsNotAllowed(String colName) {
        return CairoException.critical(0).put("column does not exist, creating new columns is disabled [table=").put(this.tableUpdateDetails.getTableNameUtf16()).put(", columnName=").put(colName).put(']');
    }

    void createWriterReleaseEvent(TableUpdateDetails tableUpdateDetails, boolean commitOnWriterClose) {
        this.writerWorkerId = -3;
        this.tableUpdateDetails = tableUpdateDetails;
        this.commitOnWriterClose = commitOnWriterClose;
    }

    private CairoException invalidColNameError(CharSequence colName) {
        return CairoException.critical(0).put("invalid column name [table=").put(this.tableUpdateDetails.getTableNameUtf16()).put(", columnName=").put(colName).put(']');
    }
}

