/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.http.processors;

import io.questdb.cairo.CairoEngine;
import io.questdb.cutlass.http.processors.TextLoaderCompletedState;
import io.questdb.cutlass.text.TextLoader;
import io.questdb.std.Misc;
import io.questdb.std.Mutable;
import java.io.Closeable;

class TextImportProcessorState
implements Mutable,
Closeable {
    public static final int STATE_OK = 0;
    public static final int STATE_DATA_ERROR = 2;
    public TextLoaderCompletedState completeState;
    TextLoader textLoader;
    public int columnIndex = 0;
    long hi;
    long lo;
    String stateMessage;
    boolean analysed = false;
    int messagePart = 3;
    int responseState = 1;
    boolean forceHeader = false;
    int state;
    boolean json = false;
    CharSequence errorMessage;

    TextImportProcessorState(CairoEngine engine) {
        this.textLoader = new TextLoader(engine);
    }

    @Override
    public void clear() {
        this.responseState = 1;
        this.columnIndex = 0;
        this.messagePart = 3;
        this.analysed = false;
        this.state = 0;
        this.textLoader.clear();
        this.errorMessage = null;
    }

    @Override
    public void close() {
        this.clear();
        this.textLoader = Misc.free(this.textLoader);
    }

    public void snapshotStateAndCloseWriter() {
        if (this.completeState == null) {
            this.completeState = new TextLoaderCompletedState();
        }
        this.completeState.copyState(this.textLoader);
        this.textLoader.closeWriter();
    }
}

