/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.http.processors;

import io.questdb.metrics.Counter;
import io.questdb.metrics.Gauge;
import io.questdb.metrics.MetricsRegistry;

public class JsonQueryMetrics {
    private final Counter startedQueriesCounter;
    private final Counter completedQueriesCounter;
    private final Gauge cachedQueriesGauge;

    public JsonQueryMetrics(MetricsRegistry metricsRegistry) {
        this.startedQueriesCounter = metricsRegistry.newCounter("json_queries");
        this.completedQueriesCounter = metricsRegistry.newCounter("json_queries_completed");
        this.cachedQueriesGauge = metricsRegistry.newGauge("json_queries_cached");
    }

    public void markStart() {
        this.startedQueriesCounter.inc();
    }

    public void markComplete() {
        this.completedQueriesCounter.inc();
    }

    public Gauge cachedQueriesGauge() {
        return this.cachedQueriesGauge;
    }

    public long startedQueriesCount() {
        return this.startedQueriesCounter.getValue();
    }

    public long completedQueriesCount() {
        return this.completedQueriesCounter.getValue();
    }
}

