/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.http;

import io.questdb.MessageBus;
import io.questdb.Metrics;
import io.questdb.WorkerPoolAwareConfiguration;
import io.questdb.cairo.CairoEngine;
import io.questdb.cutlass.http.HttpConnectionContext;
import io.questdb.cutlass.http.HttpContextConfiguration;
import io.questdb.cutlass.http.HttpMinServerConfiguration;
import io.questdb.cutlass.http.HttpRequestProcessor;
import io.questdb.cutlass.http.HttpRequestProcessorFactory;
import io.questdb.cutlass.http.HttpRequestProcessorSelector;
import io.questdb.cutlass.http.HttpServerConfiguration;
import io.questdb.cutlass.http.WaitProcessor;
import io.questdb.cutlass.http.processors.HealthCheckProcessor;
import io.questdb.cutlass.http.processors.JsonQueryProcessor;
import io.questdb.cutlass.http.processors.PrometheusMetricsProcessor;
import io.questdb.cutlass.http.processors.QueryCache;
import io.questdb.cutlass.http.processors.StaticContentProcessor;
import io.questdb.cutlass.http.processors.TableStatusCheckProcessor;
import io.questdb.cutlass.http.processors.TextImportProcessor;
import io.questdb.cutlass.http.processors.TextQueryProcessor;
import io.questdb.griffin.DatabaseSnapshotAgent;
import io.questdb.griffin.FunctionFactoryCache;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.mp.FanOut;
import io.questdb.mp.Job;
import io.questdb.mp.SCSequence;
import io.questdb.mp.WorkerPool;
import io.questdb.network.IODispatcher;
import io.questdb.network.IODispatchers;
import io.questdb.network.IORequestProcessor;
import io.questdb.network.MutableIOContextFactory;
import io.questdb.std.CharSequenceObjHashMap;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;
import java.io.Closeable;
import org.jetbrains.annotations.Nullable;

public class HttpServer
implements Closeable {
    private static final Log LOG = LogFactory.getLog(HttpServer.class);
    private static final WorkerPoolAwareConfiguration.ServerFactory<HttpServer, HttpServerConfiguration> CREATE0 = HttpServer::create0;
    private static final WorkerPoolAwareConfiguration.ServerFactory<HttpServer, HttpMinServerConfiguration> CREATE_MIN = HttpServer::createMin;
    private final ObjList<HttpRequestProcessorSelectorImpl> selectors;
    private final IODispatcher<HttpConnectionContext> dispatcher;
    private final int workerCount;
    private final HttpContextFactory httpContextFactory;
    private final WorkerPool workerPool;
    private final WaitProcessor rescheduleContext;

    public HttpServer(HttpMinServerConfiguration configuration, MessageBus messageBus, Metrics metrics, WorkerPool pool, boolean localPool) {
        int i;
        this.workerCount = pool.getWorkerCount();
        this.selectors = new ObjList(this.workerCount);
        this.workerPool = localPool ? pool : null;
        for (i = 0; i < this.workerCount; ++i) {
            this.selectors.add(new HttpRequestProcessorSelectorImpl());
        }
        this.httpContextFactory = new HttpContextFactory(configuration.getHttpContextConfiguration(), metrics);
        this.dispatcher = IODispatchers.create(configuration.getDispatcherConfiguration(), this.httpContextFactory);
        pool.assign(this.dispatcher);
        this.rescheduleContext = new WaitProcessor(configuration.getWaitProcessorConfiguration());
        pool.assign(this.rescheduleContext);
        for (i = 0; i < this.workerCount; ++i) {
            final int index = i;
            final SCSequence queryCacheEventSubSeq = new SCSequence();
            FanOut queryCacheEventFanOut = messageBus.getQueryCacheEventFanOut();
            queryCacheEventFanOut.and(queryCacheEventSubSeq);
            pool.assign(i, new Job(){
                private final HttpRequestProcessorSelector selector;
                private final IORequestProcessor<HttpConnectionContext> processor;
                {
                    this.selector = (HttpRequestProcessorSelector)HttpServer.this.selectors.getQuick(index);
                    this.processor = (operation, context) -> context.handleClientOperation(operation, this.selector, HttpServer.this.rescheduleContext);
                }

                @Override
                public boolean run(int workerId) {
                    long seq = queryCacheEventSubSeq.next();
                    if (seq > -1L) {
                        LOG.info().$("flushing HTTP server query cache [worker=").$(workerId).$(']').$();
                        QueryCache.getInstance().clear();
                        queryCacheEventSubSeq.done(seq);
                    }
                    boolean useful = HttpServer.this.dispatcher.processIOQueue(this.processor);
                    return useful |= HttpServer.this.rescheduleContext.runReruns(this.selector);
                }
            });
            pool.assign(i, () -> {
                Misc.free(this.selectors.getQuick(index));
                this.httpContextFactory.close();
                Misc.free(QueryCache.getInstance());
                messageBus.getQueryCacheEventFanOut().remove(queryCacheEventSubSeq);
                queryCacheEventSubSeq.clear();
            });
        }
    }

    public static void addDefaultEndpoints(HttpServer server, final HttpServerConfiguration configuration, final CairoEngine cairoEngine, final WorkerPool workerPool, final int sharedWorkerCount, final HttpRequestProcessorBuilder jsonQueryProcessorBuilder, final FunctionFactoryCache functionFactoryCache, final DatabaseSnapshotAgent snapshotAgent) {
        server.bind(new HttpRequestProcessorFactory(){

            @Override
            public HttpRequestProcessor newInstance() {
                return jsonQueryProcessorBuilder.newInstance();
            }

            @Override
            public String getUrl() {
                return "/exec";
            }
        });
        server.bind(new HttpRequestProcessorFactory(){

            @Override
            public HttpRequestProcessor newInstance() {
                return new TextImportProcessor(cairoEngine);
            }

            @Override
            public String getUrl() {
                return "/imp";
            }
        });
        server.bind(new HttpRequestProcessorFactory(){

            @Override
            public HttpRequestProcessor newInstance() {
                return new TextQueryProcessor(configuration.getJsonQueryProcessorConfiguration(), cairoEngine, workerPool.getWorkerCount(), sharedWorkerCount, functionFactoryCache, snapshotAgent);
            }

            @Override
            public String getUrl() {
                return "/exp";
            }
        });
        server.bind(new HttpRequestProcessorFactory(){

            @Override
            public HttpRequestProcessor newInstance() {
                return new TableStatusCheckProcessor(cairoEngine, configuration.getJsonQueryProcessorConfiguration());
            }

            @Override
            public String getUrl() {
                return "/chk";
            }
        });
        server.bind(new HttpRequestProcessorFactory(){

            @Override
            public HttpRequestProcessor newInstance() {
                return new StaticContentProcessor(configuration);
            }

            @Override
            public String getUrl() {
                return "*";
            }
        });
    }

    @Nullable
    public static HttpServer create(HttpServerConfiguration configuration, WorkerPool sharedWorkerPool, Log workerPoolLog, CairoEngine cairoEngine, Metrics metrics) {
        return HttpServer.create(configuration, sharedWorkerPool, workerPoolLog, cairoEngine, null, null, metrics);
    }

    @Nullable
    public static HttpServer create(HttpServerConfiguration configuration, WorkerPool sharedWorkerPool, Log workerPoolLog, CairoEngine cairoEngine, @Nullable FunctionFactoryCache functionFactoryCache, @Nullable DatabaseSnapshotAgent snapshotAgent, Metrics metrics) {
        return WorkerPoolAwareConfiguration.create(configuration, sharedWorkerPool, workerPoolLog, cairoEngine, CREATE0, functionFactoryCache, snapshotAgent, metrics);
    }

    @Nullable
    public static HttpServer createMin(HttpMinServerConfiguration configuration, WorkerPool sharedWorkerPool, Log workerPoolLog, CairoEngine cairoEngine, @Nullable FunctionFactoryCache functionFactoryCache, @Nullable DatabaseSnapshotAgent snapshotAgent, Metrics metrics) {
        return WorkerPoolAwareConfiguration.create(configuration, sharedWorkerPool, workerPoolLog, cairoEngine, CREATE_MIN, functionFactoryCache, snapshotAgent, metrics);
    }

    public void bind(HttpRequestProcessorFactory factory) {
        this.bind(factory, false);
    }

    public void bind(HttpRequestProcessorFactory factory, boolean useAsDefault) {
        String url = factory.getUrl();
        assert (url != null);
        for (int i = 0; i < this.workerCount; ++i) {
            HttpRequestProcessorSelectorImpl selector = this.selectors.getQuick(i);
            if ("*".equals(url)) {
                selector.defaultRequestProcessor = factory.newInstance();
                continue;
            }
            HttpRequestProcessor processor = factory.newInstance();
            selector.processorMap.put(url, processor);
            if (!useAsDefault) continue;
            selector.defaultRequestProcessor = processor;
        }
    }

    @Override
    public void close() {
        if (this.workerPool != null) {
            this.workerPool.halt();
        }
        Misc.free(this.httpContextFactory);
        Misc.free(this.dispatcher);
        Misc.free(this.rescheduleContext);
    }

    private static HttpServer create0(HttpServerConfiguration configuration, CairoEngine cairoEngine, WorkerPool workerPool, boolean localPool, int sharedWorkerCount, FunctionFactoryCache functionFactoryCache, DatabaseSnapshotAgent snapshotAgent, Metrics metrics) {
        HttpServer s = new HttpServer(configuration, cairoEngine.getMessageBus(), metrics, workerPool, localPool);
        QueryCache.configure(configuration, metrics);
        HttpRequestProcessorBuilder jsonQueryProcessorBuilder = () -> new JsonQueryProcessor(configuration.getJsonQueryProcessorConfiguration(), cairoEngine, workerPool.getWorkerCount(), sharedWorkerCount, functionFactoryCache, snapshotAgent);
        HttpServer.addDefaultEndpoints(s, configuration, cairoEngine, workerPool, sharedWorkerCount, jsonQueryProcessorBuilder, functionFactoryCache, snapshotAgent);
        return s;
    }

    private static HttpServer createMin(HttpMinServerConfiguration configuration, CairoEngine cairoEngine, WorkerPool workerPool, boolean localPool, int sharedWorkerCount, FunctionFactoryCache functionFactoryCache, DatabaseSnapshotAgent snapshotAgent, final Metrics metrics) {
        HttpServer s = new HttpServer(configuration, cairoEngine.getMessageBus(), metrics, workerPool, localPool);
        s.bind(new HttpRequestProcessorFactory(){

            @Override
            public HttpRequestProcessor newInstance() {
                return new HealthCheckProcessor();
            }

            @Override
            public String getUrl() {
                return metrics.isEnabled() ? "/status" : "*";
            }
        }, true);
        if (metrics.isEnabled()) {
            s.bind(new HttpRequestProcessorFactory(){

                @Override
                public HttpRequestProcessor newInstance() {
                    return new PrometheusMetricsProcessor(metrics);
                }

                @Override
                public String getUrl() {
                    return "/metrics";
                }
            });
        }
        return s;
    }

    private static class HttpContextFactory
    extends MutableIOContextFactory<HttpConnectionContext> {
        public HttpContextFactory(HttpContextConfiguration configuration, Metrics metrics) {
            super(() -> new HttpConnectionContext(configuration, metrics), configuration.getConnectionPoolInitialCapacity());
        }
    }

    private static class HttpRequestProcessorSelectorImpl
    implements HttpRequestProcessorSelector {
        private final CharSequenceObjHashMap<HttpRequestProcessor> processorMap = new CharSequenceObjHashMap();
        private HttpRequestProcessor defaultRequestProcessor = null;

        private HttpRequestProcessorSelectorImpl() {
        }

        @Override
        public HttpRequestProcessor select(CharSequence url) {
            return this.processorMap.get(url);
        }

        @Override
        public HttpRequestProcessor getDefaultProcessor() {
            return this.defaultRequestProcessor;
        }

        @Override
        public void close() {
            Misc.free(this.defaultRequestProcessor);
            ObjList<CharSequence> processorKeys = this.processorMap.keys();
            int n = processorKeys.size();
            for (int i = 0; i < n; ++i) {
                Misc.free(this.processorMap.get(processorKeys.getQuick(i)));
            }
        }
    }

    public static interface HttpRequestProcessorBuilder {
        public HttpRequestProcessor newInstance();
    }
}

