/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.http;

import io.questdb.cairo.Reopenable;
import io.questdb.cutlass.http.HttpChunkedResponseSocket;
import io.questdb.cutlass.http.HttpContextConfiguration;
import io.questdb.cutlass.http.HttpException;
import io.questdb.cutlass.http.HttpRawSocket;
import io.questdb.cutlass.http.HttpResponseHeader;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.network.Net;
import io.questdb.network.NetworkFacade;
import io.questdb.network.NoSpaceLeftInResponseBufferException;
import io.questdb.network.PeerDisconnectedException;
import io.questdb.network.PeerIsSlowToReadException;
import io.questdb.std.Chars;
import io.questdb.std.IntObjHashMap;
import io.questdb.std.Mutable;
import io.questdb.std.Numbers;
import io.questdb.std.Unsafe;
import io.questdb.std.Vect;
import io.questdb.std.Zip;
import io.questdb.std.datetime.millitime.DateFormatUtils;
import io.questdb.std.datetime.millitime.MillisecondClock;
import io.questdb.std.ex.ZLibException;
import io.questdb.std.str.AbstractCharSink;
import io.questdb.std.str.CharSink;
import io.questdb.std.str.StdoutSink;
import java.io.Closeable;

public class HttpResponseSink
implements Closeable,
Mutable {
    private static final Log LOG = LogFactory.getLog(HttpResponseSink.class);
    private static final IntObjHashMap<String> httpStatusMap = new IntObjHashMap();
    private final ChunkBuffer buffer;
    private final ChunkBuffer compressOutBuffer;
    private final HttpResponseHeaderImpl headerImpl;
    private final SimpleResponseImpl simple = new SimpleResponseImpl();
    private final ResponseSinkImpl sink = new ResponseSinkImpl();
    private final ChunkedResponseImpl chunkedResponse = new ChunkedResponseImpl();
    private final HttpRawSocketImpl rawSocket = new HttpRawSocketImpl();
    private final NetworkFacade nf;
    private final boolean dumpNetworkTraffic;
    private final String httpVersion;
    private long fd;
    private long z_streamp = 0L;
    private boolean deflateBeforeSend = false;
    private int crc = 0;
    private long total = 0L;
    private long totalBytesSent = 0L;
    private final boolean connectionCloseHeader;
    private boolean headersSent;
    private boolean chunkedRequestDone;
    private boolean compressedHeaderDone;
    private boolean compressedOutputReady;
    private boolean compressionComplete;

    public HttpResponseSink(HttpContextConfiguration configuration) {
        int responseBufferSize = Numbers.ceilPow2(configuration.getSendBufferSize());
        this.nf = configuration.getNetworkFacade();
        this.buffer = new ChunkBuffer(responseBufferSize);
        this.compressOutBuffer = new ChunkBuffer(responseBufferSize);
        this.headerImpl = new HttpResponseHeaderImpl(configuration.getClock());
        this.dumpNetworkTraffic = configuration.getDumpNetworkTraffic();
        this.httpVersion = configuration.getHttpVersion();
        this.connectionCloseHeader = !configuration.getServerKeepAlive();
    }

    public HttpChunkedResponseSocket getChunkedSocket() {
        return this.chunkedResponse;
    }

    @Override
    public void clear() {
        this.headerImpl.clear();
        this.totalBytesSent = 0L;
        this.headersSent = false;
        this.chunkedRequestDone = false;
        this.resetZip();
    }

    @Override
    public void close() {
        if (this.z_streamp != 0L) {
            Zip.deflateEnd(this.z_streamp);
            this.z_streamp = 0L;
            this.compressOutBuffer.close();
        }
        this.buffer.close();
        this.fd = -1L;
    }

    public void setDeflateBeforeSend(boolean deflateBeforeSend) {
        this.deflateBeforeSend = deflateBeforeSend;
        if (this.z_streamp == 0L && deflateBeforeSend) {
            this.z_streamp = Zip.deflateInit();
            this.compressOutBuffer.reopen();
        }
    }

    public int getCode() {
        return this.headerImpl.getCode();
    }

    public SimpleResponseImpl getSimple() {
        return this.simple;
    }

    public void resumeSend() throws PeerDisconnectedException, PeerIsSlowToReadException {
        if (!this.headersSent || !this.deflateBeforeSend) {
            this.sendBuffer(this.buffer);
            return;
        }
        do {
            if (!this.compressedOutputReady && !this.compressionComplete) {
                this.deflate();
            }
            if (!this.compressedOutputReady) break;
            this.sendBuffer(this.compressOutBuffer);
            this.compressedOutputReady = false;
        } while (!this.compressionComplete);
    }

    private void deflate() {
        boolean finished;
        int ret;
        long p;
        int len;
        int nInAvailable;
        if (!this.compressedHeaderDone) {
            int len2 = 10;
            Vect.memcpy(this.compressOutBuffer.getWriteAddress(len2), Zip.gzipHeader, len2);
            this.compressOutBuffer.onWrite(len2);
            this.compressedHeaderDone = true;
        }
        if ((nInAvailable = (int)this.buffer.getReadNAvailable()) > 0) {
            long inAddress = this.buffer.getReadAddress();
            LOG.debug().$("Zip.setInput [inAddress=").$(inAddress).$(", nInAvailable=").$(nInAvailable).$(']').$();
            this.buffer.write64BitZeroPadding();
            Zip.setInput(this.z_streamp, inAddress, nInAvailable);
        }
        do {
            int sz = (int)this.compressOutBuffer.getWriteNAvailable() - 8;
            p = this.compressOutBuffer.getWriteAddress(0);
            LOG.debug().$("deflate starting [p=").$(p).$(", sz=").$(sz).$(", chunkedRequestDone=").$(this.chunkedRequestDone).$(']').$();
            ret = Zip.deflate(this.z_streamp, p, sz, this.chunkedRequestDone);
            len = sz - Zip.availOut(this.z_streamp);
            this.compressOutBuffer.onWrite(len);
            if (ret < 0 && (ret != -5 || len != 0)) {
                throw HttpException.instance("could not deflate [ret=").put(ret);
            }
            int availIn = Zip.availIn(this.z_streamp);
            int nInConsumed = nInAvailable - availIn;
            if (nInConsumed > 0) {
                this.crc = Zip.crc32(this.crc, this.buffer.getReadAddress(), nInConsumed);
                this.total += (long)nInConsumed;
                this.buffer.onRead(nInConsumed);
                nInAvailable = availIn;
            }
            LOG.debug().$("deflate finished [ret=").$(ret).$(", len=").$(len).$(", availIn=").$(availIn).$(']').$();
        } while (len == 0 && nInAvailable > 0);
        if (nInAvailable == 0) {
            this.buffer.clearAndPrepareToWriteToBuffer();
        }
        if (len == 0) {
            this.compressedOutputReady = false;
            return;
        }
        this.compressedOutputReady = true;
        if (len < 0) {
            throw ZLibException.INSTANCE;
        }
        boolean bl = finished = this.chunkedRequestDone && ret == 1;
        if (finished) {
            p = this.compressOutBuffer.getWriteAddress(0);
            Unsafe.getUnsafe().putInt(p, this.crc);
            Unsafe.getUnsafe().putInt(p + 4L, (int)this.total);
            this.compressOutBuffer.onWrite(8);
            this.compressionComplete = true;
        }
        this.compressOutBuffer.prepareToReadFromBuffer(true, finished);
    }

    private void flushSingle() throws PeerDisconnectedException, PeerIsSlowToReadException {
        this.sendBuffer(this.buffer);
    }

    HttpResponseHeader getHeader() {
        return this.headerImpl;
    }

    HttpRawSocket getRawSocket() {
        return this.rawSocket;
    }

    void of(long fd) {
        this.fd = fd;
        if (fd > -1L) {
            this.buffer.reopen();
        }
    }

    private void prepareHeaderSink() {
        this.buffer.prepareToReadFromBuffer(false, false);
        this.headerImpl.prepareToSend();
    }

    private void resetZip() {
        if (this.z_streamp != 0L) {
            Zip.deflateReset(this.z_streamp);
            this.compressOutBuffer.clear();
            this.crc = 0;
            this.total = 0L;
            this.compressedHeaderDone = false;
            this.compressedOutputReady = false;
            this.compressionComplete = false;
        }
    }

    private void sendBuffer(ChunkBuffer sendBuf) throws PeerDisconnectedException, PeerIsSlowToReadException {
        int nSend = (int)sendBuf.getReadNAvailable();
        while (nSend > 0) {
            int n = this.nf.send(this.fd, sendBuf.getReadAddress(), nSend);
            if (n < 0) {
                LOG.error().$("disconnected [errno=").$(this.nf.errno()).$(", fd=").$(this.fd).$(']').$();
                throw PeerDisconnectedException.INSTANCE;
            }
            if (n == 0) {
                throw PeerIsSlowToReadException.INSTANCE;
            }
            this.dumpBuffer(sendBuf.getReadAddress(), n);
            sendBuf.onRead(n);
            nSend -= n;
            this.totalBytesSent += (long)n;
        }
        assert (sendBuf.getReadNAvailable() == 0L);
        sendBuf.clearAndPrepareToWriteToBuffer();
    }

    private void dumpBuffer(long buffer, int size) {
        if (this.dumpNetworkTraffic && size > 0) {
            StdoutSink.INSTANCE.put('<');
            Net.dump(buffer, size);
        }
    }

    long getTotalBytesSent() {
        return this.totalBytesSent;
    }

    static {
        httpStatusMap.put(200, "OK");
        httpStatusMap.put(206, "Partial content");
        httpStatusMap.put(304, "Not Modified");
        httpStatusMap.put(400, "Bad request");
        httpStatusMap.put(404, "Not Found");
        httpStatusMap.put(416, "Request range not satisfiable");
        httpStatusMap.put(431, "Headers too large");
        httpStatusMap.put(500, "Internal server error");
    }

    private class ChunkBuffer
    extends AbstractCharSink
    implements Closeable,
    Reopenable {
        private static final int MAX_CHUNK_HEADER_SIZE = 12;
        private static final String EOF_CHUNK = "\r\n00\r\n\r\n";
        private final long bufSize;
        private long bufStart;
        private long bufStartOfData;
        private long _wptr;
        private long _rptr;

        private ChunkBuffer(int bufSize) {
            this.bufSize = bufSize;
        }

        @Override
        public void close() {
            if (this.bufStart != 0L) {
                Unsafe.free(this.bufStart, this.bufSize + 12L + (long)EOF_CHUNK.length(), 11);
                this._rptr = 0L;
                this._wptr = 0L;
                this.bufStartOfData = 0L;
                this.bufStart = 0L;
            }
        }

        @Override
        public void reopen() {
            if (this.bufStart == 0L) {
                this.bufStart = Unsafe.malloc(this.bufSize + 12L + (long)EOF_CHUNK.length(), 11);
                this.bufStartOfData = this.bufStart + 12L;
                this.clear();
            }
        }

        void clear() {
            this._wptr = this._rptr = this.bufStartOfData;
        }

        long getReadAddress() {
            assert (this._rptr != 0L);
            return this._rptr;
        }

        long getReadNAvailable() {
            return this._wptr - this._rptr;
        }

        void onRead(int nRead) {
            assert (nRead >= 0 && (long)nRead <= this.getReadNAvailable());
            this._rptr += (long)nRead;
        }

        long getWriteAddress(int len) {
            assert (this._wptr != 0L);
            if (this.getWriteNAvailable() >= (long)len) {
                return this._wptr;
            }
            throw NoSpaceLeftInResponseBufferException.INSTANCE;
        }

        long getWriteNAvailable() {
            return this.bufStartOfData + this.bufSize - this._wptr;
        }

        void onWrite(int nWrite) {
            assert (nWrite >= 0 && (long)nWrite <= this.getWriteNAvailable());
            this._wptr += (long)nWrite;
        }

        void write64BitZeroPadding() {
            Unsafe.getUnsafe().putLong(this.bufStartOfData - 8L, 0L);
            Unsafe.getUnsafe().putLong(this._wptr, 0L);
        }

        @Override
        public CharSink put(CharSequence cs) {
            int len = cs.length();
            Chars.asciiStrCpy(cs, len, this.getWriteAddress(len));
            this.onWrite(len);
            return this;
        }

        @Override
        public CharSink put(char c) {
            Unsafe.getUnsafe().putByte(this.getWriteAddress(1), (byte)c);
            this.onWrite(1);
            return this;
        }

        @Override
        public CharSink put(char[] chars, int start, int len) {
            Chars.asciiCopyTo(chars, start, len, this.getWriteAddress(len));
            this.onWrite(len);
            return this;
        }

        @Override
        public CharSink put(CharSequence cs, int lo, int hi) {
            int len = hi - lo;
            Chars.asciiStrCpy(cs, lo, len, this.getWriteAddress(len));
            this.onWrite(len);
            return this;
        }

        void clearAndPrepareToWriteToBuffer() {
            this._rptr = this._wptr = this.bufStartOfData;
        }

        void prepareToReadFromBuffer(boolean addChunkHeader, boolean addEofChunk) {
            int len;
            if (addChunkHeader) {
                len = (int)(this._wptr - this.bufStartOfData);
                int padding = len == 0 ? 6 : Integer.numberOfLeadingZeros(len) >> 3 << 1;
                long tmp = this._wptr;
                this._rptr = this._wptr = this.bufStart + (long)padding;
                this.put("\r\n");
                Numbers.appendHex(this, len);
                this.put("\r\n");
                this._wptr = tmp;
            }
            if (addEofChunk) {
                len = EOF_CHUNK.length();
                Chars.asciiStrCpy(EOF_CHUNK, len, this._wptr);
                this._wptr += (long)len;
                LOG.debug().$("end chunk sent [fd=").$(HttpResponseSink.this.fd).$(']').$();
            }
        }
    }

    private class ChunkedResponseImpl
    extends ResponseSinkImpl
    implements HttpChunkedResponseSocket {
        private long bookmark;

        private ChunkedResponseImpl() {
            this.bookmark = 0L;
        }

        @Override
        public void bookmark() {
            this.bookmark = HttpResponseSink.this.buffer._wptr;
        }

        @Override
        public void done() throws PeerDisconnectedException, PeerIsSlowToReadException {
            if (!HttpResponseSink.this.chunkedRequestDone) {
                this.sendChunk(true);
            }
        }

        @Override
        public HttpResponseHeader headers() {
            return HttpResponseSink.this.headerImpl;
        }

        @Override
        public boolean resetToBookmark() {
            HttpResponseSink.this.buffer._wptr = this.bookmark;
            return this.bookmark != HttpResponseSink.this.buffer.bufStartOfData;
        }

        @Override
        public void sendChunk(boolean done) throws PeerDisconnectedException, PeerIsSlowToReadException {
            HttpResponseSink.this.headersSent = true;
            HttpResponseSink.this.chunkedRequestDone = done;
            if (HttpResponseSink.this.buffer.getReadNAvailable() > 0L || done) {
                if (!HttpResponseSink.this.deflateBeforeSend) {
                    HttpResponseSink.this.buffer.prepareToReadFromBuffer(true, HttpResponseSink.this.chunkedRequestDone);
                }
                HttpResponseSink.this.resumeSend();
            }
        }

        @Override
        public void sendHeader() throws PeerDisconnectedException, PeerIsSlowToReadException {
            HttpResponseSink.this.chunkedRequestDone = false;
            HttpResponseSink.this.prepareHeaderSink();
            HttpResponseSink.this.flushSingle();
            HttpResponseSink.this.buffer.clearAndPrepareToWriteToBuffer();
        }

        @Override
        public void status(int status, CharSequence contentType) {
            super.status(status, contentType);
            if (HttpResponseSink.this.deflateBeforeSend) {
                HttpResponseSink.this.headerImpl.put("Content-Encoding: gzip").put("\r\n");
            }
        }

        @Override
        public void shutdownWrite() {
            HttpResponseSink.this.nf.shutdown(HttpResponseSink.this.fd, 1);
        }
    }

    public class HttpRawSocketImpl
    implements HttpRawSocket {
        @Override
        public long getBufferAddress() {
            return HttpResponseSink.this.buffer.getWriteAddress(1);
        }

        @Override
        public int getBufferSize() {
            return (int)HttpResponseSink.this.buffer.getWriteNAvailable();
        }

        @Override
        public void send(int size) throws PeerDisconnectedException, PeerIsSlowToReadException {
            HttpResponseSink.this.buffer.onWrite(size);
            HttpResponseSink.this.buffer.prepareToReadFromBuffer(false, false);
            HttpResponseSink.this.flushSingle();
            HttpResponseSink.this.buffer.clearAndPrepareToWriteToBuffer();
        }
    }

    private class ResponseSinkImpl
    extends AbstractCharSink {
        private ResponseSinkImpl() {
        }

        @Override
        public CharSink put(CharSequence seq) {
            HttpResponseSink.this.buffer.put(seq);
            return this;
        }

        @Override
        public CharSink put(CharSequence cs, int lo, int hi) {
            HttpResponseSink.this.buffer.put(cs, lo, hi);
            return this;
        }

        @Override
        public CharSink put(char c) {
            HttpResponseSink.this.buffer.put(c);
            return this;
        }

        @Override
        public CharSink put(char[] chars, int start, int len) {
            HttpResponseSink.this.buffer.put(chars, start, len);
            return this;
        }

        @Override
        public CharSink put(float value, int scale) {
            if (Float.isNaN(value) || Float.isInfinite(value)) {
                this.put("null");
                return this;
            }
            return super.put(value, scale);
        }

        @Override
        public CharSink put(double value, int scale) {
            if (Double.isNaN(value) || Double.isInfinite(value)) {
                this.put("null");
                return this;
            }
            return super.put(value, scale);
        }

        @Override
        public void putUtf8Special(char c) {
            if (c < ' ') {
                this.escapeSpace(c);
            } else {
                switch (c) {
                    case '\"': 
                    case '\\': {
                        this.put('\\');
                    }
                }
                this.put(c);
            }
        }

        public void status(int status, CharSequence contentType) {
            HttpResponseSink.this.buffer.clearAndPrepareToWriteToBuffer();
            HttpResponseSink.this.headerImpl.status("HTTP/1.1 ", status, contentType, -1L);
        }

        private void escapeSpace(char c) {
            switch (c) {
                case '\b': {
                    this.put("\\b");
                    break;
                }
                case '\f': {
                    this.put("\\f");
                    break;
                }
                case '\n': {
                    this.put("\\n");
                    break;
                }
                case '\r': {
                    this.put("\\r");
                    break;
                }
                case '\t': {
                    this.put("\\t");
                    break;
                }
                default: {
                    this.put("\\u00");
                    this.put(c >> 4);
                    this.put(Numbers.hexDigits[c & 0xF]);
                }
            }
        }
    }

    public class SimpleResponseImpl {
        public void sendStatus(int code, CharSequence message) throws PeerDisconnectedException, PeerIsSlowToReadException {
            HttpResponseSink.this.buffer.clearAndPrepareToWriteToBuffer();
            String std = HttpResponseSink.this.headerImpl.status(HttpResponseSink.this.httpVersion, code, "text/plain; charset=utf-8", -1L);
            HttpResponseSink.this.prepareHeaderSink();
            HttpResponseSink.this.flushSingle();
            HttpResponseSink.this.buffer.clearAndPrepareToWriteToBuffer();
            HttpResponseSink.this.sink.put(message == null ? std : message).put("\r\n");
            HttpResponseSink.this.buffer.prepareToReadFromBuffer(true, true);
            HttpResponseSink.this.resumeSend();
        }

        public void sendStatus(int code) throws PeerDisconnectedException, PeerIsSlowToReadException {
            HttpResponseSink.this.buffer.clearAndPrepareToWriteToBuffer();
            HttpResponseSink.this.headerImpl.status(HttpResponseSink.this.httpVersion, code, "text/html; charset=utf-8", -2L);
            HttpResponseSink.this.prepareHeaderSink();
            HttpResponseSink.this.flushSingle();
        }

        public void sendStatusWithDefaultMessage(int code) throws PeerDisconnectedException, PeerIsSlowToReadException {
            this.sendStatus(code, null);
        }
    }

    public class HttpResponseHeaderImpl
    extends AbstractCharSink
    implements Mutable,
    HttpResponseHeader {
        private final MillisecondClock clock;
        private boolean chunky;
        private int code;

        public HttpResponseHeaderImpl(MillisecondClock clock) {
            this.clock = clock;
        }

        @Override
        public void clear() {
            HttpResponseSink.this.buffer.clearAndPrepareToWriteToBuffer();
            this.chunky = false;
        }

        public int getCode() {
            return this.code;
        }

        @Override
        public CharSink put(CharSequence cs) {
            int len = cs.length();
            Chars.asciiStrCpy(cs, len, HttpResponseSink.this.buffer.getWriteAddress(len));
            HttpResponseSink.this.buffer.onWrite(len);
            return this;
        }

        @Override
        public CharSink put(char c) {
            Unsafe.getUnsafe().putByte(HttpResponseSink.this.buffer.getWriteAddress(1), (byte)c);
            HttpResponseSink.this.buffer.onWrite(1);
            return this;
        }

        @Override
        public CharSink put(char[] chars, int start, int len) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void send() throws PeerDisconnectedException, PeerIsSlowToReadException {
            HttpResponseSink.this.headerImpl.prepareToSend();
            HttpResponseSink.this.flushSingle();
        }

        @Override
        public String status(CharSequence httpProtocolVersion, int code, CharSequence contentType, long contentLength) {
            this.code = code;
            String status = (String)httpStatusMap.get(code);
            if (status == null) {
                throw new IllegalArgumentException("Illegal status code: " + code);
            }
            HttpResponseSink.this.buffer.clearAndPrepareToWriteToBuffer();
            this.put(httpProtocolVersion).put(code).put(' ').put(status).put("\r\n");
            this.put("Server: ").put("questDB/1.0").put("\r\n");
            this.put("Date: ");
            DateFormatUtils.formatHTTP(this, this.clock.getTicks());
            this.put("\r\n");
            if (contentLength > -2L) {
                boolean bl = this.chunky = contentLength == -1L;
                if (this.chunky) {
                    this.put("Transfer-Encoding: ").put("chunked").put("\r\n");
                } else {
                    this.put("Content-Length: ").put(contentLength).put("\r\n");
                }
            }
            if (contentType != null) {
                this.put("Content-Type: ").put(contentType).put("\r\n");
            }
            if (HttpResponseSink.this.connectionCloseHeader) {
                this.put("Connection: close").put("\r\n");
            }
            return status;
        }

        private void prepareToSend() {
            if (!this.chunky) {
                this.put("\r\n");
            }
        }
    }
}

