/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.sql;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.sql.PageFrame;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.std.IntList;
import io.questdb.std.LongList;
import io.questdb.std.Mutable;
import io.questdb.std.Rows;

public class PageAddressCache
implements Mutable {
    private final long cacheSizeThreshold;
    private int columnCount;
    private int varLenColumnCount;
    private final IntList varLenColumnIndexes = new IntList();
    private LongList pageAddresses = new LongList();
    private LongList indexPageAddresses = new LongList();
    private LongList pageSizes = new LongList();
    private LongList pageRowIdOffsets = new LongList();

    public PageAddressCache(CairoConfiguration configuration) {
        this.cacheSizeThreshold = configuration.getSqlJitPageAddressCacheThreshold() / 8;
    }

    public void of(RecordMetadata metadata) {
        this.columnCount = metadata.getColumnCount();
        this.varLenColumnIndexes.setAll(this.columnCount, -1);
        this.varLenColumnCount = 0;
        for (int columnIndex = 0; columnIndex < this.columnCount; ++columnIndex) {
            int columnType = metadata.getColumnType(columnIndex);
            if (!ColumnType.isVariableLength(columnType)) continue;
            this.varLenColumnIndexes.setQuick(columnIndex, this.varLenColumnCount++);
        }
    }

    @Override
    public void clear() {
        this.varLenColumnIndexes.clear();
        if ((long)this.pageAddresses.size() < this.cacheSizeThreshold) {
            this.pageAddresses.clear();
            this.indexPageAddresses.clear();
            this.pageSizes.clear();
            this.pageRowIdOffsets.clear();
        } else {
            this.pageAddresses = new LongList();
            this.indexPageAddresses = new LongList();
            this.pageSizes = new LongList();
            this.pageRowIdOffsets = new LongList();
        }
    }

    public void add(int frameIndex, PageFrame frame) {
        if (this.pageAddresses.size() >= this.columnCount * (frameIndex + 1)) {
            return;
        }
        for (int columnIndex = 0; columnIndex < this.columnCount; ++columnIndex) {
            this.pageAddresses.add(frame.getPageAddress(columnIndex));
            int varLenColumnIndex = this.varLenColumnIndexes.getQuick(columnIndex);
            if (varLenColumnIndex <= -1) continue;
            this.indexPageAddresses.add(frame.getIndexPageAddress(columnIndex));
            this.pageSizes.add(frame.getPageSize(columnIndex));
        }
        this.pageRowIdOffsets.add(Rows.toRowID(frame.getPartitionIndex(), frame.getPartitionLo()));
    }

    public long getPageAddress(int frameIndex, int columnIndex) {
        assert (this.pageAddresses.size() >= this.columnCount * (frameIndex + 1));
        return this.pageAddresses.getQuick(this.columnCount * frameIndex + columnIndex);
    }

    public long getIndexPageAddress(int frameIndex, int columnIndex) {
        assert (this.indexPageAddresses.size() >= this.varLenColumnCount * (frameIndex + 1));
        int varLenColumnIndex = this.varLenColumnIndexes.getQuick(columnIndex);
        assert (varLenColumnIndex > -1);
        return this.indexPageAddresses.getQuick(this.varLenColumnCount * frameIndex + varLenColumnIndex);
    }

    public long getPageSize(int frameIndex, int columnIndex) {
        assert (this.pageSizes.size() >= this.varLenColumnCount * (frameIndex + 1));
        int varLenColumnIndex = this.varLenColumnIndexes.getQuick(columnIndex);
        assert (varLenColumnIndex > -1);
        return this.pageSizes.getQuick(this.varLenColumnCount * frameIndex + varLenColumnIndex);
    }

    public boolean hasColumnTops(int frameIndex) {
        assert (this.pageAddresses.size() >= this.columnCount * (frameIndex + 1));
        int baseIndex = this.columnCount * frameIndex;
        for (int columnIndex = 0; columnIndex < this.columnCount; ++columnIndex) {
            if (this.pageAddresses.getQuick(baseIndex + columnIndex) != 0L) continue;
            return true;
        }
        return false;
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    public long toTableRowID(int frameIndex, long index) {
        return this.pageRowIdOffsets.get(frameIndex) + index;
    }
}

