/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.pool;

import io.questdb.MessageBus;
import io.questdb.Metrics;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.DefaultLifecycleManager;
import io.questdb.cairo.EntryUnavailableException;
import io.questdb.cairo.LifecycleManager;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.TableWriter;
import io.questdb.cairo.pool.AbstractPool;
import io.questdb.cairo.pool.PoolConstants;
import io.questdb.cairo.pool.ex.EntryLockedException;
import io.questdb.cairo.pool.ex.PoolClosedException;
import io.questdb.cairo.sql.AsyncWriterCommand;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.ConcurrentHashMap;
import io.questdb.std.Misc;
import io.questdb.std.Os;
import io.questdb.std.Unsafe;
import io.questdb.std.datetime.microtime.MicrosecondClock;
import io.questdb.std.str.Path;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WriterPool
extends AbstractPool {
    public static final String OWNERSHIP_REASON_NONE = null;
    public static final String OWNERSHIP_REASON_UNKNOWN = "unknown";
    public static final String OWNERSHIP_REASON_RELEASED = "released";
    static final String OWNERSHIP_REASON_MISSING = "missing or owned by other process";
    static final String OWNERSHIP_REASON_WRITER_ERROR = "writer error";
    private static final Log LOG = LogFactory.getLog(WriterPool.class);
    private static final long ENTRY_OWNER = Unsafe.getFieldOffset(Entry.class, "owner");
    private static final long QUEUE_PROCESSING_OWNER = -2L;
    private final ConcurrentHashMap<Entry> entries = new ConcurrentHashMap();
    private final CairoConfiguration configuration;
    private final Path path = new Path();
    private final int rootLen;
    private final MicrosecondClock clock;
    private final CharSequence root;
    @NotNull
    private final MessageBus messageBus;
    @NotNull
    private final Metrics metrics;

    public WriterPool(CairoConfiguration configuration, @NotNull MessageBus messageBus, @NotNull Metrics metrics) {
        super(configuration, configuration.getInactiveWriterTTL());
        this.configuration = configuration;
        this.messageBus = messageBus;
        this.clock = configuration.getMicrosecondClock();
        this.root = configuration.getRoot();
        this.path.concat(this.root);
        this.rootLen = this.path.length();
        this.metrics = metrics;
        this.notifyListener(Thread.currentThread().getId(), null, (short)23);
    }

    public TableWriter get(CharSequence tableName, CharSequence lockReason) {
        return this.getWriterEntry(tableName, lockReason, null);
    }

    public int getBusyCount() {
        int count = 0;
        for (Entry e : this.entries.values()) {
            if (e.owner == -1L) continue;
            ++count;
        }
        return count;
    }

    public TableWriter getWriterOrPublishCommand(CharSequence tableName, String lockReason, @NotNull AsyncWriterCommand asyncWriterCommand) {
        while (true) {
            try {
                return this.getWriterEntry(tableName, lockReason, asyncWriterCommand);
            }
            catch (EntryUnavailableException entryUnavailableException) {
                continue;
            }
            break;
        }
    }

    public CharSequence lock(CharSequence tableName, CharSequence lockReason) {
        this.checkClosed();
        long thread = Thread.currentThread().getId();
        Entry e = this.entries.get(tableName);
        if (e == null) {
            e = new Entry(this.clock.getTicks());
            Entry other = this.entries.putIfAbsent(tableName, e);
            if (other == null) {
                if (this.lockAndNotify(thread, e, tableName, lockReason)) {
                    return OWNERSHIP_REASON_NONE;
                }
                this.entries.remove(tableName);
                return this.reinterpretOwnershipReason(e.ownershipReason);
            }
            e = other;
        }
        if (Unsafe.cas((Object)e, ENTRY_OWNER, -1L, thread)) {
            this.closeWriter(thread, e, (short)19, 2);
            if (this.lockAndNotify(thread, e, tableName, lockReason)) {
                return OWNERSHIP_REASON_NONE;
            }
            return this.reinterpretOwnershipReason(e.ownershipReason);
        }
        LOG.error().$("could not lock, busy [table=`").utf8(tableName).$("`, owner=").$(e.owner).$(", thread=").$(thread).$(']').$();
        this.notifyListener(thread, tableName, (short)7);
        return this.reinterpretOwnershipReason(e.ownershipReason);
    }

    public int size() {
        return this.entries.size();
    }

    public void unlock(CharSequence name) {
        this.unlock(name, null, false);
    }

    public void unlock(CharSequence name, @Nullable TableWriter writer, boolean newTable) {
        long thread = Thread.currentThread().getId();
        Entry e = this.entries.get(name);
        if (e == null) {
            this.notifyListener(thread, name, (short)9);
            return;
        }
        if (e.owner == thread) {
            if (e.writer != null) {
                this.notifyListener(thread, name, (short)9);
                throw CairoException.critical(0).put("Writer ").put(name).put(" is not locked");
            }
            if (newTable) {
                assert (writer == null && e.lockFd != -1L);
                LOG.info().$("created [table=`").utf8(name).$("`, thread=").$(thread).$(']').$();
                writer = new TableWriter(this.configuration, name, this.messageBus, null, false, e, this.root, this.metrics);
            }
            if (writer == null) {
                if (e.lockFd != -1L) {
                    this.ff.close(e.lockFd);
                    TableUtils.lockName(this.path.trimTo(this.rootLen).concat(name));
                    if (!this.ff.remove(this.path)) {
                        LOG.error().$("could not remove [file=").$(this.path).$(']').$();
                    }
                }
                this.entries.remove(name);
            } else {
                e.writer = writer;
                writer.setLifecycleManager(e);
                writer.transferLock(e.lockFd);
                e.lockFd = -1L;
                e.ownershipReason = WriterPool.OWNERSHIP_REASON_NONE;
                Unsafe.getUnsafe().storeFence();
                Unsafe.getUnsafe().putOrderedLong(e, ENTRY_OWNER, -1L);
            }
        } else {
            this.notifyListener(thread, name, (short)12);
            throw CairoException.critical(0).put("Not lock owner of ").put(name);
        }
        this.notifyListener(thread, name, (short)8);
        LOG.debug().$("unlocked [table=`").utf8(name).$("`, thread=").$(thread).I$();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addCommandToWriterQueue(Entry e, AsyncWriterCommand asyncWriterCommand, long thread) {
        TableWriter writer;
        while ((writer = e.writer) == null && e.owner != -1L) {
            Os.pause();
        }
        if (writer == null) {
            throw EntryUnavailableException.instance("please retry");
        }
        asyncWriterCommand.startAsync();
        writer.publishAsyncWriterCommand(asyncWriterCommand);
        while (e.owner == -2L) {
            Os.pause();
        }
        if (Unsafe.cas((Object)e, ENTRY_OWNER, -1L, thread)) {
            try {
                writer.tick(true);
            }
            finally {
                Unsafe.cas((Object)e, ENTRY_OWNER, thread, -1L);
            }
        }
    }

    private void assertLockReasonIsNone(CharSequence lockReason) {
        if (lockReason == OWNERSHIP_REASON_NONE) {
            throw new NullPointerException();
        }
    }

    private void checkClosed() {
        if (this.isClosed()) {
            LOG.info().$("is closed").$();
            throw PoolClosedException.INSTANCE;
        }
    }

    private TableWriter checkClosedAndGetWriter(CharSequence tableName, Entry e, CharSequence lockReason) {
        this.assertLockReasonIsNone(lockReason);
        if (this.isClosed()) {
            LOG.info().$('\'').utf8(tableName).$("' born free").$();
            return e.goodbye();
        }
        e.ownershipReason = lockReason;
        return this.logAndReturn(e, (short)11);
    }

    @Override
    protected void closePool() {
        super.closePool();
        Misc.free(this.path);
        LOG.info().$("closed").$();
    }

    @Override
    protected boolean releaseAll(long deadline) {
        long thread = Thread.currentThread().getId();
        boolean removed = false;
        int reason = deadline == Long.MAX_VALUE ? 1 : 3;
        Iterator<Entry> iterator = this.entries.values().iterator();
        while (iterator.hasNext()) {
            Entry e = iterator.next();
            if (deadline > e.lastReleaseTime && e.owner == -1L) {
                if (!Unsafe.cas((Object)e, ENTRY_OWNER, -1L, -thread - 3L)) continue;
                this.closeWriter(thread, e, (short)17, reason);
                iterator.remove();
                removed = true;
                continue;
            }
            if (e.lockFd != -1L && deadline == Long.MAX_VALUE) {
                if (!this.ff.close(e.lockFd)) continue;
                e.lockFd = -1L;
                iterator.remove();
                removed = true;
                continue;
            }
            if (e.ex == null) continue;
            LOG.info().$("purging entry for failed to allocate writer").$();
            iterator.remove();
            removed = true;
        }
        return removed;
    }

    private void closeWriter(long thread, Entry e, short ev, int reason) {
        TableWriter w = e.writer;
        if (w != null) {
            String name = e.writer.getTableName();
            w.setLifecycleManager(DefaultLifecycleManager.INSTANCE);
            w.close();
            e.writer = null;
            e.ownershipReason = OWNERSHIP_REASON_RELEASED;
            LOG.info().$("closed [table=`").utf8(name).$("`, reason=").$(PoolConstants.closeReasonText(reason)).$(", by=").$(thread).$(']').$();
            this.notifyListener(thread, name, ev);
        }
    }

    int countFreeWriters() {
        int count = 0;
        for (Entry e : this.entries.values()) {
            long owner = e.owner;
            if (owner == -1L) {
                ++count;
                continue;
            }
            LOG.info().$("'").utf8(e.writer.getTableName()).$("' is still busy [owner=").$(owner).$(']').$();
        }
        return count;
    }

    private TableWriter createWriter(CharSequence name, Entry e, long thread, CharSequence lockReason) {
        try {
            this.checkClosed();
            LOG.info().$("open [table=`").utf8(name).$("`, thread=").$(thread).$(']').$();
            e.writer = new TableWriter(this.configuration, name, this.messageBus, null, true, e, this.root, this.metrics);
            e.ownershipReason = lockReason;
            return this.logAndReturn(e, (short)10);
        }
        catch (CairoException ex) {
            LOG.critical().$("could not open [table=`").utf8(name).$("`, thread=").$(e.owner).$(", ex=").$(ex.getFlyweightMessage()).$(", errno=").$(ex.getErrno()).$(']').$();
            e.ex = ex;
            e.ownershipReason = OWNERSHIP_REASON_WRITER_ERROR;
            e.owner = -1L;
            this.notifyListener(e.owner, name, (short)14);
            throw ex;
        }
    }

    private TableWriter getWriterEntry(CharSequence tableName, CharSequence lockReason, @Nullable AsyncWriterCommand asyncWriterCommand) {
        long owner;
        Entry e;
        assert (null != lockReason);
        this.checkClosed();
        long thread = Thread.currentThread().getId();
        while (true) {
            if ((e = this.entries.get(tableName)) == null) {
                e = new Entry(this.clock.getTicks());
                Entry other = this.entries.putIfAbsent(tableName, e);
                if (other == null) {
                    return this.createWriter(tableName, e, thread, lockReason);
                }
                e = other;
            }
            owner = e.owner;
            if (Unsafe.cas((Object)e, ENTRY_OWNER, -1L, thread)) {
                if (e.writer == null) {
                    return this.createWriter(tableName, e, thread, lockReason);
                }
                return this.checkClosedAndGetWriter(tableName, e, lockReason);
            }
            if (owner >= 0L) break;
            Os.pause();
        }
        if (owner == thread) {
            if (e.lockFd != -1L) {
                throw EntryLockedException.instance(this.reinterpretOwnershipReason(e.ownershipReason));
            }
            if (e.ex != null) {
                this.notifyListener(thread, tableName, (short)21);
                this.entries.remove(tableName);
                throw e.ex;
            }
        }
        if (asyncWriterCommand != null) {
            this.addCommandToWriterQueue(e, asyncWriterCommand, thread);
            return null;
        }
        CharSequence reason = this.reinterpretOwnershipReason(e.ownershipReason);
        LOG.info().$("busy [table=`").utf8(tableName).$("`, owner=").$(owner).$(", thread=").$(thread).$(", reason=").$(reason).I$();
        throw EntryUnavailableException.instance(reason);
    }

    private boolean lockAndNotify(long thread, Entry e, CharSequence tableName, CharSequence lockReason) {
        this.assertLockReasonIsNone(lockReason);
        TableUtils.lockName(this.path.trimTo(this.rootLen).concat(tableName));
        e.lockFd = TableUtils.lock(this.ff, this.path);
        if (e.lockFd == -1L) {
            LOG.error().$("could not lock [table=`").utf8(tableName).$("`, thread=").$(thread).$(']').$();
            e.ownershipReason = OWNERSHIP_REASON_MISSING;
            e.owner = -1L;
            return false;
        }
        LOG.debug().$("locked [table=`").utf8(tableName).$("`, thread=").$(thread).$(']').$();
        this.notifyListener(thread, tableName, (short)6);
        e.ownershipReason = lockReason;
        return true;
    }

    private TableWriter logAndReturn(Entry e, short event) {
        LOG.info().$(">> [table=`").utf8(e.writer.getTableName()).$("`, thread=").$(e.owner).$(']').$();
        this.notifyListener(e.owner, e.writer.getTableName(), event);
        return e.writer;
    }

    private CharSequence reinterpretOwnershipReason(CharSequence providedReason) {
        return providedReason == OWNERSHIP_REASON_NONE ? OWNERSHIP_REASON_UNKNOWN : providedReason;
    }

    private boolean returnToPool(Entry e) {
        long thread = Thread.currentThread().getId();
        String name = e.writer.getTableName();
        try {
            e.writer.rollback();
            if (e.owner != -1L) {
                e.owner = -2L;
            }
            e.writer.tick(true);
        }
        catch (Throwable ex) {
            this.entries.remove(name);
            this.closeWriter(thread, e, (short)19, 5);
            return true;
        }
        if (e.owner != -1L) {
            LOG.info().$("<< [table=`").utf8(name).$("`, thread=").$(thread).$(']').$();
            e.ownershipReason = WriterPool.OWNERSHIP_REASON_NONE;
            e.lastReleaseTime = this.configuration.getMicrosecondClock().getTicks();
            Unsafe.getUnsafe().storeFence();
            Unsafe.getUnsafe().putOrderedLong(e, ENTRY_OWNER, -1L);
            if (this.isClosed() && Unsafe.cas((Object)e, ENTRY_OWNER, -1L, thread)) {
                e.writer = null;
                this.notifyListener(thread, name, (short)2);
                return false;
            }
            this.notifyListener(thread, name, (short)1);
        } else {
            LOG.critical().$("orphaned [table=`").utf8(name).$("`]").$();
            this.notifyListener(thread, name, (short)3);
        }
        return true;
    }

    private class Entry
    implements LifecycleManager {
        private volatile long owner = Thread.currentThread().getId();
        private volatile CharSequence ownershipReason = OWNERSHIP_REASON_NONE;
        private TableWriter writer;
        private volatile long lastReleaseTime;
        private CairoException ex = null;
        private volatile long lockFd = -1L;

        public Entry(long lastReleaseTime) {
            this.lastReleaseTime = lastReleaseTime;
        }

        @Override
        public boolean close() {
            return !WriterPool.this.returnToPool(this);
        }

        public TableWriter goodbye() {
            TableWriter w = this.writer;
            if (this.writer != null) {
                this.writer.setLifecycleManager(DefaultLifecycleManager.INSTANCE);
                this.writer = null;
            }
            return w;
        }
    }
}

