/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.mig;

import io.questdb.cairo.CairoException;
import io.questdb.cairo.mig.EngineMigration;
import io.questdb.cairo.mig.MigrationContext;
import io.questdb.cairo.vm.api.MemoryMARW;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.FilesFacade;
import io.questdb.std.str.LPSZ;
import io.questdb.std.str.Path;

final class Mig614 {
    private static final long TX_OFFSET_STRUCT_VERSION = 40L;
    private static final long META_OFFSET_STRUCTURE_VERSION = 32L;
    private static final Log LOG = LogFactory.getLog(EngineMigration.class);

    Mig614() {
    }

    static void migrate(MigrationContext migrationContext) {
        FilesFacade ff = migrationContext.getFf();
        Path path = migrationContext.getTablePath();
        Path path2 = migrationContext.getTablePath2();
        try (MemoryMARW rwMemory = migrationContext.getRwMemory();){
            path2.concat("_txn").$();
            Mig614.openFileSafe(rwMemory, ff, path2, 40L);
            long structureVersion = rwMemory.getLong(40L);
            path.concat("_meta").$();
            Mig614.openFileSafe(rwMemory, ff, path, 32L);
            LOG.advisory().$("copying structure version [version=").$(structureVersion).$(", migration=614, metadata=").$(path).I$();
            rwMemory.putLong(32L, structureVersion);
        }
    }

    private static void openFileSafe(MemoryMARW metaMem, FilesFacade ff, Path path, long readOffset) {
        long fileLen = ff.length(path);
        if (fileLen < 0L) {
            throw CairoException.critical(ff.errno()).put("cannot read file length: ").put(path);
        }
        if (fileLen < readOffset + 8L) {
            throw CairoException.critical(0).put("File length ").put(fileLen).put(" is too small at ").put(path);
        }
        metaMem.of(ff, (LPSZ)path, ff.getPageSize(), fileLen, 1);
    }
}

