/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.mig;

import io.questdb.cairo.PartitionBy;
import io.questdb.cairo.mig.EngineMigration;
import io.questdb.cairo.mig.MigrationContext;
import io.questdb.cairo.vm.MemoryCMARWImpl;
import io.questdb.cairo.vm.api.MemoryMARW;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.FilesFacade;
import io.questdb.std.str.LPSZ;
import io.questdb.std.str.Path;

final class Mig609 {
    private static final long TX_OFFSET_FIXED_ROW_COUNT_505 = 16L;
    private static final long TX_OFFSET_MAP_WRITER_COUNT_608 = 128L;
    private static final Log LOG = LogFactory.getLog(EngineMigration.class);

    Mig609() {
    }

    static void migrate(MigrationContext migrationContext) {
        FilesFacade ff = migrationContext.getFf();
        Path path = migrationContext.getTablePath();
        int plen = path.length();
        path.trimTo(plen).concat("_meta").$();
        try (MemoryMARW metaMem = migrationContext.getRwMemory();){
            metaMem.of(ff, (LPSZ)path, ff.getPageSize(), ff.length(path), 1);
            int partitionBy = metaMem.getInt(4L);
            try (MemoryCMARWImpl txMem = new MemoryCMARWImpl(ff, path.trimTo(plen).concat("_txn").$(), ff.getPageSize(), ff.length(path), 1, migrationContext.getConfiguration().getWriterFileOpenOpts());){
                int symbolMapCount = txMem.getInt(128L);
                long partitionCountOffset = 132L + (long)symbolMapCount * 8L;
                int partitionCount = txMem.getInt(partitionCountOffset) / 8 / 4 - 1;
                if (PartitionBy.isPartitioned(partitionBy)) {
                    long calculatedFixedRowCount = 0L;
                    for (int partitionIndex = 0; partitionIndex < partitionCount; ++partitionIndex) {
                        long partitionDataOffset = partitionCountOffset + 4L + (long)partitionIndex * 8L * 4L;
                        calculatedFixedRowCount += txMem.getLong(partitionDataOffset + 8L);
                    }
                    long currentFixedRowCount = txMem.getLong(16L);
                    if (currentFixedRowCount != calculatedFixedRowCount) {
                        txMem.putLong(16L, calculatedFixedRowCount);
                        LOG.info().$("fixed row count is out [table=").$(path.trimTo(plen).$()).$(", currentFixedRowCount=").$(currentFixedRowCount).$(", calculatedFixedRowCount=").$(calculatedFixedRowCount).I$();
                    }
                }
            }
        }
    }
}

