/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.mig;

import io.questdb.cairo.CairoException;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.PartitionBy;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.mig.MigrationActions;
import io.questdb.cairo.mig.MigrationContext;
import io.questdb.cairo.vm.MemoryCMARWImpl;
import io.questdb.cairo.vm.Vm;
import io.questdb.cairo.vm.api.MemoryMARW;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.FilesFacade;
import io.questdb.std.Os;
import io.questdb.std.str.CharSink;
import io.questdb.std.str.LPSZ;
import io.questdb.std.str.Path;

final class Mig607 {
    private static final String TXN_FILE_NAME = "_txn";
    private static final String META_FILE_NAME = "_meta";
    private static final String DEFAULT_PARTITION_NAME = "default";
    private static final long TX_OFFSET_TRANSIENT_ROW_COUNT = 8L;
    private static final int LONGS_PER_TX_ATTACHED_PARTITION = 4;
    private static final Log LOG = LogFactory.getLog(Mig607.class);

    Mig607() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void migrate(FilesFacade ff, Path path, MigrationContext migrationContext, MemoryMARW metaMem, int columnCount, long rowCount, long columnNameOffset) {
        int plen2 = path.length();
        if (rowCount > 0L) {
            long mem = migrationContext.getTempMemory();
            long currentColumnNameOffset = columnNameOffset;
            for (int i = 0; i < columnCount; ++i) {
                short columnType = ColumnType.tagOf(metaMem.getInt(MigrationActions.prefixedBlockOffset(128L, i, 16L)));
                CharSequence columnName = metaMem.getStr(currentColumnNameOffset);
                currentColumnNameOffset += (long)Vm.getStorageLength(columnName);
                if (columnType != 11 && columnType != 18) continue;
                long columnTop = Mig607.readColumnTop(ff, path.trimTo(plen2), columnName, plen2, false);
                long columnRowCount = rowCount - columnTop;
                long offset = columnRowCount * 8L;
                Mig607.iFile(path.trimTo(plen2), columnName);
                long fd = TableUtils.openRW(ff, path, MigrationActions.LOG, migrationContext.getConfiguration().getWriterFileOpenOpts());
                try {
                    long fileLen = ff.length(fd);
                    if (fileLen < offset) {
                        throw CairoException.critical(0).put("file is too short [path=").put(path).put("]");
                    }
                    TableUtils.allocateDiskSpace(ff, fd, offset + 8L);
                    long dataOffset = TableUtils.readLongOrFail(ff, fd, offset - 8L, mem, path);
                    Mig607.dFile(path.trimTo(plen2), columnName);
                    long fd2 = TableUtils.openRO(ff, path, MigrationActions.LOG);
                    try {
                        long len;
                        dataOffset = columnType == 18 ? ((len = TableUtils.readLongOrFail(ff, fd2, dataOffset, mem, path)) == -1L ? (dataOffset += 8L) : (dataOffset += 8L + len)) : ((len = (long)TableUtils.readIntOrFail(ff, fd2, dataOffset, mem, path)) == -1L ? (dataOffset += 4L) : (dataOffset += MigrationActions.prefixedBlockOffset(4L, 2L, len)));
                    }
                    finally {
                        ff.close(fd2);
                    }
                    TableUtils.writeLongOrFail(ff, fd, offset, dataOffset, mem, path);
                    continue;
                }
                finally {
                    Vm.bestEffortClose(ff, MigrationActions.LOG, fd, true, offset + 8L);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long readColumnTop(FilesFacade ff, Path path, CharSequence name, int plen, boolean failIfCouldNotRead) {
        try {
            if (ff.exists(Mig607.topFile(path.chop$(), name))) {
                long fd = TableUtils.openRO(ff, path, LOG);
                try {
                    long n = ff.readULong(fd, 0L);
                    if (n < 0L) {
                        if (failIfCouldNotRead) {
                            throw CairoException.critical(Os.errno()).put("could not read top of column [file=").put(path).put(", read=").put(n).put(']');
                        }
                        LOG.error().$("could not read top of column [file=").$(path).$(", read=").$(n).$(", errno=").$(ff.errno()).I$();
                        long l = 0L;
                        return l;
                    }
                    long l = n;
                    return l;
                }
                finally {
                    ff.close(fd);
                }
            }
            long l = 0L;
            return l;
        }
        finally {
            path.trimTo(plen);
        }
    }

    public static void txnPartition(CharSink path, long txn) {
        path.put('.').put(txn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void migrate(MigrationContext migrationContext) {
        long metaFileSize;
        long txFileSize;
        FilesFacade ff = migrationContext.getFf();
        Path path = migrationContext.getTablePath();
        int plen = path.length();
        path.trimTo(plen).concat(META_FILE_NAME).$();
        try (MemoryMARW metaMem = migrationContext.getRwMemory();){
            metaMem.of(ff, (LPSZ)path, ff.getPageSize(), ff.length(path), 1);
            int columnCount = metaMem.getInt(0L);
            int partitionBy = metaMem.getInt(4L);
            long columnNameOffset = MigrationActions.prefixedBlockOffset(128L, columnCount, 16L);
            try (MemoryCMARWImpl txMem = new MemoryCMARWImpl(ff, path.trimTo(plen).concat(TXN_FILE_NAME).$(), ff.getPageSize(), ff.length(path), 1, migrationContext.getConfiguration().getWriterFileOpenOpts());){
                int symbolMapCount = txMem.getInt(72L);
                long partitionCountOffset = 76L + (long)symbolMapCount * 8L;
                int partitionCount = txMem.getInt(partitionCountOffset) / 8 / 4;
                long transientRowCount = txMem.getLong(8L);
                if (PartitionBy.isPartitioned(partitionBy)) {
                    for (int partitionIndex = 0; partitionIndex < partitionCount; ++partitionIndex) {
                        long partitionDataOffset = partitionCountOffset + 4L + (long)partitionIndex * 8L * 4L;
                        TableUtils.setPathForPartition(path.trimTo(plen), partitionBy, txMem.getLong(partitionDataOffset), false);
                        long rowCount = partitionIndex < partitionCount - 1 ? txMem.getLong(partitionDataOffset + 8L) : transientRowCount;
                        long txSuffix = txMem.getLong(MigrationActions.prefixedBlockOffset(partitionDataOffset, 2L, 8L));
                        if (txSuffix > -1L) {
                            Mig607.txnPartition(path, txSuffix);
                        }
                        Mig607.migrate(ff, path, migrationContext, metaMem, columnCount, rowCount, columnNameOffset);
                    }
                } else {
                    path.trimTo(plen).concat(DEFAULT_PARTITION_NAME);
                    Mig607.migrate(ff, path, migrationContext, metaMem, columnCount, transientRowCount, columnNameOffset);
                }
                long tmpMem = migrationContext.getTempMemory();
                int denseSymbolCount = 0;
                long currentColumnNameOffset = columnNameOffset;
                for (int i = 0; i < columnCount; ++i) {
                    block36: {
                        CharSequence columnName = metaMem.getStr(currentColumnNameOffset);
                        currentColumnNameOffset += Vm.getStorageLength(columnName.length());
                        if (ColumnType.tagOf(metaMem.getInt(MigrationActions.prefixedBlockOffset(128L, i, 16L))) != 12) continue;
                        int symbolCount = txMem.getInt(80L + (long)denseSymbolCount * 8L);
                        long offset = MigrationActions.prefixedBlockOffset(64L, symbolCount, 8L);
                        Mig607.offsetFileName(path.trimTo(plen), columnName);
                        long fd = TableUtils.openRW(ff, path, MigrationActions.LOG, migrationContext.getConfiguration().getWriterFileOpenOpts());
                        try {
                            long fileLen = ff.length(fd);
                            if (symbolCount <= 0) break block36;
                            if (fileLen < offset) {
                                MigrationActions.LOG.error().$("file is too short [path=").$(path).I$();
                                break block36;
                            }
                            TableUtils.allocateDiskSpace(ff, fd, offset + 8L);
                            long dataOffset = TableUtils.readLongOrFail(ff, fd, offset - 8L, tmpMem, path);
                            Mig607.charFileName(path.trimTo(plen), columnName);
                            long fd2 = TableUtils.openRO(ff, path, MigrationActions.LOG);
                            try {
                                long len = TableUtils.readIntOrFail(ff, fd2, dataOffset, tmpMem, path);
                                dataOffset = len == -1L ? (dataOffset += 4L) : (dataOffset += 4L + len * 2L);
                                TableUtils.writeLongOrFail(ff, fd, offset, dataOffset, tmpMem, path);
                            }
                            finally {
                                ff.close(fd2);
                            }
                        }
                        finally {
                            Vm.bestEffortClose(ff, MigrationActions.LOG, fd, true, offset + 8L);
                        }
                    }
                    ++denseSymbolCount;
                }
                txFileSize = txMem.getAppendOffset();
            }
            metaFileSize = metaMem.getAppendOffset();
        }
        path.trimTo(plen).concat(META_FILE_NAME).$();
        Mig607.trimFile(ff, path, metaFileSize, migrationContext.getConfiguration().getWriterFileOpenOpts());
        path.trimTo(plen).concat(TXN_FILE_NAME).$();
        Mig607.trimFile(ff, path, txFileSize, migrationContext.getConfiguration().getWriterFileOpenOpts());
    }

    private static void dFile(Path path, CharSequence columnName) {
        path.concat(columnName).put(".d");
        path.$();
    }

    static LPSZ topFile(Path path, CharSequence columnName) {
        return path.concat(columnName).put(".top").$();
    }

    private static void trimFile(FilesFacade ff, Path path, long size, long opts) {
        long fd = TableUtils.openFileRWOrFail(ff, path, opts);
        if (!ff.truncate(fd, size)) {
            throw CairoException.critical(ff.errno()).put("Cannot trim to size [file=").put(path).put(']');
        }
        if (!ff.close(fd)) {
            throw CairoException.critical(ff.errno()).put("Cannot close [file=").put(path).put(']');
        }
    }

    private static void offsetFileName(Path path, CharSequence columnName) {
        path.concat(columnName).put(".o").$();
    }

    private static void charFileName(Path path, CharSequence columnName) {
        path.concat(columnName).put(".c").$();
    }

    private static void iFile(Path path, CharSequence columnName) {
        path.concat(columnName).put(".i").$();
    }
}

