/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.map;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.ColumnTypes;
import io.questdb.cairo.GenericRecordMetadata;
import io.questdb.cairo.map.CompactMap;
import io.questdb.cairo.map.FastMap;
import io.questdb.cairo.map.Map;
import io.questdb.std.Chars;
import org.jetbrains.annotations.NotNull;

public class MapFactory {
    public static Map createMap(CairoConfiguration configuration, @NotNull ColumnTypes keyTypes, @NotNull ColumnTypes valueTypes) {
        return MapFactory.createMap(false, configuration, keyTypes, valueTypes);
    }

    public static Map createSmallMap(CairoConfiguration configuration, @NotNull ColumnTypes keyTypes, @NotNull ColumnTypes valueTypes) {
        return MapFactory.createMap(true, configuration, keyTypes, valueTypes);
    }

    private static Map createMap(boolean smallMap, CairoConfiguration configuration, @NotNull ColumnTypes keyTypes, @NotNull ColumnTypes valueTypes) {
        int keyCapacity = smallMap ? configuration.getSqlSmallMapKeyCapacity() : configuration.getSqlMapKeyCapacity();
        CharSequence mapType = configuration.getDefaultMapType();
        if (Chars.equalsLowerCaseAscii(mapType, "fast")) {
            return new FastMap(configuration.getSqlMapPageSize(), keyTypes, valueTypes, keyCapacity, configuration.getSqlFastMapLoadFactor(), configuration.getSqlMapMaxResizes());
        }
        if (Chars.equalsLowerCaseAscii(mapType, "compact")) {
            return new CompactMap(configuration.getSqlMapPageSize(), keyTypes, valueTypes, keyCapacity, configuration.getSqlCompactMapLoadFactor(), configuration.getSqlMapMaxResizes(), configuration.getSqlMapMaxPages());
        }
        throw CairoException.critical(0).put("unknown map type: ").put(mapType);
    }

    public static Map createMap(CairoConfiguration configuration, @NotNull ColumnTypes keyTypes) {
        CharSequence mapType = configuration.getDefaultMapType();
        if (Chars.equalsLowerCaseAscii(mapType, "fast")) {
            return new FastMap(configuration.getSqlMapPageSize(), keyTypes, configuration.getSqlMapKeyCapacity(), configuration.getSqlFastMapLoadFactor(), configuration.getSqlMapMaxResizes());
        }
        if (Chars.equalsLowerCaseAscii(mapType, "compact")) {
            return new CompactMap(configuration.getSqlMapPageSize(), keyTypes, GenericRecordMetadata.EMPTY, configuration.getSqlMapKeyCapacity(), configuration.getSqlCompactMapLoadFactor(), configuration.getSqlMapMaxResizes(), configuration.getSqlMapMaxPages());
        }
        throw CairoException.critical(0).put("unknown map type: ").put(mapType);
    }
}

