/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.map;

import io.questdb.cairo.CairoException;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.ColumnTypes;
import io.questdb.cairo.RecordSink;
import io.questdb.cairo.Reopenable;
import io.questdb.cairo.map.FastMapCursor;
import io.questdb.cairo.map.FastMapRecord;
import io.questdb.cairo.map.FastMapValue;
import io.questdb.cairo.map.Map;
import io.questdb.cairo.map.MapKey;
import io.questdb.cairo.map.MapRecord;
import io.questdb.cairo.map.MapValue;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.griffin.engine.LimitOverflowException;
import io.questdb.std.BinarySequence;
import io.questdb.std.DirectLongList;
import io.questdb.std.Hash;
import io.questdb.std.Long256;
import io.questdb.std.Misc;
import io.questdb.std.Numbers;
import io.questdb.std.Unsafe;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FastMap
implements Map,
Reopenable {
    private static final HashFunction DEFAULT_HASH = Hash::hashMem;
    private static final int MIN_INITIAL_CAPACITY = 128;
    private final double loadFactor;
    private final Key key = new Key();
    private final FastMapValue value;
    private final FastMapValue value2;
    private final FastMapValue value3;
    private final FastMapCursor cursor;
    private final FastMapRecord record;
    private final int valueColumnCount;
    private final HashFunction hashFunction;
    private final int keyBlockOffset;
    private final int keyDataOffset;
    private final int maxResizes;
    private final int initialKeyCapacity;
    private final int initialPageSize;
    private long capacity;
    private DirectLongList offsets;
    private long kStart;
    private long kLimit;
    private long kPos;
    private int free;
    private int keyCapacity;
    private int size = 0;
    private int mask;
    private int nResizes;

    public FastMap(int pageSize, @NotNull ColumnTypes keyTypes, int keyCapacity, double loadFactor, int maxResizes) {
        this(pageSize, keyTypes, null, keyCapacity, loadFactor, DEFAULT_HASH, maxResizes);
    }

    public FastMap(int pageSize, @NotNull ColumnTypes keyTypes, @Nullable ColumnTypes valueTypes, int keyCapacity, double loadFactor, int maxResizes) {
        this(pageSize, keyTypes, valueTypes, keyCapacity, loadFactor, DEFAULT_HASH, maxResizes);
    }

    public FastMap(int pageSize, @NotNull ColumnTypes keyTypes, @Nullable ColumnTypes valueTypes, int keyCapacity, double loadFactor, int maxResizes, int memoryTag) {
        this(pageSize, keyTypes, valueTypes, keyCapacity, loadFactor, DEFAULT_HASH, maxResizes, memoryTag, memoryTag);
    }

    FastMap(int pageSize, ColumnTypes keyTypes, ColumnTypes valueTypes, int keyCapacity, double loadFactor, HashFunction hashFunction, int maxResizes) {
        this(pageSize, keyTypes, valueTypes, keyCapacity, loadFactor, hashFunction, maxResizes, 9, 10);
    }

    FastMap(int pageSize, ColumnTypes keyTypes, ColumnTypes valueTypes, int keyCapacity, double loadFactor, HashFunction hashFunction, int maxResizes, int mapMemoryTag, int listMemoryTag) {
        assert (pageSize > 3);
        assert (loadFactor > 0.0 && loadFactor < 1.0);
        this.initialKeyCapacity = keyCapacity;
        this.initialPageSize = pageSize;
        this.loadFactor = loadFactor;
        this.capacity = pageSize;
        this.kStart = this.kPos = Unsafe.malloc(this.capacity, mapMemoryTag);
        this.kLimit = this.kStart + (long)pageSize;
        this.keyCapacity = (int)((double)keyCapacity / loadFactor);
        this.keyCapacity = this.keyCapacity < 128 ? 128 : Numbers.ceilPow2(this.keyCapacity);
        this.mask = this.keyCapacity - 1;
        this.free = (int)((double)this.keyCapacity * loadFactor);
        this.offsets = new DirectLongList(this.keyCapacity, listMemoryTag);
        this.offsets.setPos(this.keyCapacity);
        this.offsets.zero(0L);
        this.hashFunction = hashFunction;
        this.nResizes = 0;
        this.maxResizes = maxResizes;
        int offset = 4;
        if (valueTypes != null) {
            int columnSplit = this.valueColumnCount = valueTypes.getColumnCount();
            int[] valueOffsets = new int[columnSplit];
            block8: for (int i = 0; i < columnSplit; ++i) {
                valueOffsets[i] = offset++;
                int columnType = valueTypes.getColumnType(i);
                switch (ColumnType.tagOf(columnType)) {
                    case 1: 
                    case 2: 
                    case 14: {
                        continue block8;
                    }
                    case 3: 
                    case 4: 
                    case 15: {
                        offset += 2;
                        continue block8;
                    }
                    case 5: 
                    case 9: 
                    case 12: 
                    case 16: {
                        offset += 4;
                        continue block8;
                    }
                    case 6: 
                    case 7: 
                    case 8: 
                    case 10: 
                    case 17: {
                        offset += 8;
                        continue block8;
                    }
                    case 13: {
                        offset += 32;
                        continue block8;
                    }
                    case 24: {
                        offset += 16;
                        continue block8;
                    }
                    default: {
                        this.close();
                        throw CairoException.nonCritical().put("value type is not supported: ").put(ColumnType.nameOf(columnType));
                    }
                }
            }
            this.value = new FastMapValue(valueOffsets);
            this.value2 = new FastMapValue(valueOffsets);
            this.value3 = new FastMapValue(valueOffsets);
            this.keyBlockOffset = offset;
            this.keyDataOffset = this.keyBlockOffset + 4 * keyTypes.getColumnCount();
            this.record = new FastMapRecord(valueOffsets, columnSplit, this.keyDataOffset, this.keyBlockOffset, this.value, keyTypes);
        } else {
            this.valueColumnCount = 0;
            this.value = new FastMapValue(null);
            this.value2 = new FastMapValue(null);
            this.value3 = new FastMapValue(null);
            this.keyBlockOffset = offset;
            this.keyDataOffset = this.keyBlockOffset + 4 * keyTypes.getColumnCount();
            this.record = new FastMapRecord(null, 0, this.keyDataOffset, this.keyBlockOffset, this.value, keyTypes);
        }
        assert ((long)this.keyBlockOffset < this.kLimit - this.kStart) : "page size is too small for number of columns";
        this.cursor = new FastMapCursor(this.record, this);
    }

    @Override
    public void reopen() {
        if (this.kStart == 0L) {
            this.restoreInitialCapacity();
        }
    }

    @Override
    public void clear() {
        this.kPos = this.kStart;
        this.free = (int)((double)this.keyCapacity * this.loadFactor);
        this.size = 0;
        this.offsets.zero(0L);
    }

    @Override
    public final void close() {
        Misc.free(this.offsets);
        if (this.kStart != 0L) {
            Unsafe.free(this.kStart, this.capacity, 9);
            this.kPos = 0L;
            this.kStart = 0L;
            this.kLimit = 0L;
            this.free = 0;
            this.size = 0;
            this.capacity = 0L;
        }
    }

    @Override
    public RecordCursor getCursor() {
        return this.cursor.init(this.kStart, this.size);
    }

    @Override
    public MapRecord getRecord() {
        return this.record;
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public MapValue valueAt(long address) {
        return this.valueOf(address, false, this.value);
    }

    @Override
    public MapKey withKey() {
        return this.key.init();
    }

    @Override
    public void restoreInitialCapacity() {
        this.capacity = this.initialPageSize;
        this.kStart = this.kPos = Unsafe.realloc(this.kStart, this.kLimit - this.kStart, this.capacity, 9);
        this.kLimit = this.kStart + (long)this.initialPageSize;
        this.keyCapacity = (int)((double)this.initialKeyCapacity / this.loadFactor);
        this.keyCapacity = this.keyCapacity < 128 ? 128 : Numbers.ceilPow2(this.keyCapacity);
        this.mask = this.keyCapacity - 1;
        this.free = (int)((double)this.keyCapacity * this.loadFactor);
        this.offsets.resetCapacity();
        this.offsets.setCapacity(this.keyCapacity);
        this.offsets.setPos(this.keyCapacity);
        this.offsets.zero(0L);
        this.nResizes = 0;
    }

    public long getAreaSize() {
        return this.kLimit - this.kStart;
    }

    public int getKeyCapacity() {
        return this.keyCapacity;
    }

    private long getOffset(long index) {
        return FastMap.getOffset(this.offsets, index);
    }

    private static long getOffset(DirectLongList offsets, long index) {
        return offsets.get(index) - 1L;
    }

    private void setOffset(long index, long value) {
        FastMap.setOffset(this.offsets, index, value);
    }

    private static void setOffset(DirectLongList offsets, long index, long value) {
        offsets.set(index, value + 1L);
    }

    private static boolean eqMixed(long a, long b, long lim) {
        while (b < lim - 8L) {
            if (Unsafe.getUnsafe().getLong(a) != Unsafe.getUnsafe().getLong(b)) {
                return false;
            }
            a += 8L;
            b += 8L;
        }
        while (b < lim) {
            if (Unsafe.getUnsafe().getByte(a++) == Unsafe.getUnsafe().getByte(b++)) continue;
            return false;
        }
        return true;
    }

    private static boolean eqLong(long a, long b, long lim) {
        while (b < lim) {
            if (Unsafe.getUnsafe().getLong(a) != Unsafe.getUnsafe().getLong(b)) {
                return false;
            }
            a += 8L;
            b += 8L;
        }
        return true;
    }

    private static boolean eqInt(long a, long b, long lim) {
        while (b < lim) {
            if (Unsafe.getUnsafe().getInt(a) != Unsafe.getUnsafe().getInt(b)) {
                return false;
            }
            a += 4L;
            b += 4L;
        }
        return true;
    }

    private FastMapValue asNew(Key keyWriter, long index, FastMapValue value) {
        this.kPos = keyWriter.appendAddress;
        this.setOffset(index, keyWriter.startAddress - this.kStart);
        if (--this.free == 0) {
            this.rehash();
        }
        ++this.size;
        return this.valueOf(keyWriter.startAddress, true, value);
    }

    private boolean eq(Key keyWriter, long offset) {
        long a = this.kStart + offset;
        long b = keyWriter.startAddress;
        if (Unsafe.getUnsafe().getInt(a) != Unsafe.getUnsafe().getInt(b)) {
            return false;
        }
        long lim = b + (long)keyWriter.len;
        a += (long)this.keyDataOffset;
        long d = lim - (b += (long)this.keyDataOffset);
        if (d % 8L == 0L) {
            return FastMap.eqLong(a, b, lim);
        }
        if (d % 4L == 0L) {
            return FastMap.eqInt(a, b, lim);
        }
        return FastMap.eqMixed(a, b, lim);
    }

    long getAppendOffset() {
        return this.kPos;
    }

    int getValueColumnCount() {
        return this.valueColumnCount;
    }

    private long keyIndex() {
        return this.hashFunction.hash(this.key.startAddress + (long)this.keyDataOffset, this.key.len - this.keyDataOffset) & (long)this.mask;
    }

    private FastMapValue probe0(Key keyWriter, long index, FastMapValue value) {
        block1: {
            long offset;
            do {
                ++index;
                offset = this.getOffset(index &= (long)this.mask);
                if (offset == -1L) break block1;
            } while (!this.eq(keyWriter, offset));
            return this.valueOf(this.kStart + offset, false, value);
        }
        return this.asNew(keyWriter, index, value);
    }

    private FastMapValue probeReadOnly(Key keyWriter, long index, FastMapValue value) {
        block1: {
            long offset;
            do {
                ++index;
                offset = this.getOffset(index &= (long)this.mask);
                if (offset == -1L) break block1;
            } while (!this.eq(keyWriter, offset));
            return this.valueOf(this.kStart + offset, false, value);
        }
        return null;
    }

    private void rehash() {
        int capacity = this.keyCapacity << 1;
        this.mask = capacity - 1;
        DirectLongList newOffsets = new DirectLongList(capacity, 10);
        newOffsets.setPos(capacity);
        newOffsets.zero(0L);
        long k = this.offsets.size();
        for (long i = 0L; i < k; ++i) {
            long offset = this.getOffset(i);
            if (offset == -1L) continue;
            long index = this.hashFunction.hash(this.kStart + offset + (long)this.keyDataOffset, Unsafe.getUnsafe().getInt(this.kStart + offset) - this.keyDataOffset) & (long)this.mask;
            while (FastMap.getOffset(newOffsets, index) != -1L) {
                index = index + 1L & (long)this.mask;
            }
            FastMap.setOffset(newOffsets, index, offset);
        }
        this.offsets.close();
        this.offsets = newOffsets;
        this.free = (int)((double)this.free + (double)(capacity - this.keyCapacity) * this.loadFactor);
        this.keyCapacity = capacity;
    }

    private void resize(int size) {
        long kAddress;
        long kCapacity;
        if (this.nResizes < this.maxResizes) {
            ++this.nResizes;
            kCapacity = this.kLimit - this.kStart << 1;
            long target = this.key.appendAddress + (long)size - this.kStart;
            if (kCapacity < target) {
                kCapacity = Numbers.ceilPow2(target);
            }
            kAddress = Unsafe.realloc(this.kStart, this.capacity, kCapacity, 9);
            this.capacity = kCapacity;
            long d = kAddress - this.kStart;
            this.kPos += d;
            long colOffsetDelta = this.key.nextColOffset - this.key.startAddress;
            Key key = this.key;
            key.startAddress = key.startAddress + d;
            key = this.key;
            key.appendAddress = key.appendAddress + d;
            this.key.nextColOffset = this.key.startAddress + colOffsetDelta;
            assert (this.kPos > 0L);
            assert (this.key.startAddress > 0L);
            assert (this.key.appendAddress > 0L);
            assert (this.key.nextColOffset > 0L);
        } else {
            throw LimitOverflowException.instance().put("limit of ").put(this.maxResizes).put(" resizes exceeded in FastMap");
        }
        this.kStart = kAddress;
        this.kLimit = kAddress + kCapacity;
    }

    private FastMapValue valueOf(long address, boolean _new, FastMapValue value) {
        return value.of(address, _new);
    }

    public class Key
    implements MapKey {
        private long startAddress;
        private long appendAddress;
        private int len;
        private long nextColOffset;

        @Override
        public MapValue createValue() {
            return this.createValue(FastMap.this.value);
        }

        @Override
        public MapValue createValue2() {
            return this.createValue(FastMap.this.value2);
        }

        @Override
        public MapValue createValue3() {
            return this.createValue(FastMap.this.value3);
        }

        @Override
        public MapValue findValue() {
            return this.findValue(FastMap.this.value);
        }

        @Override
        public MapValue findValue2() {
            return this.findValue(FastMap.this.value2);
        }

        @Override
        public MapValue findValue3() {
            return this.findValue(FastMap.this.value3);
        }

        @Override
        public void put(Record record, RecordSink sink) {
            sink.copy(record, this);
        }

        public Key init() {
            this.startAddress = FastMap.this.kPos;
            this.appendAddress = FastMap.this.kPos + (long)FastMap.this.keyDataOffset;
            this.nextColOffset = FastMap.this.kPos + (long)FastMap.this.keyBlockOffset;
            return this;
        }

        @Override
        public void putBin(BinarySequence value) {
            if (value == null) {
                this.putNull();
            } else {
                long len = value.length() + 4L;
                if (len > Integer.MAX_VALUE) {
                    throw CairoException.nonCritical().put("binary column is too large");
                }
                this.checkSize((int)len);
                int l = (int)(len - 4L);
                Unsafe.getUnsafe().putInt(this.appendAddress, l);
                value.copyTo(this.appendAddress + 4L, 0L, l);
                this.appendAddress += len;
                this.writeOffset();
            }
        }

        @Override
        public void putBool(boolean value) {
            this.checkSize(1);
            Unsafe.getUnsafe().putByte(this.appendAddress, (byte)(value ? 1 : 0));
            ++this.appendAddress;
            this.writeOffset();
        }

        @Override
        public void putByte(byte value) {
            this.checkSize(1);
            Unsafe.getUnsafe().putByte(this.appendAddress, value);
            ++this.appendAddress;
            this.writeOffset();
        }

        @Override
        public void putDate(long value) {
            this.putLong(value);
        }

        @Override
        public void putDouble(double value) {
            this.checkSize(8);
            Unsafe.getUnsafe().putDouble(this.appendAddress, value);
            this.appendAddress += 8L;
            this.writeOffset();
        }

        @Override
        public void putFloat(float value) {
            this.checkSize(4);
            Unsafe.getUnsafe().putFloat(this.appendAddress, value);
            this.appendAddress += 4L;
            this.writeOffset();
        }

        @Override
        public void putInt(int value) {
            this.checkSize(4);
            Unsafe.getUnsafe().putInt(this.appendAddress, value);
            this.appendAddress += 4L;
            this.writeOffset();
        }

        @Override
        public void putLong(long value) {
            this.checkSize(8);
            Unsafe.getUnsafe().putLong(this.appendAddress, value);
            this.appendAddress += 8L;
            this.writeOffset();
        }

        @Override
        public void putLong256(Long256 value) {
            this.checkSize(32);
            Unsafe.getUnsafe().putLong(this.appendAddress, value.getLong0());
            Unsafe.getUnsafe().putLong(this.appendAddress + 8L, value.getLong1());
            Unsafe.getUnsafe().putLong(this.appendAddress + 16L, value.getLong2());
            Unsafe.getUnsafe().putLong(this.appendAddress + 24L, value.getLong3());
            this.appendAddress += 32L;
            this.writeOffset();
        }

        @Override
        public void putLong128LittleEndian(long hi, long lo) {
            this.checkSize(16);
            Unsafe.getUnsafe().putLong(this.appendAddress, lo);
            Unsafe.getUnsafe().putLong(this.appendAddress + 8L, hi);
            this.appendAddress += 16L;
            this.writeOffset();
        }

        @Override
        public void putShort(short value) {
            this.checkSize(2);
            Unsafe.getUnsafe().putShort(this.appendAddress, value);
            this.appendAddress += 2L;
            this.writeOffset();
        }

        @Override
        public void putChar(char value) {
            this.checkSize(2);
            Unsafe.getUnsafe().putChar(this.appendAddress, value);
            this.appendAddress += 2L;
            this.writeOffset();
        }

        @Override
        public void putStr(CharSequence value) {
            if (value == null) {
                this.putNull();
                return;
            }
            int len = value.length();
            this.checkSize((len << 1) + 4);
            Unsafe.getUnsafe().putInt(this.appendAddress, len);
            this.appendAddress += 4L;
            for (int i = 0; i < len; ++i) {
                Unsafe.getUnsafe().putChar(this.appendAddress + ((long)i << 1), value.charAt(i));
            }
            this.appendAddress += (long)len << 1;
            this.writeOffset();
        }

        @Override
        public void putStr(CharSequence value, int lo, int hi) {
            int len = hi - lo;
            this.checkSize((len << 1) + 4);
            Unsafe.getUnsafe().putInt(this.appendAddress, len);
            this.appendAddress += 4L;
            for (int i = lo; i < hi; ++i) {
                Unsafe.getUnsafe().putChar(this.appendAddress + ((long)(i - lo) << 1), value.charAt(i));
            }
            this.appendAddress += (long)len << 1;
            this.writeOffset();
        }

        @Override
        public void putStrLowerCase(CharSequence value) {
            if (value == null) {
                this.putNull();
                return;
            }
            int len = value.length();
            this.checkSize((len << 1) + 4);
            Unsafe.getUnsafe().putInt(this.appendAddress, len);
            this.appendAddress += 4L;
            for (int i = 0; i < len; ++i) {
                Unsafe.getUnsafe().putChar(this.appendAddress + ((long)i << 1), Character.toLowerCase(value.charAt(i)));
            }
            this.appendAddress += (long)len << 1;
            this.writeOffset();
        }

        @Override
        public void putStrLowerCase(CharSequence value, int lo, int hi) {
            int len = hi - lo;
            this.checkSize((len << 1) + 4);
            Unsafe.getUnsafe().putInt(this.appendAddress, len);
            this.appendAddress += 4L;
            for (int i = lo; i < hi; ++i) {
                Unsafe.getUnsafe().putChar(this.appendAddress + ((long)(i - lo) << 1), Character.toLowerCase(value.charAt(i)));
            }
            this.appendAddress += (long)len << 1;
            this.writeOffset();
        }

        @Override
        public void putRecord(Record value) {
        }

        @Override
        public void putTimestamp(long value) {
            this.putLong(value);
        }

        @Override
        public void skip(int bytes) {
            this.checkSize(bytes);
            this.appendAddress += (long)bytes;
            this.writeOffset();
        }

        private void checkSize(int size) {
            if (this.appendAddress + (long)size > FastMap.this.kLimit) {
                FastMap.this.resize(size);
            }
        }

        private void commit() {
            this.len = (int)(this.appendAddress - this.startAddress);
            Unsafe.getUnsafe().putInt(this.startAddress, this.len);
        }

        private MapValue createValue(FastMapValue value) {
            this.commit();
            long index = FastMap.this.keyIndex();
            long offset = FastMap.this.getOffset(index);
            if (offset == -1L) {
                return FastMap.this.asNew(this, index, value);
            }
            if (FastMap.this.eq(this, offset)) {
                return FastMap.this.valueOf(FastMap.this.kStart + offset, false, value);
            }
            return FastMap.this.probe0(this, index, value);
        }

        private MapValue findValue(FastMapValue value) {
            this.commit();
            long index = FastMap.this.keyIndex();
            long offset = FastMap.this.getOffset(index);
            if (offset == -1L) {
                return null;
            }
            if (FastMap.this.eq(this, offset)) {
                return FastMap.this.valueOf(FastMap.this.kStart + offset, false, value);
            }
            return FastMap.this.probeReadOnly(this, index, value);
        }

        private void putNull() {
            this.checkSize(4);
            Unsafe.getUnsafe().putInt(this.appendAddress, -1);
            this.appendAddress += 4L;
            this.writeOffset();
        }

        private void writeOffset() {
            long len = this.appendAddress - this.startAddress;
            if (len > Integer.MAX_VALUE) {
                throw CairoException.critical(0).put("row data is too large");
            }
            Unsafe.getUnsafe().putInt(this.nextColOffset, (int)len);
            this.nextColOffset += 4L;
        }
    }

    @FunctionalInterface
    public static interface HashFunction {
        public long hash(long var1, long var3);
    }
}

