/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.map;

import io.questdb.cairo.map.CompactMapRecord;
import io.questdb.cairo.map.MapValue;
import io.questdb.cairo.vm.api.MemoryARW;
import io.questdb.std.Long256;

public class CompactMapValue
implements MapValue {
    private final MemoryARW entries;
    private final long[] columnOffsets;
    private long currentValueOffset;
    private boolean _new;
    private CompactMapRecord record;

    CompactMapValue(MemoryARW entries, long[] columnOffsets) {
        this.entries = entries;
        this.columnOffsets = columnOffsets;
    }

    @Override
    public long getAddress() {
        return this.currentValueOffset;
    }

    @Override
    public boolean getBool(int index) {
        return this.entries.getBool(this.getValueColumnOffset(index));
    }

    @Override
    public byte getByte(int index) {
        return this.entries.getByte(this.getValueColumnOffset(index));
    }

    @Override
    public long getDate(int index) {
        return this.getLong(index);
    }

    @Override
    public double getDouble(int columnIndex) {
        return this.entries.getDouble(this.getValueColumnOffset(columnIndex));
    }

    @Override
    public float getFloat(int columnIndex) {
        return this.entries.getFloat(this.getValueColumnOffset(columnIndex));
    }

    @Override
    public int getInt(int columnIndex) {
        return this.entries.getInt(this.getValueColumnOffset(columnIndex));
    }

    @Override
    public long getLong(int columnIndex) {
        return this.entries.getLong(this.getValueColumnOffset(columnIndex));
    }

    @Override
    public void addLong(int index, long value) {
        long o = this.getValueColumnOffset(index);
        this.entries.putLong(o, this.entries.getLong(o) + value);
    }

    @Override
    public void addByte(int index, byte value) {
        long o = this.getValueColumnOffset(index);
        this.entries.putByte(o, (byte)(this.entries.getByte(o) + value));
    }

    @Override
    public void addShort(int index, short value) {
        long o = this.getValueColumnOffset(index);
        this.entries.putShort(o, (short)(this.entries.getShort(o) + value));
    }

    @Override
    public void addInt(int index, int value) {
        long o = this.getValueColumnOffset(index);
        this.entries.putInt(o, this.entries.getInt(o) + value);
    }

    @Override
    public void addDouble(int index, double value) {
        long o = this.getValueColumnOffset(index);
        this.entries.putDouble(o, this.entries.getDouble(o) + value);
    }

    @Override
    public void addFloat(int index, float value) {
        long o = this.getValueColumnOffset(index);
        this.entries.putFloat(o, this.entries.getFloat(o) + value);
    }

    @Override
    public short getShort(int columnIndex) {
        return this.entries.getShort(this.getValueColumnOffset(columnIndex));
    }

    @Override
    public char getChar(int columnIndex) {
        return this.entries.getChar(this.getValueColumnOffset(columnIndex));
    }

    @Override
    public long getTimestamp(int index) {
        return this.getLong(index);
    }

    @Override
    public byte getGeoByte(int col) {
        return this.getByte(col);
    }

    @Override
    public short getGeoShort(int col) {
        return this.getShort(col);
    }

    @Override
    public int getGeoInt(int col) {
        return this.getInt(col);
    }

    @Override
    public long getGeoLong(int col) {
        return this.getLong(col);
    }

    @Override
    public boolean isNew() {
        return this._new;
    }

    @Override
    public void putBool(int index, boolean value) {
        this.entries.putBool(this.getValueColumnOffset(index), value);
    }

    @Override
    public void putByte(int columnIndex, byte value) {
        this.entries.putByte(this.getValueColumnOffset(columnIndex), value);
    }

    @Override
    public void putDate(int columnIndex, long value) {
        this.putLong(columnIndex, value);
    }

    @Override
    public void putDouble(int columnIndex, double value) {
        this.entries.putDouble(this.getValueColumnOffset(columnIndex), value);
    }

    @Override
    public void putFloat(int columnIndex, float value) {
        this.entries.putFloat(this.getValueColumnOffset(columnIndex), value);
    }

    @Override
    public void putInt(int columnIndex, int value) {
        this.entries.putInt(this.getValueColumnOffset(columnIndex), value);
    }

    @Override
    public void putLong(int columnIndex, long value) {
        this.entries.putLong(this.getValueColumnOffset(columnIndex), value);
    }

    @Override
    public void putShort(int columnIndex, short value) {
        this.entries.putShort(this.getValueColumnOffset(columnIndex), value);
    }

    @Override
    public void putChar(int columnIndex, char value) {
        this.entries.putChar(this.getValueColumnOffset(columnIndex), value);
    }

    @Override
    public void putTimestamp(int index, long value) {
        this.putLong(index, value);
    }

    @Override
    public void setMapRecordHere() {
        this.record.of(this.currentValueOffset);
    }

    @Override
    public void addLong256(int index, Long256 value) {
    }

    @Override
    public void putLong256(int index, Long256 value) {
    }

    private long getValueColumnOffset(int columnIndex) {
        assert (this.currentValueOffset != -1L);
        return this.currentValueOffset + this.columnOffsets[columnIndex];
    }

    void linkRecord(CompactMapRecord record) {
        this.record = record;
    }

    void of(long offset, boolean _new) {
        this.currentValueOffset = offset;
        this._new = _new;
    }
}

