/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.map;

import io.questdb.cairo.map.CompactMapRecord;
import io.questdb.cairo.map.MapRecord;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;

public class CompactMapCursor
implements RecordCursor {
    private final CompactMapRecord recordA;
    private final CompactMapRecord recordB;
    private long offsetHi;
    private long nextOffset;

    public CompactMapCursor(CompactMapRecord record) {
        this.recordA = record;
        this.recordB = record.clone();
    }

    @Override
    public void close() {
    }

    @Override
    public MapRecord getRecord() {
        return this.recordA;
    }

    @Override
    public boolean hasNext() {
        if (this.nextOffset < this.offsetHi) {
            this.recordA.of(this.nextOffset);
            this.nextOffset = this.recordA.getNextRecordOffset();
            return true;
        }
        return false;
    }

    @Override
    public MapRecord getRecordB() {
        return this.recordB;
    }

    @Override
    public void recordAt(Record record, long atRowId) {
        ((CompactMapRecord)record).of(atRowId);
    }

    @Override
    public void toTop() {
        this.nextOffset = 0L;
    }

    void of(long offsetHi) {
        this.nextOffset = 0L;
        this.offsetHi = offsetHi;
    }

    @Override
    public long size() {
        return -1L;
    }
}

