/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.map;

import io.questdb.cairo.CairoException;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.ColumnTypes;
import io.questdb.cairo.RecordSink;
import io.questdb.cairo.Reopenable;
import io.questdb.cairo.map.CompactMapCursor;
import io.questdb.cairo.map.CompactMapRecord;
import io.questdb.cairo.map.CompactMapValue;
import io.questdb.cairo.map.Map;
import io.questdb.cairo.map.MapKey;
import io.questdb.cairo.map.MapRecord;
import io.questdb.cairo.map.MapValue;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.vm.Vm;
import io.questdb.cairo.vm.api.MemoryARW;
import io.questdb.cairo.vm.api.MemoryR;
import io.questdb.griffin.engine.LimitOverflowException;
import io.questdb.std.BinarySequence;
import io.questdb.std.Hash;
import io.questdb.std.Long256;
import io.questdb.std.Misc;
import io.questdb.std.Numbers;

public class CompactMap
implements Map,
Reopenable {
    public static final byte BITS_DIRECT_HIT = -128;
    public static final byte BITS_DISTANCE = 127;
    public static final int jumpDistancesLen = 126;
    static final int ENTRY_HEADER_SIZE = 9;
    private static final long[] jumpDistances = new long[]{0L, 1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L, 10L, 11L, 12L, 13L, 14L, 15L, 21L, 28L, 36L, 45L, 55L, 66L, 78L, 91L, 105L, 120L, 136L, 153L, 171L, 190L, 210L, 231L, 253L, 276L, 300L, 325L, 351L, 378L, 406L, 435L, 465L, 496L, 528L, 561L, 595L, 630L, 666L, 703L, 741L, 780L, 820L, 861L, 903L, 946L, 990L, 1035L, 1081L, 1128L, 1176L, 1225L, 1275L, 1326L, 1378L, 1431L, 1485L, 1540L, 1596L, 1653L, 1711L, 1770L, 1830L, 1891L, 1953L, 2016L, 2080L, 2145L, 2211L, 2278L, 2346L, 2415L, 2485L, 2556L, 3741L, 8385L, 18915L, 42486L, 95703L, 215496L, 485605L, 1091503L, 2456436L, 5529475L, 12437578L, 27986421L, 62972253L, 141700195L, 318819126L, 717314626L, 1614000520L, 3631437253L, 8170829695L, 18384318876L, 41364501751L, 93070021080L, 209407709220L, 471167588430L, 1060127437995L, 2385287281530L, 5366895564381L, 12075513791265L, 27169907873235L, 61132301007778L, 137547673121001L, 309482258302503L, 696335090510256L, 1566753939653640L, 3525196427195653L, 7931691866727775L, 17846306747368716L, 40154190394120111L, 90346928493040500L, 203280588949935750L, 457381324898247375L, 1029107980662394500L, 2315492957028380766L, 5209859150892887590L};
    private static final HashFunctionFactory DEFAULT_HASH_FACTORY = CompactMap::defaultHashFunction;
    private final MemoryARW entries;
    private final MemoryARW entrySlots;
    private final Key key = new Key();
    private final CompactMapValue value;
    private final double loadFactor;
    private final long entryFixedSize;
    private final HashFunction hashFunction;
    private final CompactMapCursor cursor;
    private final long[] columnOffsets;
    private final long entryKeyOffset;
    private final int valueColumnCount;
    private final CompactMapRecord record;
    private int nResizes;
    private final int maxResizes;
    private long currentEntryOffset;
    private long currentEntrySize = 0L;
    private long keyCapacity;
    private long mask;
    private long size;

    public CompactMap(int pageSize, ColumnTypes keyTypes, ColumnTypes valueTypes, long keyCapacity, double loadFactor, int maxResizes, int maxPages) {
        this(pageSize, keyTypes, valueTypes, keyCapacity, loadFactor, DEFAULT_HASH_FACTORY, maxResizes, maxPages);
    }

    CompactMap(int pageSize, ColumnTypes keyTypes, ColumnTypes valueTypes, long keyCapacity, double loadFactor, HashFunctionFactory hashFunctionFactory, int maxResizes, int maxPages) {
        this.entries = Vm.getARWInstance(pageSize, maxPages, 8);
        this.entrySlots = Vm.getARWInstance(pageSize, maxPages, 8);
        try {
            this.loadFactor = loadFactor;
            this.columnOffsets = new long[keyTypes.getColumnCount() + valueTypes.getColumnCount()];
            this.valueColumnCount = valueTypes.getColumnCount();
            this.entryFixedSize = this.calcColumnOffsets(keyTypes, this.calcColumnOffsets(valueTypes, 9L, 0), this.valueColumnCount);
            this.entryKeyOffset = this.columnOffsets[this.valueColumnCount];
            this.keyCapacity = Math.max(keyCapacity, 16L);
            this.hashFunction = hashFunctionFactory.create(this.entries);
            this.configureCapacity();
            this.value = new CompactMapValue(this.entries, this.columnOffsets);
            this.record = new CompactMapRecord(this.entries, this.columnOffsets, this.value);
            this.cursor = new CompactMapCursor(this.record);
            this.nResizes = 0;
            this.maxResizes = maxResizes;
        }
        catch (Throwable e) {
            Misc.free(this.entries);
            Misc.free(this.entrySlots);
            throw e;
        }
    }

    @Override
    public void clear() {
        this.entrySlots.jumpTo((this.mask + 1L) * 8L);
        this.entrySlots.zero();
        this.currentEntryOffset = 0L;
        this.currentEntrySize = 0L;
        this.size = 0L;
        this.nResizes = 0;
    }

    @Override
    public void close() {
        this.entries.close();
        this.entrySlots.close();
    }

    @Override
    public RecordCursor getCursor() {
        this.cursor.of(this.currentEntryOffset + this.currentEntrySize);
        return this.cursor;
    }

    @Override
    public MapRecord getRecord() {
        return this.record;
    }

    @Override
    public void reopen() {
        this.clear();
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public MapValue valueAt(long address) {
        this.value.of(address, false);
        return this.value;
    }

    @Override
    public MapKey withKey() {
        this.currentEntryOffset += this.currentEntrySize;
        this.entries.jumpTo(this.currentEntryOffset + this.columnOffsets[this.valueColumnCount]);
        this.currentEntrySize = this.entryFixedSize;
        return this.key;
    }

    @Override
    public void restoreInitialCapacity() {
    }

    public long getKeyCapacity() {
        return this.keyCapacity;
    }

    public int getValueColumnCount() {
        return this.valueColumnCount;
    }

    private long calcColumnOffsets(ColumnTypes valueTypes, long startOffset, int startPosition) {
        long o = startOffset;
        int n = valueTypes.getColumnCount();
        for (int i = 0; i < n; ++i) {
            int sz;
            int columnType = valueTypes.getColumnType(i);
            switch (ColumnType.tagOf(columnType)) {
                case 1: 
                case 2: 
                case 14: {
                    sz = 1;
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 10: 
                case 11: 
                case 17: 
                case 18: {
                    sz = 8;
                    break;
                }
                case 5: 
                case 9: 
                case 16: {
                    sz = 4;
                    break;
                }
                case 3: 
                case 4: 
                case 15: {
                    sz = 2;
                    break;
                }
                case 13: {
                    sz = 32;
                    break;
                }
                case 24: {
                    sz = 16;
                    break;
                }
                default: {
                    throw CairoException.critical(0).put("Unsupported column type: ").put(ColumnType.nameOf(valueTypes.getColumnType(i)));
                }
            }
            this.columnOffsets[startPosition + i] = o;
            o += (long)sz;
        }
        return o;
    }

    private void configureCapacity() {
        this.mask = Numbers.ceilPow2((long)((double)this.keyCapacity / this.loadFactor)) - 1L;
        this.entrySlots.jumpTo((this.mask + 1L) * 8L);
        this.entrySlots.zero();
    }

    long getActualCapacity() {
        return this.mask + 1L;
    }

    long getAppendOffset() {
        return this.currentEntryOffset + this.currentEntrySize;
    }

    private static HashFunction defaultHashFunction(final MemoryR memory) {
        Hash.MemoryAccessor memoryAccessor = new Hash.MemoryAccessor(){

            @Override
            public long getLong(long offset) {
                return memory.getLong(offset);
            }

            @Override
            public int getInt(long offset) {
                return memory.getInt(offset);
            }

            @Override
            public byte getByte(long offset) {
                return memory.getByte(offset);
            }
        };
        return (offset, size) -> Hash.xxHash64(offset, size, 0L, memoryAccessor);
    }

    public class Key
    implements MapKey {
        @Override
        public CompactMapValue createValue() {
            long slot = this.calculateEntrySlot(CompactMap.this.currentEntryOffset, CompactMap.this.currentEntrySize);
            long offset = this.getOffsetAt(slot);
            if (offset == -1L) {
                return this.putNewEntryAt(slot, (byte)-128);
            }
            byte flag = CompactMap.this.entries.getByte(offset);
            if ((flag & 0xFFFFFF80) == 0) {
                if (this.moveForeignEntries(slot, offset)) {
                    return this.putNewEntryAt(slot, (byte)-128);
                }
                this.grow();
                return this.createValue();
            }
            if (this.cmp(offset)) {
                return this.found(offset);
            }
            return this.appendEntry(offset, slot, flag);
        }

        @Override
        public CompactMapValue findValue() {
            long slot = this.calculateEntrySlot(CompactMap.this.currentEntryOffset, CompactMap.this.currentEntrySize);
            long offset = this.getOffsetAt(slot);
            if (offset == -1L) {
                return null;
            }
            byte flag = CompactMap.this.entries.getByte(offset);
            if ((flag & 0xFFFFFF80) == 0) {
                return null;
            }
            if (this.cmp(offset)) {
                return this.found(offset);
            }
            int distance = flag & 0x7F;
            while (distance > 0) {
                slot = this.nextSlot(slot, distance);
                offset = this.getOffsetAt(slot);
                assert (offset != 0L);
                if (this.cmp(offset)) {
                    return this.found(offset);
                }
                distance = CompactMap.this.entries.getByte(offset) & 0x7F;
            }
            return null;
        }

        @Override
        public void put(Record record, RecordSink sink) {
            sink.copy(record, CompactMap.this.key);
        }

        @Override
        public void putBin(BinarySequence value) {
            if (value == null) {
                CompactMap.this.entries.putLong(-1L);
            } else {
                CompactMap.this.entries.putLong(CompactMap.this.currentEntrySize);
                long o = CompactMap.this.entries.getAppendOffset();
                CompactMap.this.entries.jumpTo(CompactMap.this.currentEntryOffset + CompactMap.this.currentEntrySize);
                CompactMap.this.entries.putBin(value);
                CompactMap.this.currentEntrySize = CompactMap.this.currentEntrySize + (8L + value.length());
                CompactMap.this.entries.jumpTo(o);
            }
        }

        @Override
        public void putBool(boolean value) {
            CompactMap.this.entries.putBool(value);
        }

        @Override
        public void putByte(byte value) {
            CompactMap.this.entries.putByte(value);
        }

        @Override
        public void putDate(long value) {
            this.putLong(value);
        }

        @Override
        public void putDouble(double value) {
            CompactMap.this.entries.putDouble(value);
        }

        @Override
        public void putFloat(float value) {
            CompactMap.this.entries.putFloat(value);
        }

        @Override
        public void putInt(int value) {
            CompactMap.this.entries.putInt(value);
        }

        @Override
        public void putLong(long value) {
            CompactMap.this.entries.putLong(value);
        }

        @Override
        public void putLong256(Long256 value) {
            CompactMap.this.entries.putLong256(value);
        }

        @Override
        public void putLong128LittleEndian(long hi, long lo) {
            CompactMap.this.entries.putLong128LittleEndian(hi, lo);
        }

        @Override
        public void putShort(short value) {
            CompactMap.this.entries.putShort(value);
        }

        @Override
        public void putChar(char value) {
            CompactMap.this.entries.putChar(value);
        }

        @Override
        public void putStr(CharSequence value) {
            if (value == null) {
                CompactMap.this.entries.putLong(-1L);
            } else {
                CompactMap.this.entries.putLong(CompactMap.this.currentEntrySize);
                int len = value.length();
                CompactMap.this.entries.putStr(CompactMap.this.currentEntryOffset + CompactMap.this.currentEntrySize, value, 0, len);
                CompactMap.this.currentEntrySize = CompactMap.this.currentEntrySize + Vm.getStorageLength(len);
            }
        }

        @Override
        public void putStr(CharSequence value, int lo, int hi) {
            CompactMap.this.entries.putLong(CompactMap.this.currentEntrySize);
            int len = hi - lo;
            CompactMap.this.entries.putStr(CompactMap.this.currentEntryOffset + CompactMap.this.currentEntrySize, value, lo, len);
            CompactMap.this.currentEntrySize = CompactMap.this.currentEntrySize + Vm.getStorageLength(len);
        }

        @Override
        public void putRecord(Record value) {
        }

        @Override
        public void putTimestamp(long value) {
            this.putLong(value);
        }

        @Override
        public void skip(int bytes) {
            CompactMap.this.entries.skip(bytes);
        }

        private CompactMapValue appendEntry(long offset, long slot, byte flag) {
            int distance = flag & 0x7F;
            long original = offset;
            while (distance > 0) {
                slot = this.nextSlot(slot, distance);
                offset = this.getOffsetAt(slot);
                assert (offset != 0L);
                distance = CompactMap.this.entries.getByte(offset) & 0x7F;
                if (!this.cmp(offset)) continue;
                return this.found(offset);
            }
            distance = this.findFreeSlot(slot);
            assert (distance != 0);
            slot = this.nextSlot(slot, distance);
            if (original == offset) {
                distance |= 0xFFFFFF80;
            }
            CompactMap.this.entries.putByte(offset, (byte)distance);
            return this.putNewEntryAt(slot, (byte)0);
        }

        private long calculateEntrySlot(long offset, long size) {
            return CompactMap.this.hashFunction.hash(offset + CompactMap.this.entryKeyOffset, size - CompactMap.this.entryKeyOffset) & CompactMap.this.mask;
        }

        private boolean cmp(long offset) {
            return this.cmp(CompactMap.this.currentEntryOffset + CompactMap.this.entryKeyOffset, offset + CompactMap.this.entryKeyOffset, CompactMap.this.currentEntrySize - CompactMap.this.entryKeyOffset);
        }

        private boolean cmp(long offset1, long offset2, long size) {
            long i;
            long lim = size - size % 8L;
            for (i = 0L; i < lim; i += 8L) {
                if (CompactMap.this.entries.getLong(offset1 + i) == CompactMap.this.entries.getLong(offset2 + i)) continue;
                return false;
            }
            for (i = lim; i < size; ++i) {
                if (CompactMap.this.entries.getByte(offset1 + i) == CompactMap.this.entries.getByte(offset2 + i)) continue;
                return false;
            }
            return true;
        }

        private int findFreeSlot(long slot) {
            for (int i = 1; i < 126; ++i) {
                if (CompactMap.this.entrySlots.getLong(this.nextSlot(slot, i) * 8L) != 0L) continue;
                return i;
            }
            return 0;
        }

        private long findParentSlot(long offset, long targetSlot) {
            long parentSlot = this.calculateEntrySlot(offset, this.getEntrySize(offset));
            while (true) {
                int distance = CompactMap.this.entries.getByte(this.getOffsetAt(parentSlot)) & 0x7F;
                assert (distance != 0);
                long nextSlot = this.nextSlot(parentSlot, distance);
                if (nextSlot == targetSlot) {
                    return parentSlot;
                }
                parentSlot = nextSlot;
            }
        }

        private CompactMapValue found(long offset) {
            CompactMap.this.value.of(offset, false);
            CompactMap.this.currentEntrySize = 0L;
            return CompactMap.this.value;
        }

        private long getEntrySize(long offset) {
            return CompactMap.this.entries.getLong(offset + 1L);
        }

        private long getOffsetAt(long slot) {
            return CompactMap.this.entrySlots.getLong(slot * 8L) - 1L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void grow() {
            if (CompactMap.this.nResizes < CompactMap.this.maxResizes) {
                CompactMap.this.nResizes++;
                long appendPosition = CompactMap.this.entries.getAppendOffset();
                try {
                    CompactMap.this.keyCapacity = CompactMap.this.keyCapacity * 2L;
                    CompactMap.this.configureCapacity();
                    long offset = 0L;
                    for (long target = CompactMap.this.size; target > 0L; --target) {
                        long entrySize = this.getEntrySize(offset);
                        this.rehashEntry(offset, entrySize);
                        offset += entrySize;
                    }
                }
                finally {
                    CompactMap.this.entries.jumpTo(appendPosition);
                }
            } else {
                throw LimitOverflowException.instance().put("limit of ").put(CompactMap.this.maxResizes).put(" resizes exceeded in CompactMap");
            }
        }

        private boolean moveForeignEntries(long slot, long offset) {
            long parentSlot = this.findParentSlot(offset, slot);
            long parentOffset = this.getOffsetAt(parentSlot);
            long currentSlot = slot;
            long currentOffset = offset;
            while (true) {
                int dist;
                if ((dist = this.findFreeSlot(parentSlot)) == 0) {
                    return false;
                }
                if ((CompactMap.this.entries.getByte(parentOffset) & 0xFFFFFF80) == 0) {
                    CompactMap.this.entries.putByte(parentOffset, (byte)dist);
                } else {
                    CompactMap.this.entries.putByte(parentOffset, (byte)(dist | 0xFFFFFF80));
                }
                long nextSlot = this.nextSlot(parentSlot, dist);
                this.setOffsetAt(nextSlot, currentOffset);
                dist = CompactMap.this.entries.getByte(currentOffset) & 0x7F;
                if (currentSlot != slot) {
                    this.setOffsetAt(currentSlot, -1L);
                }
                if (dist == 0) break;
                parentSlot = nextSlot;
                parentOffset = currentOffset;
                currentSlot = this.nextSlot(currentSlot, dist);
                currentOffset = this.getOffsetAt(currentSlot);
            }
            return true;
        }

        private long nextSlot(long slot, int distance) {
            return slot + jumpDistances[distance] & CompactMap.this.mask;
        }

        private void putEntryAt(long entryOffset, long slot, byte flag) {
            this.setOffsetAt(slot, entryOffset);
            CompactMap.this.entries.putByte(entryOffset, flag);
        }

        private CompactMapValue putNewEntryAt(long slot, byte flag) {
            CompactMap.this.entries.putByte(CompactMap.this.currentEntryOffset, flag);
            CompactMap.this.entries.putLong(CompactMap.this.currentEntryOffset + 1L, CompactMap.this.currentEntrySize);
            CompactMap.this.entries.jumpTo(CompactMap.this.currentEntryOffset + 9L);
            if (++CompactMap.this.size == CompactMap.this.keyCapacity) {
                this.grow();
            } else {
                this.setOffsetAt(slot, CompactMap.this.currentEntryOffset);
            }
            CompactMap.this.value.of(CompactMap.this.currentEntryOffset, true);
            return CompactMap.this.value;
        }

        private void rehashEntry(long entryOffset, long currentEntrySize) {
            long slot = this.calculateEntrySlot(entryOffset, currentEntrySize);
            long offset = this.getOffsetAt(slot);
            if (offset == -1L) {
                this.putEntryAt(entryOffset, slot, (byte)-128);
            } else {
                byte flag = CompactMap.this.entries.getByte(offset);
                if ((flag & 0xFFFFFF80) == 0) {
                    this.moveForeignEntries(slot, offset);
                    this.putEntryAt(entryOffset, slot, (byte)-128);
                } else {
                    int distance = flag & 0x7F;
                    long original = offset;
                    while (distance > 0) {
                        slot = this.nextSlot(slot, distance);
                        offset = this.getOffsetAt(slot);
                        distance = CompactMap.this.entries.getByte(offset) & 0x7F;
                    }
                    distance = this.findFreeSlot(slot);
                    assert (distance != 0);
                    slot = this.nextSlot(slot, distance);
                    if (original == offset) {
                        CompactMap.this.entries.putByte(offset, (byte)(distance | 0xFFFFFF80));
                    } else {
                        CompactMap.this.entries.putByte(offset, (byte)distance);
                    }
                    this.putEntryAt(entryOffset, slot, (byte)0);
                }
            }
        }

        private void setOffsetAt(long slot, long offset) {
            CompactMap.this.entrySlots.putLong(slot * 8L, offset + 1L);
        }
    }

    @FunctionalInterface
    public static interface HashFunctionFactory {
        public HashFunction create(MemoryR var1);
    }

    @FunctionalInterface
    public static interface HashFunction {
        public long hash(long var1, long var3);
    }
}

