/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.BitmapIndexUtils;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.CairoError;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.EmptySymbolMapReader;
import io.questdb.cairo.GeoHashes;
import io.questdb.cairo.Sequencer;
import io.questdb.cairo.SymbolMapReader;
import io.questdb.cairo.SymbolMapReaderImpl;
import io.questdb.cairo.TableDescriptor;
import io.questdb.cairo.TableDescriptorImpl;
import io.questdb.cairo.TableReader;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.TableWriter;
import io.questdb.cairo.WalWriterEvents;
import io.questdb.cairo.WalWriterMetadata;
import io.questdb.cairo.WalWriterRollStrategy;
import io.questdb.cairo.WriterRowUtils;
import io.questdb.cairo.security.AllowAllCairoSecurityContext;
import io.questdb.cairo.vm.Vm;
import io.questdb.cairo.vm.api.MemoryA;
import io.questdb.cairo.vm.api.MemoryMA;
import io.questdb.cairo.vm.api.MemoryMAR;
import io.questdb.cairo.vm.api.NullMemory;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.BinarySequence;
import io.questdb.std.CharSequenceIntHashMap;
import io.questdb.std.FilesFacade;
import io.questdb.std.IntList;
import io.questdb.std.Long256;
import io.questdb.std.LongList;
import io.questdb.std.Misc;
import io.questdb.std.Numbers;
import io.questdb.std.ObjList;
import io.questdb.std.datetime.millitime.MillisecondClock;
import io.questdb.std.str.Path;
import io.questdb.std.str.SingleCharCharSequence;
import java.io.Closeable;
import org.jetbrains.annotations.NotNull;

public class WalWriter
implements Closeable {
    static final String WAL_NAME_BASE = "wal";
    static final int WAL_FORMAT_VERSION = 0;
    private static final Log LOG = LogFactory.getLog(WalWriter.class);
    private static final Runnable NOOP = () -> {};
    private final TableDescriptor tableDescriptor = new TableDescriptorImpl();
    private final ObjList<MemoryMA> columns;
    private final ObjList<SymbolMapReader> symbolMapReaders;
    private final IntList initialSymbolCounts = new IntList();
    private final ObjList<CharSequenceIntHashMap> symbolMaps = new ObjList();
    private final MillisecondClock millisecondClock;
    private final Path path;
    private final LongList rowValueIsNotNull = new LongList();
    private final int rootLen;
    private final FilesFacade ff;
    private final MemoryMAR symbolMapMem = Vm.getMARInstance();
    private final int mkDirMode;
    private final String tableName;
    private final String walName;
    private final int walId;
    private final WalWriterMetadata metadata;
    private final WalWriterEvents events;
    private final Sequencer sequencer;
    private final CairoEngine engine;
    private final CairoConfiguration configuration;
    private final ObjList<Runnable> nullSetters;
    private final RowImpl row = new RowImpl();
    private long lockFd = -1L;
    private int columnCount;
    private long startRowCount = -1L;
    private long rowCount = -1L;
    private long segmentId = -1L;
    private long segmentStartMillis;
    private boolean txnOutOfOrder = false;
    private long txnMinTimestamp = Long.MAX_VALUE;
    private long txnMaxTimestamp = -1L;
    private boolean rollSegmentOnNextRow = false;
    private WalWriterRollStrategy rollStrategy = new WalWriterRollStrategy(){};

    public WalWriter(CairoEngine engine, String tableName, int walId, Sequencer sequencer) {
        LOG.info().$("open '").utf8(tableName).$('\'').$();
        this.sequencer = sequencer;
        this.engine = engine;
        this.configuration = engine.getConfiguration();
        this.millisecondClock = this.configuration.getMillisecondClock();
        this.mkDirMode = this.configuration.getMkDirMode();
        this.ff = this.configuration.getFilesFacade();
        this.tableName = tableName;
        this.walName = WAL_NAME_BASE + walId;
        this.walId = walId;
        this.path = new Path().of(this.configuration.getRoot()).concat(tableName).concat(this.walName);
        this.rootLen = this.path.length();
        try {
            this.lock();
            sequencer.populateDescriptor(this.tableDescriptor);
            this.columnCount = this.tableDescriptor.getColumnCount();
            this.columns = new ObjList(this.columnCount * 2);
            this.nullSetters = new ObjList(this.columnCount);
            this.symbolMapReaders = new ObjList();
            this.metadata = new WalWriterMetadata(this.ff);
            this.metadata.of(this.tableDescriptor);
            this.events = new WalWriterEvents(this.ff);
            this.events.of(this.symbolMaps, this.initialSymbolCounts);
            this.configureColumns();
            this.openNewSegment();
            this.configureSymbolTable(this.tableDescriptor);
        }
        catch (Throwable e) {
            this.doClose(false);
            throw e;
        }
    }

    public long getSegment() {
        return this.segmentId;
    }

    public void setRollStrategy(WalWriterRollStrategy rollStrategy) {
        this.rollStrategy = rollStrategy;
    }

    private static int getPrimaryColumnIndex(int index) {
        return index * 2;
    }

    private static int getSecondaryColumnIndex(int index) {
        return WalWriter.getPrimaryColumnIndex(index) + 1;
    }

    public void addColumn(CharSequence name, int type) {
        this.addColumn(name, type, this.configuration.getDefaultSymbolCapacity());
    }

    public void addColumn(CharSequence name, int type, int symbolCapacity) {
        assert (symbolCapacity == Numbers.ceilPow2(symbolCapacity)) : "power of 2 expected";
        assert (TableUtils.isValidColumnName(name, this.configuration.getMaxFileNameLength())) : "invalid column name";
        if (this.metadata.getColumnIndexQuiet(name) != -1) {
            throw CairoException.nonCritical().put("Duplicate column name: ").put(name);
        }
        try {
            LOG.info().$("adding column '").utf8(name).$('[').$(ColumnType.nameOf(type)).$("], to ").$(this.path).$();
            this.commit(true);
            int index = this.columnCount++;
            this.metadata.addColumn(index, name, type);
            this.configureColumn(index, type);
            this.configureSymbolMapWriter(index, name, 0, -1L);
            long txn = this.sequencer.addColumn(index, name, type, this.walId, this.segmentId);
            this.events.addColumn(txn, index, name, type);
            LOG.info().$("ADDED column '").utf8(name).$('[').$(ColumnType.nameOf(type)).$("], to ").$(this.path).$();
        }
        catch (Throwable e) {
            throw new CairoError(e);
        }
    }

    @Override
    public void close() {
        try {
            this.closeCurrentSegment();
            this.doClose(true);
        }
        catch (Throwable e) {
            throw new CairoError(e);
        }
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getWalName() {
        return this.walName;
    }

    public TableWriter.Row newRow() {
        return this.newRow(0L);
    }

    public TableWriter.Row newRow(long timestamp) {
        try {
            int timestampIndex;
            if (this.rollSegmentOnNextRow) {
                this.rollSegment();
            }
            if ((timestampIndex = this.metadata.getTimestampIndex()) != -1) {
                MemoryMA primaryColumn = this.getPrimaryColumn(timestampIndex);
                primaryColumn.putLongLong(timestamp, this.rowCount);
                this.setRowValueNotNull(timestampIndex);
                this.row.timestamp = timestamp;
            }
            return this.row;
        }
        catch (Throwable e) {
            throw new CairoError(e);
        }
    }

    public void removeColumn(CharSequence name) {
        int index = this.metadata.getColumnIndex(name);
        int type = this.metadata.getColumnType(index);
        try {
            LOG.info().$("removing column '").utf8(name).$("' from ").$(this.path).$();
            this.commit(true);
            if (ColumnType.isSymbol(type)) {
                this.removeSymbolMapWriter(index);
            }
            this.metadata.removeColumn(index);
            this.removeColumn(index);
            long txn = this.sequencer.removeColumn(index, this.walId, this.segmentId);
            this.events.removeColumn(txn, index);
            LOG.info().$("REMOVED column '").utf8(name).$("' from ").$(this.path).$();
        }
        catch (Throwable e) {
            throw new CairoError(e);
        }
    }

    public long size() {
        return this.rowCount;
    }

    public String toString() {
        return "WalWriter{name=" + this.tableName + '}';
    }

    private static void configureNullSetters(ObjList<Runnable> nullers, int type, MemoryA mem1, MemoryA mem2) {
        switch (ColumnType.tagOf(type)) {
            case 1: 
            case 2: {
                nullers.add(() -> mem1.putByte((byte)0));
                break;
            }
            case 10: {
                nullers.add(() -> mem1.putDouble(Double.NaN));
                break;
            }
            case 9: {
                nullers.add(() -> mem1.putFloat(Float.NaN));
                break;
            }
            case 5: {
                nullers.add(() -> mem1.putInt(Integer.MIN_VALUE));
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                nullers.add(() -> mem1.putLong(Long.MIN_VALUE));
                break;
            }
            case 13: {
                nullers.add(() -> mem1.putLong256(Long.MIN_VALUE, Long.MIN_VALUE, Long.MIN_VALUE, Long.MIN_VALUE));
                break;
            }
            case 3: {
                nullers.add(() -> mem1.putShort((short)0));
                break;
            }
            case 4: {
                nullers.add(() -> mem1.putChar('\u0000'));
                break;
            }
            case 11: {
                nullers.add(() -> mem2.putLong(mem1.putNullStr()));
                break;
            }
            case 12: {
                nullers.add(() -> mem1.putInt(Integer.MIN_VALUE));
                break;
            }
            case 18: {
                nullers.add(() -> mem2.putLong(mem1.putNullBin()));
                break;
            }
            case 14: {
                nullers.add(() -> mem1.putByte((byte)-1));
                break;
            }
            case 15: {
                nullers.add(() -> mem1.putShort((short)-1));
                break;
            }
            case 16: {
                nullers.add(() -> mem1.putInt(-1));
                break;
            }
            case 17: {
                nullers.add(() -> mem1.putLong(-1L));
                break;
            }
            default: {
                throw new UnsupportedOperationException("unsupported column type: " + ColumnType.nameOf(type));
            }
        }
    }

    private void configureColumn(int index, int type) {
        MemoryMA secondary;
        MemoryMA primary;
        if (type > 0) {
            primary = Vm.getMAInstance();
            switch (ColumnType.tagOf(type)) {
                case 11: 
                case 18: {
                    secondary = Vm.getMAInstance();
                    break;
                }
                default: {
                    secondary = null;
                    break;
                }
            }
        } else {
            secondary = NullMemory.INSTANCE;
            primary = secondary;
        }
        int baseIndex = WalWriter.getPrimaryColumnIndex(index);
        this.columns.extendAndSet(baseIndex, primary);
        this.columns.extendAndSet(baseIndex + 1, secondary);
        WalWriter.configureNullSetters(this.nullSetters, type, primary, secondary);
        this.rowValueIsNotNull.extendAndSet(index, -1L);
    }

    private void configureColumns() {
        for (int i = 0; i < this.columnCount; ++i) {
            int columnType = this.metadata.getColumnType(i);
            if (columnType <= 0) continue;
            this.configureColumn(i, columnType);
        }
    }

    private void configureSymbolTable(TableDescriptor descriptor) {
        int columnReaderIndex = 0;
        try (TableReader reader = this.engine.getReader(AllowAllCairoSecurityContext.INSTANCE, this.tableName);){
            for (int i = 0; i < this.columnCount; ++i) {
                int columnType = this.metadata.getColumnType(i);
                if (!ColumnType.isSymbol(columnType)) {
                    this.symbolMapReaders.extendAndSet(i, null);
                    this.initialSymbolCounts.extendAndSet(i, -1);
                    this.symbolMaps.extendAndSet(i, null);
                } else {
                    SymbolMapReader symbolMapReader = reader.getSymbolMapReader(columnReaderIndex);
                    int symbolCount = symbolMapReader.getSymbolCount();
                    long columnNameTxn = reader.getColumnVersionReader().getDefaultColumnNameTxn(i);
                    this.configureSymbolMapWriter(i, descriptor.getColumnName(i), symbolCount, columnNameTxn);
                }
                if (columnType <= 0) continue;
                ++columnReaderIndex;
            }
        }
    }

    private void configureSymbolMapWriter(int columnWriterIndex, CharSequence columnName, int symbolCount, long columnNameTxm) {
        if (symbolCount == 0) {
            this.symbolMapReaders.extendAndSet(columnWriterIndex, EmptySymbolMapReader.INSTANCE);
            this.initialSymbolCounts.extendAndSet(columnWriterIndex, 0);
            this.symbolMaps.extendAndSet(columnWriterIndex, new CharSequenceIntHashMap(8, 0.5, -2));
            return;
        }
        FilesFacade ff = this.configuration.getFilesFacade();
        Path tempPath = Path.PATH.get();
        tempPath.of(this.configuration.getRoot()).concat(this.tableName);
        int tempPathTripLen = tempPath.length();
        this.path.trimTo(this.rootLen);
        TableUtils.offsetFileName(tempPath, columnName, columnNameTxm);
        TableUtils.offsetFileName(this.path, columnName, -1L);
        if (-1 == ff.hardLink(tempPath.$(), this.path.$())) {
            throw CairoException.critical(ff.errno()).put("failed to link offset file [from=").put(tempPath).put(", to=").put(this.path).put(']');
        }
        tempPath.trimTo(tempPathTripLen);
        this.path.trimTo(this.rootLen);
        TableUtils.charFileName(tempPath, columnName, columnNameTxm);
        TableUtils.charFileName(this.path, columnName, -1L);
        if (-1 == ff.hardLink(tempPath.$(), this.path.$())) {
            throw CairoException.critical(ff.errno()).put("failed to link char file [from=").put(tempPath).put(", to=").put(this.path).put(']');
        }
        tempPath.trimTo(tempPathTripLen);
        this.path.trimTo(this.rootLen);
        BitmapIndexUtils.keyFileName(tempPath, columnName, columnNameTxm);
        BitmapIndexUtils.keyFileName(this.path, columnName, -1L);
        if (-1 == ff.hardLink(tempPath.$(), this.path.$())) {
            throw CairoException.critical(ff.errno()).put("failed to link key file [from=").put(tempPath).put(", to=").put(this.path).put(']');
        }
        tempPath.trimTo(tempPathTripLen);
        this.path.trimTo(this.rootLen);
        BitmapIndexUtils.valueFileName(tempPath, columnName, columnNameTxm);
        BitmapIndexUtils.valueFileName(this.path, columnName, -1L);
        if (-1 == ff.hardLink(tempPath.$(), this.path.$())) {
            throw CairoException.critical(ff.errno()).put("failed to link value file [from=").put(tempPath).put(", to=").put(this.path).put(']');
        }
        this.path.trimTo(this.rootLen);
        SymbolMapReaderImpl symbolMapReader = new SymbolMapReaderImpl(this.configuration, this.path, columnName, -1L, symbolCount);
        this.symbolMapReaders.extendAndSet(columnWriterIndex, symbolMapReader);
        this.symbolMaps.extendAndSet(columnWriterIndex, new CharSequenceIntHashMap(8, 0.5, -2));
        this.initialSymbolCounts.add(symbolCount);
    }

    private void doClose(boolean truncate) {
        Misc.free(this.metadata);
        Misc.free(this.events);
        this.freeSymbolMapWriters();
        Misc.free(this.symbolMapMem);
        this.freeColumns(truncate);
        try {
            this.releaseLock(!truncate);
        }
        finally {
            Misc.free(this.path);
            LOG.info().$("closed '").utf8(this.tableName).$('\'').$();
        }
    }

    private void freeAndRemoveColumnPair(ObjList<MemoryMA> columns, int pi, int si) {
        Misc.free(columns.getAndSetQuick(pi, NullMemory.INSTANCE));
        Misc.free(columns.getAndSetQuick(si, NullMemory.INSTANCE));
    }

    private void freeColumns(boolean truncate) {
        if (this.columns != null) {
            int n = this.columns.size();
            for (int i = 0; i < n; ++i) {
                MemoryMA m = this.columns.getQuick(i);
                if (m == null) continue;
                m.close(truncate);
            }
        }
    }

    private void freeNullSetter(ObjList<Runnable> nullSetters, int columnIndex) {
        nullSetters.setQuick(columnIndex, NOOP);
    }

    private void freeSymbolMapWriters() {
        Misc.freeObjList(this.symbolMapReaders);
    }

    private MemoryMA getPrimaryColumn(int column) {
        assert (column < this.columnCount) : "Column index is out of bounds: " + column + " >= " + this.columnCount;
        return this.columns.getQuick(WalWriter.getPrimaryColumnIndex(column));
    }

    private MemoryMA getSecondaryColumn(int column) {
        assert (column < this.columnCount) : "Column index is out of bounds: " + column + " >= " + this.columnCount;
        return this.columns.getQuick(WalWriter.getSecondaryColumnIndex(column));
    }

    SymbolMapReader getSymbolMapReader(int columnIndex) {
        return this.symbolMapReaders.getQuick(columnIndex);
    }

    private void lock() {
        try {
            TableUtils.lockName(this.path);
            this.lockFd = TableUtils.lock(this.ff, this.path);
        }
        finally {
            this.path.trimTo(this.rootLen);
        }
        if (this.lockFd == -1L) {
            throw CairoException.critical(this.ff.errno()).put("Cannot lock table: ").put(this.path.$());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openColumnFiles(CharSequence name, int columnIndex, int pathTrimToLen) {
        try {
            MemoryMA mem1 = this.getPrimaryColumn(columnIndex);
            mem1.of(this.ff, TableUtils.dFile(this.path.trimTo(pathTrimToLen), name), this.configuration.getDataAppendPageSize(), -1L, 5, this.configuration.getWriterFileOpenOpts());
            MemoryMA mem2 = this.getSecondaryColumn(columnIndex);
            if (mem2 != null) {
                mem2.of(this.ff, TableUtils.iFile(this.path.trimTo(pathTrimToLen), name), this.configuration.getDataAppendPageSize(), -1L, 5, this.configuration.getWriterFileOpenOpts());
                mem2.putLong(0L);
            }
        }
        finally {
            this.path.trimTo(pathTrimToLen);
        }
    }

    public long getTransientRowCount() {
        return this.rowCount - this.startRowCount;
    }

    public long commit() {
        return this.commit(false);
    }

    private long commit(boolean rollSegment) {
        this.rollSegmentOnNextRow = rollSegment;
        long transientRowCount = this.getTransientRowCount();
        if (transientRowCount != 0L) {
            this.events.data(this.nextTxn(), this.startRowCount, this.rowCount, this.txnMinTimestamp, this.txnMaxTimestamp, this.txnOutOfOrder);
            this.resetDataTxnProperties();
        }
        return transientRowCount;
    }

    private long nextTxn() {
        long txn;
        while ((txn = this.sequencer.nextTxn(this.tableDescriptor.getSchemaVersion(), this.walId, this.segmentId)) == Long.MIN_VALUE) {
            this.sequencer.populateDescriptor(this.tableDescriptor);
        }
        return txn;
    }

    private void resetDataTxnProperties() {
        this.startRowCount = this.rowCount;
        this.txnMinTimestamp = Long.MAX_VALUE;
        this.txnMaxTimestamp = -1L;
        this.txnOutOfOrder = false;
    }

    private void closeCurrentSegment() {
        this.commit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openNewSegment() {
        try {
            ++this.segmentId;
            this.rowCount = 0L;
            this.startRowCount = 0L;
            this.rowValueIsNotNull.fill(0, this.columnCount, -1L);
            int segmentPathLen = this.createSegmentDir();
            for (int i = 0; i < this.columnCount; ++i) {
                int type = this.metadata.getColumnType(i);
                if (type <= 0) continue;
                String name = this.metadata.getColumnName(i);
                this.openColumnFiles(name, i, segmentPathLen);
                if (type != 12 || this.symbolMapReaders.size() <= 0) continue;
                SymbolMapReader reader = this.symbolMapReaders.getQuick(i);
                this.initialSymbolCounts.setQuick(i, reader.getSymbolCount());
            }
            this.metadata.openMetaFile(this.path, segmentPathLen, this.columnCount);
            this.events.openEventFile(this.path, segmentPathLen);
            this.segmentStartMillis = this.millisecondClock.getTicks();
            LOG.info().$("opened WAL segment [path='").$(this.path).$('\'').I$();
        }
        finally {
            this.path.trimTo(this.rootLen);
        }
    }

    private int createSegmentDir() {
        this.path.slash().put(this.segmentId);
        int segmentPathLen = this.path.length();
        if (this.ff.mkdirs(this.path.slash$(), this.mkDirMode) != 0) {
            throw CairoException.critical(this.ff.errno()).put("Cannot create WAL segment directory: ").put(this.path);
        }
        this.path.trimTo(segmentPathLen);
        return segmentPathLen;
    }

    private void releaseLock(boolean keepLockFile) {
        if (this.lockFd != -1L) {
            this.ff.close(this.lockFd);
            if (keepLockFile) {
                return;
            }
            try {
                TableUtils.lockName(this.path);
                TableUtils.removeOrException(this.ff, this.path);
            }
            finally {
                this.path.trimTo(this.rootLen);
            }
        }
    }

    private void removeColumn(int columnIndex) {
        int pi = WalWriter.getPrimaryColumnIndex(columnIndex);
        int si = WalWriter.getSecondaryColumnIndex(columnIndex);
        this.freeNullSetter(this.nullSetters, columnIndex);
        this.freeAndRemoveColumnPair(this.columns, pi, si);
    }

    private void removeSymbolMapWriter(int index) {
        Misc.free(this.symbolMapReaders.getAndSetQuick(index, null));
        this.initialSymbolCounts.setQuick(index, -1);
    }

    private void rowAppend(ObjList<Runnable> activeNullSetters, long rowTimestamp) {
        for (int i = 0; i < this.columnCount; ++i) {
            if (this.rowValueIsNotNull.getQuick(i) >= this.rowCount) continue;
            activeNullSetters.getQuick(i).run();
        }
        if (rowTimestamp > this.txnMaxTimestamp) {
            this.txnMaxTimestamp = rowTimestamp;
        } else {
            boolean bl = this.txnOutOfOrder = this.txnMaxTimestamp != rowTimestamp;
        }
        if (rowTimestamp < this.txnMinTimestamp) {
            this.txnMinTimestamp = rowTimestamp;
        }
        ++this.rowCount;
    }

    public long rollSegment() {
        try {
            this.closeCurrentSegment();
            long rolledRowCount = this.rowCount;
            this.openNewSegment();
            return rolledRowCount;
        }
        catch (Throwable e) {
            throw new CairoError(e);
        }
    }

    public long rollSegmentIfLimitReached() {
        long segmentSize = 0L;
        if (this.rollStrategy.isMaxSegmentSizeSet()) {
            for (int i = 0; i < this.columnCount; ++i) {
                segmentSize = this.updateSegmentSize(segmentSize, i);
            }
        }
        long segmentAge = 0L;
        if (this.rollStrategy.isRollIntervalSet()) {
            segmentAge = this.millisecondClock.getTicks() - this.segmentStartMillis;
        }
        if (this.rollStrategy.shouldRoll(segmentSize, this.rowCount, segmentAge)) {
            return this.rollSegment();
        }
        return 0L;
    }

    private long updateSegmentSize(long segmentSize, int columnIndex) {
        MemoryMA primaryColumn = this.getPrimaryColumn(columnIndex);
        if (primaryColumn != null && primaryColumn != NullMemory.INSTANCE) {
            segmentSize += primaryColumn.getAppendOffset();
            MemoryMA secondaryColumn = this.getSecondaryColumn(columnIndex);
            if (secondaryColumn != null && secondaryColumn != NullMemory.INSTANCE) {
                segmentSize += secondaryColumn.getAppendOffset();
            }
        }
        return segmentSize;
    }

    private void setRowValueNotNull(int columnIndex) {
        assert (this.rowValueIsNotNull.getQuick(columnIndex) != this.rowCount);
        this.rowValueIsNotNull.setQuick(columnIndex, this.rowCount);
    }

    private class RowImpl
    implements TableWriter.Row {
        private long timestamp;

        private RowImpl() {
        }

        @Override
        public void append() {
            WalWriter.this.rowAppend(WalWriter.this.nullSetters, this.timestamp);
        }

        @Override
        public void cancel() {
            WalWriter.this.rollSegment();
        }

        @Override
        public void putBin(int columnIndex, long address, long len) {
            this.getSecondaryColumn(columnIndex).putLong(this.getPrimaryColumn(columnIndex).putBin(address, len));
            WalWriter.this.setRowValueNotNull(columnIndex);
        }

        @Override
        public void putBin(int columnIndex, BinarySequence sequence) {
            this.getSecondaryColumn(columnIndex).putLong(this.getPrimaryColumn(columnIndex).putBin(sequence));
            WalWriter.this.setRowValueNotNull(columnIndex);
        }

        @Override
        public void putBool(int columnIndex, boolean value) {
            this.getPrimaryColumn(columnIndex).putBool(value);
            WalWriter.this.setRowValueNotNull(columnIndex);
        }

        @Override
        public void putByte(int columnIndex, byte value) {
            this.getPrimaryColumn(columnIndex).putByte(value);
            WalWriter.this.setRowValueNotNull(columnIndex);
        }

        @Override
        public void putChar(int columnIndex, char value) {
            this.getPrimaryColumn(columnIndex).putChar(value);
            WalWriter.this.setRowValueNotNull(columnIndex);
        }

        @Override
        public void putDouble(int columnIndex, double value) {
            this.getPrimaryColumn(columnIndex).putDouble(value);
            WalWriter.this.setRowValueNotNull(columnIndex);
        }

        @Override
        public void putFloat(int columnIndex, float value) {
            this.getPrimaryColumn(columnIndex).putFloat(value);
            WalWriter.this.setRowValueNotNull(columnIndex);
        }

        @Override
        public void putGeoHash(int index, long value) {
            int type = WalWriter.this.metadata.getColumnType(index);
            WriterRowUtils.putGeoHash(index, value, type, this);
        }

        @Override
        public void putGeoHashDeg(int index, double lat, double lon) {
            int type = WalWriter.this.metadata.getColumnType(index);
            WriterRowUtils.putGeoHash(index, GeoHashes.fromCoordinatesDegUnsafe(lat, lon, ColumnType.getGeoHashBits(type)), type, this);
        }

        @Override
        public void putGeoStr(int index, CharSequence hash) {
            int type = WalWriter.this.metadata.getColumnType(index);
            WriterRowUtils.putGeoStr(index, hash, type, this);
        }

        @Override
        public void putInt(int columnIndex, int value) {
            this.getPrimaryColumn(columnIndex).putInt(value);
            WalWriter.this.setRowValueNotNull(columnIndex);
        }

        @Override
        public void putLong(int columnIndex, long value) {
            this.getPrimaryColumn(columnIndex).putLong(value);
            WalWriter.this.setRowValueNotNull(columnIndex);
        }

        @Override
        public void putLong256(int columnIndex, long l0, long l1, long l2, long l3) {
            this.getPrimaryColumn(columnIndex).putLong256(l0, l1, l2, l3);
            WalWriter.this.setRowValueNotNull(columnIndex);
        }

        @Override
        public void putLong256(int columnIndex, Long256 value) {
            this.getPrimaryColumn(columnIndex).putLong256(value.getLong0(), value.getLong1(), value.getLong2(), value.getLong3());
            WalWriter.this.setRowValueNotNull(columnIndex);
        }

        @Override
        public void putLong256(int columnIndex, CharSequence hexString) {
            this.getPrimaryColumn(columnIndex).putLong256(hexString);
            WalWriter.this.setRowValueNotNull(columnIndex);
        }

        @Override
        public void putLong128LittleEndian(int columnIndex, long hi, long lo) {
            MemoryA primaryColumn = this.getPrimaryColumn(columnIndex);
            primaryColumn.putLong(lo);
            primaryColumn.putLong(hi);
            WalWriter.this.setRowValueNotNull(columnIndex);
        }

        @Override
        public void putLong256(int columnIndex, @NotNull CharSequence hexString, int start, int end) {
            this.getPrimaryColumn(columnIndex).putLong256(hexString, start, end);
            WalWriter.this.setRowValueNotNull(columnIndex);
        }

        @Override
        public void putShort(int columnIndex, short value) {
            this.getPrimaryColumn(columnIndex).putShort(value);
            WalWriter.this.setRowValueNotNull(columnIndex);
        }

        @Override
        public void putStr(int columnIndex, CharSequence value) {
            this.getSecondaryColumn(columnIndex).putLong(this.getPrimaryColumn(columnIndex).putStr(value));
            WalWriter.this.setRowValueNotNull(columnIndex);
        }

        @Override
        public void putStr(int columnIndex, char value) {
            this.getSecondaryColumn(columnIndex).putLong(this.getPrimaryColumn(columnIndex).putStr(value));
            WalWriter.this.setRowValueNotNull(columnIndex);
        }

        @Override
        public void putStr(int columnIndex, CharSequence value, int pos, int len) {
            this.getSecondaryColumn(columnIndex).putLong(this.getPrimaryColumn(columnIndex).putStr(value, pos, len));
            WalWriter.this.setRowValueNotNull(columnIndex);
        }

        @Override
        public void putSym(int columnIndex, CharSequence value) {
            int key;
            SymbolMapReader symbolMapReader = (SymbolMapReader)WalWriter.this.symbolMapReaders.getQuick(columnIndex);
            if (symbolMapReader != null) {
                key = symbolMapReader.keyOf(value);
                if (key == -2) {
                    if (value != null) {
                        int initialSymCount = WalWriter.this.initialSymbolCounts.get(columnIndex);
                        CharSequenceIntHashMap symbolMap = (CharSequenceIntHashMap)WalWriter.this.symbolMaps.getQuick(columnIndex);
                        key = symbolMap.get(value);
                        if (key == -2) {
                            key = initialSymCount + symbolMap.size();
                            symbolMap.put(value, key);
                        }
                    } else {
                        key = Integer.MIN_VALUE;
                    }
                }
            } else {
                throw new UnsupportedOperationException();
            }
            this.getPrimaryColumn(columnIndex).putInt(key);
            WalWriter.this.setRowValueNotNull(columnIndex);
        }

        @Override
        public void putSym(int columnIndex, char value) {
            CharSequence str = SingleCharCharSequence.get(value);
            this.putSym(columnIndex, str);
        }

        private MemoryA getPrimaryColumn(int columnIndex) {
            return (MemoryA)WalWriter.this.columns.getQuick(WalWriter.getPrimaryColumnIndex(columnIndex));
        }

        private MemoryA getSecondaryColumn(int columnIndex) {
            return (MemoryA)WalWriter.this.columns.getQuick(WalWriter.getSecondaryColumnIndex(columnIndex));
        }
    }
}

