/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.TableUtils;
import io.questdb.cairo.WalEventCursor;
import io.questdb.cairo.vm.Vm;
import io.questdb.cairo.vm.api.MemoryMR;
import io.questdb.std.FilesFacade;
import io.questdb.std.Misc;
import io.questdb.std.str.Path;
import java.io.Closeable;

public class WalReaderEvents
implements Closeable {
    private final FilesFacade ff;
    private final MemoryMR eventMem;
    private final WalEventCursor eventCursor;

    public WalReaderEvents(FilesFacade ff) {
        this.ff = ff;
        this.eventMem = Vm.getMRInstance();
        this.eventCursor = new WalEventCursor(this.eventMem);
    }

    @Override
    public void close() {
        Misc.free(this.eventMem);
    }

    public WalEventCursor of(Path path, int pathLen, long segmentId, int expectedVersion) {
        try {
            TableUtils.openSmallFile(this.ff, path.slash().put(segmentId), pathLen, this.eventMem, "_event", 36);
            TableUtils.checkMemSize(this.eventMem, 12L);
            TableUtils.validateMetaVersion(this.eventMem, 0L, expectedVersion);
            this.eventCursor.reset();
        }
        catch (Throwable e) {
            this.close();
            throw e;
        }
        return this.eventCursor;
    }
}

