/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.TableUtils;
import io.questdb.cairo.vm.Vm;
import io.questdb.cairo.vm.api.MemoryMAR;
import io.questdb.std.FilesFacade;
import io.questdb.std.Misc;
import io.questdb.std.str.Path;
import java.io.Closeable;

public class TxnCatalog
implements Closeable {
    private final FilesFacade ff;
    private final MemoryMAR metaMem = Vm.getMARInstance();

    TxnCatalog(FilesFacade ff) {
        this.ff = ff;
    }

    void open(Path path, int pathLen, long startTxn) {
        TableUtils.openSmallFile(this.ff, path, pathLen, this.metaMem, "_catalog", 38);
        if (startTxn == 0L) {
            this.metaMem.putInt(0);
        } else {
            this.metaMem.jumpTo(4L + startTxn * 20L);
        }
    }

    private long calcOffsetForTxn(long txn) {
        return 4L + (txn - 1L) * 20L;
    }

    void setEntry(long txn, int walId, long segmentId) {
        this.metaMem.jumpTo(this.calcOffsetForTxn(txn));
        this.metaMem.putLong(txn);
        this.metaMem.putInt(walId);
        this.metaMem.putLong(segmentId);
    }

    @Override
    public void close() {
        Misc.free(this.metaMem);
    }
}

