/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.TableReader;
import io.questdb.cairo.TableReaderRecord;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.SymbolTable;
import io.questdb.std.Rows;

public class TableReaderRecordCursor
implements RecordCursor {
    protected final TableReaderRecord recordA = new TableReaderRecord();
    private final TableReaderRecord recordB = new TableReaderRecord();
    protected TableReader reader;
    private int partitionIndex = 0;
    private int partitionLimit;
    private long maxRecordIndex = -1L;
    private int partitionLo;
    private long recordLo;
    private int partitionHi;
    private long recordHi;

    @Override
    public void close() {
        if (this.reader != null) {
            this.reader.close();
            this.reader = null;
        }
    }

    @Override
    public Record getRecord() {
        return this.recordA;
    }

    @Override
    public SymbolTable getSymbolTable(int columnIndex) {
        return this.reader.getSymbolMapReader(columnIndex);
    }

    @Override
    public SymbolTable newSymbolTable(int columnIndex) {
        return this.reader.newSymbolTable(columnIndex);
    }

    @Override
    public boolean hasNext() {
        if (this.recordA.getRecordIndex() < this.maxRecordIndex || this.switchPartition()) {
            this.recordA.incrementRecordIndex();
            return true;
        }
        return false;
    }

    @Override
    public Record getRecordB() {
        return this.recordB;
    }

    @Override
    public long size() {
        return this.reader.size();
    }

    @Override
    public void recordAt(Record record, long rowId) {
        ((TableReaderRecord)record).jumpTo(Rows.toPartitionIndex(rowId), Rows.toLocalRowID(rowId));
    }

    @Override
    public void toTop() {
        this.partitionIndex = this.partitionLo;
        this.partitionLimit = this.recordHi == -1L ? this.reader.getPartitionCount() : Math.min(this.partitionHi + 1, this.reader.getPartitionCount());
        this.maxRecordIndex = this.recordLo - 1L;
        this.recordA.jumpTo(0, this.maxRecordIndex);
    }

    public void of(TableReader reader) {
        this.partitionLo = 0;
        this.recordLo = 0L;
        this.partitionHi = reader.getPartitionCount();
        this.recordHi = -1L;
        this.of0(reader);
    }

    private void of0(TableReader reader) {
        this.close();
        this.reader = reader;
        this.recordA.of(reader);
        this.recordB.of(reader);
        this.toTop();
    }

    public void of(TableReader reader, int partitionLo, long recordLo, int partitionHi, long recordHi) {
        this.partitionLo = partitionLo;
        this.partitionHi = partitionHi;
        this.recordLo = recordLo;
        this.recordHi = recordHi;
        this.of0(reader);
    }

    public void startFrom(long rowid) {
        this.partitionIndex = Rows.toPartitionIndex(rowid);
        long recordIndex = Rows.toLocalRowID(rowid);
        this.recordA.jumpTo(this.partitionIndex, recordIndex);
        this.maxRecordIndex = this.reader.openPartition(this.partitionIndex) - 1L;
        ++this.partitionIndex;
        this.partitionLimit = this.reader.getPartitionCount();
    }

    private boolean switchPartition() {
        if (this.partitionIndex < this.partitionLimit) {
            return this.switchPartition0();
        }
        return false;
    }

    private boolean switchPartition0() {
        while (this.partitionIndex < this.partitionLimit) {
            long partitionSize = this.reader.openPartition(this.partitionIndex);
            if (partitionSize > 0L) {
                this.maxRecordIndex = this.partitionIndex == this.partitionHi && this.recordHi > -1L ? this.recordHi - 1L : partitionSize - 1L;
                this.recordA.jumpTo(this.partitionIndex, -1L);
                ++this.partitionIndex;
                return true;
            }
            ++this.partitionIndex;
        }
        return false;
    }
}

