/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.BaseRecordMetadata;
import io.questdb.cairo.TableColumnMetadata;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.vm.Vm;
import io.questdb.cairo.vm.api.MemoryMA;
import io.questdb.cairo.vm.api.MemoryMR;
import io.questdb.std.Chars;
import io.questdb.std.FilesFacade;
import io.questdb.std.LowerCaseCharSequenceIntHashMap;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;
import io.questdb.std.str.Path;
import java.io.Closeable;

public class TableReaderMetadata
extends BaseRecordMetadata
implements Closeable {
    private final Path path;
    private final FilesFacade ff;
    private final LowerCaseCharSequenceIntHashMap tmpValidationMap = new LowerCaseCharSequenceIntHashMap();
    private MemoryMR metaMem;
    private int partitionBy;
    private int version;
    private int tableId;
    private int maxUncommittedRows;
    private long commitLag;
    private long structureVersion;
    private MemoryMR transitionMeta;
    private boolean walEnabled;

    public TableReaderMetadata(FilesFacade ff) {
        this.path = new Path();
        this.ff = ff;
        this.metaMem = Vm.getMRInstance();
        this.columnMetadata = new ObjList(this.columnCount);
        this.columnNameIndexMap = new LowerCaseCharSequenceIntHashMap();
    }

    public TableReaderMetadata(FilesFacade ff, Path path) {
        this(ff);
        this.deferredInit(path, 426);
    }

    public void applyTransitionIndex() {
        MemoryMR temp = this.metaMem;
        this.metaMem = this.transitionMeta;
        this.transitionMeta = temp;
        this.transitionMeta.close();
        this.columnNameIndexMap.clear();
        int existingColumnCount = this.columnCount;
        int columnCount = this.metaMem.getInt(0L);
        assert (columnCount >= existingColumnCount);
        this.columnMetadata.setPos(columnCount);
        int timestampIndex = this.metaMem.getInt(8L);
        this.tableId = this.metaMem.getInt(16L);
        this.structureVersion = this.metaMem.getLong(32L);
        this.maxUncommittedRows = this.metaMem.getInt(20L);
        this.commitLag = this.metaMem.getLong(24L);
        this.walEnabled = this.metaMem.getInt(40L) > 0;
        long offset = TableUtils.getColumnNameOffset(columnCount);
        int shiftLeft = 0;
        int existingIndex = 0;
        for (int metaIndex = 0; metaIndex < columnCount; ++metaIndex) {
            CharSequence name = this.metaMem.getStr(offset);
            offset += (long)Vm.getStorageLength(name);
            assert (name != null);
            int columnType = TableUtils.getColumnType(this.metaMem, metaIndex);
            boolean isIndexed = TableUtils.isColumnIndexed(this.metaMem, metaIndex);
            int indexBlockCapacity = TableUtils.getIndexBlockCapacity(this.metaMem, metaIndex);
            TableColumnMetadata existing = null;
            if (existingIndex < existingColumnCount && (existing = (TableColumnMetadata)this.columnMetadata.getQuick(existingIndex)).getWriterIndex() > metaIndex) {
                assert (columnType < 0);
                continue;
            }
            assert (existing == null || existing.getWriterIndex() == metaIndex);
            if (columnType < 0) {
                ++shiftLeft;
            } else {
                String newName;
                boolean rename = existing != null && !Chars.equals((CharSequence)existing.getName(), name);
                String string = newName = rename || existing == null ? Chars.toString(name) : existing.getName();
                if (rename || existing == null || existing.isIndexed() != isIndexed || existing.getIndexValueBlockCapacity() != indexBlockCapacity) {
                    this.columnMetadata.setQuick(existingIndex - shiftLeft, new TableColumnMetadata(newName, TableUtils.getColumnHash(this.metaMem, metaIndex), columnType, isIndexed, indexBlockCapacity, true, null, metaIndex));
                } else if (shiftLeft > 0) {
                    this.columnMetadata.setQuick(existingIndex - shiftLeft, existing);
                }
                this.columnNameIndexMap.put(newName, existingIndex - shiftLeft);
                if (timestampIndex == metaIndex) {
                    this.timestampIndex = existingIndex - shiftLeft;
                }
            }
            ++existingIndex;
        }
        this.columnMetadata.setPos(existingIndex - shiftLeft);
        this.columnCount = this.columnMetadata.size();
        if (timestampIndex < 0) {
            this.timestampIndex = timestampIndex;
        }
    }

    public void clear() {
        Misc.free(this.metaMem);
    }

    @Override
    public void close() {
        Misc.free(this.metaMem);
        Misc.free(this.path);
        Misc.free(this.transitionMeta);
    }

    public long createTransitionIndex(long txnStructureVersion) {
        if (this.transitionMeta == null) {
            this.transitionMeta = Vm.getMRInstance();
        }
        this.transitionMeta.smallFile(this.ff, this.path, 0);
        if (this.transitionMeta.size() >= 40L && txnStructureVersion != this.transitionMeta.getLong(32L)) {
            return -1L;
        }
        this.tmpValidationMap.clear();
        TableUtils.validateMeta(this.transitionMeta, this.tmpValidationMap, 426);
        return TableUtils.createTransitionIndex(this.transitionMeta, this);
    }

    public TableReaderMetadata deferredInit(Path path, int expectedVersion) {
        this.path.of(path).$();
        try {
            this.metaMem.smallFile(this.ff, path, 0);
            this.columnNameIndexMap.clear();
            TableUtils.validateMeta(this.metaMem, this.columnNameIndexMap, expectedVersion);
            int columnCount = this.metaMem.getInt(0L);
            int timestampIndex = this.metaMem.getInt(8L);
            this.partitionBy = this.metaMem.getInt(4L);
            this.version = this.metaMem.getInt(12L);
            this.tableId = this.metaMem.getInt(16L);
            this.maxUncommittedRows = this.metaMem.getInt(20L);
            this.commitLag = this.metaMem.getLong(24L);
            this.structureVersion = this.metaMem.getLong(32L);
            this.walEnabled = this.metaMem.getInt(40L) > 0;
            this.columnMetadata.clear();
            long offset = TableUtils.getColumnNameOffset(columnCount);
            this.timestampIndex = -1;
            for (int i = 0; i < columnCount; ++i) {
                CharSequence name = this.metaMem.getStr(offset);
                assert (name != null);
                int columnType = TableUtils.getColumnType(this.metaMem, i);
                if (columnType > 0) {
                    this.columnMetadata.add(new TableColumnMetadata(Chars.toString(name), TableUtils.getColumnHash(this.metaMem, i), columnType, TableUtils.isColumnIndexed(this.metaMem, i), TableUtils.getIndexBlockCapacity(this.metaMem, i), true, null, i));
                    if (i == timestampIndex) {
                        this.timestampIndex = this.columnMetadata.size() - 1;
                    }
                }
                offset += (long)Vm.getStorageLength(name);
            }
            this.columnCount = this.columnMetadata.size();
        }
        catch (Throwable e) {
            this.close();
            throw e;
        }
        return this;
    }

    public void dumpTo(MemoryMA mem) {
        long len = this.metaMem.size();
        for (long p = 0L; p < len; ++p) {
            mem.putByte(this.metaMem.getByte(p));
        }
    }

    @Override
    public int getColumnCount() {
        return this.columnCount;
    }

    public long getCommitLag() {
        return this.commitLag;
    }

    public int getId() {
        return this.tableId;
    }

    public int getMaxUncommittedRows() {
        return this.maxUncommittedRows;
    }

    public int getPartitionBy() {
        return this.partitionBy;
    }

    public long getStructureVersion() {
        return this.structureVersion;
    }

    public int getVersion() {
        return this.version;
    }

    public boolean isWalEnabled() {
        return this.walEnabled;
    }
}

