/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.BaseRecordMetadata;
import io.questdb.cairo.SequencerMetadata;
import io.questdb.cairo.TableColumnMetadata;
import io.questdb.cairo.TableDescriptor;
import io.questdb.std.LowerCaseCharSequenceIntHashMap;
import io.questdb.std.ObjList;

class TableDescriptorImpl
extends BaseRecordMetadata
implements TableDescriptor {
    private int schemaVersion;

    TableDescriptorImpl() {
        this.columnMetadata = new ObjList();
        this.columnNameIndexMap = new LowerCaseCharSequenceIntHashMap();
    }

    @Override
    public void of(SequencerMetadata source) {
        this.schemaVersion = source.getSchemaVersion();
        this.timestampIndex = source.getTimestampIndex();
        this.columnCount = source.getColumnCount();
        for (int i = 0; i < this.columnCount; ++i) {
            String name = source.getColumnName(i);
            int type = source.getColumnType(i);
            this.columnNameIndexMap.put(name, this.columnNameIndexMap.size());
            this.columnMetadata.add(new TableColumnMetadata(name, -1L, type, false, 0, false, null, i));
        }
    }

    @Override
    public int getSchemaVersion() {
        return this.schemaVersion;
    }
}

