/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.ColumnType;
import io.questdb.cairo.GenericRecordMetadata;
import io.questdb.cairo.sql.RecordMetadata;
import org.jetbrains.annotations.Nullable;

public class TableColumnMetadata {
    private final int writerIndex;
    private final long hash;
    private final boolean symbolTableStatic;
    @Nullable
    private final RecordMetadata metadata;
    private int type;
    private String name;
    private int indexValueBlockCapacity;
    private boolean indexed;

    public TableColumnMetadata(String name, long hash, int type) {
        this(name, hash, type, null);
    }

    public TableColumnMetadata(String name, long hash, int type, @Nullable RecordMetadata metadata) {
        this(name, hash, type, false, 0, false, metadata, -1);
        assert (!ColumnType.isSymbol(type));
    }

    public TableColumnMetadata(String name, long hash, int type, boolean indexFlag, int indexValueBlockCapacity, boolean symbolTableStatic, @Nullable RecordMetadata metadata) {
        this(name, hash, type, indexFlag, indexValueBlockCapacity, symbolTableStatic, metadata, -1);
    }

    public TableColumnMetadata(String name, long hash, int type, boolean indexFlag, int indexValueBlockCapacity, boolean symbolTableStatic, @Nullable RecordMetadata metadata, int writerIndex) {
        this.name = name;
        this.hash = hash;
        this.type = type;
        this.indexed = indexFlag;
        this.indexValueBlockCapacity = indexValueBlockCapacity;
        this.symbolTableStatic = symbolTableStatic;
        this.metadata = GenericRecordMetadata.copyOf(metadata);
        this.writerIndex = writerIndex;
    }

    public long getHash() {
        return this.hash;
    }

    public int getIndexValueBlockCapacity() {
        return this.indexValueBlockCapacity;
    }

    public int getWriterIndex() {
        return this.writerIndex;
    }

    public void markDeleted() {
        this.type = -Math.abs(this.type);
    }

    public void setIndexValueBlockCapacity(int indexValueBlockCapacity) {
        this.indexValueBlockCapacity = indexValueBlockCapacity;
    }

    @Nullable
    public RecordMetadata getMetadata() {
        return this.metadata;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getType() {
        return this.type;
    }

    public boolean isIndexed() {
        return this.indexed;
    }

    public void setIndexed(boolean value) {
        this.indexed = value;
    }

    public boolean isSymbolTableStatic() {
        return this.symbolTableStatic;
    }
}

