/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.SymbolMapDiff;
import io.questdb.cairo.SymbolMapDiffEntry;
import io.questdb.cairo.WalEventCursor;

public class SymbolMapDiffImpl
implements SymbolMapDiff {
    public static final int END_OF_SYMBOL_DIFFS = -1;
    public static final int END_OF_SYMBOL_ENTRIES = -1;
    private final WalEventCursor cursor;
    private final Entry entry = new Entry();
    private int columnIndex = -1;
    private int cleanSymbolCount;
    private int size;

    SymbolMapDiffImpl(WalEventCursor cursor) {
        this.cursor = cursor;
    }

    void of(int columnIndex, int cleanSymbolCount, int size) {
        this.columnIndex = columnIndex;
        this.cleanSymbolCount = cleanSymbolCount;
        this.size = size;
        this.entry.clear();
    }

    @Override
    public int getColumnIndex() {
        return this.columnIndex;
    }

    @Override
    public int getCleanSymbolCount() {
        return this.cleanSymbolCount;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public SymbolMapDiffEntry nextEntry() {
        return this.cursor.readNextSymbolMapDiffEntry(this.entry);
    }

    public static class Entry
    implements SymbolMapDiffEntry {
        private int key;
        private CharSequence symbol;

        void of(int key, CharSequence symbol) {
            this.key = key;
            this.symbol = symbol;
        }

        @Override
        public int getKey() {
            return this.key;
        }

        @Override
        public CharSequence getSymbol() {
            return this.symbol;
        }

        void clear() {
            this.of(-1, null);
        }
    }
}

