/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.BaseRecordMetadata;
import io.questdb.cairo.TableColumnMetadata;
import io.questdb.cairo.TableStructure;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.vm.Vm;
import io.questdb.cairo.vm.api.MemoryMAR;
import io.questdb.cairo.vm.api.MemoryMR;
import io.questdb.std.FilesFacade;
import io.questdb.std.LowerCaseCharSequenceIntHashMap;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;
import io.questdb.std.str.Path;
import java.io.Closeable;

public class SequencerMetadata
extends BaseRecordMetadata
implements Closeable {
    private final FilesFacade ff;
    private final MemoryMAR metaMem = Vm.getMARInstance();
    private int schemaVersion = -1;

    SequencerMetadata(FilesFacade ff) {
        this.ff = ff;
        this.columnMetadata = new ObjList();
        this.columnNameIndexMap = new LowerCaseCharSequenceIntHashMap();
    }

    void init(TableStructure model, Path path, int pathLen) {
        this.reset();
        this.schemaVersion = 0;
        this.timestampIndex = model.getTimestampIndex();
        for (int i = 0; i < model.getColumnCount(); ++i) {
            CharSequence name = model.getColumnName(i);
            int type = model.getColumnType(i);
            this.addColumn(i, name, type);
        }
        this.syncToMetaFile(path, pathLen);
    }

    void open(Path path, int pathLen) {
        this.reset();
        try (MemoryMR metaMem = Vm.getMRInstance();){
            TableUtils.openSmallFile(this.ff, path, pathLen, metaMem, "_meta", 38);
            this.columnNameIndexMap.clear();
            TableUtils.loadSequencerMetadata(metaMem, this.columnMetadata, this.columnNameIndexMap);
            this.schemaVersion = metaMem.getInt(4L);
            this.columnCount = metaMem.getInt(8L);
            this.timestampIndex = metaMem.getInt(12L);
        }
        catch (Throwable e) {
            this.close();
            throw e;
        }
    }

    private void reset() {
        this.columnMetadata.clear();
        this.columnNameIndexMap.clear();
        this.columnCount = 0;
        this.timestampIndex = -1;
    }

    public int getSchemaVersion() {
        return this.schemaVersion;
    }

    @Override
    public void close() {
        Misc.free(this.metaMem);
    }

    private void addColumn(int columnIndex, CharSequence columnName, int columnType) {
        String name = columnName.toString();
        this.columnNameIndexMap.put(name, this.columnNameIndexMap.size());
        this.columnMetadata.add(new TableColumnMetadata(name, -1L, columnType, false, 0, false, null, columnIndex));
        ++this.columnCount;
        ++this.schemaVersion;
    }

    void addColumn(int columnIndex, CharSequence columnName, int columnType, Path path, int pathLen) {
        this.addColumn(columnIndex, columnName, columnType);
        this.syncToMetaFile(path, pathLen);
    }

    void removeColumn(int columnIndex, Path path, int pathLen) {
        TableColumnMetadata deletedMeta = (TableColumnMetadata)this.columnMetadata.getQuick(columnIndex);
        deletedMeta.markDeleted();
        this.columnNameIndexMap.remove(deletedMeta.getName());
        ++this.schemaVersion;
        this.syncToMetaFile(path, pathLen);
    }

    private void syncToMetaFile(Path path, int pathLen) {
        int i;
        int liveColumnCount = 0;
        for (i = 0; i < this.columnCount; ++i) {
            if (this.getColumnType(i) <= 0) continue;
            ++liveColumnCount;
        }
        TableUtils.openSmallFile(this.ff, path, pathLen, this.metaMem, "_meta", 38);
        this.metaMem.putInt(0);
        this.metaMem.putInt(this.schemaVersion);
        this.metaMem.putInt(liveColumnCount);
        this.metaMem.putInt(this.timestampIndex);
        for (i = 0; i < this.columnCount; ++i) {
            int type = this.getColumnType(i);
            if (type <= 0) continue;
            this.metaMem.putInt(type);
            this.metaMem.putStr(this.getColumnName(i));
        }
    }
}

