/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.ColumnType;
import io.questdb.cairo.ColumnTypes;
import io.questdb.cairo.RecordSink;
import io.questdb.cairo.RecordSinkSPI;
import io.questdb.cairo.Reopenable;
import io.questdb.cairo.sql.AnalyticSPI;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.SymbolTableSource;
import io.questdb.cairo.vm.Vm;
import io.questdb.cairo.vm.api.MemoryARW;
import io.questdb.std.BinarySequence;
import io.questdb.std.Long256;
import io.questdb.std.Mutable;
import io.questdb.std.str.CharSink;
import java.io.Closeable;

public class RecordChain
implements Closeable,
RecordCursor,
Mutable,
RecordSinkSPI,
AnalyticSPI,
Reopenable {
    private final long[] columnOffsets;
    private final MemoryARW mem;
    private final RecordChainRecord recordA = new RecordChainRecord();
    private final RecordChainRecord recordB = new RecordChainRecord();
    private final long varOffset;
    private final long fixOffset;
    private final RecordSink recordSink;
    private long recordOffset;
    private long varAppendOffset = 0L;
    private long nextRecordOffset = -1L;
    private SymbolTableSource symbolTableResolver;

    public RecordChain(ColumnTypes columnTypes, RecordSink recordSink, long pageSize, int maxPages) {
        this.mem = Vm.getARWInstance(pageSize, maxPages, 4);
        this.recordSink = recordSink;
        int count = columnTypes.getColumnCount();
        long varOffset = 0L;
        long fixOffset = 0L;
        this.columnOffsets = new long[count];
        for (int i = 0; i < count; ++i) {
            int type = columnTypes.getColumnType(i);
            if (ColumnType.isVariableLength(type)) {
                this.columnOffsets[i] = varOffset;
                varOffset += 8L;
                continue;
            }
            this.columnOffsets[i] = fixOffset;
            fixOffset += (long)ColumnType.sizeOf(type);
        }
        this.varOffset = varOffset;
        this.fixOffset = fixOffset;
    }

    public long addressOf(long offset) {
        return this.mem.addressOf(offset);
    }

    public long beginRecord(long prevOffset) {
        this.mem.putLong(this.varAppendOffset, -1L);
        this.recordOffset = this.varAppendOffset;
        if (prevOffset != -1L) {
            this.mem.putLong(prevOffset, this.recordOffset);
        }
        this.mem.jumpTo(RecordChain.rowToDataOffset(this.recordOffset + this.varOffset));
        this.varAppendOffset = RecordChain.rowToDataOffset(this.recordOffset + this.varOffset + this.fixOffset);
        return this.recordOffset;
    }

    @Override
    public void clear() {
        this.mem.close();
        this.nextRecordOffset = -1L;
        this.varAppendOffset = 0L;
    }

    @Override
    public void close() {
        this.clear();
        this.symbolTableResolver = null;
    }

    @Override
    public long getAddress(long recordOffset, int columnIndex) {
        return this.addressOf(this.getOffsetOfColumn(recordOffset, columnIndex));
    }

    public long getOffsetOfColumn(long recordOffset, int columnIndex) {
        return RecordChain.rowToDataOffset(recordOffset) + this.varOffset + this.columnOffsets[columnIndex];
    }

    @Override
    public Record getRecord() {
        return this.recordA;
    }

    @Override
    public boolean hasNext() {
        if (this.nextRecordOffset != -1L) {
            long offset = this.nextRecordOffset;
            this.nextRecordOffset = this.mem.getLong(this.nextRecordOffset);
            this.recordA.of(RecordChain.rowToDataOffset(offset));
            return true;
        }
        return false;
    }

    @Override
    public Record getRecordB() {
        return this.recordB;
    }

    @Override
    public void reopen() {
    }

    @Override
    public void recordAt(Record record, long row) {
        ((RecordChainRecord)record).of(RecordChain.rowToDataOffset(row));
    }

    @Override
    public void toTop() {
        this.nextRecordOffset = this.mem.getAppendOffset() == 0L ? -1L : 0L;
    }

    @Override
    public long size() {
        return -1L;
    }

    public void of(long nextRecordOffset) {
        this.nextRecordOffset = nextRecordOffset;
    }

    public long put(Record record, long prevRecordOffset) {
        long offset = this.beginRecord(prevRecordOffset);
        this.recordSink.copy(record, this);
        return offset;
    }

    @Override
    public void putBin(BinarySequence value) {
        if (value == null) {
            this.putNull();
        } else {
            long offset = this.mem.getAppendOffset();
            this.mem.putLong(RecordChain.rowToDataOffset(this.recordOffset), this.varAppendOffset);
            this.recordOffset += 8L;
            this.mem.jumpTo(this.varAppendOffset);
            this.mem.putBin(value);
            this.varAppendOffset = this.mem.getAppendOffset();
            this.mem.jumpTo(offset);
        }
    }

    @Override
    public void putBool(boolean value) {
        this.mem.putBool(value);
    }

    @Override
    public void putByte(byte value) {
        this.mem.putByte(value);
    }

    @Override
    public void putDate(long date) {
        this.putLong(date);
    }

    @Override
    public void putDouble(double value) {
        this.mem.putDouble(value);
    }

    @Override
    public void putFloat(float value) {
        this.mem.putFloat(value);
    }

    @Override
    public void putInt(int value) {
        this.mem.putInt(value);
    }

    @Override
    public void putLong(long value) {
        this.mem.putLong(value);
    }

    @Override
    public void putLong256(Long256 value) {
        this.mem.putLong256(value);
    }

    @Override
    public void putLong128LittleEndian(long hi, long lo) {
        this.mem.putLong128LittleEndian(hi, lo);
    }

    @Override
    public void putShort(short value) {
        this.mem.putShort(value);
    }

    @Override
    public void putChar(char value) {
        this.mem.putChar(value);
    }

    @Override
    public void putStr(CharSequence value) {
        if (value != null) {
            this.mem.putLong(RecordChain.rowToDataOffset(this.recordOffset), this.varAppendOffset);
            this.recordOffset += 8L;
            this.mem.putStr(this.varAppendOffset, value);
            this.varAppendOffset += Vm.getStorageLength(value.length());
        } else {
            this.putNull();
        }
    }

    @Override
    public void putStr(CharSequence value, int lo, int hi) {
        int len = hi - lo;
        this.mem.putLong(RecordChain.rowToDataOffset(this.recordOffset), this.varAppendOffset);
        this.recordOffset += 8L;
        this.mem.putStr(this.varAppendOffset, value, lo, len);
        this.varAppendOffset += Vm.getStorageLength(len);
    }

    @Override
    public void putRecord(Record value) {
    }

    @Override
    public void putTimestamp(long value) {
        this.putLong(value);
    }

    @Override
    public void skip(int bytes) {
        this.mem.skip(bytes);
    }

    public void setSymbolTableResolver(SymbolTableSource resolver) {
        this.symbolTableResolver = resolver;
    }

    private static long rowToDataOffset(long row) {
        return row + 8L;
    }

    private void putNull() {
        this.mem.putLong(RecordChain.rowToDataOffset(this.recordOffset), -1L);
        this.recordOffset += 8L;
    }

    private class RecordChainRecord
    implements Record {
        long fixedOffset;
        long baseOffset;

        private RecordChainRecord() {
        }

        @Override
        public BinarySequence getBin(int col) {
            long offset = this.varWidthColumnOffset(col);
            return offset == -1L ? null : RecordChain.this.mem.getBin(offset);
        }

        @Override
        public long getBinLen(int col) {
            long offset = this.varWidthColumnOffset(col);
            return offset == -1L ? -1L : RecordChain.this.mem.getLong(offset);
        }

        @Override
        public boolean getBool(int col) {
            return RecordChain.this.mem.getBool(this.fixedWithColumnOffset(col));
        }

        @Override
        public byte getByte(int col) {
            return RecordChain.this.mem.getByte(this.fixedWithColumnOffset(col));
        }

        @Override
        public char getChar(int col) {
            return RecordChain.this.mem.getChar(this.fixedWithColumnOffset(col));
        }

        @Override
        public double getDouble(int col) {
            return RecordChain.this.mem.getDouble(this.fixedWithColumnOffset(col));
        }

        @Override
        public float getFloat(int col) {
            return RecordChain.this.mem.getFloat(this.fixedWithColumnOffset(col));
        }

        @Override
        public int getInt(int col) {
            return RecordChain.this.mem.getInt(this.fixedWithColumnOffset(col));
        }

        @Override
        public long getLong(int col) {
            return RecordChain.this.mem.getLong(this.fixedWithColumnOffset(col));
        }

        @Override
        public void getLong256(int col, CharSink sink) {
            RecordChain.this.mem.getLong256(this.fixedWithColumnOffset(col), sink);
        }

        @Override
        public Long256 getLong256A(int col) {
            return RecordChain.this.mem.getLong256A(this.fixedWithColumnOffset(col));
        }

        @Override
        public Long256 getLong256B(int col) {
            return RecordChain.this.mem.getLong256B(this.fixedWithColumnOffset(col));
        }

        @Override
        public long getLong128Hi(int col) {
            return RecordChain.this.mem.getLong(this.fixedWithColumnOffset(col) + 8L);
        }

        @Override
        public long getLong128Lo(int col) {
            return RecordChain.this.mem.getLong(this.fixedWithColumnOffset(col));
        }

        @Override
        public long getRowId() {
            return this.baseOffset - 8L;
        }

        @Override
        public short getShort(int col) {
            return RecordChain.this.mem.getShort(this.fixedWithColumnOffset(col));
        }

        @Override
        public CharSequence getStr(int col) {
            long offset = this.varWidthColumnOffset(col);
            assert (offset > -2L);
            return offset == -1L ? null : RecordChain.this.mem.getStr(offset);
        }

        @Override
        public CharSequence getStrB(int col) {
            long offset = this.varWidthColumnOffset(col);
            assert (offset > -2L);
            return offset == -1L ? null : RecordChain.this.mem.getStr2(offset);
        }

        @Override
        public int getStrLen(int col) {
            long offset = this.varWidthColumnOffset(col);
            if (offset > -1L) {
                return RecordChain.this.mem.getInt(offset);
            }
            return -1;
        }

        @Override
        public CharSequence getSym(int col) {
            return RecordChain.this.symbolTableResolver.getSymbolTable(col).valueOf(this.getInt(col));
        }

        @Override
        public CharSequence getSymB(int col) {
            return RecordChain.this.symbolTableResolver.getSymbolTable(col).valueBOf(this.getInt(col));
        }

        @Override
        public byte getGeoByte(int col) {
            return RecordChain.this.mem.getByte(this.fixedWithColumnOffset(col));
        }

        @Override
        public short getGeoShort(int col) {
            return RecordChain.this.mem.getShort(this.fixedWithColumnOffset(col));
        }

        @Override
        public int getGeoInt(int col) {
            return RecordChain.this.mem.getInt(this.fixedWithColumnOffset(col));
        }

        @Override
        public long getGeoLong(int col) {
            return RecordChain.this.mem.getLong(this.fixedWithColumnOffset(col));
        }

        private long fixedWithColumnOffset(int index) {
            return this.fixedOffset + RecordChain.this.columnOffsets[index];
        }

        private void of(long offset) {
            this.baseOffset = offset;
            this.fixedOffset = offset + RecordChain.this.varOffset;
        }

        private long varWidthColumnOffset(int index) {
            return RecordChain.this.mem.getLong(this.baseOffset + RecordChain.this.columnOffsets[index]);
        }
    }
}

