/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.AbstractFullDataFrameCursor;
import io.questdb.cairo.sql.DataFrame;
import org.jetbrains.annotations.Nullable;

public class FullFwdDataFrameCursor
extends AbstractFullDataFrameCursor {
    @Override
    @Nullable
    public DataFrame next() {
        while (this.partitionIndex < this.partitionHi) {
            long hi = this.getTableReader().openPartition(this.partitionIndex);
            if (hi < 1L) {
                ++this.partitionIndex;
                continue;
            }
            this.frame.partitionIndex = this.partitionIndex++;
            this.frame.rowLo = 0L;
            this.frame.rowHi = hi;
            return this.frame;
        }
        return null;
    }

    @Override
    public void toTop() {
        this.partitionIndex = 0;
    }

    @Override
    @Nullable
    public DataFrame skipTo(long rowCount) {
        int partitionIndex;
        int partitionCount = this.getTableReader().getPartitionCount();
        if (partitionCount < 1) {
            return null;
        }
        long position = rowCount;
        long partitionRows = 0L;
        for (partitionIndex = 0; partitionIndex < partitionCount; ++partitionIndex) {
            partitionRows = this.getTableReader().openPartition(partitionIndex);
            if (partitionRows < 0L) continue;
            if (partitionRows > position) break;
            if (partitionIndex == partitionCount - 1) {
                position = partitionRows;
                break;
            }
            position -= partitionRows;
        }
        this.frame.partitionIndex = partitionIndex;
        this.frame.rowHi = partitionRows;
        this.frame.rowLo = position;
        this.partitionIndex = partitionIndex + 1;
        return this.frame;
    }

    @Override
    public boolean supportsRandomAccess() {
        return true;
    }
}

