/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.CairoException;
import io.questdb.cairo.vm.Vm;
import io.questdb.cairo.vm.api.MemoryCMR;
import io.questdb.cairo.vm.api.MemoryR;
import io.questdb.cairo.vm.api.MemoryW;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.FilesFacade;
import io.questdb.std.LongList;
import io.questdb.std.Mutable;
import io.questdb.std.Numbers;
import io.questdb.std.Os;
import io.questdb.std.Unsafe;
import io.questdb.std.datetime.millitime.MillisecondClock;
import io.questdb.std.str.LPSZ;
import java.io.Closeable;

public class ColumnVersionReader
implements Closeable,
Mutable {
    public static final int OFFSET_VERSION_64 = 0;
    public static final int OFFSET_OFFSET_A_64 = 8;
    public static final int OFFSET_SIZE_A_64 = 16;
    public static final int OFFSET_OFFSET_B_64 = 24;
    public static final int OFFSET_SIZE_B_64 = 32;
    public static final int HEADER_SIZE = 40;
    public static final int BLOCK_SIZE = 4;
    public static final int BLOCK_SIZE_BYTES = 32;
    public static final int BLOCK_SIZE_MSB = Numbers.msb(4);
    public static final long COL_TOP_DEFAULT_PARTITION = Long.MIN_VALUE;
    public static final int COLUMN_INDEX_OFFSET = 1;
    public static final int COLUMN_NAME_TXN_OFFSET = 2;
    public static final int COLUMN_TOP_OFFSET = 3;
    private static final Log LOG = LogFactory.getLog(ColumnVersionReader.class);
    protected final LongList cachedList = new LongList();
    private MemoryCMR mem;
    private boolean ownMem;
    private long version;

    @Override
    public void clear() {
        if (this.ownMem) {
            this.mem.close();
        }
    }

    @Override
    public void close() {
        this.clear();
    }

    public void dumpTo(MemoryW mem) {
        mem.putLong(0L, this.version);
        boolean areaA = (this.version & 1L) == 0L;
        long offset = 40L;
        mem.putLong(areaA ? 8L : 24L, 40L);
        long size = (long)(this.cachedList.size() / 4) * 32L;
        mem.putLong(areaA ? 16L : 32L, size);
        int i = 0;
        long lim = 40L + size;
        for (long p = 40L; p < lim; p += 32L) {
            mem.putLong(p, this.cachedList.getQuick(i));
            mem.putLong(p + 8L, this.cachedList.getQuick(i + 1));
            mem.putLong(p + 16L, this.cachedList.getQuick(i + 2));
            mem.putLong(p + 24L, this.cachedList.getQuick(i + 3));
            i += 4;
        }
    }

    public LongList getCachedList() {
        return this.cachedList;
    }

    public long getColumnNameTxn(long partitionTimestamp, int columnIndex) {
        int versionRecordIndex = this.getRecordIndex(partitionTimestamp, columnIndex);
        return versionRecordIndex > -1 ? this.cachedList.getQuick(versionRecordIndex + 2) : this.getDefaultColumnNameTxn(columnIndex);
    }

    public long getColumnNameTxnByIndex(int versionRecordIndex) {
        return versionRecordIndex > -1 ? this.cachedList.getQuick(versionRecordIndex + 2) : -1L;
    }

    public long getColumnTop(long partitionTimestamp, int columnIndex) {
        int recordIndex = this.getRecordIndex(partitionTimestamp, columnIndex);
        if ((long)recordIndex > -1L) {
            return this.cachedList.getQuick(recordIndex + 3);
        }
        long columnTopDefaultPartition = this.getColumnTopPartitionTimestamp(columnIndex);
        if (columnTopDefaultPartition <= partitionTimestamp) {
            return 0L;
        }
        return -1L;
    }

    public long getColumnTopQuick(long partitionTimestamp, int columnIndex) {
        int index = this.getRecordIndex(partitionTimestamp, columnIndex);
        return this.getColumnTopByIndex(index);
    }

    public long getColumnTopByIndex(int versionRecordIndex) {
        return versionRecordIndex > -1 ? this.cachedList.getQuick(versionRecordIndex + 3) : 0L;
    }

    public long getColumnTopPartitionTimestamp(int columnIndex) {
        int index = this.getRecordIndex(Long.MIN_VALUE, columnIndex);
        return index > -1 ? this.getColumnTopByIndex(index) : Long.MIN_VALUE;
    }

    public long getDefaultColumnNameTxn(int columnIndex) {
        int index = this.getRecordIndex(Long.MIN_VALUE, columnIndex);
        return index > -1 ? this.getColumnNameTxnByIndex(index) : -1L;
    }

    public int getRecordIndex(long partitionTimestamp, int columnIndex) {
        int index = this.cachedList.binarySearchBlock(BLOCK_SIZE_MSB, partitionTimestamp, -1);
        if (index > -1) {
            int sz = this.cachedList.size();
            while (index < sz && this.cachedList.getQuick(index) == partitionTimestamp) {
                long thisIndex = this.cachedList.getQuick(index + 1);
                if (thisIndex == (long)columnIndex) {
                    return index;
                }
                if (thisIndex > (long)columnIndex) break;
                index += 4;
            }
        }
        return -1;
    }

    public long getVersion() {
        return this.version;
    }

    public ColumnVersionReader ofRO(FilesFacade ff, LPSZ fileName) {
        this.version = -1L;
        if (this.mem == null || !this.ownMem) {
            this.mem = Vm.getCMRInstance();
        }
        this.mem.of(ff, fileName, 0L, 40L, 7);
        this.ownMem = true;
        return this;
    }

    public void readSafe(MillisecondClock microsecondClock, long spinLockTimeout) {
        long tick = microsecondClock.getTicks();
        long version;
        while ((version = this.unsafeGetVersion()) != this.version) {
            long size;
            long offset;
            boolean areaA;
            Unsafe.getUnsafe().loadFence();
            boolean bl = areaA = (version & 1L) == 0L;
            if (areaA) {
                offset = this.mem.getLong(8L);
                size = this.mem.getLong(16L);
            } else {
                offset = this.mem.getLong(24L);
                size = this.mem.getLong(32L);
            }
            Unsafe.getUnsafe().loadFence();
            if (version == this.unsafeGetVersion()) {
                this.mem.resize(offset + size);
                ColumnVersionReader.readUnsafe(offset, size, this.cachedList, this.mem);
                Unsafe.getUnsafe().loadFence();
                if (version == this.unsafeGetVersion()) {
                    this.version = version;
                    LOG.debug().$("read clean version ").$(version).$(", offset ").$(offset).$(", size ").$(size).$();
                    return;
                }
            }
            if (microsecondClock.getTicks() - tick > spinLockTimeout) {
                LOG.error().$("Column Version read timeout [timeout=").$(spinLockTimeout).utf8("ms]").$();
                throw CairoException.critical(0).put("Column Version read timeout");
            }
            Os.pause();
            LOG.debug().$("read dirty version ").$(version).$(", retrying").$();
        }
        return;
    }

    private static void readUnsafe(long offset, long areaSize, LongList cachedList, MemoryR mem) {
        long lim = offset + areaSize;
        mem.extend(lim);
        int i = 0;
        assert (areaSize % 32L == 0L);
        cachedList.setPos((int)(areaSize / 32L * 4L));
        for (long p = offset; p < lim; p += 32L) {
            cachedList.setQuick(i, mem.getLong(p));
            cachedList.setQuick(i + 1, mem.getLong(p + 8L));
            cachedList.setQuick(i + 2, mem.getLong(p + 16L));
            cachedList.setQuick(i + 3, mem.getLong(p + 24L));
            i += 4;
        }
    }

    void ofRO(MemoryCMR mem) {
        if (this.mem != null && this.ownMem) {
            this.mem.close();
        }
        this.mem = mem;
        this.ownMem = false;
        this.version = -1L;
    }

    long readUnsafe() {
        long version = this.mem.getLong(0L);
        boolean areaA = (version & 1L) == 0L;
        long offset = areaA ? this.mem.getLong(8L) : this.mem.getLong(24L);
        long size = areaA ? this.mem.getLong(16L) : this.mem.getLong(32L);
        this.mem.resize(offset + size);
        ColumnVersionReader.readUnsafe(offset, size, this.cachedList, this.mem);
        return version;
    }

    private long unsafeGetVersion() {
        return this.mem.getLong(0L);
    }
}

