/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.std.IntObjHashMap;
import io.questdb.std.LowerCaseAsciiCharSequenceIntHashMap;
import io.questdb.std.Numbers;
import io.questdb.std.str.StringSink;

public final class ColumnType {
    public static final int VERSION = 426;
    public static final short UNDEFINED = 0;
    public static final short BOOLEAN = 1;
    public static final short BYTE = 2;
    public static final short SHORT = 3;
    public static final short CHAR = 4;
    public static final short INT = 5;
    public static final short LONG = 6;
    public static final short DATE = 7;
    public static final short TIMESTAMP = 8;
    public static final short FLOAT = 9;
    public static final short DOUBLE = 10;
    public static final short STRING = 11;
    public static final short SYMBOL = 12;
    public static final short LONG256 = 13;
    public static final short GEOBYTE = 14;
    public static final short GEOSHORT = 15;
    public static final short GEOINT = 16;
    public static final short GEOLONG = 17;
    public static final short BINARY = 18;
    public static final short PARAMETER = 19;
    public static final short CURSOR = 20;
    public static final short VAR_ARG = 21;
    public static final short RECORD = 22;
    public static final short GEOHASH = 23;
    public static final short LONG128 = 24;
    public static final short REGCLASS = 25;
    public static final short REGPROCEDURE = 26;
    public static final short ARRAY_STRING = 27;
    public static final short NULL = 28;
    public static final short MAX = 28;
    public static final short TYPES_SIZE = 29;
    private static final int[] TYPE_SIZE_POW2 = new int[29];
    private static final int[] TYPE_SIZE = new int[29];
    public static final int GEO_HASH_MAX_BITS_LENGTH;
    public static final int NO_OVERLOAD = 10000;
    static final int[] GEO_TYPE_SIZE_POW2;
    private static final IntObjHashMap<String> typeNameMap;
    private static final LowerCaseAsciiCharSequenceIntHashMap nameTypeMap;
    private static final short[][] overloadPriority;
    private static final int OVERLOAD_MATRIX_SIZE = 32;
    private static final int[] overloadPriorityMatrix;
    private static final int TYPE_FLAG_GEO_HASH = 65536;
    private static final int TYPE_FLAG_DESIGNATED_TIMESTAMP = 131072;
    private static final int BITS_OFFSET = 8;
    public static final int GEOBYTE_MIN_BITS = 1;
    public static final int GEOBYTE_MAX_BITS = 7;
    public static final int GEOSHORT_MIN_BITS = 8;
    public static final int GEOSHORT_MAX_BITS = 15;
    public static final int GEOINT_MIN_BITS = 16;
    public static final int GEOINT_MAX_BITS = 31;
    public static final int GEOLONG_MIN_BITS = 32;
    public static final int GEOLONG_MAX_BITS;

    private ColumnType() {
    }

    public static int getGeoHashBits(int type) {
        return (byte)(type >> 8 & 0xFF);
    }

    public static int getGeoHashTypeWithBits(int bits) {
        assert (bits > 0 && bits <= GEO_HASH_MAX_BITS_LENGTH);
        return ColumnType.mkGeoHashType(bits, (short)(14 + ColumnType.pow2SizeOfBits(bits)));
    }

    public static boolean isAssignableFrom(int fromType, int toType) {
        return ColumnType.isToSameOrWider(fromType, toType) || ColumnType.isNarrowingCast(fromType, toType);
    }

    public static boolean isToSameOrWider(int fromType, int toType) {
        return (toType == fromType || ColumnType.tagOf(fromType) == ColumnType.tagOf(toType)) && (ColumnType.getGeoHashBits(fromType) >= ColumnType.getGeoHashBits(toType) || ColumnType.getGeoHashBits(fromType) == 0) || ColumnType.isBuiltInWideningCast(fromType, toType) || ColumnType.isStringCast(fromType, toType) || ColumnType.isGeoHashWideningCast(fromType, toType) || ColumnType.isImplicitParsingCast(fromType, toType);
    }

    public static boolean isBinary(int columnType) {
        return columnType == 18;
    }

    public static boolean isBoolean(int columnType) {
        return columnType == 1;
    }

    public static boolean isBuiltInWideningCast(int fromType, int toType) {
        return fromType >= 2 && toType >= 2 && toType <= 10 && fromType < toType || fromType == 28 || fromType == 4 && toType == 3 || fromType == 8 && toType == 6;
    }

    public static boolean isChar(int columnType) {
        return columnType == 4;
    }

    public static boolean isCursor(int columnType) {
        return columnType == 20;
    }

    public static boolean isDesignatedTimestamp(int type) {
        return (type & 0x20000) != 0;
    }

    public static boolean isDouble(int columnType) {
        return columnType == 10;
    }

    public static boolean isGeoHash(int columnType) {
        return (columnType & 0x10000) != 0;
    }

    public static boolean isInt(int columnType) {
        return columnType == 5;
    }

    public static boolean isNull(int columnType) {
        return columnType == 28;
    }

    public static boolean isString(int columnType) {
        return columnType == 11;
    }

    public static boolean isSymbol(int columnType) {
        return columnType == 12;
    }

    public static boolean isSymbolOrString(int columnType) {
        return columnType == 12 || columnType == 11;
    }

    public static boolean isTimestamp(int columnType) {
        return columnType == 8;
    }

    public static boolean isUndefined(int columnType) {
        return columnType == 0;
    }

    public static boolean isVariableLength(int columnType) {
        return columnType == 11 || columnType == 18;
    }

    public static String nameOf(int columnType) {
        int index = typeNameMap.keyIndex(columnType);
        if (index > -1) {
            return "unknown";
        }
        return typeNameMap.valueAtQuick(index);
    }

    public static int overloadDistance(short from, short to) {
        short fromTag = ColumnType.tagOf(from);
        short toTag = ColumnType.tagOf(to);
        assert (toTag > 0) : "Undefined not supported in overloads";
        return overloadPriorityMatrix[32 * fromTag + toTag];
    }

    public static int pow2SizeOf(int columnType) {
        return TYPE_SIZE_POW2[ColumnType.tagOf(columnType)];
    }

    public static int pow2SizeOfBits(int bits) {
        assert (bits <= GEO_HASH_MAX_BITS_LENGTH);
        return GEO_TYPE_SIZE_POW2[bits];
    }

    public static int setDesignatedTimestampBit(int tsType, boolean designated) {
        if (designated) {
            return tsType | 0x20000;
        }
        return tsType & 0xFFFDFFFF;
    }

    public static int sizeOf(int columnType) {
        short tag = ColumnType.tagOf(columnType);
        if (tag < 29) {
            return TYPE_SIZE[tag];
        }
        return -1;
    }

    public static short tagOf(int type) {
        return (short)(type & 0xFF);
    }

    public static short tagOf(CharSequence name) {
        return (short)nameTypeMap.get(name);
    }

    public static int typeOf(CharSequence name) {
        return nameTypeMap.get(name);
    }

    private static int mkGeoHashType(int bits, short baseType) {
        return baseType & 0xFFFF00FF | bits << 8 | 0x10000;
    }

    private static short indexOf(short[] list, short value) {
        for (short i = 0; i < list.length; i = (short)(i + 1)) {
            if (list[i] != value) continue;
            return i;
        }
        return -1;
    }

    private static boolean isStringCast(int fromType, int toType) {
        return fromType == 11 && toType == 12 || fromType == 12 && toType == 11 || fromType == 4 && toType == 12 || fromType == 4 && toType == 11;
    }

    private static boolean isGeoHashWideningCast(int fromType, int toType) {
        short toTag = ColumnType.tagOf(toType);
        short fromTag = ColumnType.tagOf(fromType);
        return fromTag == 17 && toTag == 16 || fromTag == 17 && toTag == 15 || fromTag == 17 && toTag == 14 || fromTag == 16 && toTag == 15 || fromTag == 16 && toTag == 14 || fromTag == 15 && toTag == 14;
    }

    private static boolean isImplicitParsingCast(int fromType, int toType) {
        short toTag = ColumnType.tagOf(toType);
        return fromType == 4 && toTag == 14 && ColumnType.getGeoHashBits(toType) < 6 || fromType == 11 && toTag == 14 || fromType == 11 && toTag == 15 || fromType == 11 && toTag == 16 || fromType == 11 && toTag == 17 || fromType == 11 && toTag == 8 || fromType == 12 && toTag == 8;
    }

    private static boolean isNarrowingCast(int fromType, int toType) {
        return fromType == 10 && (toType == 9 || toType >= 2 && toType <= 6) || fromType == 9 && toType >= 2 && toType <= 6 || fromType == 6 && toType >= 2 && toType <= 5 || fromType == 5 && toType >= 2 && toType <= 3 || fromType == 3 && toType == 2 || fromType == 4 && toType == 2 || fromType == 11 && toType == 2 || fromType == 11 && toType == 3 || fromType == 11 && toType == 5 || fromType == 11 && toType == 6 || fromType == 11 && toType == 7 || fromType == 11 && toType == 8 || fromType == 11 && toType == 9 || fromType == 11 && toType == 10 || fromType == 11 && toType == 4;
    }

    static {
        typeNameMap = new IntObjHashMap();
        nameTypeMap = new LowerCaseAsciiCharSequenceIntHashMap();
        overloadPriority = new short[][]{{10, 9, 11, 6, 8, 7, 5, 4, 3, 2, 1}, {1}, {2, 3, 5, 6, 9, 10}, {3, 5, 6, 9, 10}, {4, 11}, {5, 6, 9, 10, 8, 7}, {6, 10, 8, 7}, {7, 8, 6}, {8, 6}, {9, 10}, {10}, {11, 4, 10, 6, 5, 9, 3, 2}, {12, 11}, {13}, {14, 15, 16, 17, 23}, {15, 16, 17, 23}, {16, 17, 23}, {17, 23}, {18}};
        overloadPriorityMatrix = new int[1024];
        for (int i = 0; i < 28; i = (int)((short)(i + 1))) {
            for (short j = 1; j <= 28; j = (short)(j + 1)) {
                int index;
                ColumnType.overloadPriorityMatrix[32 * i + j] = i < overloadPriority.length ? ((index = ColumnType.indexOf(overloadPriority[i], j)) != -1 ? index : 10000) : 10000;
            }
        }
        GEO_HASH_MAX_BITS_LENGTH = 60;
        GEO_TYPE_SIZE_POW2 = new int[GEO_HASH_MAX_BITS_LENGTH + 1];
        for (int bits = 1; bits <= GEO_HASH_MAX_BITS_LENGTH; ++bits) {
            ColumnType.GEO_TYPE_SIZE_POW2[bits] = Numbers.msb(Numbers.ceilPow2(bits + 8 & 0xFFFFFFF8) >> 3);
        }
        typeNameMap.put(1, "BOOLEAN");
        typeNameMap.put(2, "BYTE");
        typeNameMap.put(10, "DOUBLE");
        typeNameMap.put(9, "FLOAT");
        typeNameMap.put(5, "INT");
        typeNameMap.put(6, "LONG");
        typeNameMap.put(3, "SHORT");
        typeNameMap.put(4, "CHAR");
        typeNameMap.put(11, "STRING");
        typeNameMap.put(12, "SYMBOL");
        typeNameMap.put(18, "BINARY");
        typeNameMap.put(7, "DATE");
        typeNameMap.put(19, "PARAMETER");
        typeNameMap.put(8, "TIMESTAMP");
        typeNameMap.put(13, "LONG256");
        typeNameMap.put(24, "LONG128");
        typeNameMap.put(20, "CURSOR");
        typeNameMap.put(22, "RECORD");
        typeNameMap.put(21, "VARARG");
        typeNameMap.put(23, "GEOHASH");
        typeNameMap.put(25, "regclass");
        typeNameMap.put(26, "regprocedure");
        typeNameMap.put(27, "text[]");
        nameTypeMap.put("boolean", 1);
        nameTypeMap.put("byte", 2);
        nameTypeMap.put("double", 10);
        nameTypeMap.put("float", 9);
        nameTypeMap.put("int", 5);
        nameTypeMap.put("long", 6);
        nameTypeMap.put("short", 3);
        nameTypeMap.put("char", 4);
        nameTypeMap.put("string", 11);
        nameTypeMap.put("symbol", 12);
        nameTypeMap.put("binary", 18);
        nameTypeMap.put("date", 7);
        nameTypeMap.put("parameter", 19);
        nameTypeMap.put("timestamp", 8);
        nameTypeMap.put("cursor", 20);
        nameTypeMap.put("long256", 13);
        nameTypeMap.put("long128", 24);
        nameTypeMap.put("geohash", 23);
        nameTypeMap.put("text", 11);
        nameTypeMap.put("smallint", 3);
        nameTypeMap.put("bigint", 6);
        nameTypeMap.put("real", 9);
        nameTypeMap.put("bytea", 11);
        nameTypeMap.put("varchar", 11);
        nameTypeMap.put("regclass", 25);
        nameTypeMap.put("regprocedure", 26);
        nameTypeMap.put("text[]", 27);
        StringSink sink = new StringSink();
        for (int b = 1; b <= GEO_HASH_MAX_BITS_LENGTH; ++b) {
            sink.clear();
            if (b % 5 != 0) {
                sink.put("GEOHASH(").put(b).put("b)");
            } else {
                sink.put("GEOHASH(").put(b / 5).put("c)");
            }
            String name = sink.toString();
            int type = ColumnType.getGeoHashTypeWithBits(b);
            typeNameMap.put(type, name);
            nameTypeMap.put(name, type);
        }
        ColumnType.TYPE_SIZE_POW2[0] = -1;
        ColumnType.TYPE_SIZE_POW2[1] = 0;
        ColumnType.TYPE_SIZE_POW2[2] = 0;
        ColumnType.TYPE_SIZE_POW2[3] = 1;
        ColumnType.TYPE_SIZE_POW2[4] = 1;
        ColumnType.TYPE_SIZE_POW2[9] = 2;
        ColumnType.TYPE_SIZE_POW2[5] = 2;
        ColumnType.TYPE_SIZE_POW2[12] = 2;
        ColumnType.TYPE_SIZE_POW2[10] = 3;
        ColumnType.TYPE_SIZE_POW2[11] = -1;
        ColumnType.TYPE_SIZE_POW2[6] = 3;
        ColumnType.TYPE_SIZE_POW2[7] = 3;
        ColumnType.TYPE_SIZE_POW2[8] = 3;
        ColumnType.TYPE_SIZE_POW2[13] = 5;
        ColumnType.TYPE_SIZE_POW2[14] = 0;
        ColumnType.TYPE_SIZE_POW2[15] = 1;
        ColumnType.TYPE_SIZE_POW2[16] = 2;
        ColumnType.TYPE_SIZE_POW2[17] = 3;
        ColumnType.TYPE_SIZE_POW2[18] = 2;
        ColumnType.TYPE_SIZE_POW2[19] = -1;
        ColumnType.TYPE_SIZE_POW2[20] = -1;
        ColumnType.TYPE_SIZE_POW2[21] = -1;
        ColumnType.TYPE_SIZE_POW2[22] = -1;
        ColumnType.TYPE_SIZE_POW2[28] = -1;
        ColumnType.TYPE_SIZE_POW2[24] = 4;
        ColumnType.TYPE_SIZE[0] = -1;
        ColumnType.TYPE_SIZE[1] = 1;
        ColumnType.TYPE_SIZE[2] = 1;
        ColumnType.TYPE_SIZE[3] = 2;
        ColumnType.TYPE_SIZE[4] = 2;
        ColumnType.TYPE_SIZE[9] = 4;
        ColumnType.TYPE_SIZE[5] = 4;
        ColumnType.TYPE_SIZE[12] = 4;
        ColumnType.TYPE_SIZE[11] = 0;
        ColumnType.TYPE_SIZE[10] = 8;
        ColumnType.TYPE_SIZE[6] = 8;
        ColumnType.TYPE_SIZE[7] = 8;
        ColumnType.TYPE_SIZE[8] = 8;
        ColumnType.TYPE_SIZE[13] = 32;
        ColumnType.TYPE_SIZE[14] = 1;
        ColumnType.TYPE_SIZE[15] = 2;
        ColumnType.TYPE_SIZE[16] = 4;
        ColumnType.TYPE_SIZE[17] = 8;
        ColumnType.TYPE_SIZE[18] = 0;
        ColumnType.TYPE_SIZE[19] = -1;
        ColumnType.TYPE_SIZE[20] = -1;
        ColumnType.TYPE_SIZE[21] = -1;
        ColumnType.TYPE_SIZE[22] = -1;
        ColumnType.TYPE_SIZE[28] = 0;
        ColumnType.TYPE_SIZE[24] = 16;
        GEOLONG_MAX_BITS = GEO_HASH_MAX_BITS_LENGTH;
    }
}

