/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.BuildInformation;
import io.questdb.TelemetryConfiguration;
import io.questdb.cairo.sql.SqlExecutionCircuitBreakerConfiguration;
import io.questdb.cutlass.text.TextConfiguration;
import io.questdb.std.FilesFacade;
import io.questdb.std.IOURingFacade;
import io.questdb.std.IOURingFacadeImpl;
import io.questdb.std.NanosecondClock;
import io.questdb.std.NanosecondClockImpl;
import io.questdb.std.Rnd;
import io.questdb.std.RostiAllocFacade;
import io.questdb.std.RostiAllocFacadeImpl;
import io.questdb.std.datetime.DateFormat;
import io.questdb.std.datetime.DateLocale;
import io.questdb.std.datetime.microtime.MicrosecondClock;
import io.questdb.std.datetime.millitime.MillisecondClock;

public interface CairoConfiguration {
    public static final long O_NONE = 0L;
    public static final long O_ASYNC = 64L;
    public static final long O_SYNC = 128L;
    public static final long O_DIRECT = 16384L;
    public static final ThreadLocal<Rnd> RANDOM = new ThreadLocal();

    public boolean attachPartitionCopy();

    public boolean enableTestFactories();

    public int getAnalyticColumnPoolCapacity();

    default public String getArchivedCrashFilePrefix() {
        return "crash+";
    }

    public String getAttachPartitionSuffix();

    public DateFormat getBackupDirTimestampFormat();

    public int getBackupMkDirMode();

    public CharSequence getBackupRoot();

    public CharSequence getBackupTempDirName();

    public int getBinaryEncodingMaxLength();

    public int getBindVariablePoolSize();

    public BuildInformation getBuildInformation();

    public SqlExecutionCircuitBreakerConfiguration getCircuitBreakerConfiguration();

    public int getColumnCastModelPoolCapacity();

    public int getColumnIndexerQueueCapacity();

    public int getColumnPurgeQueueCapacity();

    public long getColumnPurgeRetryDelay();

    public long getColumnPurgeRetryDelayLimit();

    public double getColumnPurgeRetryDelayMultiplier();

    public int getColumnPurgeTaskPoolCapacity();

    public long getCommitLag();

    public int getCommitMode();

    public CharSequence getConfRoot();

    public int getCopyPoolCapacity();

    public int getCreateAsSelectRetryCount();

    public int getCreateTableModelPoolCapacity();

    public long getDataAppendPageSize();

    public long getDataIndexKeyAppendPageSize();

    public long getDataIndexValueAppendPageSize();

    public long getDatabaseIdHi();

    public long getDatabaseIdLo();

    public CharSequence getDbDirectory();

    public DateLocale getDefaultDateLocale();

    public CharSequence getDefaultMapType();

    public boolean getDefaultSymbolCacheFlag();

    public int getDefaultSymbolCapacity();

    public int getDoubleToStrCastScale();

    public int getFileOperationRetryCount();

    public FilesFacade getFilesFacade();

    public int getFloatToStrCastScale();

    public int getGroupByMapCapacity();

    public int getGroupByPoolCapacity();

    default public IOURingFacade getIOURingFacade() {
        return IOURingFacadeImpl.INSTANCE;
    }

    public long getIdleCheckInterval();

    public long getInactiveReaderTTL();

    public long getInactiveWriterTTL();

    public int getIndexValueBlockSize();

    public int getInsertPoolCapacity();

    public int getLatestByQueueCapacity();

    public int getMaxCrashFiles();

    public int getMaxFileNameLength();

    public int getMaxSwapFileCount();

    public int getMaxSymbolNotEqualsCount();

    public int getMaxUncommittedRows();

    public MicrosecondClock getMicrosecondClock();

    public MillisecondClock getMillisecondClock();

    public long getMiscAppendPageSize();

    public int getMkDirMode();

    default public NanosecondClock getNanosecondClock() {
        return NanosecondClockImpl.INSTANCE;
    }

    public int getO3CallbackQueueCapacity();

    public int getO3ColumnMemorySize();

    public int getO3CopyQueueCapacity();

    public int getO3OpenColumnQueueCapacity();

    public int getO3PartitionQueueCapacity();

    public int getO3PartitionUpdateQueueCapacity();

    public int getO3PurgeDiscoveryQueueCapacity();

    default public String getOGCrashFilePrefix() {
        return "hs_err_pid+";
    }

    public int getPageFrameReduceColumnListCapacity();

    public int getPageFrameReduceQueueCapacity();

    public int getPageFrameReduceRowIdListCapacity();

    public int getPageFrameReduceShardCount();

    public int getPageFrameReduceTaskPoolCapacity();

    public int getParallelIndexThreshold();

    public int getPartitionPurgeListCapacity();

    public int getQueryCacheEventQueueCapacity();

    default public Rnd getRandom() {
        Rnd rnd = RANDOM.get();
        if (rnd == null) {
            rnd = new Rnd(this.getNanosecondClock().getTicks(), this.getMicrosecondClock().getTicks());
            RANDOM.set(rnd);
        }
        return rnd;
    }

    public int getReaderPoolMaxSegments();

    public int getRenameTableModelPoolCapacity();

    public int getReplaceFunctionMaxBufferLength();

    public int getRndFunctionMemoryMaxPages();

    public int getRndFunctionMemoryPageSize();

    public CharSequence getRoot();

    default public RostiAllocFacade getRostiAllocFacade() {
        return RostiAllocFacadeImpl.INSTANCE;
    }

    public int getSampleByIndexSearchPageSize();

    public boolean getSimulateCrashEnabled();

    public CharSequence getSnapshotInstanceId();

    public CharSequence getSnapshotRoot();

    public long getSpinLockTimeout();

    public int getSqlAnalyticRowIdMaxPages();

    public int getSqlAnalyticRowIdPageSize();

    public int getSqlAnalyticStoreMaxPages();

    public int getSqlAnalyticStorePageSize();

    public int getSqlAnalyticTreeKeyMaxPages();

    public int getSqlAnalyticTreeKeyPageSize();

    public int getSqlCharacterStoreCapacity();

    public int getSqlCharacterStoreSequencePoolCapacity();

    public int getSqlColumnPoolCapacity();

    public double getSqlCompactMapLoadFactor();

    public int getSqlCopyBufferSize();

    public CharSequence getSqlCopyInputRoot();

    public CharSequence getSqlCopyInputWorkRoot();

    public int getSqlCopyLogRetentionDays();

    public long getSqlCopyMaxIndexChunkSize();

    public int getSqlCopyQueueCapacity();

    public int getSqlDistinctTimestampKeyCapacity();

    public double getSqlDistinctTimestampLoadFactor();

    public int getSqlExpressionPoolCapacity();

    public double getSqlFastMapLoadFactor();

    public int getSqlHashJoinLightValueMaxPages();

    public int getSqlHashJoinLightValuePageSize();

    public int getSqlHashJoinValueMaxPages();

    public int getSqlHashJoinValuePageSize();

    public int getSqlJitBindVarsMemoryMaxPages();

    public int getSqlJitBindVarsMemoryPageSize();

    public int getSqlJitIRMemoryMaxPages();

    public int getSqlJitIRMemoryPageSize();

    public int getSqlJitMode();

    public int getSqlJitPageAddressCacheThreshold();

    public int getSqlJitRowsThreshold();

    public int getSqlJoinContextPoolCapacity();

    public int getSqlJoinMetadataMaxResizes();

    public int getSqlJoinMetadataPageSize();

    public long getSqlLatestByRowCount();

    public int getSqlLexerPoolCapacity();

    public int getSqlMapKeyCapacity();

    public int getSqlMapMaxPages();

    public int getSqlMapMaxResizes();

    public int getSqlMapPageSize();

    public int getSqlMaxNegativeLimit();

    public int getSqlModelPoolCapacity();

    public int getSqlPageFrameMaxRows();

    public int getSqlPageFrameMinRows();

    public int getSqlSmallMapKeyCapacity();

    public int getSqlSortKeyMaxPages();

    public long getSqlSortKeyPageSize();

    public int getSqlSortLightValueMaxPages();

    public long getSqlSortLightValuePageSize();

    public int getSqlSortValueMaxPages();

    public int getSqlSortValuePageSize();

    public CharSequence getSystemTableNamePrefix();

    public TelemetryConfiguration getTelemetryConfiguration();

    public TextConfiguration getTextConfiguration();

    public int getTxnScoreboardEntryCount();

    public int getVectorAggregateQueueCapacity();

    public boolean getWallEnabledDefault();

    public int getWithClauseModelPoolCapacity();

    public long getWorkStealTimeoutNanos();

    public long getWriterAsyncCommandBusyWaitTimeout();

    public long getWriterAsyncCommandMaxTimeout();

    public int getWriterCommandQueueCapacity();

    public long getWriterCommandQueueSlotSize();

    public long getWriterFileOpenOpts();

    public int getWriterTickRowsCountMod();

    public boolean isIOURingEnabled();

    public boolean isO3QuickSortEnabled();

    public boolean isParallelIndexingEnabled();

    public boolean isSnapshotRecoveryEnabled();

    public boolean isSqlJitDebugEnabled();

    public boolean isSqlParallelFilterEnabled();

    public boolean isSqlParallelFilterPreTouchEnabled();
}

