/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.CairoException;
import io.questdb.cairo.vm.api.MemoryR;
import io.questdb.std.str.Path;

public final class BitmapIndexUtils {
    static final long KEY_ENTRY_SIZE = 32L;
    static final int KEY_ENTRY_OFFSET_VALUE_COUNT = 0;
    static final int KEY_ENTRY_OFFSET_LAST_VALUE_BLOCK_OFFSET = 16;
    static final int KEY_ENTRY_OFFSET_FIRST_VALUE_BLOCK_OFFSET = 8;
    static final int KEY_ENTRY_OFFSET_COUNT_CHECK = 24;
    static final int KEY_FILE_RESERVED = 64;
    static final int KEY_RESERVED_OFFSET_SIGNATURE = 0;
    static final int KEY_RESERVED_OFFSET_SEQUENCE = 1;
    static final int KEY_RESERVED_OFFSET_VALUE_MEM_SIZE = 9;
    static final int KEY_RESERVED_OFFSET_BLOCK_VALUE_COUNT = 17;
    static final int KEY_RESERVED_OFFSET_KEY_COUNT = 21;
    static final int KEY_RESERVED_OFFSET_SEQUENCE_CHECK = 29;
    static final byte SIGNATURE = -6;
    static final int VALUE_BLOCK_FILE_RESERVED = 16;

    public static Path keyFileName(Path path, CharSequence name, long columnNameTxn) {
        path.concat(name).put(".k");
        if (columnNameTxn > -1L) {
            path.put('.').put(columnNameTxn);
        }
        return path.$();
    }

    public static Path valueFileName(Path path, CharSequence name, long columnNameTxn) {
        path.concat(name).put(".v");
        if (columnNameTxn > -1L) {
            path.put('.').put(columnNameTxn);
        }
        return path.$();
    }

    static void seekValueBlockRTL(long valueCount, long blockOffset, MemoryR valueMem, long maxValue, long blockValueCountMod, ValueBlockSeeker seeker) {
        long valueBlockOffset = blockOffset;
        if (valueCount > 0L) {
            long hi;
            long cellCount;
            long prevBlockOffset = (blockValueCountMod + 1L) * 8L;
            while (true) {
                long lo = valueMem.getLong(valueBlockOffset);
                cellCount = (valueCount - 1L & blockValueCountMod) + 1L;
                if (lo <= maxValue || (valueCount -= cellCount) <= 0L) break;
                valueBlockOffset = valueMem.getLong(valueBlockOffset + prevBlockOffset);
            }
            if (valueCount > 0L && maxValue < (hi = valueMem.getLong(valueBlockOffset + (cellCount - 1L) * 8L))) {
                valueCount -= cellCount - BitmapIndexUtils.searchValueBlock(valueMem, valueBlockOffset, cellCount, maxValue);
            }
        }
        seeker.seek(valueCount, valueBlockOffset);
    }

    static void seekValueBlockLTR(long totalCount, long firstValueBlockOffset, MemoryR valueMem, long minValue, long blockValueCountMod, ValueBlockSeeker seeker) {
        long valueCount = totalCount;
        long valueBlockOffset = firstValueBlockOffset;
        if (firstValueBlockOffset >= valueMem.size()) {
            seeker.seek(totalCount, firstValueBlockOffset);
            return;
        }
        if (valueCount > 0L) {
            long lo;
            long cellCount;
            long hi;
            while ((hi = valueMem.getLong(valueBlockOffset + ((cellCount = valueCount > blockValueCountMod ? blockValueCountMod + 1L : valueCount) - 1L) * 8L)) < minValue && (valueCount -= cellCount) > 0L) {
                long nextBlockOffset = (blockValueCountMod + 1L) * 8L + 8L;
                if ((valueBlockOffset = valueMem.getLong(valueBlockOffset + nextBlockOffset)) < valueMem.size()) continue;
                seeker.seek(totalCount, valueBlockOffset);
                return;
            }
            if (valueCount > 0L && minValue > (lo = valueMem.getLong(valueBlockOffset))) {
                valueCount -= BitmapIndexUtils.searchValueBlock(valueMem, valueBlockOffset, cellCount, minValue - 1L);
            }
        }
        seeker.seek(totalCount - valueCount, valueBlockOffset);
    }

    static long getKeyEntryOffset(int key) {
        return (long)key * 32L + 64L;
    }

    static long searchValueBlock(MemoryR memory, long offset, long cellCount, long value) {
        if (cellCount < 64L) {
            long limit = memory.size();
            for (long i = offset; i < limit; i += 8L) {
                if (memory.getLong(i) <= value) continue;
                return (i - offset) / 8L;
            }
        } else {
            long half;
            long low = 0L;
            long high = cellCount - 1L;
            while ((half = (high - low) / 2L) != 0L) {
                long pivot = memory.getLong(offset + (low + half) * 8L);
                if (pivot <= value) {
                    low += half;
                    continue;
                }
                high = low + half;
            }
            return low + 1L;
        }
        throw CairoException.critical(0).put("index is corrupt, rowid not found [offset=").put(offset).put(", cellCount=").put(cellCount).put(", value=").put(value).put(']');
    }

    @FunctionalInterface
    static interface ValueBlockSeeker {
        public void seek(long var1, long var3);
    }
}

