/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.NullIndexFrameCursor;
import io.questdb.cairo.BitmapIndexReader;
import io.questdb.cairo.IndexFrameCursor;
import io.questdb.cairo.sql.RowCursor;

public class BitmapIndexFwdNullReader
implements BitmapIndexReader {
    private final NullCursor cursor = new NullCursor();

    @Override
    public RowCursor getCursor(boolean cachedInstance, int key, long minValue, long maxValue) {
        NullCursor cursor = this.getCursor(cachedInstance);
        cursor.max = key == 0 ? maxValue + 1L : 0L;
        cursor.value = 0L;
        return cursor;
    }

    @Override
    public int getKeyCount() {
        return 1;
    }

    @Override
    public boolean isOpen() {
        return true;
    }

    @Override
    public long getKeyBaseAddress() {
        return 0L;
    }

    @Override
    public long getKeyMemorySize() {
        return 0L;
    }

    @Override
    public long getValueBaseAddress() {
        return 0L;
    }

    @Override
    public long getValueMemorySize() {
        return 0L;
    }

    @Override
    public long getUnIndexedNullCount() {
        return 0L;
    }

    @Override
    public int getValueBlockCapacity() {
        return 0;
    }

    private NullCursor getCursor(boolean cachedInstance) {
        return cachedInstance ? this.cursor : new NullCursor();
    }

    @Override
    public IndexFrameCursor getFrameCursor(int key, long minValue, long maxValue) {
        return NullIndexFrameCursor.INSTANCE;
    }

    private static class NullCursor
    implements RowCursor {
        private long max;
        private long value;

        private NullCursor() {
        }

        @Override
        public boolean hasNext() {
            return this.value < this.max;
        }

        @Override
        public long next() {
            return this.value++;
        }
    }
}

