/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.BitmapIndexReader;
import io.questdb.cairo.PartitionBy;
import io.questdb.cairo.SymbolMapReader;
import io.questdb.cairo.TableReader;
import io.questdb.cairo.sql.DataFrame;
import io.questdb.cairo.sql.DataFrameCursor;
import io.questdb.cairo.sql.StaticSymbolTable;
import io.questdb.cairo.vm.api.MemoryR;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.model.RuntimeIntrinsicIntervalModel;
import io.questdb.std.LongList;
import io.questdb.std.Misc;

public abstract class AbstractIntervalDataFrameCursor
implements DataFrameCursor {
    static final int SCAN_UP = -1;
    static final int SCAN_DOWN = 1;
    protected final RuntimeIntrinsicIntervalModel intervalsModel;
    protected final IntervalDataFrame dataFrame = new IntervalDataFrame();
    protected final int timestampIndex;
    protected LongList intervals;
    protected TableReader reader;
    protected int intervalsLo;
    protected int intervalsHi;
    protected int partitionLo;
    protected int partitionHi;
    protected long partitionLimit;
    protected long sizeSoFar = 0L;
    protected long size = -1L;
    private int initialIntervalsLo;
    private int initialIntervalsHi;
    private int initialPartitionLo;
    private int initialPartitionHi;

    public AbstractIntervalDataFrameCursor(RuntimeIntrinsicIntervalModel intervals, int timestampIndex) {
        assert (timestampIndex > -1);
        this.intervalsModel = intervals;
        this.timestampIndex = timestampIndex;
    }

    @Override
    public TableReader getTableReader() {
        return this.reader;
    }

    @Override
    public boolean reload() {
        if (this.reader != null && this.reader.reload()) {
            this.calculateRanges(this.intervals);
            return true;
        }
        return false;
    }

    @Override
    public void close() {
        this.reader = Misc.free(this.reader);
    }

    @Override
    public void toTop() {
        this.intervalsLo = this.initialIntervalsLo;
        this.intervalsHi = this.initialIntervalsHi;
        this.partitionLo = this.initialPartitionLo;
        this.partitionHi = this.initialPartitionHi;
        this.sizeSoFar = 0L;
    }

    @Override
    public long size() {
        return this.size > -1L ? this.size : this.computeSize();
    }

    @Override
    public SymbolMapReader getSymbolTable(int columnIndex) {
        return this.reader.getSymbolMapReader(columnIndex);
    }

    @Override
    public StaticSymbolTable newSymbolTable(int columnIndex) {
        return this.reader.newSymbolTable(columnIndex);
    }

    public int getTimestampIndex() {
        return this.timestampIndex;
    }

    public AbstractIntervalDataFrameCursor of(TableReader reader, SqlExecutionContext sqlContext) throws SqlException {
        this.reader = reader;
        this.intervals = this.intervalsModel.calculateIntervals(sqlContext);
        this.calculateRanges(this.intervals);
        return this;
    }

    protected static long search(MemoryR column, long value, long low, long high, int increment) {
        while (low < high) {
            long mid = low + high - 1L >>> 1;
            long midVal = column.getLong(mid * 8L);
            if (midVal < value) {
                low = mid + 1L;
                continue;
            }
            if (midVal > value) {
                high = mid;
                continue;
            }
            mid += (long)increment;
            while (mid > 0L && mid < high && midVal == column.getLong(mid * 8L)) {
                mid += (long)increment;
            }
            return mid - (long)increment;
        }
        return -(low + 1L);
    }

    private void calculateRanges(LongList intervals) {
        this.size = -1L;
        if (intervals.size() > 0) {
            if (PartitionBy.isPartitioned(this.reader.getPartitionedBy())) {
                this.cullIntervals(intervals);
                if (this.initialIntervalsLo < this.initialIntervalsHi) {
                    this.cullPartitions(intervals);
                }
            } else {
                this.initialIntervalsLo = 0;
                this.initialIntervalsHi = intervals.size() / 2;
                this.initialPartitionLo = 0;
                this.initialPartitionHi = this.reader.getPartitionCount();
            }
            this.toTop();
        }
    }

    private long computeSize() {
        int intervalsLo = this.intervalsLo;
        int intervalsHi = this.intervalsHi;
        int partitionLo = this.partitionLo;
        int partitionHi = this.partitionHi;
        long partitionLimit = this.partitionLimit;
        long size = this.sizeSoFar;
        while (intervalsLo < intervalsHi && partitionLo < partitionHi) {
            long rowCount = this.reader.openPartition(partitionLo);
            if (rowCount > 0L) {
                long lo;
                MemoryR column = this.reader.getColumn(TableReader.getPrimaryColumnIndex(this.reader.getColumnBase(partitionLo), this.timestampIndex));
                long intervalLo = this.intervals.getQuick(intervalsLo * 2);
                long intervalHi = this.intervals.getQuick(intervalsLo * 2 + 1);
                long partitionTimestampLo = column.getLong(0L);
                if (partitionTimestampLo > intervalHi) {
                    ++intervalsLo;
                    continue;
                }
                long partitionTimestampHi = column.getLong((rowCount - 1L) * 8L);
                if (partitionTimestampHi < intervalLo) {
                    partitionLimit = 0L;
                    ++partitionLo;
                    continue;
                }
                if (partitionTimestampLo == intervalLo) {
                    lo = 0L;
                } else {
                    lo = AbstractIntervalDataFrameCursor.search(column, intervalLo, partitionLimit, rowCount, -1);
                    if (lo < 0L) {
                        lo = -lo - 1L;
                    }
                }
                long hi = AbstractIntervalDataFrameCursor.search(column, intervalHi, lo, rowCount, 1);
                hi = hi < 0L ? -hi - 1L : ++hi;
                if (lo < hi) {
                    size += hi - lo;
                    if (hi == rowCount) {
                        partitionLimit = 0L;
                        ++partitionLo;
                        continue;
                    }
                    partitionLimit = hi;
                    ++intervalsLo;
                    continue;
                }
                partitionLimit = hi;
                ++intervalsLo;
                continue;
            }
            ++partitionLo;
        }
        this.size = size;
        return this.size;
    }

    private void cullIntervals(LongList intervals) {
        int intervalsLo = intervals.binarySearch(this.reader.getMinTimestamp(), -1);
        if (intervalsLo < 0) {
            intervalsLo = -intervalsLo - 1;
        }
        this.initialIntervalsLo = intervalsLo / 2;
        int intervalsHi = intervals.binarySearch(this.reader.getMaxTimestamp(), -1);
        if (this.reader.getMaxTimestamp() == intervals.getQuick(intervals.size() - 1)) {
            this.initialIntervalsHi = intervals.size() - 1;
        }
        if (this.reader.getMaxTimestamp() == intervals.getQuick(0)) {
            this.initialIntervalsHi = 1;
        }
        if (intervalsHi < 0) {
            this.initialIntervalsHi = (intervalsHi = -intervalsHi - 1) % 2 == 0 ? intervalsHi / 2 : intervalsHi / 2 + 1;
        }
    }

    private void cullPartitions(LongList intervals) {
        long lo = intervals.getQuick(this.initialIntervalsLo * 2);
        long intervalLo = lo == Long.MIN_VALUE ? this.reader.floorToPartitionTimestamp(this.reader.getMinTimestamp()) : this.reader.floorToPartitionTimestamp(lo);
        this.initialPartitionLo = this.reader.getMinTimestamp() < intervalLo ? this.reader.getPartitionIndexByTimestamp(intervalLo) : 0;
        long intervalHi = this.reader.floorToPartitionTimestamp(intervals.getQuick((this.initialIntervalsHi - 1) * 2 + 1));
        this.initialPartitionHi = Math.min(this.reader.getPartitionCount(), this.reader.getPartitionIndexByTimestamp(intervalHi) + 1);
    }

    protected class IntervalDataFrame
    implements DataFrame {
        protected long rowLo = 0L;
        protected long rowHi;
        protected int partitionIndex;

        protected IntervalDataFrame() {
        }

        @Override
        public BitmapIndexReader getBitmapIndexReader(int columnIndex, int direction) {
            return AbstractIntervalDataFrameCursor.this.reader.getBitmapIndexReader(this.partitionIndex, columnIndex, direction);
        }

        @Override
        public int getPartitionIndex() {
            return this.partitionIndex;
        }

        @Override
        public long getRowHi() {
            return this.rowHi;
        }

        @Override
        public long getRowLo() {
            return this.rowLo;
        }
    }
}

